/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.algart.arrays.AbstractIterativeArrayProcessor;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.QuickPointCountPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.Morphology;

public class IterativeErosion
extends AbstractIterativeArrayProcessor<Matrix<? extends UpdatablePArray>>
implements IterativeArrayProcessor<Matrix<? extends UpdatablePArray>> {
    private static final int TEST_MATRIX_DIM_FOR_COMPLEXITY_ESTIMATION = 5;
    private static final int MAX_TEST_MATRIX_DIM_FOR_COMPLEXITY_ESTIMATION = 5000;
    private static final int NUMBER_OF_TESTS_FOR_COMPLEXITY_ESTIMATION = 5;
    private static final int MAX_NUMBER_OF_ITERATIONS_FOR_COMPLEXITY_ESTIMATION = 5000;
    private static final int MAX_TESTING_TIME_PER_COORD_FOR_COMPLEXITY_ESTIMATION = 250;
    private static final int NUMBER_OF_STORED_EROSIONS = 8;
    private final Morphology morphology;
    private final Pattern[] patterns;
    private final Matrix<? extends UpdatablePArray> result;
    private final Matrix<? extends UpdatablePArray> temp1;
    private final Matrix<? extends UpdatablePArray> temp2;
    private final List<Matrix<? extends UpdatablePArray>> store = new ArrayList<Matrix<? extends UpdatablePArray>>();
    private int patternIndex = 0;
    private int storeSize = 0;
    private boolean firstIteration = true;
    private boolean useCarcasses = false;
    private boolean done = false;

    private IterativeErosion(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern ... patterns) {
        super(morphology.context());
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        Objects.requireNonNull(matrix, "Null matrix argument");
        if (patterns.length == 0) {
            throw new IllegalArgumentException("Empty patterns[] argument");
        }
        for (int k = 0; k < patterns.length; ++k) {
            Objects.requireNonNull(patterns[k], "Null patterns[" + k + "]");
        }
        Class<?> reType = Arrays.elementType(requiredType);
        MemoryModel mmRes = IterativeErosion.mm(this.memoryModel, matrix, Arrays.sizeOf(reType) / Arrays.sizeOf(matrix.elementType()));
        MemoryModel mmTemp = IterativeErosion.mm(this.memoryModel, matrix, 10.0);
        this.morphology = morphology;
        this.patterns = (Pattern[])patterns.clone();
        this.result = mmRes.newMatrix(requiredType, reType, matrix.dimensions());
        this.temp1 = mmTemp.newLazyCopy(UpdatablePArray.class, matrix);
        this.temp2 = mmTemp.newMatrix(UpdatablePArray.class, matrix);
        this.store.add(this.result);
        for (int k = 0; k < 8; ++k) {
            this.store.add(mmTemp.newMatrix(UpdatablePArray.class, matrix));
        }
        this.store.add(this.temp1);
    }

    public static IterativeErosion getInstance(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern ... patterns) {
        return new IterativeErosion(morphology, requiredType, matrix, patterns);
    }

    @Override
    public void performIteration(ArrayContext context) {
        Pattern ptnOrCarc;
        Pattern ptn = this.patterns[this.patternIndex];
        Pattern pattern = ptnOrCarc = this.useCarcasses ? ptn.carcass() : ptn;
        if (this.firstIteration) {
            Matrices.applyFunc(IterativeErosion.part(context, 0.0, 0.05), Func.IDENTITY, this.result, this.temp1);
        }
        this.morphology.context(IterativeErosion.part(context, this.firstIteration ? 0.05 : 0.0, 0.75)).erosion(this.temp2, this.temp1, ptnOrCarc);
        this.firstIteration = false;
        ++this.patternIndex;
        if (this.patternIndex == this.patterns.length) {
            this.useCarcasses = true;
            this.patternIndex = 0;
        }
        boolean bl = this.done = !Matrices.compareAndCopy(IterativeErosion.part(context, 0.75, 0.8), this.temp1, this.temp2).changed();
        if (this.done || this.storeSize == 8) {
            int n;
            int n2 = n = this.done ? 1 + this.storeSize : 10;
            if (n > 1) {
                LinearFunc f = LinearFunc.getInstance(0.0, Arrays.nDoubleCopies(n, 1.0).toJavaArray());
                Matrices.applyFunc(IterativeErosion.part(context, 0.8, 1.0), (Func)f, this.result, this.store.subList(0, n));
            }
            this.storeSize = 0;
        } else {
            Matrices.copy(IterativeErosion.part(context, 0.8, 1.0), this.store.get(1 + this.storeSize), this.temp1);
            ++this.storeSize;
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public long estimatedNumberOfIterations() {
        return IterativeErosion.estimatedNumberOfIterations(this.temp1, this.patterns[0]);
    }

    @Override
    public Matrix<? extends UpdatablePArray> result() {
        return this.result;
    }

    @Override
    public void freeResources(ArrayContext context) {
        this.temp1.freeResources(context == null ? null : context.part(0.0, 0.3333333333333333));
        this.temp2.freeResources(context == null ? null : context.part(0.3333333333333333, 0.6666666666666666));
        this.result.freeResources(context == null ? null : context.part(0.6666666666666666, 1.0));
    }

    public String toString() {
        return "iterative erosion by patterns: " + JArrays.toString(this.patterns, ", ", 1000);
    }

    public static long estimatedNumberOfIterations(Matrix<? extends PArray> matrix, Pattern pattern) {
        int dimCount = matrix.dimCount();
        long minDim = matrix.dim(0);
        for (int coord = 1; coord < dimCount; ++coord) {
            minDim = Math.min(minDim, matrix.dim(coord));
        }
        if (dimCount > 3 || minDim < 10L) {
            return minDim;
        }
        pattern = Patterns.newRectangularIntegerPattern(pattern.roundedCoordArea().ranges());
        int maxIterCount = 0;
        long[] position = new long[dimCount];
        long[] dimensions = new long[dimCount];
        JArrays.fill(dimensions, 5L);
        Random rnd = new Random(157L);
        SimpleMemoryModel smm = SimpleMemoryModel.getInstance();
        BasicMorphology morphology = BasicMorphology.getInstance(null);
        for (int coord = 0; coord < dimCount; ++coord) {
            dimensions[coord] = Math.min(matrix.dim(coord), 5000L);
            Matrix<UpdatablePArray> w1 = smm.newMatrix(UpdatablePArray.class, matrix.elementType(), dimensions);
            Matrix<UpdatablePArray> w2 = smm.newMatrix(UpdatablePArray.class, matrix.elementType(), dimensions);
            for (int testIndex = 0; testIndex < 5; ++testIndex) {
                int count;
                for (int k = 0; k < dimCount; ++k) {
                    int dim = (int)Math.min(Integer.MAX_VALUE, matrix.dim(k));
                    assert (dim >= 5);
                    position[k] = k == coord ? 0L : (long)rnd.nextInt(dim - 5);
                }
                Matrix<? extends PArray> m = matrix.subMatr(position, dimensions);
                Matrices.copy(null, w1, m);
                long patternWidth = Math.min(Integer.MAX_VALUE, pattern.roundedCoordRange(coord).size());
                long tStart = System.currentTimeMillis();
                for (count = 1; count < 5000 && patternWidth * (long)count < dimensions[coord]; ++count) {
                    morphology.erosion(w2, w1, pattern, true);
                    if (!Matrices.compareAndCopy(null, w1, w2).changed() || System.currentTimeMillis() - tStart > 50L) break;
                }
                maxIterCount = Math.max(maxIterCount, count);
                if (count != 5000) continue;
                return maxIterCount;
            }
            dimensions[coord] = 5L;
        }
        return maxIterCount;
    }

    static MemoryModel mm(MemoryModel memoryModel, Matrix<? extends PArray> matrix, double numberOfMatrices) {
        if ((double)Matrices.sizeOf(matrix) > (double)Arrays.SystemSettings.maxTempJavaMemory() / numberOfMatrices) {
            return memoryModel;
        }
        return SimpleMemoryModel.getInstance();
    }

    static boolean isSmall(Pattern pattern) {
        if (pattern instanceof QuickPointCountPattern) {
            return pattern.pointCount() <= 5L;
        }
        return false;
    }
}

