/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.morphology;

import java.util.Objects;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.Morphology;

public abstract class AbstractMorphology
extends AbstractArrayProcessorWithContextSwitching
implements Morphology {
    protected AbstractMorphology(ArrayContext context) {
        super(context);
    }

    @Override
    public Morphology context(ArrayContext newContext) {
        return (Morphology)super.context(newContext);
    }

    @Override
    public abstract boolean isPseudoCyclic();

    @Override
    public Matrix<? extends PArray> asDilation(Matrix<? extends PArray> src, Pattern pattern) {
        return this.asDilationOrErosion(src, pattern, true);
    }

    @Override
    public Matrix<? extends PArray> asErosion(Matrix<? extends PArray> src, Pattern pattern) {
        return this.asDilationOrErosion(src, pattern, false);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, Pattern pattern) {
        return this.dilationOrErosion(null, src, pattern, true, false);
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, Pattern pattern) {
        return this.dilationOrErosion(null, src, pattern, false, false);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilation(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        Objects.requireNonNull(subtractionMode, "Null subtractionMode");
        Matrix<? extends UpdatablePArray> dilation = (subtractionMode == Morphology.SubtractionMode.NONE ? this : this.context(this.contextPart(0.0, 0.9))).dilation(src, pattern);
        subtractionMode.subtract(this.contextPart(0.9, 1.0), dilation, src);
        return dilation;
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosion(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        Objects.requireNonNull(subtractionMode, "Null subtractionMode");
        Matrix<? extends UpdatablePArray> erosion = (subtractionMode == Morphology.SubtractionMode.NONE ? this : this.context(this.contextPart(0.0, 0.9))).erosion(src, pattern);
        subtractionMode.subtract(this.contextPart(0.9, 1.0), erosion, src);
        return erosion;
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean disableMemoryAllocation) {
        Objects.requireNonNull(dest, "Null dest argument");
        this.dilationOrErosion(dest, src, pattern, true, disableMemoryAllocation);
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean disableMemoryAllocation) {
        Objects.requireNonNull(dest, "Null dest argument");
        this.dilationOrErosion(dest, src, pattern, false, disableMemoryAllocation);
    }

    @Override
    public void dilation(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.dilation(dest, src, pattern, false);
    }

    @Override
    public void erosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
        this.erosion(dest, src, pattern, false);
    }

    @Override
    public Matrix<? extends UpdatablePArray> dilationErosion(Matrix<? extends PArray> src, Pattern dilationPattern, Pattern erosionPattern, Morphology.SubtractionMode subtractionMode) {
        Objects.requireNonNull(dilationPattern, "Null dilationPattern argument");
        Objects.requireNonNull(erosionPattern, "Null erosionPattern argument");
        if (!this.dimensionsAllowed(src, dilationPattern)) {
            throw new IllegalArgumentException("Number of dimensions of the dilation pattern and the matrix mismatch");
        }
        if (!this.dimensionsAllowed(src, erosionPattern)) {
            throw new IllegalArgumentException("Number of dimensions of the erosion pattern and the matrix mismatch");
        }
        Objects.requireNonNull(subtractionMode, "Null subtractionMode");
        double w = subtractionMode == Morphology.SubtractionMode.NONE ? 1.0 : 0.9;
        Matrix<? extends UpdatablePArray> actual = this.context(this.contextPart(0.0, 0.5 * w)).dilation(src, dilationPattern);
        actual = this.context(this.contextPart(0.5 * w, 1.0 * w)).erosion(actual, erosionPattern);
        subtractionMode.subtract(this.contextPart(0.9, 1.0), actual, src);
        return actual;
    }

    @Override
    public Matrix<? extends UpdatablePArray> erosionDilation(Matrix<? extends PArray> src, Pattern erosionPattern, Pattern dilationPattern, Morphology.SubtractionMode subtractionMode) {
        Objects.requireNonNull(erosionPattern, "Null erosionPattern argument");
        Objects.requireNonNull(dilationPattern, "Null dilationPattern argument");
        if (!this.dimensionsAllowed(src, dilationPattern)) {
            throw new IllegalArgumentException("Number of dimensions of the erosion pattern and the matrix mismatch");
        }
        if (!this.dimensionsAllowed(src, erosionPattern)) {
            throw new IllegalArgumentException("Number of dimensions of the dilation pattern and the matrix mismatch");
        }
        double w = subtractionMode == Morphology.SubtractionMode.NONE ? 1.0 : 0.9;
        Matrix<? extends UpdatablePArray> actual = this.context(this.contextPart(0.0, 0.5 * w)).erosion(src, erosionPattern);
        actual = this.context(this.contextPart(0.5 * w, 1.0 * w)).dilation(actual, dilationPattern);
        subtractionMode.subtract(this.contextPart(0.9, 1.0), actual, src);
        return actual;
    }

    @Override
    public Matrix<? extends UpdatablePArray> closing(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        return this.dilationErosion(src, pattern, pattern, subtractionMode);
    }

    @Override
    public Matrix<? extends UpdatablePArray> opening(Matrix<? extends PArray> src, Pattern pattern, Morphology.SubtractionMode subtractionMode) {
        return this.erosionDilation(src, pattern, pattern, subtractionMode);
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakDilation(Matrix<? extends PArray> src, Pattern pattern) {
        Matrix<? extends UpdatablePArray> dilation = this.context(this.contextPart(0.0, 0.5)).dilation(src, pattern);
        Matrix<? extends UpdatablePArray> closing = this.context(this.contextPart(0.45, 0.9)).erosion(dilation, pattern);
        Matrices.applyFunc(this.contextPart(0.9, 1.0), !(this instanceof BasicMorphology), LinearFunc.getInstance(0.0, 1.0, -1.0, 1.0), dilation, dilation, closing, src);
        return dilation;
    }

    @Override
    public Matrix<? extends UpdatablePArray> weakErosion(Matrix<? extends PArray> src, Pattern pattern) {
        Matrix<? extends UpdatablePArray> erosion = this.context(this.contextPart(0.0, 0.5)).erosion(src, pattern);
        Matrix<? extends UpdatablePArray> opening = this.context(this.contextPart(0.45, 0.9)).dilation(erosion, pattern);
        Matrices.applyFunc(this.contextPart(0.9, 1.0), !(this instanceof BasicMorphology), LinearFunc.getInstance(0.0, 1.0, -1.0, 1.0), erosion, erosion, opening, src);
        return erosion;
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedDilationErosion(Matrix<? extends PArray> src, Pattern dilationPattern, Pattern erosionPattern) {
        Matrix<? extends UpdatablePArray> actual = this.context(this.contextPart(0.0, 0.95)).dilationErosion(src, dilationPattern, erosionPattern, Morphology.SubtractionMode.NONE);
        Matrices.applyFunc(this.contextPart(0.95, 1.0), Func.MIN, actual, actual, src);
        return actual;
    }

    @Override
    public Matrix<? extends UpdatablePArray> maskedErosionDilation(Matrix<? extends PArray> src, Pattern erosionPattern, Pattern dilationPattern) {
        Matrix<? extends UpdatablePArray> actual = this.context(this.contextPart(0.0, 0.95)).erosionDilation(src, erosionPattern, dilationPattern, Morphology.SubtractionMode.NONE);
        Matrices.applyFunc(this.contextPart(0.95, 1.0), Func.MAX, actual, actual, src);
        return actual;
    }

    @Override
    public Matrix<? extends UpdatablePArray> beucherGradient(Matrix<? extends PArray> src, Pattern pattern) {
        Matrix<? extends UpdatablePArray> dilation = this.context(this.contextPart(0.0, 0.45)).dilation(src, pattern);
        Matrix<? extends UpdatablePArray> erosion = this.context(this.contextPart(0.45, 0.9)).erosion(src, pattern);
        Matrices.applyFunc(this.contextPart(0.9, 1.0), Func.POSITIVE_DIFF, dilation, dilation, erosion);
        return dilation;
    }

    protected abstract Matrix<? extends PArray> asDilationOrErosion(Matrix<? extends PArray> var1, Pattern var2, boolean var3);

    protected Matrix<? extends UpdatablePArray> dilationOrErosion(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern, boolean isDilation, boolean disableMemoryAllocation) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (!this.dimensionsAllowed(src, pattern)) {
            throw new IllegalArgumentException("Number of dimensions of the pattern and the matrix mismatch");
        }
        if (dest == null) {
            dest = this.memoryModel().newMatrix(UpdatablePArray.class, src);
        } else {
            if (!dest.dimEquals(src)) {
                throw new SizeMismatchException("Destination and source matrix dimensions mismatch: " + String.valueOf(dest) + " and " + String.valueOf(src));
            }
            Matrix<? extends UpdatablePArray> castDest = dest.elementType() == src.elementType() ? dest : Matrices.asUpdatableFuncMatrix(true, Func.UPDATABLE_IDENTITY, src.updatableType(UpdatablePArray.class), dest);
            Matrices.copy(this.context(), castDest, this.asDilationOrErosion(src, pattern, isDilation));
        }
        return dest;
    }

    protected boolean dimensionsAllowed(Matrix<? extends PArray> matrix, Pattern pattern) {
        return pattern.dimCount() == matrix.dimCount();
    }
}

