/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IRectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.WeightedPattern;
import net.algart.matrices.DependenceApertureBuilder;
import net.algart.matrices.linearfiltering.Convolution;

public class ContinuedConvolution
implements Convolution {
    private final Convolution parent;
    private final ArrayContext context;
    private final Matrix.ContinuationMode continuationMode;

    private ContinuedConvolution(Convolution parent, Matrix.ContinuationMode continuationMode) {
        Objects.requireNonNull(parent, "Null parent convolution");
        Objects.requireNonNull(continuationMode, "Null continuationMode derivator");
        if (continuationMode == Matrix.ContinuationMode.NONE) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be used with continuation mode \"" + String.valueOf(continuationMode) + "\"");
        }
        this.parent = parent;
        this.context = parent.context() == null ? ArrayContext.DEFAULT : parent.context();
        this.continuationMode = continuationMode;
    }

    public static ContinuedConvolution getInstance(Convolution parent, Matrix.ContinuationMode continuationMode) {
        return new ContinuedConvolution(parent, continuationMode);
    }

    public Convolution parent() {
        return this.parent;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    @Override
    public ArrayContext context() {
        return this.context;
    }

    @Override
    public Convolution context(ArrayContext newContext) {
        return new ContinuedConvolution(this.parent.context(newContext), this.continuationMode);
    }

    @Override
    public boolean isPseudoCyclic() {
        return this.continuationMode == Matrix.ContinuationMode.PSEUDO_CYCLIC;
    }

    @Override
    public double increment(Class<?> elementType) {
        return this.parent.increment(elementType);
    }

    @Override
    public Matrix<? extends PArray> asConvolution(Matrix<? extends PArray> src, WeightedPattern pattern) {
        Continuer c = new Continuer(this, null, src, pattern);
        return c.reduce(this.parent.asConvolution(c.continuedSrc(), pattern));
    }

    @Override
    public <T extends PArray> Matrix<T> asConvolution(Class<? extends T> requiredType, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Continuer c = new Continuer(this, null, src, pattern);
        return c.reduce(this.parent.asConvolution(requiredType, c.continuedSrc(), pattern));
    }

    @Override
    public Matrix<? extends UpdatablePArray> convolution(Matrix<? extends PArray> src, WeightedPattern pattern) {
        Continuer c = new Continuer(this, null, src, pattern);
        return c.reduce(this.parent.convolution(c.continuedSrc(), pattern));
    }

    @Override
    public <T extends PArray> Matrix<? extends T> convolution(Class<? extends T> requiredType, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Continuer c = new Continuer(this, null, src, pattern);
        return c.reduce(this.parent.convolution(requiredType, c.continuedSrc(), pattern));
    }

    @Override
    public void convolution(Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, WeightedPattern pattern) {
        Continuer c = new Continuer(this, dest, src, pattern);
        this.parent.convolution(c.continuedDest(), c.continuedSrc(), pattern);
    }

    private class Continuer {
        private final Matrix<? extends UpdatablePArray> continuedDest;
        private final Matrix<? extends PArray> continuedSrc;
        private final IRectangularArea aperture;

        private Continuer(ContinuedConvolution continuedConvolution, Matrix<? extends UpdatablePArray> dest, Matrix<? extends PArray> src, Pattern pattern) {
            if (dest != null) {
                Matrices.checkDimensionEquality(dest, src);
            }
            DependenceApertureBuilder builder = dest == null && continuedConvolution.parent.isPseudoCyclic() ? DependenceApertureBuilder.SUM : DependenceApertureBuilder.SUM_MAX_0;
            this.aperture = builder.getAperture(src.dimCount(), pattern, false);
            this.continuedSrc = DependenceApertureBuilder.extend(src, this.aperture, continuedConvolution.continuationMode);
            this.continuedDest = dest == null ? null : DependenceApertureBuilder.extend(dest, this.aperture, Matrix.ContinuationMode.ZERO_CONSTANT);
        }

        public Matrix<? extends PArray> continuedSrc() {
            return this.continuedSrc;
        }

        public Matrix<? extends UpdatablePArray> continuedDest() {
            assert (this.continuedDest != null);
            return this.continuedDest;
        }

        public <T extends PArray> Matrix<T> reduce(Matrix<T> matrix) {
            assert (this.continuedDest == null);
            return DependenceApertureBuilder.reduce(matrix, this.aperture);
        }
    }
}

