/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.linearfiltering;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PIntegerArray;
import net.algart.math.IPoint;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.MaxFromTwoSelectedNumbersFunc;
import net.algart.math.functions.MinFromTwoSelectedNumbersFunc;
import net.algart.matrices.linearfiltering.AbstractDerivator;
import net.algart.matrices.linearfiltering.Derivator;

public class BasicDerivator
extends AbstractDerivator
implements Derivator {
    private BasicDerivator(ArrayContext context, boolean decrementForUnsigned) {
        super(context, decrementForUnsigned);
    }

    public static BasicDerivator getInstance(ArrayContext context) {
        return new BasicDerivator(context, false);
    }

    public static BasicDerivator getCorrectingUnsignedInstance(ArrayContext context) {
        return new BasicDerivator(context, true);
    }

    @Override
    public boolean isPseudoCyclic() {
        return true;
    }

    @Override
    public Matrix<? extends PArray> asMaximumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = BasicDerivator.checkAndCloneDirections(src.dimCount(), directions);
        return Matrices.asFuncMatrix((Func)MaxFromTwoSelectedNumbersFunc.getInstance(directions.length), src.type(PArray.class), this.getShiftedMatrices(src, directionIndexes, directions));
    }

    @Override
    public Matrix<? extends BitArray> asMaskOfMaximums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Objects.requireNonNull(mode, "Null suppression mode argument");
        Matrix<? extends PArray> max = this.asMaximumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        Matrix<BitArray> zeroMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(0.0), BitArray.class, src.dimensions());
        Matrix<BitArray> unitMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(1.0), BitArray.class, src.dimensions());
        return Matrices.asFuncMatrix(mode.selectionFunc, BitArray.class, src, max, unitMatrix, zeroMatrix);
    }

    @Override
    public Matrix<? extends PArray> asNonMaximumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Objects.requireNonNull(mode, "Null suppression mode argument");
        Matrix<? extends PArray> max = this.asMaximumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        Matrix<PArray> filledMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(filler), src.type(PArray.class), src.dimensions());
        return Matrices.asFuncMatrix(mode.selectionFunc, src.type(PArray.class), src, max, src, filledMatrix);
    }

    @Override
    public Matrix<? extends PArray> asMinimumFromShiftedForwardAndBackward(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Matrices.checkDimensionEquality(src, directionIndexes);
        directions = BasicDerivator.checkAndCloneDirections(src.dimCount(), directions);
        return Matrices.asFuncMatrix((Func)MinFromTwoSelectedNumbersFunc.getInstance(directions.length), src.type(PArray.class), this.getShiftedMatrices(src, directionIndexes, directions));
    }

    @Override
    public Matrix<? extends BitArray> asMaskOfMinimums(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Objects.requireNonNull(mode, "Null suppression mode argument");
        Matrix<? extends PArray> min = this.asMinimumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        Matrix<BitArray> zeroMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(0.0), BitArray.class, src.dimensions());
        Matrix<BitArray> unitMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(1.0), BitArray.class, src.dimensions());
        return Matrices.asFuncMatrix(mode.selectionFunc, BitArray.class, min, src, unitMatrix, zeroMatrix);
    }

    @Override
    public Matrix<? extends PArray> asNonMinimumSuppression(Matrix<? extends PArray> src, Derivator.SuppressionMode mode, double filler, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        Objects.requireNonNull(mode, "Null suppression mode argument");
        Matrix<? extends PArray> min = this.asMinimumFromShiftedForwardAndBackward(src, directionIndexes, directions);
        Matrix<PArray> filledMatrix = Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(filler), src.type(PArray.class), src.dimensions());
        return Matrices.asFuncMatrix(mode.selectionFunc, src.type(PArray.class), min, src, src, filledMatrix);
    }

    private List<Matrix<? extends PArray>> getShiftedMatrices(Matrix<? extends PArray> src, Matrix<? extends PIntegerArray> directionIndexes, IPoint ... directions) {
        ArrayList<Matrix<? extends PArray>> matrices = new ArrayList<Matrix<? extends PArray>>();
        matrices.add(directionIndexes);
        for (IPoint dir : directions) {
            matrices.add(Matrices.asShifted(src, dir.coordinates()).cast(PArray.class));
        }
        for (IPoint dir : directions) {
            matrices.add(Matrices.asShifted(src, dir.symmetric().coordinates()).cast(PArray.class));
        }
        return matrices;
    }
}

