/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.filters3x3;

import net.algart.matrices.filters3x3.AbstractQuickFilter3x3;

public abstract class QuickGradientByCross3x3
extends AbstractQuickFilter3x3 {
    private QuickGradientByCross3x3(Class<?> elementType, long[] dimensions) {
        super(elementType, dimensions);
    }

    public static QuickGradientByCross3x3 newInstance(Class<?> elementType, long dimX, long dimY) {
        return QuickGradientByCross3x3.newInstance(elementType, new long[]{dimX, dimY});
    }

    public static QuickGradientByCross3x3 newInstance(Class<?> elementType, long[] dimensions) {
        if (elementType == Character.TYPE) {
            return new ForChar(dimensions);
        }
        if (elementType == Boolean.TYPE) {
            return new ForBit(dimensions);
        }
        if (elementType == Byte.TYPE) {
            return new ForByte(dimensions);
        }
        if (elementType == Short.TYPE) {
            return new ForShort(dimensions);
        }
        if (elementType == Integer.TYPE) {
            return new ForInt(dimensions);
        }
        if (elementType == Long.TYPE) {
            return new ForLong(dimensions);
        }
        if (elementType == Float.TYPE) {
            return new ForFloat(dimensions);
        }
        if (elementType == Double.TYPE) {
            return new ForDouble(dimensions);
        }
        throw new UnsupportedOperationException("Non-primitive element type " + String.valueOf(elementType) + " is not supported");
    }

    private static class ForChar
    extends QuickGradientByCross3x3 {
        private ForChar(long[] dimensions) {
            super(Character.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            char[] result = (char[])resultJavaArray;
            char[] source = (char[])sourceJavaArray;
            char vL = source[middleLineOffset + this.dimXm1];
            char vR = source[middleLineOffset + this.rem1ForDimX];
            char vU = source[firstLineOffset];
            char vD = source[lastLineOffset];
            int r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
            result[resultLineOffset] = (char)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1];
                vR = source[middleLineOffset + k + 1];
                vU = source[firstLineOffset + k];
                vD = source[lastLineOffset + k];
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + k] = (char)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1];
                vR = source[middleLineOffset];
                vU = source[firstLineOffset + this.dimXm1];
                vD = source[lastLineOffset + this.dimXm1];
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + this.dimXm1] = (char)r;
            }
        }
    }

    private static class ForBit
    extends QuickGradientByCross3x3 {
        private ForBit(long[] dimensions) {
            super(Boolean.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            boolean[] result = (boolean[])resultJavaArray;
            boolean[] source = (boolean[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1] ? 1 : 0;
            int vR = source[middleLineOffset + this.rem1ForDimX] ? 1 : 0;
            int vU = source[firstLineOffset] ? 1 : 0;
            int vD = source[lastLineOffset] ? 1 : 0;
            int r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
            result[resultLineOffset] = r != 0;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1] ? 1 : 0;
                vR = source[middleLineOffset + k + 1] ? 1 : 0;
                vU = source[firstLineOffset + k] ? 1 : 0;
                vD = source[lastLineOffset + k] ? 1 : 0;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + k] = r != 0;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1] ? 1 : 0;
                vR = source[middleLineOffset] ? 1 : 0;
                vU = source[firstLineOffset + this.dimXm1] ? 1 : 0;
                vD = source[lastLineOffset + this.dimXm1] ? 1 : 0;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + this.dimXm1] = r != 0;
            }
        }
    }

    private static class ForByte
    extends QuickGradientByCross3x3 {
        private ForByte(long[] dimensions) {
            super(Byte.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            byte[] result = (byte[])resultJavaArray;
            byte[] source = (byte[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1] & 0xFF;
            int vR = source[middleLineOffset + this.rem1ForDimX] & 0xFF;
            int vU = source[firstLineOffset] & 0xFF;
            int vD = source[lastLineOffset] & 0xFF;
            int r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
            result[resultLineOffset] = (byte)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1] & 0xFF;
                vR = source[middleLineOffset + k + 1] & 0xFF;
                vU = source[firstLineOffset + k] & 0xFF;
                vD = source[lastLineOffset + k] & 0xFF;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + k] = (byte)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1] & 0xFF;
                vR = source[middleLineOffset] & 0xFF;
                vU = source[firstLineOffset + this.dimXm1] & 0xFF;
                vD = source[lastLineOffset + this.dimXm1] & 0xFF;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + this.dimXm1] = (byte)r;
            }
        }
    }

    private static class ForShort
    extends QuickGradientByCross3x3 {
        private ForShort(long[] dimensions) {
            super(Short.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            short[] result = (short[])resultJavaArray;
            short[] source = (short[])sourceJavaArray;
            int vL = source[middleLineOffset + this.dimXm1] & 0xFFFF;
            int vR = source[middleLineOffset + this.rem1ForDimX] & 0xFFFF;
            int vU = source[firstLineOffset] & 0xFFFF;
            int vD = source[lastLineOffset] & 0xFFFF;
            int r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
            result[resultLineOffset] = (short)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1] & 0xFFFF;
                vR = source[middleLineOffset + k + 1] & 0xFFFF;
                vU = source[firstLineOffset + k] & 0xFFFF;
                vD = source[lastLineOffset + k] & 0xFFFF;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + k] = (short)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1] & 0xFFFF;
                vR = source[middleLineOffset] & 0xFFFF;
                vU = source[firstLineOffset + this.dimXm1] & 0xFFFF;
                vD = source[lastLineOffset + this.dimXm1] & 0xFFFF;
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + this.dimXm1] = (short)r;
            }
        }
    }

    private static class ForInt
    extends QuickGradientByCross3x3 {
        private ForInt(long[] dimensions) {
            super(Integer.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            int[] result = (int[])resultJavaArray;
            int[] source = (int[])sourceJavaArray;
            long vL = source[middleLineOffset + this.dimXm1];
            long vR = source[middleLineOffset + this.rem1ForDimX];
            long vU = source[firstLineOffset];
            long vD = source[lastLineOffset];
            long r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
            result[resultLineOffset] = (int)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1];
                vR = source[middleLineOffset + k + 1];
                vU = source[firstLineOffset + k];
                vD = source[lastLineOffset + k];
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + k] = (int)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1];
                vR = source[middleLineOffset];
                vU = source[firstLineOffset + this.dimXm1];
                vD = source[lastLineOffset + this.dimXm1];
                r = (vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD) >> 1;
                result[resultLineOffset + this.dimXm1] = (int)r;
            }
        }
    }

    private static class ForLong
    extends QuickGradientByCross3x3 {
        private ForLong(long[] dimensions) {
            super(Long.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            long[] result = (long[])resultJavaArray;
            long[] source = (long[])sourceJavaArray;
            double vL = source[middleLineOffset + this.dimXm1];
            double vR = source[middleLineOffset + this.rem1ForDimX];
            double vU = source[firstLineOffset];
            double vD = source[lastLineOffset];
            double r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
            result[resultLineOffset] = (long)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1];
                vR = source[middleLineOffset + k + 1];
                vU = source[firstLineOffset + k];
                vD = source[lastLineOffset + k];
                r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
                result[resultLineOffset + k] = (long)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1];
                vR = source[middleLineOffset];
                vU = source[firstLineOffset + this.dimXm1];
                vD = source[lastLineOffset + this.dimXm1];
                r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
                result[resultLineOffset + this.dimXm1] = (long)r;
            }
        }
    }

    private static class ForFloat
    extends QuickGradientByCross3x3 {
        private ForFloat(long[] dimensions) {
            super(Float.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            float[] result = (float[])resultJavaArray;
            float[] source = (float[])sourceJavaArray;
            double vL = source[middleLineOffset + this.dimXm1];
            double vR = source[middleLineOffset + this.rem1ForDimX];
            double vU = source[firstLineOffset];
            double vD = source[lastLineOffset];
            double r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
            result[resultLineOffset] = (float)r;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1];
                vR = source[middleLineOffset + k + 1];
                vU = source[firstLineOffset + k];
                vD = source[lastLineOffset + k];
                r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
                result[resultLineOffset + k] = (float)r;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1];
                vR = source[middleLineOffset];
                vU = source[firstLineOffset + this.dimXm1];
                vD = source[lastLineOffset + this.dimXm1];
                r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
                result[resultLineOffset + this.dimXm1] = (float)r;
            }
        }
    }

    private static class ForDouble
    extends QuickGradientByCross3x3 {
        private ForDouble(long[] dimensions) {
            super(Double.TYPE, dimensions);
        }

        @Override
        protected void process3Lines(Object resultJavaArray, int resultLineOffset, Object sourceJavaArray, int firstLineOffset, int middleLineOffset, int lastLineOffset, int multithreadingRangeIndex) {
            double r;
            double[] result = (double[])resultJavaArray;
            double[] source = (double[])sourceJavaArray;
            double vL = source[middleLineOffset + this.dimXm1];
            double vR = source[middleLineOffset + this.rem1ForDimX];
            double vU = source[firstLineOffset];
            double vD = source[lastLineOffset];
            result[resultLineOffset] = r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
            for (int k = 1; k < this.dimXm1; ++k) {
                vL = source[middleLineOffset + k - 1];
                vR = source[middleLineOffset + k + 1];
                vU = source[firstLineOffset + k];
                vD = source[lastLineOffset + k];
                result[resultLineOffset + k] = r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
            }
            if (this.dimX >= 2) {
                vL = source[middleLineOffset + this.dimXm1 - 1];
                vR = source[middleLineOffset];
                vU = source[firstLineOffset + this.dimXm1];
                vD = source[lastLineOffset + this.dimXm1];
                result[resultLineOffset + this.dimXm1] = r = ((vL < vR ? vR - vL : vL - vR) + (vU < vD ? vD - vU : vU - vD)) * 0.5;
            }
        }
    }
}

