/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.AbstractArrayProcessorWithContextSwitching;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayProcessorWithContextSwitching;
import net.algart.arrays.Arrays;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.arrays.UpdatableArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.ApertureProcessor;
import net.algart.matrices.DependenceApertureBuilder;

public final class TiledApertureProcessorFactory {
    private final ArrayContext context;
    private final ThreadPoolFactory threadPoolFactory;
    private final int numberOfTasks;
    private final int originalNumberOfTasks;
    private final long maxTempJavaMemory;
    private final Matrix.ContinuationMode continuationMode;
    private final long[] processingTileDim;
    private final long[] allocationTileDim;
    private final int dimCount;

    private TiledApertureProcessorFactory(ArrayContext context, Matrix.ContinuationMode continuationMode, long maxTempJavaMemory, long[] processingTileDim, long[] allocationTileDim, int numberOfTasks) {
        Objects.requireNonNull(continuationMode, "Null continuation mode");
        Objects.requireNonNull(processingTileDim, "Null processing tile dimensions Java array");
        if (continuationMode == Matrix.ContinuationMode.NONE) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " cannot be used with continuation mode \"" + String.valueOf(continuationMode) + "\"");
        }
        if (processingTileDim.length == 0) {
            throw new IllegalArgumentException("Empty processing tile dimensions Java array");
        }
        if (allocationTileDim != null && allocationTileDim.length != processingTileDim.length) {
            throw new IllegalArgumentException("Different number of allocation and processing tile dimensions");
        }
        if (numberOfTasks < 0) {
            throw new IllegalArgumentException("Negative numberOfTasks=" + numberOfTasks);
        }
        this.processingTileDim = (long[])processingTileDim.clone();
        this.allocationTileDim = allocationTileDim == null ? null : (long[])allocationTileDim.clone();
        this.dimCount = processingTileDim.length;
        for (int k = 0; k < this.dimCount; ++k) {
            if (this.processingTileDim[k] <= 0L) {
                throw new IllegalArgumentException("Negative or zero processing tile dimension #" + k + ": " + this.processingTileDim[k]);
            }
            if (this.allocationTileDim == null || this.allocationTileDim[k] > 0L) continue;
            throw new IllegalArgumentException("Negative or zero allocation tile dimension #" + k + ": " + this.allocationTileDim[k]);
        }
        if (maxTempJavaMemory < 0L) {
            throw new IllegalArgumentException("Negative maxTempJavaMemory argument");
        }
        this.context = context;
        this.maxTempJavaMemory = maxTempJavaMemory;
        this.continuationMode = continuationMode;
        this.threadPoolFactory = Arrays.getThreadPoolFactory(context);
        this.originalNumberOfTasks = numberOfTasks;
        this.numberOfTasks = numberOfTasks > 0 ? numberOfTasks : Math.max(1, this.threadPoolFactory.recommendedNumberOfTasks());
    }

    public static TiledApertureProcessorFactory getInstance(ArrayContext context, Matrix.ContinuationMode continuationMode, long maxTempJavaMemory, long[] tileDim) {
        return new TiledApertureProcessorFactory(context, continuationMode, maxTempJavaMemory, tileDim, Matrices.defaultTileDimensions(tileDim.length), 0);
    }

    public static TiledApertureProcessorFactory getInstance(ArrayContext context, Matrix.ContinuationMode continuationMode, long maxTempJavaMemory, long[] tileDim, long[] allocationTileDim) {
        return new TiledApertureProcessorFactory(context, continuationMode, maxTempJavaMemory, tileDim, allocationTileDim, 0);
    }

    public static TiledApertureProcessorFactory getInstance(ArrayContext context, Matrix.ContinuationMode continuationMode, long maxTempJavaMemory, long[] tileDim, int numberOfTasks) {
        return new TiledApertureProcessorFactory(context, continuationMode, maxTempJavaMemory, tileDim, Matrices.defaultTileDimensions(tileDim.length), numberOfTasks);
    }

    public static TiledApertureProcessorFactory getInstance(ArrayContext context, Matrix.ContinuationMode continuationMode, long maxTempJavaMemory, long[] tileDim, long[] allocationTileDim, int numberOfTasks) {
        return new TiledApertureProcessorFactory(context, continuationMode, maxTempJavaMemory, tileDim, allocationTileDim, numberOfTasks);
    }

    public ArrayContext context() {
        return this.context;
    }

    public TiledApertureProcessorFactory context(ArrayContext newContext) {
        return new TiledApertureProcessorFactory(newContext, this.continuationMode, this.maxTempJavaMemory, this.processingTileDim, this.allocationTileDim, this.originalNumberOfTasks);
    }

    public int dimCount() {
        return this.dimCount;
    }

    public Matrix.ContinuationMode continuationMode() {
        return this.continuationMode;
    }

    public long maxTempJavaMemory() {
        return this.maxTempJavaMemory;
    }

    public long[] tileDim() {
        return (long[])this.processingTileDim.clone();
    }

    public int numberOfTasks() {
        return this.numberOfTasks;
    }

    public <K> ApertureProcessor<K> tile(ApertureProcessor<K> oneTileProcessor) {
        return new BasicTilingProcessor<K>(oneTileProcessor);
    }

    public String toString() {
        return "universal " + this.dimCount + "-dimensional " + (String)(this.numberOfTasks == 1 ? "" : this.numberOfTasks + "-threading ") + "processing tiler (tiles " + JArrays.toString(this.processingTileDim, "x", 1000) + ")";
    }

    private class BasicTilingProcessor<K>
    extends AbstractArrayProcessorWithContextSwitching
    implements ApertureProcessor<K>,
    ArrayProcessorWithContextSwitching {
        private final ApertureProcessor<K> oneTileProcessor;

        private BasicTilingProcessor(ApertureProcessor<K> oneTileProcessor) {
            super(TiledApertureProcessorFactory.this.context);
            Objects.requireNonNull(oneTileProcessor, "Null one-tile processor");
            this.oneTileProcessor = oneTileProcessor;
        }

        @Override
        public void process(Map<K, Matrix<?>> dest, Map<K, Matrix<?>> src) {
            Objects.requireNonNull(src, "Null table of source matrices");
            Objects.requireNonNull(dest, "Null table of destination matrices");
            LinkedHashMap destCopy = new LinkedHashMap();
            for (Map.Entry entry : dest.entrySet()) {
                Object k = entry.getKey();
                Matrix<?> m = entry.getValue();
                if (m != null && !(m.array() instanceof UpdatableArray)) {
                    throw new IllegalArgumentException("The destination matrix with key \"" + String.valueOf(k) + "\" is not updatable and cannot be used for returning result");
                }
                destCopy.put(k, m == null ? null : m.cast(UpdatableArray.class));
            }
            LinkedHashMap srcCopy = new LinkedHashMap();
            for (Map.Entry<K, Matrix<?>> entry : src.entrySet()) {
                K key = entry.getKey();
                Matrix<?> m = entry.getValue();
                Objects.requireNonNull(m, "Null source matrix with key \"" + String.valueOf(key) + "\"");
                srcCopy.put(key, m);
            }
            long[] lArray = this.getDimensionsAndCheck(destCopy, srcCopy);
            if (lArray == null) {
                return;
            }
            long l = Arrays.longMul(lArray);
            long[] tileCounts = new long[TiledApertureProcessorFactory.this.dimCount];
            long[] maxTileDim = new long[TiledApertureProcessorFactory.this.dimCount];
            long tileCount = 1L;
            for (int k = 0; k < TiledApertureProcessorFactory.this.dimCount; ++k) {
                if (lArray[k] == 0L) {
                    return;
                }
                tileCounts[k] = (lArray[k] - 1L) / TiledApertureProcessorFactory.this.processingTileDim[k] + 1L;
                assert (tileCounts[k] <= lArray[k]);
                maxTileDim[k] = Math.min(lArray[k], TiledApertureProcessorFactory.this.processingTileDim[k]);
                tileCount *= tileCounts[k];
            }
            int nt = (int)Math.min((long)TiledApertureProcessorFactory.this.numberOfTasks, tileCount);
            IRectangularArea maxAperture = this.maxDependenceAperture(srcCopy.keySet());
            DependenceApertureBuilder.extendDimensions(lArray, maxAperture);
            long maxExtTileSize = Arrays.longMul(DependenceApertureBuilder.extendDimensions(maxTileDim, maxAperture));
            double estimatedMemory = this.estimateWorkMemory(maxExtTileSize, destCopy.values(), srcCopy.values(), nt);
            MemoryModel betterModel = estimatedMemory < (double)TiledApertureProcessorFactory.this.maxTempJavaMemory ? Arrays.SMM : this.memoryModel();
            List srcTileMem = this.allocateTile(betterModel, maxExtTileSize, srcCopy, nt);
            List destTileMem = this.allocateTile(betterModel, maxExtTileSize, destCopy, nt);
            Matrix<IntArray> enumerator = Matrices.matrix(Arrays.nIntCopies(tileCount, 157), tileCounts);
            ArrayContext context = this.context();
            if (nt > 1) {
                context = context == null ? ArrayContext.DEFAULT_SINGLE_THREAD : context.singleThreadVersion();
            } else if (context == null) {
                context = ArrayContext.DEFAULT;
            }
            Runnable[] tasks = new Runnable[nt];
            Runnable[] postprocessing = new Runnable[nt];
            long readyElementsCount = 0L;
            int taskIndex = 0;
            for (long tileIndex = 0L; tileIndex < tileCount; ++tileIndex) {
                long[] tileIndexes = enumerator.coordinates(tileIndex, null);
                long[] tilePos = new long[TiledApertureProcessorFactory.this.dimCount];
                long[] tileDim = new long[TiledApertureProcessorFactory.this.dimCount];
                long[] tileMax = new long[TiledApertureProcessorFactory.this.dimCount];
                long[] extTilePos = new long[TiledApertureProcessorFactory.this.dimCount];
                long[] extTileDim = new long[TiledApertureProcessorFactory.this.dimCount];
                long[] extTileMax = new long[TiledApertureProcessorFactory.this.dimCount];
                long tileSize = 1L;
                for (int k = 0; k < TiledApertureProcessorFactory.this.dimCount; ++k) {
                    tilePos[k] = tileIndexes[k] * TiledApertureProcessorFactory.this.processingTileDim[k];
                    assert (tilePos[k] < lArray[k]);
                    tileDim[k] = Math.min(TiledApertureProcessorFactory.this.processingTileDim[k], lArray[k] - tilePos[k]);
                    assert (tileDim[k] > 0L);
                    tileMax[k] = tilePos[k] + tileDim[k] - 1L;
                    extTileDim[k] = DependenceApertureBuilder.safelyAdd(tileDim[k], maxAperture.width(k));
                    extTilePos[k] = tilePos[k] + maxAperture.min(k);
                    extTileMax[k] = tileMax[k] + maxAperture.max(k);
                    tileSize *= tileDim[k];
                }
                ArrayContext ac = nt == 1 ? context.part(readyElementsCount, readyElementsCount + tileSize, l) : context.noProgressVersion();
                Map srcTile = this.loadSrcTile(ac.part(0.0, 0.05), maxAperture, srcTileMem.get(taskIndex), srcCopy, tilePos, tileDim, extTileDim);
                Map destTile = this.prepareDestTile(destTileMem.get(taskIndex), destCopy.keySet(), extTileDim);
                int ti = taskIndex;
                tasks[taskIndex] = () -> {
                    ArrayContext tileContext = this.switchingContextSupported() ? ac.part(0.05, 0.95).multithreadingVersion(ti, nt).customDataVersion(new TileInformation(IRectangularArea.of(IPoint.of(tilePos), IPoint.of(tileMax)), IRectangularArea.of(IPoint.of(extTilePos), IPoint.of(extTileMax)))) : ac;
                    this.subtaskTileProcessor(tileContext).process(destTile, srcTile);
                };
                postprocessing[taskIndex] = () -> {
                    this.allocateDestMatricesIfNecessary(dim, destCopy, destTile);
                    this.saveDestTile(ac.part(0.95, 1.0), maxAperture, destCopy, destTile, tilePos, tileDim);
                    this.freeResources(destTile);
                };
                readyElementsCount += tileSize;
                if (++taskIndex == nt || tileIndex == tileCount - 1L) {
                    TiledApertureProcessorFactory.this.threadPoolFactory.performTasks(tasks, 0, taskIndex);
                    for (int i = 0; i < taskIndex; ++i) {
                        postprocessing[i].run();
                    }
                    Class<?> elementType = (!destCopy.isEmpty() ? (Matrix)destCopy.values().iterator().next() : (Matrix)srcCopy.values().iterator().next()).elementType();
                    context.checkInterruptionAndUpdateProgress(elementType, readyElementsCount, l);
                }
                if (taskIndex != nt) continue;
                taskIndex = 0;
            }
            for (Map.Entry e : destCopy.entrySet()) {
                Object key = e.getKey();
                if (dest.get(key) != null) continue;
                dest.put(key, (Matrix)e.getValue());
            }
        }

        @Override
        public IRectangularArea dependenceAperture(K srcMatrixKey) {
            return this.oneTileProcessor.dependenceAperture(srcMatrixKey);
        }

        public String toString() {
            return "aperture-dependent tiled processor of an " + String.valueOf(TiledApertureProcessorFactory.this);
        }

        private long[] getDimensionsAndCheck(Map<K, Matrix<? extends UpdatableArray>> dest, Map<K, Matrix<?>> src) {
            Matrix<UpdatableArray> m;
            K key;
            long[] result = null;
            for (Map.Entry<K, Matrix<UpdatableArray>> entry : dest.entrySet()) {
                key = entry.getKey();
                m = entry.getValue();
                if (m == null) continue;
                if (m.dimCount() != TiledApertureProcessorFactory.this.dimCount) {
                    throw new IllegalArgumentException("The destination matrix with key \"" + String.valueOf(key) + "\" has " + m.dimCount() + " dimensions, but this processing tiler works with " + TiledApertureProcessorFactory.this.dimCount + " dimensions");
                }
                if (result == null) {
                    result = m.dimensions();
                    continue;
                }
                if (m.dimEquals(result)) continue;
                throw new SizeMismatchException("The destination matrix with key \"" + String.valueOf(key) + "\" and the first matrix dimensions mismatch: the destination matrix with key \"" + String.valueOf(key) + "\" is " + String.valueOf(m) + ", but the first matrix has dimensions " + JArrays.toString(result, "x", 1000));
            }
            for (Map.Entry<K, Matrix<UpdatableArray>> entry : src.entrySet()) {
                key = entry.getKey();
                m = entry.getValue();
                assert (m != null);
                if (m.dimCount() != TiledApertureProcessorFactory.this.dimCount) {
                    throw new IllegalArgumentException("The source matrix with key \"" + String.valueOf(key) + "\" has " + m.dimCount() + " dimensions, but this processing tiler works with " + TiledApertureProcessorFactory.this.dimCount + " dimensions");
                }
                if (result == null) {
                    result = m.dimensions();
                    continue;
                }
                if (m.dimEquals(result)) continue;
                throw new SizeMismatchException("The source matrix with key \"" + String.valueOf(key) + "\" and the first matrix dimensions mismatch: the source matrix with key \"" + String.valueOf(key) + "\" is " + String.valueOf(m) + ", but the first matrix has dimensions " + JArrays.toString(result, "x", 1000));
            }
            return result;
        }

        private IRectangularArea maxDependenceAperture(Set<K> srcKeys) {
            long[] min = new long[TiledApertureProcessorFactory.this.dimCount];
            long[] max = new long[TiledApertureProcessorFactory.this.dimCount];
            for (K key : srcKeys) {
                IRectangularArea a = this.oneTileProcessor.dependenceAperture(key);
                for (int k = 0; k < TiledApertureProcessorFactory.this.dimCount; ++k) {
                    min[k] = Math.min(min[k], a.min(k));
                    max[k] = Math.max(max[k], a.max(k));
                }
            }
            return IRectangularArea.of(IPoint.of(min), IPoint.of(max));
        }

        private double estimateWorkMemory(long extendedTileSize, Collection<Matrix<? extends UpdatableArray>> destList, Collection<Matrix<?>> srcList, int numberOfTasks) {
            double result = 0.0;
            for (Matrix<?> matrix : srcList) {
                result += Math.max(Arrays.sizeOf(matrix.elementType()), 0.0) * (double)extendedTileSize;
            }
            for (Matrix<Object> matrix : destList) {
                if (matrix == null) continue;
                result += Math.max(Arrays.sizeOf(matrix.elementType()), 0.0) * (double)extendedTileSize;
            }
            return result * (double)numberOfTasks;
        }

        private List<Map<K, UpdatableArray>> allocateTile(MemoryModel betterMemoryModel, long extendedTileSize, Map<K, ? extends Matrix<?>> processorArguments, int numberOfTasks) {
            ArrayList<Map<K, UpdatableArray>> result = new ArrayList<Map<K, UpdatableArray>>();
            for (int taskIndex = 0; taskIndex < numberOfTasks; ++taskIndex) {
                LinkedHashMap<K, UpdatableArray> tileMemory = new LinkedHashMap<K, UpdatableArray>();
                for (Map.Entry<K, Matrix<?>> e : processorArguments.entrySet()) {
                    Matrix<?> m = e.getValue();
                    if (m == null) continue;
                    K key = e.getKey();
                    MemoryModel mm = Arrays.sizeOf(m.elementType()) < 0.0 ? this.memoryModel() : betterMemoryModel;
                    tileMemory.put(key, mm.newUnresizableArray(m.elementType(), extendedTileSize));
                }
                result.add(tileMemory);
            }
            return result;
        }

        private Map<K, Matrix<?>> loadSrcTile(ArrayContext ac, IRectangularArea maxAperture, Map<K, UpdatableArray> srcTileMem, Map<K, Matrix<?>> src, long[] tilePos, long[] tileDim, long[] extTileDim) {
            long len = Arrays.longMul(extTileDim);
            LinkedHashMap<K, Matrix<UpdatableArray>> srcTile = new LinkedHashMap<K, Matrix<UpdatableArray>>();
            long[] inTilePos = new long[TiledApertureProcessorFactory.this.dimCount];
            long[] preciseTileDim = new long[TiledApertureProcessorFactory.this.dimCount];
            long[] preciseTilePos = new long[TiledApertureProcessorFactory.this.dimCount];
            int i = 0;
            int n = src.size();
            for (Map.Entry<K, Matrix<?>> e : src.entrySet()) {
                K key = e.getKey();
                Matrix<UpdatableArray> tileMatrix = Matrices.matrix(srcTileMem.get(key).subArr(0L, len), extTileDim);
                IRectangularArea a = this.oneTileProcessor.dependenceAperture(key);
                assert (a != null) : "Null dependenceAperture(" + String.valueOf(key) + ")";
                for (int k = 0; k < TiledApertureProcessorFactory.this.dimCount; ++k) {
                    inTilePos[k] = a.min(k) - maxAperture.min(k);
                    preciseTilePos[k] = tilePos[k] + a.min(k);
                    preciseTileDim[k] = DependenceApertureBuilder.safelyAdd(tileDim[k], a.width(k));
                }
                Matrices.copy(ac.part(i++, i, n), tileMatrix.subMatr(inTilePos, preciseTileDim), e.getValue().subMatr(preciseTilePos, preciseTileDim, TiledApertureProcessorFactory.this.continuationMode));
                srcTile.put(key, tileMatrix);
            }
            return srcTile;
        }

        private Map<K, Matrix<?>> prepareDestTile(Map<K, UpdatableArray> destTileMem, Set<K> destKeys, long[] extTileDim) {
            long len = Arrays.longMul(extTileDim);
            LinkedHashMap<K, Matrix<UpdatableArray>> destTile = new LinkedHashMap<K, Matrix<UpdatableArray>>();
            Iterator<K> iterator = destKeys.iterator();
            while (iterator.hasNext()) {
                K key;
                UpdatableArray a = destTileMem.get(key = iterator.next());
                destTile.put(key, a == null ? null : Matrices.matrix(a.subArr(0L, len), extTileDim));
            }
            return destTile;
        }

        private void allocateDestMatricesIfNecessary(long[] dim, Map<K, Matrix<? extends UpdatableArray>> dest, Map<K, Matrix<?>> destTile) {
            K key;
            for (Map.Entry<K, Matrix<?>> entry : destTile.entrySet()) {
                key = entry.getKey();
                if (dest.get(key) != null) continue;
                Matrix<?> destTileMatrix = entry.getValue();
                if (destTileMatrix == null) {
                    throw new AssertionError((Object)("Illegal implementation of one-tile processor " + String.valueOf(this.oneTileProcessor.getClass()) + (dest.containsKey(key) ? ": it leaves null result matrix" : ": it creates null result") + " for the key \"" + String.valueOf(key) + "\""));
                }
                Matrix<UpdatableArray> destMatrix = this.memoryModel().newMatrix(UpdatableArray.class, destTileMatrix.elementType(), dim);
                if (TiledApertureProcessorFactory.this.allocationTileDim != null) {
                    destMatrix = destMatrix.tile(TiledApertureProcessorFactory.this.allocationTileDim);
                }
                dest.put(key, destMatrix);
            }
            for (Map.Entry<K, Matrix<Object>> entry : dest.entrySet()) {
                key = entry.getKey();
                if (entry.getValue() == null) {
                    throw new AssertionError((Object)("Illegal implementation of one-tile processor " + String.valueOf(this.oneTileProcessor.getClass()) + ": it does not allocate necessary result matrix with the key \"" + String.valueOf(key) + "\""));
                }
                if (destTile.get(key) == null) {
                    throw new AssertionError((Object)("Illegal implementation of one-tile processor " + String.valueOf(this.oneTileProcessor.getClass()) + ": it removes the matrix with the key \"" + String.valueOf(key) + "\" from the list of resulting arguments"));
                }
            }
            assert (dest.size() == destTile.size());
        }

        private void saveDestTile(ArrayContext ac, IRectangularArea maxAperture, Map<K, Matrix<? extends UpdatableArray>> dest, Map<K, Matrix<?>> destTile, long[] tilePos, long[] tileDim) {
            long[] inTilePos = maxAperture.min().symmetric().coordinates();
            int i = 0;
            int n = dest.size();
            for (Map.Entry<K, Matrix<UpdatableArray>> e : dest.entrySet()) {
                K key = e.getKey();
                Matrix<? extends UpdatableArray> destMatrix = e.getValue();
                assert (destMatrix != null) : "internal bug: dest matrix with the key \"" + String.valueOf(key) + "\" is not allocated";
                Matrix<?> destTileMatrix = destTile.get(key);
                Matrices.copy(ac.part(i++, i, n), destMatrix.subMatr(tilePos, tileDim), destTileMatrix.subMatr(inTilePos, tileDim));
            }
        }

        private void freeResources(Map<?, Matrix<?>> tile) {
            for (Matrix<?> m : tile.values()) {
                m.freeResources();
            }
        }

        private ApertureProcessor<K> subtaskTileProcessor(ArrayContext tileContext) {
            assert (tileContext != null) : "Null tileContext";
            if (!this.switchingContextSupported()) {
                return this.oneTileProcessor;
            }
            ArrayProcessorWithContextSwitching p = ((ArrayProcessorWithContextSwitching)((Object)this.oneTileProcessor)).context(tileContext);
            if (!(p instanceof ApertureProcessor)) {
                throw new AssertionError((Object)("Illegal implementation of one-tile processor, " + String.valueOf(this.oneTileProcessor.getClass()) + ": it implements " + String.valueOf(ApertureProcessor.class) + ", but after switching context the result does not implement it"));
            }
            return (ApertureProcessor)((Object)p);
        }

        private boolean switchingContextSupported() {
            return this.oneTileProcessor instanceof ArrayProcessorWithContextSwitching;
        }
    }

    public static final class TileInformation {
        private final IRectangularArea tile;
        private final IRectangularArea extendedTile;

        private TileInformation(IRectangularArea tile, IRectangularArea extendedTile) {
            assert (tile != null && extendedTile != null);
            this.tile = tile;
            this.extendedTile = extendedTile;
        }

        public IRectangularArea getTile() {
            return this.tile;
        }

        public IRectangularArea getExtendedTile() {
            return this.extendedTile;
        }
    }
}

