/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import net.algart.math.IRangeFinder;
import net.algart.math.IRectangularArea;
import net.algart.math.rectangles.IRectangleFinderWithoutOptimization;

public abstract class IRectangleFinder {
    IntUnaryOperator minX = null;
    IntUnaryOperator maxX = null;
    IntUnaryOperator minY = null;
    IntUnaryOperator maxY = null;
    IntUnaryOperator left2 = null;
    IntUnaryOperator right2 = null;
    int n = 0;
    final IRangeFinder rangeFinder = IRangeFinder.getEmptyInstance();

    public static IRectangleFinder getEmptyInstance() {
        return IRectangleFinder.getEmptyInstance(false);
    }

    public static IRectangleFinder getEmptyInstance(boolean horizontal) {
        return horizontal ? new Horizontal() : new Vertical();
    }

    public static IRectangleFinder getEmptyUnoptimizedInstance() {
        return new IRectangleFinderWithoutOptimization();
    }

    public static IRectangleFinder getInstance(IntUnaryOperator minX, IntUnaryOperator maxX, IntUnaryOperator minY, IntUnaryOperator maxY, int numberOfRectangles) {
        return IRectangleFinder.getEmptyInstance().setRectangles(minX, maxX, minY, maxY, numberOfRectangles);
    }

    public static IRectangleFinder getInstance(int[] minX, int[] maxX, int[] minY, int[] maxY) {
        Objects.requireNonNull(minX, "Null minX");
        Objects.requireNonNull(maxX, "Null maxX");
        Objects.requireNonNull(minY, "Null minY");
        Objects.requireNonNull(maxY, "Null maxY");
        if (maxX.length != minX.length || minY.length != minX.length || maxY.length != minX.length) {
            throw new IllegalArgumentException("Different lengths of arrays of minimal/maximal coordinates");
        }
        return IRectangleFinder.getInstance(i -> minX[i], i -> maxX[i], i -> minY[i], i -> maxY[i], minX.length);
    }

    public IntUnaryOperator minX() {
        return this.minX;
    }

    public IntUnaryOperator maxX() {
        return this.maxX;
    }

    public IntUnaryOperator minY() {
        return this.minY;
    }

    public IntUnaryOperator maxY() {
        return this.maxY;
    }

    public final int minX(int k) {
        return this.minX.applyAsInt(k);
    }

    public final int maxX(int k) {
        return this.maxX.applyAsInt(k);
    }

    public final int minY(int k) {
        return this.minY.applyAsInt(k);
    }

    public final int maxY(int k) {
        return this.maxY.applyAsInt(k);
    }

    public final int numberOfRectangles() {
        return this.n;
    }

    public final IRectangleFinder setRectangles(IntUnaryOperator minX, IntUnaryOperator maxX, IntUnaryOperator minY, IntUnaryOperator maxY, int numberOfRectangles) {
        if (numberOfRectangles < 0) {
            throw new IllegalArgumentException("Negative number of rectangles " + numberOfRectangles);
        }
        IRectangleFinder.checkRectangles(minX, maxX, minY, maxY, numberOfRectangles);
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.n = numberOfRectangles;
        this.setRanges();
        return this;
    }

    public final IRectangleFinder setRectangles(int[] minX, int[] maxX, int[] minY, int[] maxY) {
        Objects.requireNonNull(minX, "Null minX");
        Objects.requireNonNull(maxX, "Null maxX");
        Objects.requireNonNull(minY, "Null minY");
        Objects.requireNonNull(maxY, "Null maxY");
        if (maxX.length != minX.length || minY.length != minX.length || maxY.length != minX.length) {
            throw new IllegalArgumentException("Different lengths of arrays of minimal/maximal coordinates");
        }
        return this.setRectangles(i -> minX[i], i -> maxX[i], i -> minY[i], i -> maxY[i], minX.length);
    }

    public final IRectangleFinder setIndexedRectangles(int[] minX, int[] maxX, int[] minY, int[] maxY, int[] indexes, int numberOfRectangles) {
        Objects.requireNonNull(minX, "Null minX");
        Objects.requireNonNull(maxX, "Null maxX");
        Objects.requireNonNull(minY, "Null minY");
        Objects.requireNonNull(maxY, "Null maxY");
        Objects.requireNonNull(indexes, "Null indexes");
        if (maxX.length != minX.length || minY.length != minX.length || maxY.length != minX.length) {
            throw new IllegalArgumentException("Different lengths of arrays of minimal/maximal coordinates");
        }
        if (numberOfRectangles < 0) {
            throw new IllegalArgumentException("Negative number of rectangles");
        }
        if (numberOfRectangles > indexes.length) {
            throw new IllegalArgumentException("Number of rectangles " + numberOfRectangles + " > indexes array length = " + indexes.length);
        }
        return this.setRectangles(i -> minX[indexes[i]], i -> maxX[indexes[i]], i -> minY[indexes[i]], i -> maxY[indexes[i]], numberOfRectangles);
    }

    public final IRectangleFinder setIndexActual(IntPredicate indexActual) {
        this.rangeFinder.setIndexActual(indexActual);
        return this;
    }

    public final IRectangleFinder setAllIndexesActual() {
        this.rangeFinder.setAllIndexesActual();
        return this;
    }

    public final boolean indexActual(int k) {
        return this.rangeFinder.indexActual(k);
    }

    public IRectangleFinder compact() {
        this.rangeFinder.compact();
        return this;
    }

    public abstract void findContaining(int var1, int var2, IntConsumer var3);

    public int findContaining(int x, int y, int[] resultIndexes) {
        IRangeFinder.IntArrayAppender appender = new IRangeFinder.IntArrayAppender(resultIndexes);
        this.findContaining(x, y, (IntConsumer)appender);
        return appender.offset();
    }

    public abstract void findContaining(double var1, double var3, IntConsumer var5);

    public int findContaining(double x, double y, int[] resultIndexes) {
        IRangeFinder.IntArrayAppender appender = new IRangeFinder.IntArrayAppender(resultIndexes);
        this.findContaining(x, y, (IntConsumer)appender);
        return appender.offset();
    }

    public abstract void findIntersecting(int var1, int var2, int var3, int var4, IntConsumer var5);

    public int findIntersecting(int minX, int maxX, int minY, int maxY, int[] resultIndexes) {
        IRangeFinder.IntArrayAppender appender = new IRangeFinder.IntArrayAppender(resultIndexes);
        this.findIntersecting(minX, maxX, minY, maxY, appender);
        return appender.offset();
    }

    public void clear() {
        this.rangeFinder.clear();
        this.minX = null;
        this.maxX = null;
        this.minY = null;
        this.maxY = null;
        this.left2 = null;
        this.right2 = null;
        this.n = 0;
    }

    public String toString() {
        return this.algorithmName() + " for " + this.n + " rectangles" + (this.n == 0 ? " (empty)" : "") + ", based on " + String.valueOf(this.rangeFinder);
    }

    protected abstract void setRanges();

    protected String algorithmName() {
        return "finder";
    }

    private static IRectangularArea checkAndFindContainingRectangle(IntUnaryOperator minX, IntUnaryOperator maxX, IntUnaryOperator minY, IntUnaryOperator maxY, int numberOfRectangles) {
        if (numberOfRectangles <= 0) {
            return null;
        }
        Objects.requireNonNull(minX, "Null operator for getting minX bounds");
        Objects.requireNonNull(maxX, "Null operator for getting maxX bounds");
        Objects.requireNonNull(minY, "Null operator for getting minY bounds");
        Objects.requireNonNull(maxY, "Null operator for getting maxY bounds");
        return IntStream.range(0, numberOfRectangles + 1023 >>> 10).parallel().mapToObj(block -> {
            int i;
            int containingMinX = Integer.MAX_VALUE;
            int containingMaxX = Integer.MIN_VALUE;
            int containingMinY = Integer.MAX_VALUE;
            int containingMaxY = Integer.MIN_VALUE;
            int to = (int)Math.min((long)i + 1024L, (long)numberOfRectangles);
            for (i = block << 10; i < to; ++i) {
                int rMinX = minX.applyAsInt(i);
                int rMaxX = maxX.applyAsInt(i);
                int rMinY = minY.applyAsInt(i);
                int rMaxY = maxY.applyAsInt(i);
                if (rMinX > rMaxX) {
                    throw new IllegalArgumentException("Illegal rectangle #" + i + ": minX > maxX");
                }
                if (rMinY > rMaxY) {
                    throw new IllegalArgumentException("Illegal rectangle #" + i + ": minY > maxY");
                }
                if (rMinX < containingMinX) {
                    containingMinX = rMinX;
                }
                if (rMaxX > containingMaxX) {
                    containingMaxX = rMaxX;
                }
                if (rMinY < containingMinY) {
                    containingMinY = rMinY;
                }
                if (rMaxY <= containingMaxY) continue;
                containingMaxY = rMaxY;
            }
            return IRectangularArea.of(containingMinX, containingMinY, containingMaxX, containingMaxY);
        }).reduce(IRectangularArea::expand).orElse(null);
    }

    private static void checkRectangles(IntUnaryOperator minX, IntUnaryOperator maxX, IntUnaryOperator minY, IntUnaryOperator maxY, int numberOfRectangles) {
        if (numberOfRectangles <= 0) {
            return;
        }
        Objects.requireNonNull(minX, "Null operator for getting minX bounds");
        Objects.requireNonNull(maxX, "Null operator for getting maxX bounds");
        Objects.requireNonNull(minY, "Null operator for getting minY bounds");
        Objects.requireNonNull(maxY, "Null operator for getting maxY bounds");
        IntStream.range(0, numberOfRectangles + 1023 >>> 10).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 1024L, (long)numberOfRectangles);
            for (i = block << 10; i < to; ++i) {
                int rMinX = minX.applyAsInt(i);
                int rMaxX = maxX.applyAsInt(i);
                int rMinY = minY.applyAsInt(i);
                int rMaxY = maxY.applyAsInt(i);
                if (rMinX > rMaxX) {
                    throw new IllegalArgumentException("Illegal rectangle #" + i + ": minX > maxX");
                }
                if (rMinY <= rMaxY) continue;
                throw new IllegalArgumentException("Illegal rectangle #" + i + ": minY > maxY");
            }
        });
    }

    private static class Horizontal
    extends IRectangleFinder {
        private Horizontal() {
        }

        @Override
        public void findContaining(int x, int y, IntConsumer indexConsumer) {
            this.rangeFinder.findContaining(x, index -> {
                if (this.left2.applyAsInt(index) <= y && this.right2.applyAsInt(index) >= y) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        public void findContaining(double x, double y, IntConsumer indexConsumer) {
            if (y < -2.147483648E9 || y > 2.147483647E9) {
                return;
            }
            this.rangeFinder.findContaining(x, index -> {
                if ((double)this.left2.applyAsInt(index) <= y && (double)this.right2.applyAsInt(index) >= y) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        public void findIntersecting(int minX, int maxX, int minY, int maxY, IntConsumer indexConsumer) {
            if (minX > maxX || minY > maxY) {
                return;
            }
            this.rangeFinder.findIntersecting(minX, maxX, index -> {
                if (this.left2.applyAsInt(index) <= maxY && this.right2.applyAsInt(index) >= minY) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        protected void setRanges() {
            this.rangeFinder.setRanges(this.minX, this.maxX, this.n);
            this.left2 = this.minY;
            this.right2 = this.maxY;
        }

        @Override
        protected String algorithmName() {
            return "horizontal-splitting integer rectangles finder";
        }
    }

    private static class Vertical
    extends IRectangleFinder {
        private Vertical() {
        }

        @Override
        public void findContaining(int x, int y, IntConsumer indexConsumer) {
            this.rangeFinder.findContaining(y, index -> {
                if (this.left2.applyAsInt(index) <= x && this.right2.applyAsInt(index) >= x) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        public void findContaining(double x, double y, IntConsumer indexConsumer) {
            if (x < -2.147483648E9 || x > 2.147483647E9) {
                return;
            }
            this.rangeFinder.findContaining(y, index -> {
                if ((double)this.left2.applyAsInt(index) <= x && (double)this.right2.applyAsInt(index) >= x) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        public void findIntersecting(int minX, int maxX, int minY, int maxY, IntConsumer indexConsumer) {
            if (minX > maxX || minY > maxY) {
                return;
            }
            this.rangeFinder.findIntersecting(minY, maxY, index -> {
                if (this.left2.applyAsInt(index) <= maxX && this.right2.applyAsInt(index) >= minX) {
                    indexConsumer.accept(index);
                }
            });
        }

        @Override
        protected void setRanges() {
            this.rangeFinder.setRanges(this.minY, this.maxY, this.n);
            this.left2 = this.minX;
            this.right2 = this.maxX;
        }

        @Override
        protected String algorithmName() {
            return "vertical-splitting integer rectangles finder";
        }
    }
}

