/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.rectangles;

import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.algart.math.rectangles.IRectanglesUnion;

class HorizontalBoundaryIBracketSet<L extends IRectanglesUnion.BoundaryLink> {
    private final List<L> allHorizontals;
    private final int numberOfHorizontals;
    int horizontalIndex;
    L horizontal;
    long coord;
    private final NavigableSet<Integer> intersectingLinks = new TreeSet<Integer>();

    public HorizontalBoundaryIBracketSet(List<L> allHorizontals) {
        assert (allHorizontals != null);
        assert (!allHorizontals.isEmpty());
        this.allHorizontals = allHorizontals;
        this.numberOfHorizontals = allHorizontals.size();
        this.horizontalIndex = -1;
        this.horizontal = null;
        if (IRectanglesUnion.DEBUG_LEVEL >= 2) {
            int n = allHorizontals.size();
            for (int k = 1; k < n; ++k) {
                assert (((IRectanglesUnion.BoundaryLink)allHorizontals.get(k - 1)).coord() <= ((IRectanglesUnion.BoundaryLink)allHorizontals.get(k)).coord());
            }
        }
    }

    public boolean next() {
        long newCoord;
        if (this.horizontalIndex == this.numberOfHorizontals) {
            throw new IllegalArgumentException(String.valueOf(this.getClass()) + " should not be used more");
        }
        assert (this.horizontalIndex < this.numberOfHorizontals);
        IRectanglesUnion.BoundaryLink newHorizontal = this.horizontalIndex + 1 < this.numberOfHorizontals ? (IRectanglesUnion.BoundaryLink)this.allHorizontals.get(this.horizontalIndex + 1) : null;
        long l = newCoord = newHorizontal == null ? -157L : newHorizontal.coord();
        if (this.horizontal == null || newHorizontal == null || newHorizontal.coord() != ((IRectanglesUnion.BoundaryLink)this.horizontal).coord()) {
            IRectanglesUnion.BoundaryLink h;
            int index;
            if (this.horizontal != null) {
                for (index = this.horizontalIndex; index >= 0 && (h = (IRectanglesUnion.BoundaryLink)this.allHorizontals.get(index)).coord() == this.coord; --index) {
                    this.removeHorizontal(h);
                }
            }
            if (newHorizontal != null) {
                for (index = this.horizontalIndex + 1; index < this.numberOfHorizontals && (h = (IRectanglesUnion.BoundaryLink)this.allHorizontals.get(index)).coord() == newCoord; ++index) {
                    this.addHorizontal(h);
                }
            }
        }
        assert (this.intersectingLinks.size() % 2 == 0);
        ++this.horizontalIndex;
        this.horizontal = newHorizontal;
        this.coord = newCoord;
        if (newHorizontal == null && !this.intersectingLinks.isEmpty()) {
            throw new AssertionError((Object)"Non-empty intersection set at the end of the loop");
        }
        if (IRectanglesUnion.DEBUG_LEVEL >= 3) {
            IRectanglesUnion.debug(3, "  Horizontal #%d, y=%d%s, %s; brackets: %s%n", this.horizontalIndex, this.coord, this.horizontal == null ? " (LOOP FINISHED)" : (((IRectanglesUnion.BoundaryLink)this.horizontal).atFirstOfTwoParallelSides() ? " (starting)" : " (ending)"), this.horizontal, this.intersectingLinks);
        }
        return this.horizontal != null;
    }

    public int maxLeftIndexBeloningToUnion() {
        int fromIndex = ((IRectanglesUnion.BoundaryLink)this.horizontal).linkFrom().parentSeries.numberOfLessCoordinatesAtBoundary;
        assert (fromIndex >= 0);
        NavigableSet<Integer> headSet = this.intersectingLinks.headSet(fromIndex, false);
        if (headSet.size() % 2 == 0) {
            return fromIndex;
        }
        return (Integer)headSet.last();
    }

    public int minRightIndexBeloningToUnion() {
        int toIndex = ((IRectanglesUnion.BoundaryLink)this.horizontal).linkTo().parentSeries.numberOfLessCoordinatesAtBoundary;
        assert (toIndex >= 0);
        NavigableSet<Integer> tailSet = this.intersectingLinks.tailSet(toIndex, false);
        if (tailSet.size() % 2 == 0) {
            return toIndex;
        }
        return (Integer)tailSet.first();
    }

    private void addHorizontal(IRectanglesUnion.BoundaryLink h) {
        if (h.atFirstOfTwoParallelSides()) {
            boolean lessTo;
            IRectanglesUnion.BoundaryLink linkFrom = h.linkFrom();
            IRectanglesUnion.BoundaryLink linkTo = h.linkTo();
            boolean lessFrom = linkFrom.linkTo() == h;
            boolean bl = lessTo = linkTo.linkTo() == h;
            assert (lessFrom || linkFrom.linkFrom() == h);
            assert (lessTo || linkTo.linkFrom() == h);
            if (!lessFrom) {
                if (!lessTo) {
                    this.addBracket(linkFrom);
                    this.addBracket(linkTo);
                } else {
                    this.addBracket(linkFrom);
                    this.removeBracket(linkTo);
                }
            } else if (!lessTo) {
                this.addBracket(linkTo);
                this.removeBracket(linkFrom);
            } else {
                this.removeBracket(linkFrom);
                this.removeBracket(linkTo);
            }
        }
    }

    private void removeHorizontal(IRectanglesUnion.BoundaryLink h) {
        if (h.atSecondOfTwoParallelSides()) {
            boolean lessTo;
            IRectanglesUnion.BoundaryLink linkFrom = h.linkFrom();
            IRectanglesUnion.BoundaryLink linkTo = h.linkTo();
            boolean lessFrom = linkFrom.linkTo() == h;
            boolean bl = lessTo = linkTo.linkTo() == h;
            assert (lessFrom || linkFrom.linkFrom() == h);
            assert (lessTo || linkTo.linkFrom() == h);
            if (lessFrom) {
                if (lessTo) {
                    this.removeBracket(linkFrom);
                    this.removeBracket(linkTo);
                } else {
                    this.removeBracket(linkFrom);
                    this.addBracket(linkTo);
                }
            } else if (lessTo) {
                this.removeBracket(linkTo);
                this.addBracket(linkFrom);
            } else {
                this.addBracket(linkFrom);
                this.addBracket(linkTo);
            }
        }
    }

    private void addBracket(IRectanglesUnion.BoundaryLink link) {
        assert (link.parentSeries.indexInSortedListAtBoundary >= 0) : "indexInSortedListAtBoundary is not set in " + String.valueOf(link.parentSeries);
        boolean newlyAdded = this.intersectingLinks.add(link.parentSeries.numberOfLessCoordinatesAtBoundary);
        assert (newlyAdded);
    }

    private void removeBracket(IRectanglesUnion.BoundaryLink link) {
        assert (link.parentSeries.indexInSortedListAtBoundary >= 0) : "indexInSortedListAtBoundary is not set in " + String.valueOf(link.parentSeries);
        boolean contained = this.intersectingLinks.remove(link.parentSeries.numberOfLessCoordinatesAtBoundary);
        assert (contained);
    }
}

