/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.patterns.AbstractUniformGridPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.RectangularPattern;
import net.algart.math.patterns.TooManyPointsInPatternError;
import net.algart.math.patterns.UniformGridPattern;

final class BasicRectangularPattern
extends AbstractUniformGridPattern
implements RectangularPattern {
    private final IRectangularArea gridIndexArea;
    private final long pointCount;
    private final double largePointCount;
    private final boolean veryLarge;
    private volatile Reference<Set<Point>> pointsRef = null;
    private volatile Reference<Set<IPoint>> gridIndexesRef = null;

    BasicRectangularPattern(IRange[] gridIndexRanges) {
        this(Point.origin(gridIndexRanges.length), Point.ofEqualCoordinates(gridIndexRanges.length, 1.0).coordinates(), gridIndexRanges);
    }

    BasicRectangularPattern(Point originOfGrid, double[] stepsOfGrid, IRange[] gridIndexRanges) {
        super(originOfGrid, stepsOfGrid, true);
        Objects.requireNonNull(gridIndexRanges, "Null coordinate ranges argument");
        if (gridIndexRanges.length != originOfGrid.coordCount()) {
            throw new IllegalArgumentException("The number of coordinate ranges is not equal to the number of origin dimensions");
        }
        System.arraycopy(gridIndexRanges, 0, this.gridIndexRanges, 0, gridIndexRanges.length);
        long count = 1L;
        double largeCount = 1.0;
        for (int k = 0; k < this.gridIndexRanges.length; ++k) {
            IRange gridIndexRange = this.gridIndexRanges[k];
            BasicRectangularPattern.checkGridIndexRange(gridIndexRange);
            BasicRectangularPattern.checkCoordRange(this.coordRange(k, gridIndexRange));
            long size = gridIndexRange.size();
            if (count != Long.MIN_VALUE) {
                count = net.algart.arrays.Arrays.longMul(count, size);
            }
            largeCount *= (double)size;
        }
        this.gridIndexArea = IRectangularArea.of(this.gridIndexRanges);
        this.pointCount = count == Long.MIN_VALUE ? Long.MAX_VALUE : count;
        this.largePointCount = count == Long.MIN_VALUE ? largeCount : (double)count;
        this.veryLarge = count == Long.MIN_VALUE;
    }

    @Override
    public Set<IPoint> gridIndexes() {
        Set<IPoint> resultIndexes;
        if (this.pointCount > Integer.MAX_VALUE) {
            throw new TooManyPointsInPatternError("Too large number of points: " + this.largePointCount + " > Integer.MAX_VALUE");
        }
        Set<IPoint> set = resultIndexes = this.gridIndexesRef == null ? null : this.gridIndexesRef.get();
        if (resultIndexes == null) {
            resultIndexes = new HashSet<IPoint>((int)this.pointCount);
            this.addIPointsToParallelepiped(resultIndexes, new long[this.dimCount], 0);
            this.gridIndexesRef = new SoftReference<Set<IPoint>>(resultIndexes);
        }
        return Collections.unmodifiableSet(resultIndexes);
    }

    @Override
    public IRange gridIndexRange(int coordIndex) {
        return this.gridIndexRanges[coordIndex];
    }

    @Override
    public IRectangularArea gridIndexArea() {
        return this.gridIndexArea;
    }

    @Override
    public boolean isActuallyRectangular() {
        return true;
    }

    @Override
    public RectangularPattern gridIndexPattern() {
        return this.zeroOriginOfGrid && this.unitStepsOfGrid ? this : new BasicRectangularPattern(this.gridIndexRanges);
    }

    @Override
    public RectangularPattern shiftGridIndexes(IPoint shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        IRange[] newRanges = new IRange[this.gridIndexRanges.length];
        for (int k = 0; k < this.gridIndexRanges.length; ++k) {
            long sh = shift.coord(k);
            long newMin = this.gridIndexRanges[k].min() + sh;
            long newMax = this.gridIndexRanges[k].max() + sh;
            BasicRectangularPattern.checkGridIndexRange(newMin, newMax);
            newRanges[k] = IRange.of(newMin, newMax);
        }
        return new BasicRectangularPattern(this.originOfGrid, this.stepsOfGrid, newRanges);
    }

    @Override
    public RectangularPattern lowerSurface(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        IRange[] surfaceRanges = (IRange[])this.gridIndexRanges.clone();
        long coord = this.gridIndexRange(coordIndex).min();
        surfaceRanges[coordIndex] = IRange.of(coord, coord);
        return Patterns.newRectangularIntegerPattern(surfaceRanges).scale(this.stepsOfGrid).shift(this.originOfGrid);
    }

    @Override
    public RectangularPattern upperSurface(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        IRange[] surfaceRanges = (IRange[])this.gridIndexRanges.clone();
        long coord = this.gridIndexRange(coordIndex).max();
        surfaceRanges[coordIndex] = IRange.of(coord, coord);
        return Patterns.newRectangularIntegerPattern(surfaceRanges).scale(this.stepsOfGrid).shift(this.originOfGrid);
    }

    @Override
    public Pattern surface() {
        Pattern[] facets = new Pattern[2 * this.dimCount];
        IRange[] surfaceRanges = (IRange[])this.gridIndexRanges.clone();
        int facetIndex = 0;
        for (int coordIndex = surfaceRanges.length - 1; coordIndex >= 0; --coordIndex) {
            long min = this.gridIndexRange(coordIndex).min();
            surfaceRanges[coordIndex] = IRange.of(min, min);
            facets[facetIndex++] = Patterns.newRectangularIntegerPattern(surfaceRanges).scale(this.stepsOfGrid).shift(this.originOfGrid);
            long max = this.gridIndexRange(coordIndex).max();
            assert (max >= min);
            if (max == min) break;
            surfaceRanges[coordIndex] = IRange.of(max, max);
            facets[facetIndex++] = Patterns.newRectangularIntegerPattern(surfaceRanges).scale(this.stepsOfGrid).shift(this.originOfGrid);
            if (max - min == 1L) break;
            surfaceRanges[coordIndex] = IRange.of(min + 1L, max - 1L);
        }
        Pattern[] result = new Pattern[facetIndex];
        System.arraycopy(facets, 0, result, 0, facetIndex);
        return Patterns.newUnion(result);
    }

    @Override
    public long pointCount() {
        return this.pointCount;
    }

    @Override
    public double largePointCount() {
        return this.largePointCount;
    }

    @Override
    public boolean isSurelySinglePoint() {
        return this.pointCount == 1L;
    }

    @Override
    public boolean isPointCountVeryLarge() {
        return this.veryLarge;
    }

    @Override
    public Set<Point> points() {
        Set<Point> resultIndexes;
        if (this.pointCount > Integer.MAX_VALUE) {
            throw new TooManyPointsInPatternError("Too large number of points: " + this.largePointCount + " > Integer.MAX_VALUE");
        }
        Set<Point> set = resultIndexes = this.pointsRef == null ? null : this.pointsRef.get();
        if (resultIndexes == null) {
            resultIndexes = new HashSet<Point>((int)this.pointCount);
            this.addPointsToParallelepiped(resultIndexes, new long[this.dimCount], 0);
            this.pointsRef = new SoftReference<Set<Point>>(resultIndexes);
        }
        return Collections.unmodifiableSet(resultIndexes);
    }

    @Override
    public UniformGridPattern round() {
        if (this.zeroOriginOfGrid && this.unitStepsOfGrid) {
            return this;
        }
        return new BasicRectangularPattern(this.roundedCoordArea().ranges());
    }

    @Override
    public RectangularPattern shift(Point shift) {
        Objects.requireNonNull(shift, "Null shift argument");
        if (shift.coordCount() != this.dimCount) {
            throw new IllegalArgumentException("The number of shift coordinates " + shift.coordCount() + " is not equal to the number of pattern coordinates " + this.dimCount);
        }
        if (shift.isOrigin()) {
            return this;
        }
        return new BasicRectangularPattern(this.originOfGrid.add(shift), this.stepsOfGrid, this.gridIndexRanges);
    }

    @Override
    public RectangularPattern symmetric() {
        return (RectangularPattern)super.symmetric();
    }

    @Override
    public RectangularPattern multiply(double multiplier) {
        return (RectangularPattern)super.multiply(multiplier);
    }

    @Override
    public RectangularPattern scale(double ... multipliers) {
        Objects.requireNonNull(multipliers, "Null multipliers argument");
        if (multipliers.length != this.dimCount) {
            throw new IllegalArgumentException("Illegal number of multipliers: " + multipliers.length + " instead of " + this.dimCount);
        }
        double[] positiveMultipliers = (double[])multipliers.clone();
        multipliers = (double[])multipliers.clone();
        IRange[] newRanges = this.gridIndexRanges;
        boolean allPositive = true;
        boolean allUnit = true;
        for (double m : multipliers) {
            allPositive &= m > 0.0;
            allUnit &= m == 1.0;
        }
        if (allUnit) {
            return this;
        }
        if (!allPositive) {
            int k;
            for (k = 0; k < multipliers.length; ++k) {
                positiveMultipliers[k] = multipliers[k] < 0.0 ? -multipliers[k] : (multipliers[k] == 0.0 ? 1.0 : multipliers[k]);
            }
            newRanges = new IRange[this.dimCount];
            for (k = 0; k < this.dimCount; ++k) {
                newRanges[k] = multipliers[k] < 0.0 ? IRange.of(-this.gridIndexRanges[k].max(), -this.gridIndexRanges[k].min()) : (multipliers[k] == 0.0 ? IRange.of(0L, 0L) : this.gridIndexRanges[k]);
            }
        }
        return new BasicRectangularPattern(this.zeroOriginOfGrid ? this.originOfGrid : this.originOfGrid.scale(multipliers), this.unitStepsOfGrid ? positiveMultipliers : this.stepsVector.scale(positiveMultipliers).coordinates(), newRanges);
    }

    @Override
    public RectangularPattern projectionAlongAxis(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        assert (this.dimCount > 0);
        if (this.dimCount == 1) {
            throw new IllegalStateException("Cannot perform projection for 1-dimensional pattern");
        }
        IRange[] newRanges = new IRange[this.gridIndexRanges.length - 1];
        System.arraycopy(this.gridIndexRanges, 0, newRanges, 0, coordIndex);
        System.arraycopy(this.gridIndexRanges, coordIndex + 1, newRanges, coordIndex, newRanges.length - coordIndex);
        return new BasicRectangularPattern(this.originOfGrid.projectionAlongAxis(coordIndex), this.stepsVector.projectionAlongAxis(coordIndex).coordinates(), newRanges);
    }

    @Override
    public RectangularPattern minBound(int coordIndex) {
        return this.lowerSurface(coordIndex);
    }

    @Override
    public RectangularPattern maxBound(int coordIndex) {
        return this.upperSurface(coordIndex);
    }

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        BasicRectangularPattern ugAdded;
        block6: {
            block5: {
                if (!(added instanceof BasicRectangularPattern)) break block5;
                ugAdded = (BasicRectangularPattern)added;
                if (added.dimCount() == this.dimCount) break block6;
            }
            return super.minkowskiAdd(added);
        }
        if (!this.stepsOfGridEqual(ugAdded)) {
            return super.minkowskiAdd(added);
        }
        IRange[] sumRanges = new IRange[this.gridIndexRanges.length];
        for (int k = 0; k < this.gridIndexRanges.length; ++k) {
            long newMin = this.gridIndexRanges[k].min() + ugAdded.gridIndexRange(k).min();
            long newMax = this.gridIndexRanges[k].max() + ugAdded.gridIndexRange(k).max();
            sumRanges[k] = IRange.of(newMin, newMax);
        }
        return new BasicRectangularPattern(this.originOfGrid.add(ugAdded.originOfGrid()), this.stepsOfGrid, sumRanges);
    }

    @Override
    public Pattern minkowskiSubtract(Pattern subtracted) {
        BasicRectangularPattern ugSubtracted;
        block7: {
            block6: {
                if (!(subtracted instanceof BasicRectangularPattern)) break block6;
                ugSubtracted = (BasicRectangularPattern)subtracted;
                if (subtracted.dimCount() == this.dimCount) break block7;
            }
            return super.minkowskiSubtract(subtracted);
        }
        if (!this.stepsOfGridEqual(ugSubtracted)) {
            return super.minkowskiAdd(subtracted);
        }
        IRange[] diffRanges = new IRange[this.gridIndexRanges.length];
        for (int k = 0; k < this.gridIndexRanges.length; ++k) {
            long newMax;
            long newMin = this.gridIndexRanges[k].min() - ugSubtracted.gridIndexRange(k).min();
            if (newMin > (newMax = this.gridIndexRanges[k].max() - ugSubtracted.gridIndexRange(k).max())) {
                return null;
            }
            diffRanges[k] = IRange.of(newMin, newMax);
        }
        return new BasicRectangularPattern(this.originOfGrid.subtract(ugSubtracted.originOfGrid()), this.stepsOfGrid, diffRanges);
    }

    @Override
    public boolean hasMinkowskiDecomposition() {
        return this.pointCount > 1L;
    }

    public String toString() {
        int k;
        StringBuilder sb = new StringBuilder(this.dimCount + "D rectangular uniform-grid pattern containing " + (this.pointCount == Long.MAX_VALUE ? this.largePointCount + " points" : this.pointCount + " points ("));
        for (k = 0; k < this.dimCount; ++k) {
            if (k > 0) {
                sb.append(",");
            }
            sb.append(this.coordRange(k).min());
        }
        sb.append(")..(");
        for (k = 0; k < this.dimCount; ++k) {
            if (k > 0) {
                sb.append(",");
            }
            sb.append(this.coordRange(k).max());
        }
        sb.append(") - on grid ").append(this.gridToString());
        return sb.toString();
    }

    public int hashCode() {
        return ((this.getClass().getName().hashCode() * 31 + Arrays.hashCode(this.gridIndexRanges)) * 31 + this.originOfGrid.hashCode()) * 31 + this.stepsVector.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicRectangularPattern)) {
            return false;
        }
        BasicRectangularPattern pattern = (BasicRectangularPattern)obj;
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.gridIndexRanges, pattern.gridIndexRanges) && this.originOfGrid.equals(pattern.originOfGrid) && this.stepsVector.equals(pattern.stepsVector);
    }

    private void addIPointsToParallelepiped(Set<IPoint> points, long[] coordinates, int lastCoordinatesCount) {
        int cIndex = this.dimCount - 1 - lastCoordinatesCount;
        if (cIndex == 0) {
            long i = this.gridIndexRanges[0].min();
            long iMax = this.gridIndexRanges[0].max();
            while (i <= iMax) {
                coordinates[0] = i++;
                points.add(IPoint.of(coordinates));
            }
        } else {
            long i = this.gridIndexRanges[cIndex].min();
            long iMax = this.gridIndexRanges[cIndex].max();
            while (i <= iMax) {
                coordinates[cIndex] = i++;
                this.addIPointsToParallelepiped(points, coordinates, lastCoordinatesCount + 1);
            }
        }
    }

    private void addPointsToParallelepiped(Set<Point> points, long[] coordinates, int lastCoordinatesCount) {
        int cIndex = this.dimCount - 1 - lastCoordinatesCount;
        if (cIndex == 0) {
            long i = this.gridIndexRanges[0].min();
            long iMax = this.gridIndexRanges[0].max();
            while (i <= iMax) {
                coordinates[0] = i++;
                points.add(IPoint.of(coordinates).scaleAndShift(this.stepsOfGrid, this.originOfGrid));
            }
        } else {
            long i = this.gridIndexRanges[cIndex].min();
            long iMax = this.gridIndexRanges[cIndex].max();
            while (i <= iMax) {
                coordinates[cIndex] = i++;
                this.addPointsToParallelepiped(points, coordinates, lastCoordinatesCount + 1);
            }
        }
    }
}

