/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.math.patterns.WeightedPattern;

public abstract class AbstractWeightedPattern
implements WeightedPattern {
    protected final Pattern parent;

    protected AbstractWeightedPattern(Pattern parent) {
        Objects.requireNonNull(parent, "Null parent pattern");
        this.parent = parent;
    }

    @Override
    public int dimCount() {
        return this.parent.dimCount();
    }

    @Override
    public long pointCount() {
        return this.parent.pointCount();
    }

    @Override
    public double largePointCount() {
        return this.parent.largePointCount();
    }

    @Override
    public Set<Point> points() {
        return this.parent.points();
    }

    @Override
    public Set<IPoint> roundedPoints() {
        return this.parent.roundedPoints();
    }

    @Override
    public Range coordRange(int coordIndex) {
        return this.parent.coordRange(coordIndex);
    }

    @Override
    public RectangularArea coordArea() {
        return this.parent.coordArea();
    }

    @Override
    public Point coordMin() {
        return this.parent.coordMin();
    }

    @Override
    public Point coordMax() {
        return this.parent.coordMax();
    }

    @Override
    public IRange roundedCoordRange(int coordIndex) {
        return this.parent.roundedCoordRange(coordIndex);
    }

    @Override
    public IRectangularArea roundedCoordArea() {
        return this.parent.roundedCoordArea();
    }

    @Override
    public boolean isSurelySinglePoint() {
        return this.parent.isSurelySinglePoint();
    }

    @Override
    public boolean isSurelyOriginPoint() {
        return this.parent.isSurelyOriginPoint();
    }

    @Override
    public Pattern projectionAlongAxis(int coordIndex) {
        return this.parent.projectionAlongAxis(coordIndex);
    }

    @Override
    public boolean isSurelyInteger() {
        return this.parent.isSurelyInteger();
    }

    @Override
    public UniformGridPattern round() {
        return this.parent.round();
    }

    @Override
    public Pattern minBound(int coordIndex) {
        return this.parent.minBound(coordIndex);
    }

    @Override
    public Pattern maxBound(int coordIndex) {
        return this.parent.maxBound(coordIndex);
    }

    @Override
    public Pattern carcass() {
        return this.parent.carcass();
    }

    @Override
    public int maxCarcassMultiplier() {
        return this.parent.maxCarcassMultiplier();
    }

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        return this.parent.minkowskiAdd(added);
    }

    @Override
    public Pattern minkowskiSubtract(Pattern subtracted) {
        return this.parent.minkowskiSubtract(subtracted);
    }

    @Override
    public List<Pattern> minkowskiDecomposition(int minimalPointCount) {
        return this.parent.minkowskiDecomposition(minimalPointCount);
    }

    @Override
    public boolean hasMinkowskiDecomposition() {
        return this.parent.hasMinkowskiDecomposition();
    }

    @Override
    public List<Pattern> unionDecomposition(int minimalPointCount) {
        return this.parent.unionDecomposition(minimalPointCount);
    }

    @Override
    public List<List<Pattern>> allUnionDecompositions(int minimalPointCount) {
        return this.parent.allUnionDecompositions(minimalPointCount);
    }

    @Override
    public WeightedPattern shift(Point shift) {
        return this.shift(shift.toRoundedPoint());
    }

    @Override
    public abstract WeightedPattern shift(IPoint var1);

    @Override
    public WeightedPattern multiply(double multiplier) {
        double[] multipliers = new double[this.dimCount()];
        Arrays.fill(multipliers, multiplier);
        return this.scale(multipliers);
    }

    @Override
    public abstract WeightedPattern scale(double ... var1);

    @Override
    public WeightedPattern symmetric() {
        return this.multiply(-1.0);
    }

    @Override
    public abstract double weight(IPoint var1);

    @Override
    public abstract Range weightRange();

    @Override
    public boolean isConstant() {
        return this.weightRange().size() == 0.0;
    }

    @Override
    public List<WeightedPattern> productDecomposition(int minimalPointCount) {
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        return Collections.singletonList(this);
    }
}

