/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.PackedBitArrays;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;
import net.algart.math.patterns.AbstractPattern;
import net.algart.math.patterns.BasicDirectPointSetUniformGridPattern;
import net.algart.math.patterns.BasicRectangularPattern;
import net.algart.math.patterns.DirectPointSetUniformGridPattern;
import net.algart.math.patterns.OnePointPattern;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.TinyBitMatrix;
import net.algart.math.patterns.TooLargePatternCoordinatesException;
import net.algart.math.patterns.TwoPointsPattern;
import net.algart.math.patterns.UniformGridPattern;

public abstract class AbstractUniformGridPattern
extends AbstractPattern
implements UniformGridPattern {
    private static final boolean DEBUG_MODE = false;
    private static final double MAX_RELATION_OF_PARALLELEPIPED_VOLUME_TO_THIS_TO_OPTIMIZE_IN_MINKOWSKI_ADD = 200.0;
    private static final int MIN_POINT_COUNT_TO_OPTIMIZE_MINKOWSKI_ADD = 32;
    final Point originOfGrid;
    final double[] stepsOfGrid;
    final Point stepsVector;
    final boolean zeroOriginOfGrid;
    final boolean unitStepsOfGrid;
    final IPoint iOriginOfGrid;
    final long[] iStepsOfGrid;
    volatile Boolean isRectangular = null;
    final IRange[] gridIndexRanges;
    final DirectPointSetUniformGridPattern[] lowerSurface;
    final DirectPointSetUniformGridPattern[] upperSurface;
    volatile UniformGridPattern surface = null;
    private volatile UniformGridPattern carcass = null;
    private volatile int maxCarcassMultiplier = -1;
    private final boolean trivialUnionDecomposition;
    private final List<List<Pattern>> minkowskiDecompositions;
    private final List<List<List<Pattern>>> allUnionDecompositions;

    private static int maxNumberOfPointsInNewParallelepipedWhileCheckingLargeCarcasses(int dimCount) {
        return dimCount <= 2 ? 4000000 : 16000000;
    }

    protected AbstractUniformGridPattern(Point originOfGrid, double[] stepsOfGrid, boolean trivialUnionDecomposition) {
        super(originOfGrid.coordCount());
        int k;
        Objects.requireNonNull(stepsOfGrid, "Null stepsOfGrid");
        if (stepsOfGrid.length != originOfGrid.coordCount()) {
            throw new IllegalArgumentException("The number of steps of the grid is not equal to the number of the origin dimensions");
        }
        this.trivialUnionDecomposition = trivialUnionDecomposition;
        this.originOfGrid = originOfGrid;
        for (double step : this.stepsOfGrid = (double[])stepsOfGrid.clone()) {
            if (!(step <= 0.0)) continue;
            throw new IllegalArgumentException("Zero or negative steps of the grid are not allowed");
        }
        this.zeroOriginOfGrid = this.originOfGrid.isOrigin();
        this.stepsVector = Point.of(this.stepsOfGrid);
        this.unitStepsOfGrid = this.stepsVector.equals(Point.ofEqualCoordinates(this.dimCount, 1.0));
        this.surelyInteger = this.originOfGrid.isInteger() && this.stepsVector.isInteger();
        this.iOriginOfGrid = this.surelyInteger != false ? this.originOfGrid.toIntegerPoint() : null;
        this.iStepsOfGrid = this.surelyInteger != false ? this.stepsVector.toIntegerPoint().coordinates() : null;
        this.gridIndexRanges = new IRange[this.dimCount];
        this.lowerSurface = new DirectPointSetUniformGridPattern[this.dimCount];
        this.upperSurface = new DirectPointSetUniformGridPattern[this.dimCount];
        this.minkowskiDecompositions = Collections.synchronizedList(new ArrayList(16));
        for (k = 0; k < 16; ++k) {
            this.minkowskiDecompositions.add(null);
        }
        this.allUnionDecompositions = Collections.synchronizedList(new ArrayList(16));
        for (k = 0; k < 16; ++k) {
            this.allUnionDecompositions.add(null);
        }
    }

    @Override
    public Point originOfGrid() {
        return this.originOfGrid;
    }

    @Override
    public double[] stepsOfGrid() {
        return (double[])this.stepsOfGrid.clone();
    }

    @Override
    public double stepOfGrid(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        return this.stepsOfGrid[coordIndex];
    }

    @Override
    public boolean stepsOfGridEqual(UniformGridPattern pattern) {
        Objects.requireNonNull(pattern, "Null pattern argument");
        if (pattern.dimCount() != this.dimCount) {
            return false;
        }
        for (int k = 0; k < this.dimCount; ++k) {
            if (this.stepsOfGrid[k] == pattern.stepOfGrid(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract Set<IPoint> gridIndexes();

    @Override
    public abstract IRange gridIndexRange(int var1);

    @Override
    public IRectangularArea gridIndexArea() {
        IRange[] result = new IRange[this.dimCount];
        for (int k = 0; k < result.length; ++k) {
            result[k] = this.gridIndexRange(k);
        }
        return IRectangularArea.of(result);
    }

    @Override
    public IPoint gridIndexMin() {
        long[] coordinates = new long[this.dimCount];
        for (int k = 0; k < coordinates.length; ++k) {
            coordinates[k] = this.gridIndexRange(k).min();
        }
        return IPoint.of(coordinates);
    }

    @Override
    public IPoint gridIndexMax() {
        long[] coordinates = new long[this.dimCount];
        for (int k = 0; k < coordinates.length; ++k) {
            coordinates[k] = this.gridIndexRange(k).max();
        }
        return IPoint.of(coordinates);
    }

    @Override
    public final boolean isOrdinary() {
        return this.zeroOriginOfGrid && this.unitStepsOfGrid;
    }

    @Override
    public boolean isActuallyRectangular() {
        block2: {
            if (this.isRectangular == null) {
                long count = 1L;
                for (int k = 0; k < this.dimCount; ++k) {
                    long size = this.gridIndexRange(k).size();
                    if ((count = net.algart.arrays.Arrays.longMul(count, size)) != Long.MIN_VALUE && count != Long.MAX_VALUE) continue;
                    this.isRectangular = false;
                    break block2;
                }
                this.isRectangular = count == this.pointCount();
            }
        }
        return this.isRectangular;
    }

    @Override
    public abstract UniformGridPattern gridIndexPattern();

    @Override
    public abstract UniformGridPattern shiftGridIndexes(IPoint var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniformGridPattern lowerSurface(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        DirectPointSetUniformGridPattern[] directPointSetUniformGridPatternArray = this.lowerSurface;
        synchronized (this.lowerSurface) {
            if (this.lowerSurface[coordIndex] == null) {
                long[] shiftCoordinates = new long[this.dimCount];
                shiftCoordinates[coordIndex] = -1L;
                IPoint shift = IPoint.of(shiftCoordinates);
                Set<IPoint> points = this.gridIndexes();
                HashSet<IPoint> resultPoints = new HashSet<IPoint>();
                for (IPoint ip : points) {
                    if (ip.coord(coordIndex) != Long.MIN_VALUE && points.contains(ip.add(shift))) continue;
                    resultPoints.add(ip);
                }
                this.lowerSurface[coordIndex] = this.newCompatiblePattern(resultPoints);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.lowerSurface[coordIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniformGridPattern upperSurface(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        DirectPointSetUniformGridPattern[] directPointSetUniformGridPatternArray = this.upperSurface;
        synchronized (this.upperSurface) {
            if (this.upperSurface[coordIndex] == null) {
                long[] shiftCoordinates = new long[this.dimCount];
                shiftCoordinates[coordIndex] = 1L;
                IPoint shift = IPoint.of(shiftCoordinates);
                Set<IPoint> points = this.gridIndexes();
                HashSet<IPoint> resultPoints = new HashSet<IPoint>();
                for (IPoint ip : points) {
                    if (ip.coord(coordIndex) != Long.MIN_VALUE && points.contains(ip.add(shift))) continue;
                    resultPoints.add(ip);
                }
                this.upperSurface[coordIndex] = this.newCompatiblePattern(resultPoints);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.upperSurface[coordIndex];
        }
    }

    @Override
    public Pattern surface() {
        if (this.surface == null) {
            HashSet<IPoint> resultPoints = new HashSet<IPoint>();
            for (int k = 0; k < this.dimCount; ++k) {
                resultPoints.addAll(this.lowerSurface(k).gridIndexes());
                resultPoints.addAll(this.upperSurface(k).gridIndexes());
            }
            this.surface = this.newCompatiblePattern(resultPoints);
        }
        return this.surface;
    }

    @Override
    public abstract long pointCount();

    @Override
    public Set<Point> points() {
        HashSet<Point> result = new HashSet<Point>();
        for (IPoint p : this.gridIndexes()) {
            result.add(p.scaleAndShift(this.stepsOfGrid, this.originOfGrid));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<IPoint> roundedPoints() {
        if (this.zeroOriginOfGrid && this.unitStepsOfGrid) {
            return Collections.unmodifiableSet(this.gridIndexes());
        }
        return super.roundedPoints();
    }

    @Override
    public Range coordRange(int coordIndex) {
        IRange r = this.gridIndexRange(coordIndex);
        return this.coordRange(coordIndex, r);
    }

    @Override
    public boolean isSurelyInteger() {
        return this.surelyInteger;
    }

    @Override
    public UniformGridPattern round() {
        return this.zeroOriginOfGrid && this.unitStepsOfGrid ? this : super.round();
    }

    @Override
    public abstract UniformGridPattern projectionAlongAxis(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniformGridPattern minBound(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        Pattern[] patternArray = this.minBound;
        synchronized (this.minBound) {
            if (this.minBound[coordIndex] == null) {
                Set<IPoint> points = this.gridIndexes();
                HashMap<IPoint, IPoint> map = new HashMap<IPoint, IPoint>();
                for (IPoint p : points) {
                    IPoint projection = p.projectionAlongAxis(coordIndex);
                    IPoint bound = (IPoint)map.get(projection);
                    if (bound != null && p.coord(coordIndex) >= bound.coord(coordIndex)) continue;
                    map.put(projection, p);
                }
                this.minBound[coordIndex] = this.newCompatiblePattern(map.values());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (UniformGridPattern)this.minBound[coordIndex];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniformGridPattern maxBound(int coordIndex) {
        this.checkCoordIndex(coordIndex);
        Pattern[] patternArray = this.maxBound;
        synchronized (this.maxBound) {
            if (this.maxBound[coordIndex] == null) {
                Set<IPoint> points = this.gridIndexes();
                HashMap<IPoint, IPoint> map = new HashMap<IPoint, IPoint>();
                for (IPoint p : points) {
                    IPoint projection = p.projectionAlongAxis(coordIndex);
                    IPoint bound = (IPoint)map.get(projection);
                    if (bound != null && p.coord(coordIndex) <= bound.coord(coordIndex)) continue;
                    map.put(projection, p);
                }
                this.maxBound[coordIndex] = this.newCompatiblePattern(map.values());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (UniformGridPattern)this.maxBound[coordIndex];
        }
    }

    @Override
    public UniformGridPattern carcass() {
        if (this.pointCount() <= 2L) {
            this.maxCarcassMultiplier = Integer.MAX_VALUE;
            return this;
        }
        if (this.carcass == null) {
            if (this.isActuallyRectangular()) {
                IRectangularArea area = this.gridIndexArea();
                long[] vertex = new long[this.dimCount];
                IRange[] r01 = Collections.nCopies(this.dimCount, IRange.of(0L, 1L)).toArray(new IRange[this.dimCount]);
                Set<IPoint> vertices01 = new BasicRectangularPattern(r01).roundedPoints();
                HashSet<IPoint> resultPoints = new HashSet<IPoint>();
                for (IPoint vertex01 : vertices01) {
                    for (int k = 0; k < vertex.length; ++k) {
                        long coord = vertex01.coord(k);
                        assert (coord == 0L || coord == 1L);
                        vertex[k] = coord == 1L ? area.max(k) : area.min(k);
                    }
                    resultPoints.add(IPoint.of(vertex));
                }
                this.maxCarcassMultiplier = Integer.MAX_VALUE;
                this.carcass = this.newCompatiblePattern(resultPoints);
            } else {
                int lastButOneDim;
                IPoint correctionShift = this.gridIndexMin();
                UniformGridPattern p = this.shiftGridIndexes(correctionShift.symmetric());
                IRange[] r3x3 = Collections.nCopies(this.dimCount, IRange.of(-2L, 2L)).toArray(new IRange[this.dimCount]);
                Set<IPoint> shifts = new BasicRectangularPattern(r3x3).roundedPoints();
                Set<IPoint> bestBoundaryForDirection = null;
                HashSet<IPoint> intersectionOfBoundaries = null;
                Set<IPoint> points = p.gridIndexes();
                int minPointCount = Integer.MAX_VALUE;
                for (IPoint shift : shifts) {
                    IPoint halfShift;
                    if (shift.isOrigin() || shift.equals((halfShift = shift.multiply(0.5)).multiply(2.0))) continue;
                    Set<IPoint> boundaryForDirection = AbstractUniformGridPattern.gridBoundaryForDirection(points, shift);
                    int pointCount = boundaryForDirection.size();
                    if (bestBoundaryForDirection == null || pointCount < minPointCount) {
                        bestBoundaryForDirection = boundaryForDirection;
                        minPointCount = pointCount;
                    }
                    if (intersectionOfBoundaries == null) {
                        intersectionOfBoundaries = new HashSet<IPoint>(boundaryForDirection);
                        continue;
                    }
                    intersectionOfBoundaries.retainAll(boundaryForDirection);
                }
                BasicDirectPointSetUniformGridPattern alwaysWorkingCarcass = new BasicDirectPointSetUniformGridPattern(this.dimCount, bestBoundaryForDirection);
                BasicDirectPointSetUniformGridPattern goodCarcass = new BasicDirectPointSetUniformGridPattern(this.dimCount, intersectionOfBoundaries);
                if (this.dimCount <= 1 || this.dimCount > 16 || AbstractUniformGridPattern.intGridDimensions(p) == null) {
                    this.maxCarcassMultiplier = 2;
                    this.carcass = ((AbstractUniformGridPattern)alwaysWorkingCarcass).shiftGridIndexes(correctionShift).scale(this.stepsOfGrid).shift(this.originOfGrid);
                    return this.carcass;
                }
                IRange[] ranges = p.gridIndexArea().ranges();
                for (int k = 0; k < ranges.length; ++k) {
                    ranges[k] = IRange.of(2L * ranges[k].min(), 2L * ranges[k].max());
                }
                BasicRectangularPattern circumscribed2P = new BasicRectangularPattern(ranges);
                if (((AbstractPattern)circumscribed2P).largePointCount() > (double)AbstractUniformGridPattern.maxNumberOfPointsInNewParallelepipedWhileCheckingLargeCarcasses(this.dimCount)) {
                    this.maxCarcassMultiplier = 2;
                    this.carcass = ((AbstractUniformGridPattern)alwaysWorkingCarcass).shiftGridIndexes(correctionShift).scale(this.stepsOfGrid).shift(this.originOfGrid);
                    return this.carcass;
                }
                long m = 1L;
                while (true) {
                    long newVolume = 1L;
                    for (int k = 0; k < ranges.length; ++k) {
                        ranges[k] = IRange.of(2L * ranges[k].min(), 2L * ranges[k].max());
                        newVolume *= ranges[k].size();
                    }
                    if (newVolume > (long)AbstractUniformGridPattern.maxNumberOfPointsInNewParallelepipedWhileCheckingLargeCarcasses(this.dimCount)) break;
                    m *= 2L;
                }
                int[] dimensions = AbstractUniformGridPattern.intGridDimensions(new BasicRectangularPattern(ranges));
                assert (dimensions != null) : "Probably too large maxNumberOfPointsInNewParallelepipedWhileCheckingLargeCarcasses constants";
                BasicDirectPointSetUniformGridPattern pUnscaled = new BasicDirectPointSetUniformGridPattern(this.dimCount, points);
                TinyBitMatrix temp1 = new TinyBitMatrix(dimensions);
                TinyBitMatrix temp2 = new TinyBitMatrix(dimensions);
                int lastDim = (int)((AbstractUniformGridPattern)circumscribed2P).gridIndexRange(dimensions.length - 1).size();
                dimensions[dimensions.length - 2] = lastButOneDim = (int)((AbstractUniformGridPattern)circumscribed2P).gridIndexRange(dimensions.length - 2).size();
                dimensions[dimensions.length - 1] = lastDim;
                TinyBitMatrix temp = temp1.reDim(dimensions);
                TinyBitMatrix multiple = temp2.reDim(dimensions);
                temp.putPattern(pUnscaled);
                multiple.simpleDilation(temp, goodCarcass);
                long correctCardinality = multiple.cardinality();
                multiple.simpleDilation(temp, alwaysWorkingCarcass);
                long probableCardinality = multiple.cardinality();
                int n = 1;
                BasicDirectPointSetUniformGridPattern c = goodCarcass;
                if (probableCardinality != correctCardinality) {
                    c = alwaysWorkingCarcass;
                }
                UniformGridPattern nc = c;
                Object np = null;
                Object np2 = null;
                while ((long)n < m) {
                    if (4 * n < 0) {
                        assert (4 * n == Integer.MIN_VALUE);
                        break;
                    }
                    lastDim = 2 * lastDim - 1;
                    lastButOneDim = 2 * lastButOneDim - 1;
                    multiple = AbstractUniformGridPattern.increaseMatrixBy2LastCoordinates(multiple, lastDim, lastButOneDim);
                    temp = temp.reDim(multiple.dimensions());
                    UniformGridPattern nc2 = nc.multiply(2.0);
                    temp.simpleDilation(multiple, nc2);
                    probableCardinality = temp.cardinality();
                    temp.simpleDilation(multiple, nc);
                    multiple.simpleDilation(temp, nc);
                    correctCardinality = multiple.cardinality();
                    if (probableCardinality != correctCardinality) break;
                    nc = nc2;
                    n *= 2;
                }
                this.maxCarcassMultiplier = 2 * n;
                this.carcass = ((AbstractUniformGridPattern)c).shiftGridIndexes(correctionShift).scale(this.stepsOfGrid).shift(this.originOfGrid);
            }
        }
        return this.carcass;
    }

    @Override
    public int maxCarcassMultiplier() {
        if (this.isActuallyRectangular()) {
            return Integer.MAX_VALUE;
        }
        this.carcass();
        return this.maxCarcassMultiplier;
    }

    @Override
    public abstract UniformGridPattern shift(Point var1);

    @Override
    public UniformGridPattern symmetric() {
        return (UniformGridPattern)super.symmetric();
    }

    @Override
    public UniformGridPattern multiply(double multiplier) {
        return (UniformGridPattern)super.multiply(multiplier);
    }

    @Override
    public abstract UniformGridPattern scale(double ... var1);

    @Override
    public Pattern minkowskiAdd(Pattern added) {
        Objects.requireNonNull(added, "Null added argument");
        if (added.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + added.dimCount() + " instead of " + this.dimCount);
        }
        long addedPointCount = added.pointCount();
        if (addedPointCount == 1L) {
            return this.shift(added.coordMin());
        }
        if (!(added instanceof UniformGridPattern)) {
            return super.minkowskiAdd(added);
        }
        UniformGridPattern ugAdded = (UniformGridPattern)added;
        if (!this.stepsOfGridEqual(ugAdded)) {
            return super.minkowskiAdd(added);
        }
        if (this.pointCount() < 32L && addedPointCount < 32L) {
            return this.simpleMinkowskiAdd(ugAdded);
        }
        BasicRectangularPattern circumscribedOfThis = new BasicRectangularPattern(this.gridIndexArea().ranges());
        BasicRectangularPattern circumscribedOfAdded = new BasicRectangularPattern(ugAdded.gridIndexArea().ranges());
        Pattern halfCircumscribed = circumscribedOfThis.multiply(0.5).round().minkowskiAdd(circumscribedOfAdded.multiply(0.5).round());
        double volumeOfCircumscribed = halfCircumscribed.largePointCount() * Math.pow(2.0, this.dimCount);
        if (volumeOfCircumscribed > this.largePointCount() * 200.0) {
            return this.simpleMinkowskiAdd(ugAdded);
        }
        Pattern circumscribed = circumscribedOfThis.minkowskiAdd(circumscribedOfAdded);
        assert (circumscribed instanceof UniformGridPattern);
        int[] dimensions = AbstractUniformGridPattern.intGridDimensions((UniformGridPattern)circumscribed);
        Objects.requireNonNull(dimensions, "Too large pattern for Minkowski adding: some dimensions are 2^31 or greater");
        assert (circumscribedOfThis.isOrdinary());
        assert (circumscribedOfAdded.isOrdinary());
        UniformGridPattern thisGridIndexes = this.gridIndexPattern();
        UniformGridPattern addedGridIndexes = ugAdded.gridIndexPattern();
        IPoint thisShift = circumscribedOfThis.gridIndexMin();
        IPoint addedShift = circumscribedOfAdded.gridIndexMin();
        TinyBitMatrix src = new TinyBitMatrix(dimensions);
        src.putPattern(thisGridIndexes.shiftGridIndexes(thisShift.symmetric()));
        TinyBitMatrix dest = new TinyBitMatrix(dimensions);
        dest.simpleDilation(src, addedGridIndexes.shiftGridIndexes(addedShift.symmetric()));
        UniformGridPattern drawnPattern = dest.getPattern(thisShift.add(addedShift));
        return drawnPattern.scale(this.stepsOfGrid).shift(this.originOfGrid.add(ugAdded.originOfGrid()));
    }

    @Override
    public Pattern minkowskiSubtract(Pattern subtracted) {
        Objects.requireNonNull(subtracted, "Null subtracted argument");
        if (subtracted.dimCount() != this.dimCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + subtracted.dimCount() + " instead of " + this.dimCount);
        }
        long subtractedPointCount = subtracted.pointCount();
        if (subtractedPointCount == 1L) {
            return this.shift(subtracted.coordMin().symmetric());
        }
        if (!(subtracted instanceof UniformGridPattern)) {
            return super.minkowskiSubtract(subtracted);
        }
        UniformGridPattern ugSubtracted = (UniformGridPattern)subtracted;
        if (!this.stepsOfGridEqual(ugSubtracted)) {
            return super.minkowskiSubtract(subtracted);
        }
        Set<IPoint> subtractedPoints = ugSubtracted.gridIndexes();
        IPoint minimal = null;
        double minimalDistance = Double.POSITIVE_INFINITY;
        for (IPoint p : subtractedPoints) {
            double distance = p.distanceFromOrigin();
            if (minimal != null && !(distance < minimalDistance)) continue;
            minimal = p;
            minimalDistance = distance;
        }
        assert (minimal != null) : "Empty subtracted.points()";
        boolean containsOrigin = minimal.isOrigin();
        Set<IPoint> points = this.gridIndexes();
        HashSet<IPoint> resultPoints = new HashSet<IPoint>();
        block1: for (IPoint p : points) {
            if (!containsOrigin) {
                p = p.subtract(minimal);
            }
            for (IPoint q : subtractedPoints) {
                if (q.equals(minimal) || points.contains(p.add(q))) continue;
                continue block1;
            }
            resultPoints.add(p);
        }
        return resultPoints.isEmpty() ? null : Patterns.newIntegerPattern(resultPoints).scale(this.stepsOfGrid).shift(this.originOfGrid.subtract(ugSubtracted.originOfGrid()));
    }

    @Override
    public List<Pattern> minkowskiDecomposition(int minimalPointCount) {
        List<Pattern> result;
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        if (!this.isActuallyRectangular()) {
            return Collections.singletonList(this);
        }
        long pointCount = this.pointCount();
        if (pointCount <= 2L) {
            return Collections.singletonList(this);
        }
        if (minimalPointCount < this.minkowskiDecompositions.size() && (result = this.minkowskiDecompositions.get(minimalPointCount)) != null) {
            return result;
        }
        if (pointCount < (long)minimalPointCount) {
            return Collections.singletonList(this);
        }
        IRectangularArea gridIndexArea = this.gridIndexArea();
        boolean joinShortSegments = minimalPointCount > 4;
        ArrayList<Pattern> result2 = new ArrayList<OnePointPattern>();
        Point origin = Point.origin(this.dimCount);
        long[] shifts = new long[this.dimCount];
        double[] coordinates = new double[this.dimCount];
        Object[] ranges = new IRange[this.dimCount];
        Arrays.fill(ranges, IRange.of(0L, 0L));
        boolean allShiftsAreZero = true;
        for (int k = 0; k < this.dimCount; ++k) {
            shifts[k] = gridIndexArea.min(k);
            allShiftsAreZero &= shifts[k] == 0L;
            boolean startSegmentAdded = false;
            long m = 1L;
            long n = gridIndexArea.size(k);
            long sumLen = 1L;
            while (sumLen < n) {
                assert (m == sumLen) : "m != sumLen";
                if (m > n - sumLen) {
                    m = n - sumLen;
                }
                if (sumLen + m >= (long)minimalPointCount && joinShortSegments && !startSegmentAdded) {
                    ranges[k] = IRange.of(0L, sumLen - 1L);
                    result2.add(new BasicRectangularPattern(origin, this.stepsOfGrid, (IRange[])ranges));
                    startSegmentAdded = true;
                }
                if (!joinShortSegments || (sumLen += m) >= (long)minimalPointCount) {
                    coordinates[k] = (double)m * this.stepsOfGrid[k];
                    result2.add(new TwoPointsPattern(origin, Point.of(coordinates)));
                }
                m *= 2L;
            }
            coordinates[k] = 0.0;
            ranges[k] = IRange.of(0L, 0L);
        }
        if (!allShiftsAreZero || !this.originOfGrid.isOrigin()) {
            result2.add(new OnePointPattern(IPoint.of(shifts).scaleAndShift(this.stepsOfGrid, this.originOfGrid)));
        }
        result2 = Collections.unmodifiableList(result2);
        if (minimalPointCount < this.minkowskiDecompositions.size()) {
            this.minkowskiDecompositions.set(minimalPointCount, result2);
        }
        return result2;
    }

    @Override
    public boolean hasMinkowskiDecomposition() {
        return this.minkowskiDecomposition(0).size() > 1;
    }

    @Override
    public List<List<Pattern>> allUnionDecompositions(int minimalPointCount) {
        List<List<Pattern>> result;
        if (minimalPointCount < 0) {
            throw new IllegalArgumentException("Negative minimalPointCount");
        }
        if (this.trivialUnionDecomposition) {
            return Collections.singletonList(Collections.singletonList(this));
        }
        if (minimalPointCount < this.allUnionDecompositions.size() && (result = this.allUnionDecompositions.get(minimalPointCount)) != null) {
            return result;
        }
        ArrayList<IPoint> points = new ArrayList<IPoint>(this.gridIndexes());
        if (points.size() < minimalPointCount) {
            return Collections.singletonList(Collections.singletonList(this));
        }
        ArrayList<IPoint> retainedPoints = new ArrayList<IPoint>();
        ArrayList<ArrayList<UniformGridPattern>> decompositions = new ArrayList<ArrayList<UniformGridPattern>>();
        long[] totalComplexities = new long[this.dimCount];
        long bestTotalComplexity = Long.MAX_VALUE;
        for (int coordIndex = 0; coordIndex < this.dimCount; ++coordIndex) {
            retainedPoints.clear();
            List<UniformGridPattern> gridIndexes = AbstractUniformGridPattern.joinPointsToSegments(points, retainedPoints, coordIndex, minimalPointCount);
            if (!retainedPoints.isEmpty()) {
                gridIndexes.add(Patterns.newIntegerPattern(retainedPoints.toArray(new IPoint[0])));
            }
            double totalCount = 0.0;
            for (UniformGridPattern ptn : gridIndexes) {
                long pointCount = ptn.pointCount();
                if (ptn.isActuallyRectangular() && pointCount >= (long)minimalPointCount) {
                    totalCount += (double)(2 * (64 - Long.numberOfLeadingZeros(pointCount - 1L)));
                    continue;
                }
                totalCount += (double)pointCount;
            }
            long totalComplexity = StrictMath.round(totalCount);
            decompositions.add(new ArrayList<UniformGridPattern>(gridIndexes));
            totalComplexities[coordIndex] = totalComplexity;
            if (totalComplexity > bestTotalComplexity) continue;
            bestTotalComplexity = totalComplexity;
        }
        ArrayList bestResults = new ArrayList();
        for (int dimIndex = 0; dimIndex < this.dimCount; ++dimIndex) {
            if (totalComplexities[dimIndex] != bestTotalComplexity) continue;
            List gridIndexes = (List)decompositions.get(dimIndex);
            ArrayList<Pattern> resultPatterns = new ArrayList<Pattern>();
            for (Pattern pattern : gridIndexes) {
                resultPatterns.add(pattern.scale(this.stepsOfGrid).shift(this.originOfGrid));
            }
            bestResults.add(Collections.unmodifiableList(resultPatterns));
        }
        assert (!bestResults.isEmpty()) : "Empty bestResults";
        List<List<Pattern>> result2 = Collections.unmodifiableList(bestResults);
        if (minimalPointCount < this.allUnionDecompositions.size()) {
            this.allUnionDecompositions.set(minimalPointCount, result2);
        }
        return result2;
    }

    public static boolean isAllowedGridIndex(IPoint gridIndex) {
        Objects.requireNonNull(gridIndex, "Null grid index");
        int n = gridIndex.coordCount();
        for (int k = 0; k < n; ++k) {
            long coord = gridIndex.coord(k);
            if (coord >= -4503599627370496L && coord <= 0x10000000000000L) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowedGridIndexRange(IRange gridIndexRange) {
        Objects.requireNonNull(gridIndexRange, "Null grid index range");
        long min = gridIndexRange.min();
        long max = gridIndexRange.max();
        assert (min <= max);
        return min >= -4503599627370496L && max <= 0x10000000000000L && max - min <= 0x10000000000000L;
    }

    protected String gridToString() {
        if (this.isOrdinary()) {
            return "trivial grid";
        }
        StringBuilder sb = new StringBuilder("steps ");
        for (int k = 0; k < this.dimCount; ++k) {
            if (k > 0) {
                sb.append(" x ");
            }
            sb.append(this.stepsOfGrid[k]);
        }
        sb.append(" starting from ").append(this.zeroOriginOfGrid ? "the origin" : this.originOfGrid.toString());
        return sb.toString();
    }

    Range coordRange(int coordIndex, IRange gridIndexRange) {
        return Range.of((double)gridIndexRange.min() * this.stepsOfGrid[coordIndex] + this.originOfGrid.coord(coordIndex), (double)gridIndexRange.max() * this.stepsOfGrid[coordIndex] + this.originOfGrid.coord(coordIndex));
    }

    DirectPointSetUniformGridPattern newCompatiblePattern(Collection<IPoint> gridIndexes) {
        return Patterns.newUniformGridPattern(this.originOfGrid, this.stepsOfGrid, gridIndexes);
    }

    static void checkGridIndex(IPoint gridIndex) throws TooLargePatternCoordinatesException {
        if (!AbstractUniformGridPattern.isAllowedGridIndex(gridIndex)) {
            throw new TooLargePatternCoordinatesException("Some grid index " + String.valueOf(gridIndex) + " is out of  out of -4503599627370496..4503599627370496 range and cannot be used for building a pattern");
        }
    }

    static void checkGridIndexRange(IRange gridIndexRange) throws TooLargePatternCoordinatesException {
        Objects.requireNonNull(gridIndexRange, "Null grid index range");
        long min = gridIndexRange.min();
        long max = gridIndexRange.max();
        assert (min <= max);
        AbstractUniformGridPattern.checkGridIndexRange(min, max);
    }

    static void checkGridIndexRange(long min, long max) throws TooLargePatternCoordinatesException {
        if (min < -4503599627370496L || max > 0x10000000000000L) {
            throw new TooLargePatternCoordinatesException("Some grid index range " + min + ".." + max + " is out of -4503599627370496..4503599627370496 range and cannot be used for building a pattern");
        }
        if (max - min > 0x10000000000000L) {
            throw new TooLargePatternCoordinatesException("Some grid index range " + min + ".." + max + " has a size larger than 4503599627370496 and cannot be used for building a pattern");
        }
    }

    private AbstractUniformGridPattern simpleMinkowskiAdd(UniformGridPattern added) {
        if (!this.stepsOfGridEqual(added)) {
            throw new AssertionError((Object)"simpleMinkowskiAdd should be used with compatible grids only");
        }
        HashSet<IPoint> resultIndexes = new HashSet<IPoint>();
        Set<IPoint> indexes = this.gridIndexes();
        Set<IPoint> addedIndexes = added.gridIndexes();
        for (IPoint p : indexes) {
            for (IPoint q : addedIndexes) {
                resultIndexes.add(p.add(q));
            }
        }
        return new BasicDirectPointSetUniformGridPattern(this.originOfGrid.add(added.originOfGrid()), this.stepsOfGrid, resultIndexes);
    }

    private static Set<IPoint> gridBoundaryForDirection(Set<IPoint> points, IPoint direction) {
        HashSet<IPoint> result = new HashSet<IPoint>();
        IPoint directionSymmetric = direction.symmetric();
        for (IPoint ip : points) {
            boolean overflow = false;
            int n = direction.coordCount();
            for (int k = 0; k < n; ++k) {
                long coord = ip.coord(k);
                if (coord < 0x7FFFFFFFFFFFFFFEL && coord > -9223372036854775807L) continue;
                overflow = true;
                break;
            }
            if (!overflow && points.contains(ip.add(direction)) && points.contains(ip.add(directionSymmetric))) continue;
            result.add(ip);
        }
        return result;
    }

    private static int[] intGridDimensions(UniformGridPattern pattern) {
        int[] result = new int[pattern.dimCount()];
        for (int k = 0; k < result.length; ++k) {
            long size = pattern.gridIndexRange(k).size();
            if (size > Integer.MAX_VALUE) {
                return null;
            }
            result[k] = (int)size;
        }
        return result;
    }

    private static List<UniformGridPattern> joinPointsToSegments(List<IPoint> points, List<IPoint> retainedPoints, int coordIndex, int minimalPointCount) {
        ArrayList<UniformGridPattern> result = new ArrayList<UniformGridPattern>();
        if (points.isEmpty()) {
            return result;
        }
        Collections.sort(points, (o1, o2) -> o1.compareTo((IPoint)o2, coordIndex));
        IPoint last = points.get(0);
        int coordCount = last.coordCount();
        IPoint min = last;
        int minIndex = 0;
        int n = points.size();
        for (int k = 1; k < n; ++k) {
            IPoint p = points.get(k);
            boolean newSegment = false;
            for (int j = 0; j < coordCount; ++j) {
                long lastCoord = last.coord(j);
                long nextCoord = p.coord(j);
                if (nextCoord == (j == coordIndex ? lastCoord + 1L : lastCoord)) continue;
                newSegment = true;
                break;
            }
            if (newSegment) {
                int len = k - minIndex;
                if (len >= minimalPointCount) {
                    result.add(Patterns.newRectangularIntegerPattern(min, last));
                } else {
                    retainedPoints.addAll(points.subList(minIndex, k));
                }
                minIndex = k;
                min = p;
            }
            last = p;
        }
        int len = n - minIndex;
        if (len >= minimalPointCount) {
            result.add(Patterns.newRectangularIntegerPattern(min, last));
        } else {
            retainedPoints.addAll(points.subList(minIndex, n));
        }
        return result;
    }

    private static TinyBitMatrix increaseMatrixBy2LastCoordinates(TinyBitMatrix matrix, int newLastDim, int newLastButOneDim) {
        int[] dim = matrix.dimensions();
        if (dim.length < 2) {
            throw new AssertionError((Object)"This method cannot process 1-dimensional matrices");
        }
        if (newLastDim < dim[dim.length - 1]) {
            throw new AssertionError((Object)"This method cannot reduce the matrix");
        }
        if (newLastButOneDim < dim[dim.length - 2]) {
            throw new AssertionError((Object)"This method cannot reduce the matrix");
        }
        long mult = 1L;
        for (int k = 0; k < dim.length - 2; ++k) {
            mult *= (long)dim[k];
        }
        long oldHyperplaneSize = (long)dim[dim.length - 2] * mult;
        long newHyperplaneSize = (long)newLastButOneDim * mult;
        int n = dim[dim.length - 1];
        dim[dim.length - 2] = newLastButOneDim;
        dim[dim.length - 1] = newLastDim;
        long[] array = matrix.array();
        TinyBitMatrix result = matrix.reDim(dim);
        long oldDisp = (long)n * oldHyperplaneSize;
        long newDisp = (long)n * newHyperplaneSize;
        for (int k = n - 1; k >= 0; --k) {
            PackedBitArrays.copyBits(array, newDisp -= newHyperplaneSize, array, oldDisp -= oldHyperplaneSize, oldHyperplaneSize);
            PackedBitArrays.fillBits(array, newDisp + oldHyperplaneSize, newHyperplaneSize - oldHyperplaneSize, false);
        }
        return result;
    }
}

