/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public abstract class ExpFunc
implements Func {
    private final double base;

    private ExpFunc(double base) {
        this.base = base;
    }

    public static ExpFunc getInstance(double b) {
        if (b == Math.E) {
            return new ExpFunc(b){

                @Override
                public double get(double ... x) {
                    return Math.exp(x[0]);
                }

                @Override
                public double get(double x0) {
                    return Math.exp(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return Math.exp(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return Math.exp(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return Math.exp(x0);
                }
            };
        }
        final double mult = Math.log(b);
        return new ExpFunc(b){

            @Override
            public double get(double ... x) {
                return Math.exp(x[0] * mult);
            }

            @Override
            public double get(double x0) {
                return Math.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1) {
                return Math.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return Math.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return Math.exp(x0 * mult);
            }
        };
    }

    public static ExpFunc getStrictInstance(double b) {
        if (b == Math.E) {
            return new ExpFunc(b){

                @Override
                public double get(double ... x) {
                    return StrictMath.exp(x[0]);
                }

                @Override
                public double get(double x0) {
                    return StrictMath.exp(x0);
                }

                @Override
                public double get(double x0, double x1) {
                    return StrictMath.exp(x0);
                }

                @Override
                public double get(double x0, double x1, double x2) {
                    return StrictMath.exp(x0);
                }

                @Override
                public double get(double x0, double x1, double x2, double x3) {
                    return StrictMath.exp(x0);
                }
            };
        }
        final double mult = StrictMath.log(b);
        return new ExpFunc(b){

            @Override
            public double get(double ... x) {
                return StrictMath.exp(x[0] * mult);
            }

            @Override
            public double get(double x0) {
                return StrictMath.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1) {
                return StrictMath.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1, double x2) {
                return StrictMath.exp(x0 * mult);
            }

            @Override
            public double get(double x0, double x1, double x2, double x3) {
                return StrictMath.exp(x0 * mult);
            }
        };
    }

    @Override
    public abstract double get(double ... var1);

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 1 argument required");
    }

    @Override
    public abstract double get(double var1);

    @Override
    public abstract double get(double var1, double var3);

    public String toString() {
        return "exponent function f(x)=" + (String)(this.base == Math.E ? "e^x" : this.base + "^x");
    }
}

