/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import net.algart.math.functions.Func;

public final class DividingFunc
implements Func {
    private final double scale;

    private DividingFunc(double scale) {
        this.scale = scale;
    }

    public static DividingFunc getInstance(double scale) {
        return new DividingFunc(scale);
    }

    @Override
    public double get(double ... x) {
        return this.scale * x[0] / x[1];
    }

    @Override
    public double get() {
        throw new IndexOutOfBoundsException("At least 2 arguments required");
    }

    @Override
    public double get(double x0) {
        throw new IndexOutOfBoundsException("At least 2 arguments required");
    }

    @Override
    public double get(double x0, double x1) {
        return this.scale * x0 / x1;
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.scale * x0 / x1;
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.scale * x0 / x1;
    }

    public String toString() {
        return "quotient function f(x,y)=" + this.scale + "*x/y";
    }
}

