/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math.functions;

import java.util.Objects;
import net.algart.math.functions.CoordinateTransformationOperator;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;
import net.algart.math.functions.ProjectiveOperator;

public class CoordinateTransformedFunc
implements Func {
    final Func parent;
    final CoordinateTransformationOperator operator;

    private CoordinateTransformedFunc(Func parent, CoordinateTransformationOperator operator) {
        Objects.requireNonNull(parent, "Null parent function");
        Objects.requireNonNull(operator, "Null operator");
        this.parent = parent;
        this.operator = operator;
    }

    public static Func getInstance(Func parent, CoordinateTransformationOperator operator) {
        int dimCount;
        if (operator instanceof LinearOperator) {
            LinearOperator lo = (LinearOperator)operator;
            if (lo.isShift() && lo.isZeroB()) {
                return parent;
            }
            dimCount = lo.n();
            final double[] b = lo.b();
            if (dimCount == 1) {
                final double[] a = lo.a();
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0) {
                        double y0 = a[0] * x0 + b[0];
                        return this.parent.get(y0);
                    }
                };
            }
            if (dimCount == 2) {
                if (lo.isDiagonal()) {
                    final double[] diagonal = lo.diagonal();
                    if (b[0] == 0.0 && b[1] == 0.0) {
                        return new CoordinateTransformedFunc(parent, operator){

                            @Override
                            public double get(double x0, double x1) {
                                return this.parent.get(diagonal[0] * x0, diagonal[1] * x1);
                            }
                        };
                    }
                    return new CoordinateTransformedFunc(parent, operator){

                        @Override
                        public double get(double x0, double x1) {
                            double y0 = diagonal[0] * x0 + b[0];
                            double y1 = diagonal[1] * x1 + b[1];
                            return this.parent.get(y0, y1);
                        }
                    };
                }
                final double[] a = lo.a();
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0, double x1) {
                        double y0 = a[0] * x0 + a[1] * x1 + b[0];
                        double y1 = a[2] * x0 + a[3] * x1 + b[1];
                        return this.parent.get(y0, y1);
                    }
                };
            }
            if (dimCount == 3) {
                if (lo.isDiagonal()) {
                    final double[] diagonal = lo.diagonal();
                    if (b[0] == 0.0 && b[1] == 0.0 && b[2] == 0.0) {
                        return new CoordinateTransformedFunc(parent, operator){

                            @Override
                            public double get(double x0, double x1, double x2) {
                                return this.parent.get(diagonal[0] * x0, diagonal[1] * x1, diagonal[2] * x2);
                            }
                        };
                    }
                    return new CoordinateTransformedFunc(parent, operator){

                        @Override
                        public double get(double x0, double x1, double x2) {
                            double y0 = diagonal[0] * x0 + b[0];
                            double y1 = diagonal[1] * x1 + b[1];
                            double y2 = diagonal[2] * x2 + b[2];
                            return this.parent.get(y0, y1, y2);
                        }
                    };
                }
                final double[] a = lo.a();
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0, double x1, double x2) {
                        double y0 = a[0] * x0 + a[1] * x1 + a[2] * x2 + b[0];
                        double y1 = a[3] * x0 + a[4] * x1 + a[5] * x2 + b[1];
                        double y2 = a[6] * x0 + a[7] * x1 + a[8] * x2 + b[2];
                        return this.parent.get(y0, y1, y2);
                    }
                };
            }
        }
        if (operator instanceof ProjectiveOperator) {
            ProjectiveOperator po = (ProjectiveOperator)operator;
            dimCount = po.n();
            if (po.isShift() && po.isZeroB()) {
                throw new AssertionError((Object)("Identity operator must be " + String.valueOf(LinearOperator.class)));
            }
            final double[] a = po.a();
            final double[] b = po.b();
            final double[] c = po.c();
            final double d = po.d();
            assert (po.n() == b.length && b.length == c.length && a.length == b.length * b.length);
            if (dimCount == 1) {
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0) {
                        double y0 = (a[0] * x0 + b[0]) / (c[0] * x0 + d);
                        return this.parent.get(y0);
                    }
                };
            }
            if (dimCount == 2) {
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0, double x1) {
                        double multiplier = 1.0 / (c[0] * x0 + c[1] * x1 + d);
                        double y0 = (a[0] * x0 + a[1] * x1 + b[0]) * multiplier;
                        double y1 = (a[2] * x0 + a[3] * x1 + b[1]) * multiplier;
                        return this.parent.get(y0, y1);
                    }
                };
            }
            if (dimCount == 3) {
                return new CoordinateTransformedFunc(parent, operator){

                    @Override
                    public double get(double x0, double x1, double x2) {
                        double multiplier = 1.0 / (c[0] * x0 + c[1] * x1 + c[2] * x2 + d);
                        double y0 = (a[0] * x0 + a[1] * x1 + a[2] * x2 + b[0]) * multiplier;
                        double y1 = (a[3] * x0 + a[4] * x1 + a[5] * x2 + b[1]) * multiplier;
                        double y2 = (a[6] * x0 + a[7] * x1 + a[8] * x2 + b[2]) * multiplier;
                        return this.parent.get(y0, y1, y2);
                    }
                };
            }
        }
        return new CoordinateTransformedFunc(parent, operator);
    }

    public Func parent() {
        return this.parent;
    }

    public CoordinateTransformationOperator operator() {
        return this.operator;
    }

    @Override
    public double get(double ... x) {
        double[] y = new double[x.length];
        this.operator.map(y, x);
        return this.parent.get(y);
    }

    @Override
    public double get() {
        return this.parent.get();
    }

    @Override
    public double get(double x0) {
        return this.get(new double[]{x0});
    }

    @Override
    public double get(double x0, double x1) {
        return this.get(new double[]{x0, x1});
    }

    @Override
    public double get(double x0, double x1, double x2) {
        return this.get(new double[]{x0, x1, x2});
    }

    @Override
    public double get(double x0, double x1, double x2, double x3) {
        return this.get(new double[]{x0, x1, x2, x3});
    }

    public String toString() {
        return String.valueOf(this.parent) + " transformed by " + String.valueOf(this.operator);
    }
}

