/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.Range;

public class RectangularArea {
    final Point min;
    final Point max;

    RectangularArea(Point min, Point max) {
        this.min = min;
        this.max = max;
    }

    public static RectangularArea of(Point min, Point max) {
        Objects.requireNonNull(min, "Null min vertex");
        Objects.requireNonNull(max, "Null max vertex");
        int n = min.coordinates.length;
        if (n != max.coordinates.length) {
            throw new IllegalArgumentException("Cannot create RectangularArea: min.coordCount() = " + n + " does not match max.coordCount() = " + max.coordinates.length);
        }
        for (int k = 0; k < n; ++k) {
            if (Double.isNaN(min.coordinates[k])) {
                throw new IllegalArgumentException("Cannot create RectangularArea: min.coord(" + k + ") is NaN");
            }
            if (Double.isNaN(max.coordinates[k])) {
                throw new IllegalArgumentException("Cannot create RectangularArea: max.coord(" + k + ") is NaN");
            }
            if (!(min.coordinates[k] > max.coordinates[k])) continue;
            throw new IllegalArgumentException("Cannot create RectangularArea: min.coord(" + k + ") > max.coord(" + k + ") (min = " + String.valueOf(min) + ", max = " + String.valueOf(max) + ")");
        }
        return new RectangularArea(min, max);
    }

    @Deprecated
    public static RectangularArea valueOf(Point min, Point max) {
        return RectangularArea.of(min, max);
    }

    public static RectangularArea of(Range ... coordinateRanges) {
        Objects.requireNonNull(coordinateRanges, "Null coordinateRanges argument");
        int n = coordinateRanges.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinateRanges array");
        }
        coordinateRanges = (Range[])coordinateRanges.clone();
        for (int k = 0; k < n; ++k) {
            Objects.requireNonNull(coordinateRanges[k], "Null coordinateRanges[" + k + "]");
        }
        double[] min = new double[n];
        double[] max = new double[n];
        for (int k = 0; k < n; ++k) {
            min[k] = coordinateRanges[k].min;
            max[k] = coordinateRanges[k].max;
        }
        return new RectangularArea(new Point(min), new Point(max));
    }

    @Deprecated
    public static RectangularArea valueOf(Range ... coordinateRanges) {
        return RectangularArea.of(coordinateRanges);
    }

    public static RectangularArea ofSize(double minX, double sizeX) {
        if (sizeX < 0.0) {
            throw new IllegalArgumentException("Negative sizeX: " + sizeX);
        }
        if (Double.isNaN(sizeX)) {
            throw new IllegalArgumentException("sizeX is NaN");
        }
        return RectangularArea.of(minX, minX + sizeX);
    }

    public static RectangularArea of(double minX, double maxX) {
        return RectangularArea.of(Point.of(minX), Point.of(maxX));
    }

    @Deprecated
    public static RectangularArea valueOf(double minX, double maxX) {
        return RectangularArea.of(minX, maxX);
    }

    public static RectangularArea ofSize(double minX, double minY, double sizeX, double sizeY) {
        if (sizeX < 0.0) {
            throw new IllegalArgumentException("Negative sizeX: " + sizeX);
        }
        if (sizeY < 0.0) {
            throw new IllegalArgumentException("Negative sizeY: " + sizeY);
        }
        if (Double.isNaN(sizeX)) {
            throw new IllegalArgumentException("sizeX is NaN");
        }
        if (Double.isNaN(sizeY)) {
            throw new IllegalArgumentException("sizeY is NaN");
        }
        return RectangularArea.of(minX, minY, minX + sizeX, minY + sizeY);
    }

    public static RectangularArea of(double minX, double minY, double maxX, double maxY) {
        return RectangularArea.of(Point.of(minX, minY), Point.of(maxX, maxY));
    }

    @Deprecated
    public static RectangularArea valueOf(double minX, double minY, double maxX, double maxY) {
        return RectangularArea.of(minX, minY, maxX, maxY);
    }

    public static RectangularArea ofSize(double minX, double minY, double minZ, double sizeX, double sizeY, double sizeZ) {
        if (sizeX < 0.0) {
            throw new IllegalArgumentException("Negative sizeX: " + sizeX);
        }
        if (sizeY < 0.0) {
            throw new IllegalArgumentException("Negative sizeY: " + sizeY);
        }
        if (sizeZ < 0.0) {
            throw new IllegalArgumentException("Negative sizeZ: " + sizeZ);
        }
        if (Double.isNaN(sizeX)) {
            throw new IllegalArgumentException("sizeX is NaN");
        }
        if (Double.isNaN(sizeY)) {
            throw new IllegalArgumentException("sizeY is NaN");
        }
        if (Double.isNaN(sizeZ)) {
            throw new IllegalArgumentException("sizeZ is NaN");
        }
        return RectangularArea.of(minX, minY, minZ, minX + sizeX, minY + sizeY, minZ + sizeZ);
    }

    public static RectangularArea of(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return RectangularArea.of(Point.of(minX, minY, minZ), Point.of(maxX, maxY, maxZ));
    }

    @Deprecated
    public static RectangularArea valueOf(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return RectangularArea.of(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static RectangularArea of(IRectangularArea iArea) {
        Objects.requireNonNull(iArea, "Null iArea argument");
        return new RectangularArea(Point.of(iArea.min), Point.of(iArea.max));
    }

    @Deprecated
    public static RectangularArea valueOf(IRectangularArea iArea) {
        return RectangularArea.of(iArea);
    }

    public int coordCount() {
        return this.min.coordinates.length;
    }

    public Point min() {
        return this.min;
    }

    public Point max() {
        return this.max;
    }

    public Point size() {
        return new Point(this.sizes());
    }

    public double min(int coordIndex) {
        return this.min.coordinates[coordIndex];
    }

    public double max(int coordIndex) {
        return this.max.coordinates[coordIndex];
    }

    public double size(int coordIndex) {
        return this.max.coordinates[coordIndex] - this.min.coordinates[coordIndex];
    }

    public double minX() {
        return this.min.coordinates[0];
    }

    public double maxX() {
        return this.max.coordinates[0];
    }

    public double sizeX() {
        return this.max.coordinates[0] - this.min.coordinates[0];
    }

    public double minY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.min.coordinates[1];
    }

    public double maxY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[1];
    }

    public double sizeY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[1] - this.min.coordinates[1];
    }

    public double minZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.min.coordinates[2];
    }

    public double maxZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[2];
    }

    public double sizeZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[2] - this.min.coordinates[2];
    }

    public double[] sizes() {
        double[] sizes = new double[this.min.coordinates.length];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = this.max.coordinates[k] - this.min.coordinates[k];
        }
        return sizes;
    }

    public double volume() {
        double result = this.max.coordinates[0] - this.min.coordinates[0];
        for (int k = 1; k < this.min.coordinates.length; ++k) {
            result *= this.max.coordinates[k] - this.min.coordinates[k];
        }
        return result;
    }

    public Range range(int coordIndex) {
        return new Range(this.min.coordinates[coordIndex], this.max.coordinates[coordIndex]);
    }

    public Range[] ranges() {
        Range[] ranges = new Range[this.min.coordinates.length];
        for (int k = 0; k < ranges.length; ++k) {
            ranges[k] = Range.of(this.min.coordinates[k], this.max.coordinates[k]);
        }
        return ranges;
    }

    public boolean contains(Point point) {
        Objects.requireNonNull(point, "Null point argument");
        int n = this.min.coordinates.length;
        if (point.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + point.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (!(point.coordinates[k] < this.min.coordinates[k]) && !(point.coordinates[k] > this.max.coordinates[k])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<RectangularArea> areas, Point point) {
        Objects.requireNonNull(areas, "Null areas");
        Objects.requireNonNull(point, "Null point");
        for (RectangularArea a : areas) {
            if (!a.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (!(area.min.coordinates[k] < this.min.coordinates[k]) && !(area.max.coordinates[k] > this.max.coordinates[k])) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<RectangularArea> areas, RectangularArea area) {
        Objects.requireNonNull(areas, "Null areas argument");
        Objects.requireNonNull(area, "Null area argument");
        for (RectangularArea a : areas) {
            if (!a.contains(area)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (!(area.max.coordinates[k] < this.min.coordinates[k]) && !(area.min.coordinates[k] > this.max.coordinates[k])) continue;
            return false;
        }
        return true;
    }

    public boolean overlaps(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (!(area.max.coordinates[k] <= this.min.coordinates[k]) && !(area.min.coordinates[k] >= this.max.coordinates[k])) continue;
            return false;
        }
        return true;
    }

    public RectangularArea intersection(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        double[] newMin = new double[n];
        double[] newMax = new double[n];
        for (int k = 0; k < n; ++k) {
            newMin[k] = Math.max(this.min.coordinates[k], area.min.coordinates[k]);
            newMax[k] = Math.min(this.max.coordinates[k], area.max.coordinates[k]);
            if (!(newMin[k] > newMax[k])) continue;
            return null;
        }
        return new RectangularArea(new Point(newMin), new Point(newMax));
    }

    public List<RectangularArea> intersection(Collection<RectangularArea> areas) {
        Objects.requireNonNull(areas, "Null areas argument");
        ArrayList<RectangularArea> result = new ArrayList<RectangularArea>();
        for (RectangularArea area : areas) {
            RectangularArea intersection = this.intersection(area);
            if (intersection == null) continue;
            result.add(intersection);
        }
        return result;
    }

    public Collection<RectangularArea> difference(Collection<RectangularArea> results, RectangularArea area) {
        Objects.requireNonNull(results, "Null results argument");
        if (!this.intersects(area)) {
            results.add(this);
            return results;
        }
        double[] min = (double[])this.min.coordinates.clone();
        double[] max = (double[])this.max.coordinates.clone();
        for (int k = min.length - 1; k >= 0; --k) {
            assert (area.max.coordinates[k] >= min[k] && area.min.coordinates[k] <= max[k]);
            if (area.min.coordinates[k] > this.min.coordinates[k]) {
                min[k] = this.min.coordinates[k];
                max[k] = area.min.coordinates[k];
                results.add(new RectangularArea(Point.of(min), Point.of(max)));
            }
            if (area.max.coordinates[k] < this.max.coordinates[k]) {
                min[k] = area.max.coordinates[k];
                max[k] = this.max.coordinates[k];
                results.add(new RectangularArea(Point.of(min), Point.of(max)));
            }
            min[k] = Math.max(area.min.coordinates[k], this.min.coordinates[k]);
            max[k] = Math.min(area.max.coordinates[k], this.max.coordinates[k]);
        }
        return results;
    }

    public static Queue<RectangularArea> subtractCollection(Queue<RectangularArea> fromWhatToSubtract, Collection<RectangularArea> whatToSubtract) {
        Objects.requireNonNull(fromWhatToSubtract, "Null fromWhatToSubtract");
        Objects.requireNonNull(whatToSubtract, "Null whatToSubtract");
        for (RectangularArea area : whatToSubtract) {
            int n = fromWhatToSubtract.size();
            for (int i = 0; i < n; ++i) {
                RectangularArea minuend = fromWhatToSubtract.poll();
                if (minuend == null) {
                    throw new AssertionError((Object)("Null minuend in fromWhatToSubtract at index " + i));
                }
                minuend.difference(fromWhatToSubtract, area);
            }
            if (!fromWhatToSubtract.isEmpty()) continue;
            break;
        }
        return fromWhatToSubtract;
    }

    public static Queue<RectangularArea> subtractCollection(Queue<RectangularArea> fromWhatToSubtract, RectangularArea ... whatToSubtract) {
        return RectangularArea.subtractCollection(fromWhatToSubtract, Arrays.asList(whatToSubtract));
    }

    public Queue<RectangularArea> subtract(Collection<RectangularArea> whatToSubtract) {
        Objects.requireNonNull(whatToSubtract, "Null whatToSubtract");
        ArrayDeque<RectangularArea> difference = new ArrayDeque<RectangularArea>();
        difference.add(this);
        RectangularArea.subtractCollection(difference, whatToSubtract);
        return difference;
    }

    public Queue<RectangularArea> subtract(RectangularArea ... whatToSubtract) {
        return this.subtract(Arrays.asList(whatToSubtract));
    }

    public RectangularArea expand(Point point) {
        if (this.contains(point)) {
            return this;
        }
        double[] newMin = new double[this.min.coordinates.length];
        double[] newMax = new double[this.min.coordinates.length];
        for (int k = 0; k < this.min.coordinates.length; ++k) {
            newMin[k] = Math.min(this.min.coordinates[k], point.coordinates[k]);
            newMax[k] = Math.max(this.max.coordinates[k], point.coordinates[k]);
        }
        return RectangularArea.of(new Point(newMin), new Point(newMax));
    }

    public RectangularArea expand(RectangularArea area) {
        if (this.contains(area)) {
            return this;
        }
        double[] newMin = new double[this.min.coordinates.length];
        double[] newMax = new double[this.min.coordinates.length];
        for (int k = 0; k < this.min.coordinates.length; ++k) {
            newMin[k] = Math.min(this.min.coordinates[k], area.min.coordinates[k]);
            newMax[k] = Math.max(this.max.coordinates[k], area.max.coordinates[k]);
        }
        return RectangularArea.of(new Point(newMin), new Point(newMax));
    }

    public static RectangularArea minimalContainingArea(Collection<RectangularArea> areas) {
        Objects.requireNonNull(areas, "Null areas");
        if (areas.isEmpty()) {
            return null;
        }
        int coordCount = areas.iterator().next().coordCount();
        double[] min = new double[coordCount];
        double[] max = new double[coordCount];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (RectangularArea area : areas) {
            if (area.coordCount() != coordCount) {
                throw new IllegalArgumentException("Some areas have different number of dimension: " + area.coordCount() + " and " + coordCount);
            }
            for (int k = 0; k < coordCount; ++k) {
                min[k] = Math.min(min[k], area.min(k));
                max[k] = Math.max(max[k], area.max(k));
            }
        }
        return RectangularArea.of(new Point(min), new Point(max));
    }

    public double parallelDistance(Point point) {
        Objects.requireNonNull(point, "Null point argument");
        return this.parallelDistance(point.coordinates);
    }

    public double parallelDistance(double ... coordinates) {
        Objects.requireNonNull(coordinates, "Null coordinates argument");
        int n = this.min.coordinates.length;
        if (coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + coordinates.length + " instead of " + n);
        }
        double min = this.min.coordinates[0];
        double max = this.max.coordinates[0];
        double x = coordinates[0];
        double maxD = Math.max(min - x, x - max);
        for (int k = 1; k < n; ++k) {
            min = this.min.coordinates[k];
            double xk = coordinates[k];
            max = this.max.coordinates[k];
            double d = Math.max(min - xk, xk - max);
            if (!(d > maxD)) continue;
            maxD = d;
        }
        return maxD;
    }

    public double parallelDistance(double x, double y) {
        int n = this.min.coordinates.length;
        if (n != 2) {
            throw new IllegalArgumentException("Dimensions count mismatch: 2 instead of " + n);
        }
        double min = this.min.coordinates[0];
        double max = this.max.coordinates[0];
        double maxD = Math.max(min - x, x - max);
        min = this.min.coordinates[1];
        max = this.max.coordinates[1];
        double d = Math.max(min - y, y - max);
        if (d > maxD) {
            maxD = d;
        }
        return maxD;
    }

    public double parallelDistance(double x, double y, double z) {
        int n = this.min.coordinates.length;
        if (n != 3) {
            throw new IllegalArgumentException("Dimensions count mismatch: 3 instead of " + n);
        }
        double min = this.min.coordinates[0];
        double max = this.max.coordinates[0];
        double maxD = Math.max(min - x, x - max);
        min = this.min.coordinates[1];
        max = this.max.coordinates[1];
        double d = Math.max(min - y, y - max);
        if (d > maxD) {
            maxD = d;
        }
        if ((d = Math.max((min = this.min.coordinates[2]) - z, z - (max = this.max.coordinates[2]))) > maxD) {
            maxD = d;
        }
        return maxD;
    }

    public RectangularArea shift(Point vector) {
        Objects.requireNonNull(vector, "Null vector argument");
        if (vector.coordinates.length != this.min.coordinates.length) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + vector.coordinates.length + " instead of " + this.min.coordinates.length);
        }
        if (vector.isOrigin()) {
            return this;
        }
        return new RectangularArea(this.min.add(vector), this.max.add(vector));
    }

    public RectangularArea shiftBack(Point vector) {
        Objects.requireNonNull(vector, "Null vector argument");
        if (vector.coordinates.length != this.min.coordinates.length) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + vector.coordinates.length + " instead of " + this.min.coordinates.length);
        }
        if (vector.isOrigin()) {
            return this;
        }
        return new RectangularArea(this.min.subtract(vector), this.max.subtract(vector));
    }

    public RectangularArea dilate(Point expansion) {
        Objects.requireNonNull(expansion, "Null expansion");
        if (expansion.coordCount() != this.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + expansion.coordCount() + " instead of " + this.coordCount());
        }
        if (expansion.isOrigin()) {
            return this;
        }
        return RectangularArea.of(this.min().subtract(expansion), this.max().add(expansion));
    }

    public RectangularArea dilate(double expansion) {
        return this.dilate(Point.ofEqualCoordinates(this.coordCount(), expansion));
    }

    public List<RectangularArea> dilateStraightOnly(List<RectangularArea> results, Point expansion) {
        Objects.requireNonNull(results, "Null results");
        Objects.requireNonNull(expansion, "Null expansion");
        results.add(this);
        int coordCount = this.coordCount();
        if (expansion.coordCount() != coordCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + expansion.coordCount() + " instead of " + coordCount);
        }
        double[] min = this.min.coordinates();
        double[] max = this.max.coordinates();
        for (int k = 0; k < coordCount; ++k) {
            double delta = expansion.coordinates[k];
            if (delta == 0.0) continue;
            if (delta < 0.0) {
                throw new IllegalArgumentException("Negative expansion is impossible: " + String.valueOf(expansion));
            }
            double saveMin = min[k];
            double saveMax = max[k];
            min[k] = saveMin - delta;
            max[k] = saveMin;
            results.add(RectangularArea.of(Point.of(min), Point.of(max)));
            min[k] = saveMax;
            max[k] = saveMax + delta;
            results.add(RectangularArea.of(Point.of(min), Point.of(max)));
            min[k] = saveMin;
            max[k] = saveMax;
        }
        return results;
    }

    public List<RectangularArea> dilateStraightOnly(List<RectangularArea> results, double expansion) {
        return this.dilateStraightOnly(results, Point.ofEqualCoordinates(this.coordCount(), expansion));
    }

    public static List<RectangularArea> dilate(Collection<RectangularArea> areas, Point expansion, boolean straightOnly) {
        Objects.requireNonNull(areas, "Null areas");
        ArrayList<RectangularArea> result = new ArrayList<RectangularArea>();
        for (RectangularArea area : areas) {
            if (straightOnly) {
                area.dilateStraightOnly(result, expansion);
                continue;
            }
            result.add(area.dilate(expansion));
        }
        return result;
    }

    public IRectangularArea toIntegerRectangularArea() {
        return IRectangularArea.of(IPoint.of(this.min), IPoint.of(this.max), true);
    }

    public IRectangularArea toRoundedRectangularArea() {
        return IRectangularArea.of(IPoint.roundOf(this.min), IPoint.roundOf(this.max), true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + String.valueOf(this.range(0)) + "]");
        for (int k = 1; k < this.min.coordinates.length; ++k) {
            sb.append("x").append("[").append(this.range(k)).append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.min.hashCode() * 37 + this.max.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RectangularArea && ((RectangularArea)obj).min.equals(this.min) && ((RectangularArea)obj).max.equals(this.max);
    }
}

