/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.Point;
import net.algart.math.RectangularArea;

public class IRectangularArea {
    final IPoint min;
    final IPoint max;

    private IRectangularArea(IPoint min, IPoint max) {
        this.min = min;
        this.max = max;
    }

    public static IRectangularArea of(IPoint min, IPoint max) {
        return IRectangularArea.of(min, max, false);
    }

    @Deprecated
    public static IRectangularArea valueOf(IPoint min, IPoint max) {
        return IRectangularArea.of(min, max);
    }

    public static IRectangularArea of(IRange ... coordinateRanges) {
        Objects.requireNonNull(coordinateRanges, "Null coordinateRanges argument");
        int n = coordinateRanges.length;
        if (n == 0) {
            throw new IllegalArgumentException("Empty coordinateRanges array");
        }
        coordinateRanges = (IRange[])coordinateRanges.clone();
        for (int k = 0; k < n; ++k) {
            Objects.requireNonNull(coordinateRanges[k], "Null coordinateRanges[" + k + "]");
        }
        long[] min = new long[n];
        long[] max = new long[n];
        for (int k = 0; k < n; ++k) {
            min[k] = coordinateRanges[k].min;
            max[k] = coordinateRanges[k].max;
        }
        return new IRectangularArea(new IPoint(min), new IPoint(max));
    }

    @Deprecated
    public static IRectangularArea valueOf(IRange ... coordinateRanges) {
        return IRectangularArea.of(coordinateRanges);
    }

    public static IRectangularArea ofSize(long minX, long sizeX) {
        if (sizeX <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeX: " + sizeX);
        }
        if (minX > Long.MAX_VALUE - (sizeX - 1L)) {
            throw new IllegalArgumentException("Overflow: minX + sizeX > Long.MAX_VALUE");
        }
        return IRectangularArea.of(minX, minX + sizeX - 1L);
    }

    public static IRectangularArea of(long minX, long maxX) {
        return IRectangularArea.of(IPoint.of(minX), IPoint.of(maxX));
    }

    @Deprecated
    public static IRectangularArea valueOf(long minX, long maxX) {
        return IRectangularArea.of(minX, maxX);
    }

    public static IRectangularArea ofSize(long minX, long minY, long sizeX, long sizeY) {
        if (sizeX <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeX: " + sizeX);
        }
        if (sizeY <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeY: " + sizeY);
        }
        if (minX > Long.MAX_VALUE - (sizeX - 1L)) {
            throw new IllegalArgumentException("Overflow: minX + sizeX > Long.MAX_VALUE");
        }
        if (minY > Long.MAX_VALUE - (sizeY - 1L)) {
            throw new IllegalArgumentException("Overflow: minY + sizeY > Long.MAX_VALUE");
        }
        return IRectangularArea.of(minX, minY, minX + sizeX - 1L, minY + sizeY - 1L);
    }

    public static IRectangularArea of(long minX, long minY, long maxX, long maxY) {
        return IRectangularArea.of(IPoint.of(minX, minY), IPoint.of(maxX, maxY));
    }

    @Deprecated
    public static IRectangularArea valueOf(long minX, long minY, long maxX, long maxY) {
        return IRectangularArea.of(minX, minY, maxX, maxY);
    }

    public static IRectangularArea ofSize(long minX, long minY, long minZ, long sizeX, long sizeY, long sizeZ) {
        if (sizeX <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeX: " + sizeX);
        }
        if (sizeY <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeY: " + sizeY);
        }
        if (sizeZ <= 0L) {
            throw new IllegalArgumentException("Zero or negative sizeZ: " + sizeZ);
        }
        if (minX > Long.MAX_VALUE - (sizeX - 1L)) {
            throw new IllegalArgumentException("Overflow: minX + sizeX > Long.MAX_VALUE");
        }
        if (minY > Long.MAX_VALUE - (sizeY - 1L)) {
            throw new IllegalArgumentException("Overflow: minY + sizeY > Long.MAX_VALUE");
        }
        if (minZ > Long.MAX_VALUE - (sizeZ - 1L)) {
            throw new IllegalArgumentException("Overflow: minZ + sizeZ > Long.MAX_VALUE");
        }
        return IRectangularArea.of(minX, minY, minZ, minX + sizeX - 1L, minY + sizeY - 1L, minZ + sizeZ - 1L);
    }

    public static IRectangularArea of(long minX, long minY, long minZ, long maxX, long maxY, long maxZ) {
        return IRectangularArea.of(IPoint.of(minX, minY, minZ), IPoint.of(maxX, maxY, maxZ));
    }

    @Deprecated
    public static IRectangularArea valueOf(long minX, long minY, long minZ, long maxX, long maxY, long maxZ) {
        return IRectangularArea.of(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static IRectangularArea of(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        return IRectangularArea.of(IPoint.of(area.min), IPoint.of(area.max));
    }

    @Deprecated
    public static IRectangularArea valueOf(RectangularArea area) {
        return IRectangularArea.of(area);
    }

    public static IRectangularArea roundOf(RectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        return IRectangularArea.of(IPoint.roundOf(area.min), IPoint.roundOf(area.max));
    }

    public int coordCount() {
        return this.min.coordinates.length;
    }

    public IPoint min() {
        return this.min;
    }

    public IPoint max() {
        return this.max;
    }

    public IPoint size() {
        return new IPoint(this.sizes());
    }

    public IPoint width() {
        return new IPoint(this.widths());
    }

    public long min(int coordIndex) {
        return this.min.coordinates[coordIndex];
    }

    public long max(int coordIndex) {
        return this.max.coordinates[coordIndex];
    }

    public long size(int coordIndex) {
        return this.max.coordinates[coordIndex] - this.min.coordinates[coordIndex] + 1L;
    }

    public long width(int coordIndex) {
        return this.max.coordinates[coordIndex] - this.min.coordinates[coordIndex];
    }

    public long minX() {
        return this.min.coordinates[0];
    }

    public long maxX() {
        return this.max.coordinates[0];
    }

    public long sizeX() {
        return this.max.coordinates[0] - this.min.coordinates[0] + 1L;
    }

    public long widthX() {
        return this.max.coordinates[0] - this.min.coordinates[0];
    }

    public long minY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.min.coordinates[1];
    }

    public long maxY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[1];
    }

    public long sizeY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[1] - this.min.coordinates[1] + 1L;
    }

    public long widthY() {
        if (this.min.coordinates.length < 2) {
            throw new IllegalStateException("Cannot get y-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[1] - this.min.coordinates[1];
    }

    public long minZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.min.coordinates[2];
    }

    public long maxZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[2];
    }

    public long sizeZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[2] - this.min.coordinates[2] + 1L;
    }

    public long widthZ() {
        if (this.min.coordinates.length < 3) {
            throw new IllegalStateException("Cannot get z-coordinates of " + this.coordCount() + "-dimensional area");
        }
        return this.max.coordinates[2] - this.min.coordinates[2];
    }

    public long[] sizes() {
        long[] sizes = new long[this.min.coordinates.length];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = this.max.coordinates[k] - this.min.coordinates[k] + 1L;
        }
        return sizes;
    }

    public long[] widths() {
        long[] widths = new long[this.min.coordinates.length];
        for (int k = 0; k < widths.length; ++k) {
            widths[k] = this.max.coordinates[k] - this.min.coordinates[k];
        }
        return widths;
    }

    public double volume() {
        double result = this.max.coordinates[0] - this.min.coordinates[0] + 1L;
        for (int k = 1; k < this.min.coordinates.length; ++k) {
            result *= (double)(this.max.coordinates[k] - this.min.coordinates[k] + 1L);
        }
        return result;
    }

    public IRange range(int coordIndex) {
        return new IRange(this.min.coordinates[coordIndex], this.max.coordinates[coordIndex]);
    }

    public IRange[] ranges() {
        IRange[] ranges = new IRange[this.min.coordinates.length];
        for (int k = 0; k < ranges.length; ++k) {
            ranges[k] = IRange.of(this.min.coordinates[k], this.max.coordinates[k]);
        }
        return ranges;
    }

    public boolean contains(IPoint point) {
        Objects.requireNonNull(point, "Null point argument");
        int n = this.min.coordinates.length;
        if (point.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + point.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (point.coordinates[k] >= this.min.coordinates[k] && point.coordinates[k] <= this.max.coordinates[k]) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<IRectangularArea> areas, IPoint point) {
        Objects.requireNonNull(areas, "Null areas argument");
        Objects.requireNonNull(point, "Null point argument");
        for (IRectangularArea a : areas) {
            if (!a.contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (area.min.coordinates[k] >= this.min.coordinates[k] && area.max.coordinates[k] <= this.max.coordinates[k]) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Collection<IRectangularArea> areas, IRectangularArea area) {
        Objects.requireNonNull(areas, "Null areas argument");
        Objects.requireNonNull(area, "Null area argument");
        for (IRectangularArea a : areas) {
            if (!a.contains(area)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        for (int k = 0; k < n; ++k) {
            if (area.max.coordinates[k] >= this.min.coordinates[k] && area.min.coordinates[k] <= this.max.coordinates[k]) continue;
            return false;
        }
        return true;
    }

    public IRectangularArea intersection(IRectangularArea area) {
        Objects.requireNonNull(area, "Null area argument");
        int n = this.min.coordinates.length;
        if (area.min.coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + area.min.coordinates.length + " instead of " + n);
        }
        long[] newMin = new long[n];
        long[] newMax = new long[n];
        for (int k = 0; k < n; ++k) {
            newMin[k] = Math.max(this.min.coordinates[k], area.min.coordinates[k]);
            newMax[k] = Math.min(this.max.coordinates[k], area.max.coordinates[k]);
            if (newMin[k] <= newMax[k]) continue;
            return null;
        }
        return new IRectangularArea(new IPoint(newMin), new IPoint(newMax));
    }

    public List<IRectangularArea> intersection(Collection<IRectangularArea> areas) {
        Objects.requireNonNull(areas, "Null areas argument");
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>();
        for (IRectangularArea area : areas) {
            IRectangularArea intersection = this.intersection(area);
            if (intersection == null) continue;
            result.add(intersection);
        }
        return result;
    }

    public Collection<IRectangularArea> difference(Collection<IRectangularArea> results, IRectangularArea area) {
        Objects.requireNonNull(results, "Null results argument");
        if (!this.intersects(area)) {
            results.add(this);
            return results;
        }
        long[] min = (long[])this.min.coordinates.clone();
        long[] max = (long[])this.max.coordinates.clone();
        for (int k = min.length - 1; k >= 0; --k) {
            assert (area.max.coordinates[k] >= min[k] && area.min.coordinates[k] <= max[k]);
            if (area.min.coordinates[k] > this.min.coordinates[k]) {
                min[k] = this.min.coordinates[k];
                max[k] = area.min.coordinates[k] - 1L;
                results.add(new IRectangularArea(IPoint.of(min), IPoint.of(max)));
            }
            if (area.max.coordinates[k] < this.max.coordinates[k]) {
                min[k] = area.max.coordinates[k] + 1L;
                max[k] = this.max.coordinates[k];
                results.add(new IRectangularArea(IPoint.of(min), IPoint.of(max)));
            }
            min[k] = Math.max(area.min.coordinates[k], this.min.coordinates[k]);
            max[k] = Math.min(area.max.coordinates[k], this.max.coordinates[k]);
        }
        return results;
    }

    public static Queue<IRectangularArea> subtractCollection(Queue<IRectangularArea> fromWhatToSubtract, Collection<IRectangularArea> whatToSubtract) {
        Objects.requireNonNull(fromWhatToSubtract, "Null fromWhatToSubtract");
        Objects.requireNonNull(whatToSubtract, "Null whatToSubtract");
        for (IRectangularArea area : whatToSubtract) {
            int n = fromWhatToSubtract.size();
            for (int i = 0; i < n; ++i) {
                IRectangularArea minuend = fromWhatToSubtract.poll();
                if (minuend == null) {
                    throw new AssertionError((Object)("Null minuend in fromWhatToSubtract at index " + i));
                }
                minuend.difference(fromWhatToSubtract, area);
            }
            if (!fromWhatToSubtract.isEmpty()) continue;
            break;
        }
        return fromWhatToSubtract;
    }

    public static Queue<IRectangularArea> subtractCollection(Queue<IRectangularArea> fromWhatToSubtract, IRectangularArea ... whatToSubtract) {
        return IRectangularArea.subtractCollection(fromWhatToSubtract, Arrays.asList(whatToSubtract));
    }

    public Queue<IRectangularArea> subtract(Collection<IRectangularArea> whatToSubtract) {
        Objects.requireNonNull(whatToSubtract, "Null whatToSubtract");
        ArrayDeque<IRectangularArea> difference = new ArrayDeque<IRectangularArea>();
        difference.add(this);
        IRectangularArea.subtractCollection(difference, whatToSubtract);
        return difference;
    }

    public Queue<IRectangularArea> subtract(IRectangularArea ... whatToSubtract) {
        return this.subtract(Arrays.asList(whatToSubtract));
    }

    public IRectangularArea expand(IPoint point) {
        if (this.contains(point)) {
            return this;
        }
        long[] newMin = new long[this.min.coordinates.length];
        long[] newMax = new long[this.min.coordinates.length];
        for (int k = 0; k < this.min.coordinates.length; ++k) {
            newMin[k] = Math.min(this.min.coordinates[k], point.coordinates[k]);
            newMax[k] = Math.max(this.max.coordinates[k], point.coordinates[k]);
        }
        return IRectangularArea.of(new IPoint(newMin), new IPoint(newMax));
    }

    public IRectangularArea expand(IRectangularArea area) {
        if (this.contains(area)) {
            return this;
        }
        long[] newMin = new long[this.min.coordinates.length];
        long[] newMax = new long[this.min.coordinates.length];
        for (int k = 0; k < this.min.coordinates.length; ++k) {
            newMin[k] = Math.min(this.min.coordinates[k], area.min.coordinates[k]);
            newMax[k] = Math.max(this.max.coordinates[k], area.max.coordinates[k]);
        }
        return IRectangularArea.of(new IPoint(newMin), new IPoint(newMax));
    }

    public static IRectangularArea minimalContainingArea(Collection<IRectangularArea> areas) {
        Objects.requireNonNull(areas, "Null areas");
        if (areas.isEmpty()) {
            return null;
        }
        int coordCount = areas.iterator().next().coordCount();
        long[] min = new long[coordCount];
        long[] max = new long[coordCount];
        Arrays.fill(min, Long.MAX_VALUE);
        Arrays.fill(max, Long.MIN_VALUE);
        for (IRectangularArea area : areas) {
            if (area.coordCount() != coordCount) {
                throw new IllegalArgumentException("Some areas have different number of dimension: " + area.coordCount() + " and " + coordCount);
            }
            for (int k = 0; k < coordCount; ++k) {
                min[k] = Math.min(min[k], area.min(k));
                max[k] = Math.max(max[k], area.max(k));
            }
        }
        return IRectangularArea.of(new IPoint(min), new IPoint(max));
    }

    public long parallelDistance(IPoint point) {
        Objects.requireNonNull(point, "Null point argument");
        return this.parallelDistance(point.coordinates);
    }

    public long parallelDistance(long ... coordinates) {
        Objects.requireNonNull(coordinates, "Null coordinates argument");
        int n = this.min.coordinates.length;
        if (coordinates.length != n) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + coordinates.length + " instead of " + n);
        }
        long min = this.min.coordinates[0];
        long max = this.max.coordinates[0];
        long x = coordinates[0];
        long maxD = Math.max(min - x, x - max);
        for (int k = 1; k < n; ++k) {
            min = this.min.coordinates[k];
            long xk = coordinates[k];
            max = this.max.coordinates[k];
            long d = Math.max(min - xk, xk - max);
            if (d <= maxD) continue;
            maxD = d;
        }
        return maxD;
    }

    public long parallelDistance(long x, long y) {
        int n = this.min.coordinates.length;
        if (n != 2) {
            throw new IllegalArgumentException("Dimensions count mismatch: 2 instead of " + n);
        }
        long min = this.min.coordinates[0];
        long max = this.max.coordinates[0];
        long maxD = Math.max(min - x, x - max);
        min = this.min.coordinates[1];
        max = this.max.coordinates[1];
        long d = Math.max(min - y, y - max);
        if (d > maxD) {
            maxD = d;
        }
        return maxD;
    }

    public long parallelDistance(long x, long y, long z) {
        int n = this.min.coordinates.length;
        if (n != 3) {
            throw new IllegalArgumentException("Dimensions count mismatch: 3 instead of " + n);
        }
        long min = this.min.coordinates[0];
        long max = this.max.coordinates[0];
        long maxD = Math.max(min - x, x - max);
        min = this.min.coordinates[1];
        max = this.max.coordinates[1];
        long d = Math.max(min - y, y - max);
        if (d > maxD) {
            maxD = d;
        }
        if ((d = Math.max((min = this.min.coordinates[2]) - z, z - (max = this.max.coordinates[2]))) > maxD) {
            maxD = d;
        }
        return maxD;
    }

    public IRectangularArea shift(IPoint vector) {
        Objects.requireNonNull(vector, "Null vector argument");
        if (vector.coordinates.length != this.min.coordinates.length) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + vector.coordinates.length + " instead of " + this.min.coordinates.length);
        }
        if (vector.isOrigin()) {
            return this;
        }
        return IRectangularArea.of(this.min.addExact(vector), this.max.addExact(vector));
    }

    public IRectangularArea shiftBack(IPoint vector) {
        Objects.requireNonNull(vector, "Null vector argument");
        if (vector.coordinates.length != this.min.coordinates.length) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + vector.coordinates.length + " instead of " + this.min.coordinates.length);
        }
        if (vector.isOrigin()) {
            return this;
        }
        return IRectangularArea.of(this.min.subtractExact(vector), this.max.subtractExact(vector));
    }

    public IRectangularArea dilate(IPoint expansion) {
        Objects.requireNonNull(expansion, "Null expansion");
        if (expansion.coordCount() != this.coordCount()) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + expansion.coordCount() + " instead of " + this.coordCount());
        }
        if (expansion.isOrigin()) {
            return this;
        }
        return IRectangularArea.of(this.min().subtractExact(expansion), this.max().addExact(expansion));
    }

    public IRectangularArea dilate(long expansion) {
        return this.dilate(IPoint.ofEqualCoordinates(this.coordCount(), expansion));
    }

    public List<IRectangularArea> dilateStraightOnly(List<IRectangularArea> results, IPoint expansion) {
        Objects.requireNonNull(results, "Null results");
        Objects.requireNonNull(expansion, "Null expansion");
        results.add(this);
        int coordCount = this.coordCount();
        if (expansion.coordCount() != coordCount) {
            throw new IllegalArgumentException("Dimensions count mismatch: " + expansion.coordCount() + " instead of " + coordCount);
        }
        long[] min = this.min.coordinates();
        long[] max = this.max.coordinates();
        for (int k = 0; k < coordCount; ++k) {
            long delta = expansion.coordinates[k];
            if (delta == 0L) continue;
            if (delta < 0L) {
                throw new IllegalArgumentException("Negative expansion is impossible: " + String.valueOf(expansion));
            }
            long saveMin = min[k];
            long saveMax = max[k];
            min[k] = IPoint.subtractExact(saveMin, delta);
            max[k] = IPoint.subtractExact(saveMin, 1L);
            results.add(IRectangularArea.of(IPoint.of(min), IPoint.of(max)));
            min[k] = IPoint.addExact(saveMax, 1L);
            max[k] = IPoint.addExact(saveMax, delta);
            results.add(IRectangularArea.of(IPoint.of(min), IPoint.of(max)));
            min[k] = saveMin;
            max[k] = saveMax;
        }
        return results;
    }

    public List<IRectangularArea> dilateStraightOnly(List<IRectangularArea> results, long expansion) {
        return this.dilateStraightOnly(results, IPoint.ofEqualCoordinates(this.coordCount(), expansion));
    }

    public static List<IRectangularArea> dilate(Collection<IRectangularArea> areas, IPoint expansion, boolean straightOnly) {
        Objects.requireNonNull(areas, "Null areas");
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>();
        for (IRectangularArea area : areas) {
            if (straightOnly) {
                area.dilateStraightOnly(result, expansion);
                continue;
            }
            result.add(area.dilate(expansion));
        }
        return result;
    }

    public RectangularArea toRectangularArea() {
        return RectangularArea.of(this);
    }

    public RectangularArea toContainingArea() {
        double[] coordinates = new double[this.max.coordinates.length];
        for (int k = 0; k < coordinates.length; ++k) {
            coordinates[k] = (double)this.max.coordinates[k] + 1.0;
        }
        return new RectangularArea(Point.of(this.min), new Point(coordinates));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + String.valueOf(this.range(0)) + "]");
        for (int k = 1; k < this.min.coordinates.length; ++k) {
            sb.append("x").append("[").append(this.range(k)).append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.min.hashCode() * 37 + this.max.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof IRectangularArea && ((IRectangularArea)obj).min.equals(this.min) && ((IRectangularArea)obj).max.equals(this.max);
    }

    static IRectangularArea of(IPoint min, IPoint max, boolean ise) {
        Objects.requireNonNull(min, "Null min vertex");
        Objects.requireNonNull(max, "Null max vertex");
        int n = min.coordinates.length;
        if (n != max.coordinates.length) {
            throw new IllegalArgumentException("Cannot create IRectangularArea: min.coordCount() = " + n + " does not match max.coordCount() = " + max.coordinates.length);
        }
        for (int k = 0; k < n; ++k) {
            if (min.coordinates[k] > max.coordinates[k]) {
                throw IRange.invalidBoundsException("Cannot create IRectangularArea: min.coord(" + k + ") > max.coord(" + k + ") (min = " + String.valueOf(min) + ", max = " + String.valueOf(max) + ")", ise);
            }
            if (max.coordinates[k] == Long.MAX_VALUE) {
                throw IRange.invalidBoundsException("Cannot create IRectangularArea: max.coord(" + k + ") must not be Long.MAX_VALUE", ise);
            }
            if (min.coordinates[k] <= -9223372036854775807L) {
                throw IRange.invalidBoundsException("Cannot create IRectangularArea: min.coord(" + k + ") must not be Long.MIN_VALUE or Long.MIN_VALUE+1", ise);
            }
            if (max.coordinates[k] - min.coordinates[k] + 1L > 0L) continue;
            throw IRange.invalidBoundsException("Cannot create IRectangularArea: max.coord(" + k + ") - min.coord(" + k + ") >= Long.MAX_VALUE (min = " + String.valueOf(min) + ", max = " + String.valueOf(max) + ")", ise);
        }
        return new IRectangularArea(min, max);
    }
}

