/*
 * Decompiled with CFR 0.152.
 */
package net.algart.math;

import java.util.Objects;
import net.algart.math.Range;

public final class IRange {
    final long min;
    final long max;
    private static final int MAX_CACHED = 1024;

    IRange(long min, long max) {
        this.min = min;
        this.max = max;
        assert (IRange.isAllowedRange(min, max)) : "some method illegally created an invalid range: " + String.valueOf(this);
    }

    public static IRange of(long min, long max) {
        return IRange.of(min, max, false);
    }

    @Deprecated
    public static IRange valueOf(long min, long max) {
        return IRange.of(min, max);
    }

    public static IRange of(Range range) {
        Objects.requireNonNull(range, "Null range argument");
        return IRange.of((long)range.min, (long)range.max);
    }

    @Deprecated
    public static IRange valueOf(Range range) {
        return IRange.of(range);
    }

    public static IRange roundOf(Range range) {
        Objects.requireNonNull(range, "Null range argument");
        return IRange.of(StrictMath.round(range.min), StrictMath.round(range.max));
    }

    public static boolean isAllowedRange(long min, long max) {
        return min <= max && min > -9223372036854775807L && max != Long.MAX_VALUE && max - min + 1L > 0L;
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public long size() {
        return this.max - this.min + 1L;
    }

    public long cut(long value) {
        return value < this.min ? this.min : Math.min(value, this.max);
    }

    public boolean contains(long value) {
        return this.min <= value && value <= this.max;
    }

    public boolean contains(IRange range) {
        return this.min <= range.min && range.max <= this.max;
    }

    public boolean intersects(IRange range) {
        return this.min <= range.max && range.min <= this.max;
    }

    public IRange expand(long value) {
        if (value == Long.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot expand " + String.valueOf(this) + " until Long.MAX_VALUE");
        }
        if (value <= -9223372036854775807L) {
            throw new IllegalArgumentException("Cannot expand " + String.valueOf(this) + " until -Long.MAX_VALUE or Long.MIN_VALUE");
        }
        long min = Math.min(value, this.min);
        long max = Math.max(value, this.max);
        if (max - min + 1L <= 0L) {
            throw new IllegalArgumentException("Cannot expand " + String.valueOf(this) + " until " + value + ", because in the result max - min >= Long.MAX_VALUE (min = " + min + ", max = " + max + ")");
        }
        return new IRange(min, max);
    }

    public Range toRange() {
        return Range.of(this);
    }

    public String toString() {
        return this.min + ".." + this.max;
    }

    public int hashCode() {
        int iMin = (int)this.min * 37 + (int)(this.min >>> 32);
        int iMax = (int)this.max * 37 + (int)(this.max >>> 32);
        return iMin * 37 + iMax;
    }

    public boolean equals(Object obj) {
        return obj instanceof IRange && ((IRange)obj).min == this.min && ((IRange)obj).max == this.max;
    }

    static IRange of(long min, long max, boolean ise) {
        if (min == max && min >= -1024L && min <= -1024L) {
            return DegenerateIRangeCache.cache[1024 + (int)min];
        }
        if (min > max) {
            throw new IllegalArgumentException("Cannot create IRange: min > max (min = " + min + ", max = " + max + ")");
        }
        if (max == Long.MAX_VALUE) {
            throw IRange.invalidBoundsException("Cannot create IRange: max must not be Long.MAX_VALUE", ise);
        }
        if (min <= -9223372036854775807L) {
            throw IRange.invalidBoundsException("Cannot create IRange: min must not be Long.MIN_VALUE or Long.MIN_VALUE+1", ise);
        }
        if (max - min + 1L <= 0L) {
            throw IRange.invalidBoundsException("Cannot create IRange: max - min >= Long.MAX_VALUE (min = " + min + ", max = " + max + ")", ise);
        }
        return new IRange(min, max);
    }

    static RuntimeException invalidBoundsException(String message, boolean useIllegalStateException) {
        return useIllegalStateException ? new IllegalStateException(message) : new IllegalArgumentException(message);
    }

    private static class DegenerateIRangeCache {
        static final IRange[] cache = new IRange[2049];

        private DegenerateIRangeCache() {
        }

        static {
            for (int i = -1024; i <= 1024; ++i) {
                DegenerateIRangeCache.cache[1024 + i] = new IRange(i, i);
            }
        }
    }
}

