/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractMemoryModel;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.SimpleArraysImpl;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.arrays.UpdatableShortArray;

public final class SimpleMemoryModel
extends AbstractMemoryModel {
    static final SimpleMemoryModel INSTANCE = new SimpleMemoryModel();

    private SimpleMemoryModel() {
    }

    public static SimpleMemoryModel getInstance() {
        return INSTANCE;
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType) {
        return this.newEmptyArray(elementType, 10L);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType, long initialCapacity) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initial capacity");
        }
        if (elementType == Boolean.TYPE) {
            return new SimpleArraysImpl.MutableJABitArray(initialCapacity, 0L);
        }
        if (elementType == Character.TYPE) {
            return new SimpleArraysImpl.MutableJACharArray(initialCapacity, 0L);
        }
        if (elementType == Byte.TYPE) {
            return new SimpleArraysImpl.MutableJAByteArray(initialCapacity, 0L);
        }
        if (elementType == Short.TYPE) {
            return new SimpleArraysImpl.MutableJAShortArray(initialCapacity, 0L);
        }
        if (elementType == Integer.TYPE) {
            return new SimpleArraysImpl.MutableJAIntArray(initialCapacity, 0L);
        }
        if (elementType == Long.TYPE) {
            return new SimpleArraysImpl.MutableJALongArray(initialCapacity, 0L);
        }
        if (elementType == Float.TYPE) {
            return new SimpleArraysImpl.MutableJAFloatArray(initialCapacity, 0L);
        }
        if (elementType == Double.TYPE) {
            return new SimpleArraysImpl.MutableJADoubleArray(initialCapacity, 0L);
        }
        return new SimpleArraysImpl.MutableJAObjectArray(elementType, initialCapacity, 0L);
    }

    @Override
    public MutableArray newArray(Class<?> elementType, long initialLength) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initial length");
        }
        if (elementType == Boolean.TYPE) {
            return new SimpleArraysImpl.MutableJABitArray(initialLength, initialLength);
        }
        if (elementType == Character.TYPE) {
            return new SimpleArraysImpl.MutableJACharArray(initialLength, initialLength);
        }
        if (elementType == Byte.TYPE) {
            return new SimpleArraysImpl.MutableJAByteArray(initialLength, initialLength);
        }
        if (elementType == Short.TYPE) {
            return new SimpleArraysImpl.MutableJAShortArray(initialLength, initialLength);
        }
        if (elementType == Integer.TYPE) {
            return new SimpleArraysImpl.MutableJAIntArray(initialLength, initialLength);
        }
        if (elementType == Long.TYPE) {
            return new SimpleArraysImpl.MutableJALongArray(initialLength, initialLength);
        }
        if (elementType == Float.TYPE) {
            return new SimpleArraysImpl.MutableJAFloatArray(initialLength, initialLength);
        }
        if (elementType == Double.TYPE) {
            return new SimpleArraysImpl.MutableJADoubleArray(initialLength, initialLength);
        }
        return new SimpleArraysImpl.MutableJAObjectArray(elementType, initialLength, initialLength);
    }

    @Override
    public UpdatableArray newUnresizableArray(Class<?> elementType, long length) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (length < 0L) {
            throw new IllegalArgumentException("Negative array length");
        }
        if (elementType == Boolean.TYPE) {
            return new SimpleArraysImpl.UpdatableJABitArray(length, length);
        }
        if (elementType == Character.TYPE) {
            return new SimpleArraysImpl.UpdatableJACharArray(length, length);
        }
        if (elementType == Byte.TYPE) {
            return new SimpleArraysImpl.UpdatableJAByteArray(length, length);
        }
        if (elementType == Short.TYPE) {
            return new SimpleArraysImpl.UpdatableJAShortArray(length, length);
        }
        if (elementType == Integer.TYPE) {
            return new SimpleArraysImpl.UpdatableJAIntArray(length, length);
        }
        if (elementType == Long.TYPE) {
            return new SimpleArraysImpl.UpdatableJALongArray(length, length);
        }
        if (elementType == Float.TYPE) {
            return new SimpleArraysImpl.UpdatableJAFloatArray(length, length);
        }
        if (elementType == Double.TYPE) {
            return new SimpleArraysImpl.UpdatableJADoubleArray(length, length);
        }
        return new SimpleArraysImpl.UpdatableJAObjectArray(elementType, length, length);
    }

    @Override
    public UpdatableArray of(Object array, int offset, int count) {
        SimpleArraysImpl.AbstractJAArray result;
        Objects.requireNonNull(array, "Null array argument");
        if (array instanceof boolean[]) {
            result = new SimpleArraysImpl.UpdatableJABitArray(count, (long)count);
            PackedBitArrays.packBits(((SimpleArraysImpl.JABitArray)result).bitArray, 0L, (boolean[])array, offset, count);
        } else if (array instanceof char[]) {
            result = new SimpleArraysImpl.UpdatableJACharArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JACharArray)result).charArray, 0, count);
        } else if (array instanceof byte[]) {
            result = new SimpleArraysImpl.UpdatableJAByteArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JAByteArray)result).byteArray, 0, count);
        } else if (array instanceof short[]) {
            result = new SimpleArraysImpl.UpdatableJAShortArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JAShortArray)result).shortArray, 0, count);
        } else if (array instanceof int[]) {
            result = new SimpleArraysImpl.UpdatableJAIntArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JAIntArray)result).intArray, 0, count);
        } else if (array instanceof long[]) {
            result = new SimpleArraysImpl.UpdatableJALongArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JALongArray)result).longArray, 0, count);
        } else if (array instanceof float[]) {
            result = new SimpleArraysImpl.UpdatableJAFloatArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JAFloatArray)result).floatArray, 0, count);
        } else if (array instanceof double[]) {
            result = new SimpleArraysImpl.UpdatableJADoubleArray(count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JADoubleArray)result).doubleArray, 0, count);
        } else if (array instanceof Object[]) {
            result = new SimpleArraysImpl.UpdatableJAObjectArray(array.getClass().getComponentType(), (long)count, (long)count);
            System.arraycopy(array, offset, ((SimpleArraysImpl.JAObjectArray)result).objectArray, 0, count);
        } else {
            throw new IllegalArgumentException("The argument is not a Java array: " + String.valueOf(array.getClass()));
        }
        return result;
    }

    @Override
    public UpdatableArray of(Object array) {
        Objects.requireNonNull(array, "Null array argument");
        return this.of(array, 0, java.lang.reflect.Array.getLength(array));
    }

    @Override
    public UpdatableBitArray of(boolean[] array, int offset, int count) {
        return (UpdatableBitArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableBitArray of(boolean[] array) {
        return (UpdatableBitArray)this.of((Object)array);
    }

    @Override
    public UpdatableCharArray of(char[] array, int offset, int count) {
        return (UpdatableCharArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableCharArray of(char[] array) {
        return (UpdatableCharArray)this.of((Object)array);
    }

    @Override
    public UpdatableByteArray of(byte[] array, int offset, int count) {
        return (UpdatableByteArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableByteArray of(byte[] array) {
        return (UpdatableByteArray)this.of((Object)array);
    }

    @Override
    public UpdatableShortArray of(short[] array, int offset, int count) {
        return (UpdatableShortArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableShortArray of(short[] array) {
        return (UpdatableShortArray)this.of((Object)array);
    }

    @Override
    public UpdatableIntArray of(int[] array, int offset, int count) {
        return (UpdatableIntArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableIntArray of(int[] array) {
        return (UpdatableIntArray)this.of((Object)array);
    }

    @Override
    public UpdatableLongArray of(long[] array, int offset, int count) {
        return (UpdatableLongArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableLongArray of(long[] array) {
        return (UpdatableLongArray)this.of((Object)array);
    }

    @Override
    public UpdatableFloatArray of(float[] array, int offset, int count) {
        return (UpdatableFloatArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableFloatArray of(float[] array) {
        return (UpdatableFloatArray)this.of((Object)array);
    }

    @Override
    public UpdatableDoubleArray of(double[] array, int offset, int count) {
        return (UpdatableDoubleArray)this.of((Object)array, offset, count);
    }

    @Override
    public UpdatableDoubleArray of(double[] array) {
        return (UpdatableDoubleArray)this.of((Object)array);
    }

    @Override
    public boolean isElementTypeSupported(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return true;
    }

    @Override
    public boolean areAllPrimitiveElementTypesSupported() {
        return true;
    }

    @Override
    public boolean areAllElementTypesSupported() {
        return true;
    }

    @Override
    public long maxSupportedLength(Class<?> elementType) {
        return SimpleMemoryModel.maxSupportedLengthImpl(elementType);
    }

    @Override
    public boolean isCreatedBy(Array array) {
        return SimpleMemoryModel.isSimpleArray(array);
    }

    public static boolean isSimpleArray(Array array) {
        return array instanceof SimpleArraysImpl.AbstractJAArray;
    }

    public String toString() {
        return "Simple memory model";
    }

    public static UpdatableArray asUpdatableArray(Object array) {
        Objects.requireNonNull(array, "Null array argument");
        if (array instanceof boolean[]) {
            throw new IllegalArgumentException("boolean[] Java array cannot be viewed as UpdatableArray");
        }
        if (array instanceof byte[]) {
            return new SimpleArraysImpl.UpdatableJAByteArray((byte[])array, ((byte[])array).length, ((byte[])array).length);
        }
        if (array instanceof char[]) {
            return new SimpleArraysImpl.UpdatableJACharArray((char[])array, ((char[])array).length, ((char[])array).length);
        }
        if (array instanceof short[]) {
            return new SimpleArraysImpl.UpdatableJAShortArray((short[])array, ((short[])array).length, ((short[])array).length);
        }
        if (array instanceof int[]) {
            return new SimpleArraysImpl.UpdatableJAIntArray((int[])array, ((int[])array).length, ((int[])array).length);
        }
        if (array instanceof long[]) {
            return new SimpleArraysImpl.UpdatableJALongArray((long[])array, ((long[])array).length, ((long[])array).length);
        }
        if (array instanceof float[]) {
            return new SimpleArraysImpl.UpdatableJAFloatArray((float[])array, ((float[])array).length, ((float[])array).length);
        }
        if (array instanceof double[]) {
            return new SimpleArraysImpl.UpdatableJADoubleArray((double[])array, ((double[])array).length, ((double[])array).length);
        }
        if (array instanceof Object[]) {
            return new SimpleArraysImpl.UpdatableJAObjectArray((Object[])array, ((Object[])array).length, ((Object[])array).length);
        }
        throw new IllegalArgumentException("The argument is not a Java array: " + String.valueOf(array.getClass()));
    }

    public static UpdatablePArray asUpdatablePArray(Object array) {
        if (array instanceof Object[]) {
            throw new IllegalArgumentException("Object[] Java array cannot be viewed as UpdatablePArray");
        }
        return (UpdatablePArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatablePNumberArray asUpdatablePNumberArray(Object array) {
        if (array instanceof Object[]) {
            throw new IllegalArgumentException("Object[] Java array cannot be viewed as UpdatablePArray");
        }
        if (array instanceof boolean[]) {
            throw new IllegalArgumentException("boolean[] Java array cannot be viewed as UpdatablePArray");
        }
        if (array instanceof char[]) {
            throw new IllegalArgumentException("char[] Java array cannot be viewed as UpdatablePArray");
        }
        return (UpdatablePNumberArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableBitArray asUpdatableBitArray(long[] packedBitArray, long length) {
        Objects.requireNonNull(packedBitArray, "Null packedBitArray");
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length");
        }
        long packedLength = PackedBitArrays.packedLength(length);
        if (packedLength > (long)packedBitArray.length) {
            throw new IllegalArgumentException("Too short packedBitArray long[" + packedBitArray.length + "]: it must contain at least " + packedLength + " long elements to store " + length + " bits");
        }
        return new SimpleArraysImpl.UpdatableJABitArray(packedBitArray, length);
    }

    public static UpdatableCharArray asUpdatableCharArray(char[] array) {
        return (UpdatableCharArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableByteArray asUpdatableByteArray(byte[] array) {
        return (UpdatableByteArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableShortArray asUpdatableShortArray(short[] array) {
        return (UpdatableShortArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableIntArray asUpdatableIntArray(int[] array) {
        return (UpdatableIntArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableLongArray asUpdatableLongArray(long[] array) {
        return (UpdatableLongArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableFloatArray asUpdatableFloatArray(float[] array) {
        return (UpdatableFloatArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static UpdatableDoubleArray asUpdatableDoubleArray(double[] array) {
        return (UpdatableDoubleArray)SimpleMemoryModel.asUpdatableArray(array);
    }

    public static <E> UpdatableObjectArray<E> asUpdatableObjectArray(E[] array) {
        return (UpdatableObjectArray)InternalUtils.cast(SimpleMemoryModel.asUpdatableArray(array));
    }

    public static Matrix<UpdatablePArray> asMatrix(Object array, long ... dim) {
        if (array instanceof Object[]) {
            throw new IllegalArgumentException("Object[] Java array cannot be viewed as Matrix<UpdatablePArray>");
        }
        if (array instanceof boolean[]) {
            throw new IllegalArgumentException("boolean[] Java array cannot be viewed as Matrix<UpdatablePArray>");
        }
        if (array instanceof Array) {
            if (!(array instanceof UpdatablePArray)) {
                throw new IllegalArgumentException("AlgART array, which is not UpdatablePArray, cannot be viewed as Matrix<UpdatablePArray>: " + String.valueOf(array));
            }
            UpdatablePArray a = (UpdatablePArray)array;
            return Matrices.matrix(a, dim);
        }
        return Matrices.matrix((UpdatablePArray)SimpleMemoryModel.asUpdatableArray(array), dim);
    }

    static long maxSupportedLengthImpl(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE) {
            return 137438953408L;
        }
        return Integer.MAX_VALUE;
    }
}

