/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.PFloatingArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableDoubleArray;

public interface DoubleArray
extends PFloatingArray {
    public Class<? extends DoubleArray> type();

    public Class<? extends UpdatableDoubleArray> updatableType();

    public Class<? extends MutableDoubleArray> mutableType();

    @Override
    public double getDouble(long var1);

    default public double[] newJavaArray(int length) {
        return new double[length];
    }

    @Override
    public long indexOf(long var1, long var3, double var5);

    @Override
    public long lastIndexOf(long var1, long var3, double var5);

    @Override
    public DataDoubleBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataDoubleBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataDoubleBuffer buffer(long var1);

    @Override
    public DataDoubleBuffer buffer();

    @Override
    public DoubleArray asImmutable();

    @Override
    public DoubleArray asTrustedImmutable();

    @Override
    public MutableDoubleArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableDoubleArray updatableClone(MemoryModel var1);

    default public double[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to double[] Java array, because it is too large: " + String.valueOf(this));
        }
        double[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public double[] ja();

    default public Matrix<? extends DoubleArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public double[] toDouble() {
        return this.toJavaArray();
    }

    @Override
    default public double[] jaDouble() {
        return this.ja();
    }

    public static UpdatableDoubleArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableDoubleArray(length);
    }

    public static UpdatableDoubleArray newArray(long length) {
        return Arrays.SMM.newUnresizableDoubleArray(length);
    }

    public static UpdatableDoubleArray as(double[] array) {
        return SimpleMemoryModel.asUpdatableDoubleArray(array);
    }
}

