/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.PIntegerArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableByteArray;

public interface ByteArray
extends PIntegerArray {
    public Class<? extends ByteArray> type();

    public Class<? extends UpdatableByteArray> updatableType();

    public Class<? extends MutableByteArray> mutableType();

    public int getByte(long var1);

    default public byte[] newJavaArray(int length) {
        return new byte[length];
    }

    public long indexOf(long var1, long var3, byte var5);

    public long lastIndexOf(long var1, long var3, byte var5);

    @Override
    public DataByteBuffer buffer(DataBuffer.AccessMode var1, long var2);

    @Override
    public DataByteBuffer buffer(DataBuffer.AccessMode var1);

    @Override
    public DataByteBuffer buffer(long var1);

    @Override
    public DataByteBuffer buffer();

    @Override
    public ByteArray asImmutable();

    @Override
    public ByteArray asTrustedImmutable();

    @Override
    public MutableByteArray mutableClone(MemoryModel var1);

    @Override
    public UpdatableByteArray updatableClone(MemoryModel var1);

    default public byte[] toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to byte[] Java array, because it is too large: " + String.valueOf(this));
        }
        byte[] result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public byte[] ja();

    default public Matrix<? extends ByteArray> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    @Override
    default public byte[] toByte() {
        return this.toJavaArray();
    }

    @Override
    default public byte[] jaByte() {
        return this.ja();
    }

    public static UpdatableByteArray newArray(MemoryModel memoryModel, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableByteArray(length);
    }

    public static UpdatableByteArray newArray(long length) {
        return Arrays.SMM.newUnresizableByteArray(length);
    }

    @Override
    public int getInt(long var1);

    public static UpdatableByteArray as(byte[] array) {
        return SimpleMemoryModel.asUpdatableByteArray(array);
    }
}

