/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractObjectArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArrayPool;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysBufferedCopier;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableObjectInPlaceArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysOpImpl {
    ArraysOpImpl() {
    }

    static ArrayComparator defaultComparator(UpdatableArray array, boolean reverse) {
        Objects.requireNonNull(array, "Null array argument");
        if (array instanceof UpdatableBitArray) {
            UpdatableBitArray a = (UpdatableBitArray)array;
            if (!reverse) {
                return (first, second) -> !a.getBit(first) && a.getBit(second);
            }
            return (first, second) -> !a.getBit(second) && a.getBit(first);
        }
        if (array instanceof UpdatableCharArray) {
            UpdatableCharArray a = (UpdatableCharArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                char[] ja = (char[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ja[offset + (int)first] < ja[offset + (int)second];
                }
                return (first, second) -> ja[offset + (int)second] < ja[offset + (int)first];
            }
            if (!reverse) {
                return (first, second) -> a.getChar(first) < a.getChar(second);
            }
            return (first, second) -> a.getChar(second) < a.getChar(first);
        }
        if (array instanceof UpdatableByteArray) {
            UpdatableByteArray a = (UpdatableByteArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                byte[] ja = (byte[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ja[offset + (int)first] < ja[offset + (int)second];
                }
                return (first, second) -> ja[offset + (int)second] < ja[offset + (int)first];
            }
            if (!reverse) {
                return (first, second) -> a.getByte(first) < a.getByte(second);
            }
            return (first, second) -> a.getByte(second) < a.getByte(first);
        }
        if (array instanceof UpdatableShortArray) {
            UpdatableShortArray a = (UpdatableShortArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                short[] ja = (short[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ja[offset + (int)first] < ja[offset + (int)second];
                }
                return (first, second) -> ja[offset + (int)second] < ja[offset + (int)first];
            }
            if (!reverse) {
                return (first, second) -> a.getShort(first) < a.getShort(second);
            }
            return (first, second) -> a.getShort(second) < a.getShort(first);
        }
        if (array instanceof UpdatableIntArray) {
            UpdatableIntArray a = (UpdatableIntArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                int[] ja = (int[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ja[offset + (int)first] < ja[offset + (int)second];
                }
                return (first, second) -> ja[offset + (int)second] < ja[offset + (int)first];
            }
            if (!reverse) {
                return (first, second) -> a.getInt(first) < a.getInt(second);
            }
            return (first, second) -> a.getInt(second) < a.getInt(first);
        }
        if (array instanceof UpdatableLongArray) {
            UpdatableLongArray a = (UpdatableLongArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                long[] ja = (long[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ja[offset + (int)first] < ja[offset + (int)second];
                }
                return (first, second) -> ja[offset + (int)second] < ja[offset + (int)first];
            }
            if (!reverse) {
                return (first, second) -> a.getLong(first) < a.getLong(second);
            }
            return (first, second) -> a.getLong(second) < a.getLong(first);
        }
        if (array instanceof UpdatableFloatArray) {
            UpdatableFloatArray a = (UpdatableFloatArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                float[] ja = (float[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> Float.compare(ja[offset + (int)first], ja[offset + (int)second]) < 0;
                }
                return (first, second) -> Float.compare(ja[offset + (int)second], ja[offset + (int)first]) < 0;
            }
            if (!reverse) {
                return (first, second) -> Float.compare(a.getFloat(first), a.getFloat(second)) < 0;
            }
            return (first, second) -> Float.compare(a.getFloat(second), a.getFloat(first)) < 0;
        }
        if (array instanceof UpdatableDoubleArray) {
            UpdatableDoubleArray a = (UpdatableDoubleArray)array;
            if (a instanceof DirectAccessible && ((DirectAccessible)((Object)a)).hasJavaArray()) {
                double[] ja = (double[])((DirectAccessible)((Object)a)).javaArray();
                int offset = ((DirectAccessible)((Object)a)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> Double.compare(ja[offset + (int)first], ja[offset + (int)second]) < 0;
                }
                return (first, second) -> Double.compare(ja[offset + (int)second], ja[offset + (int)first]) < 0;
            }
            if (!reverse) {
                return (first, second) -> Double.compare(a.getDouble(first), a.getDouble(second)) < 0;
            }
            return (first, second) -> Double.compare(a.getDouble(second), a.getDouble(first)) < 0;
        }
        if (array instanceof UpdatableObjectInPlaceArray && !(array instanceof DirectAccessible)) {
            UpdatableObjectInPlaceArray a = (UpdatableObjectInPlaceArray)InternalUtils.cast(array);
            Object work1 = a.allocateElement();
            Object work2 = a.allocateElement();
            if (!reverse) {
                return (first, second) -> ((Comparable)a.getInPlace(first, work1)).compareTo(a.getInPlace(second, work2)) < 0;
            }
            return (first, second) -> ((Comparable)a.getInPlace(second, work1)).compareTo(a.getInPlace(first, work2)) < 0;
        }
        if (array instanceof UpdatableObjectArray) {
            if (array instanceof DirectAccessible && ((DirectAccessible)((Object)array)).hasJavaArray()) {
                Object[] ja = (Object[])((DirectAccessible)((Object)array)).javaArray();
                int offset = ((DirectAccessible)((Object)array)).javaArrayOffset();
                if (!reverse) {
                    return (first, second) -> ((Comparable)InternalUtils.cast(ja[offset + (int)first])).compareTo(ja[offset + (int)second]) < 0;
                }
                return (first, second) -> ((Comparable)InternalUtils.cast(ja[offset + (int)second])).compareTo(ja[offset + (int)first]) < 0;
            }
            UpdatableObjectArray a = (UpdatableObjectArray)InternalUtils.cast(array);
            if (!reverse) {
                return (first, second) -> ((Comparable)a.get(first)).compareTo(a.get(second)) < 0;
            }
            return (first, second) -> ((Comparable)a.get(second)).compareTo(a.get(first)) < 0;
        }
        throw new AssertionError((Object)("Unallowed type of passed argument: " + String.valueOf(array.getClass())));
    }

    static Arrays.CopyStatus copy(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean strictMode, boolean compare) {
        long t2;
        Arrays.CopyStatus result;
        long t1 = Arrays.CONFIG_LOGGABLE ? System.nanoTime() : 0L;
        Array srcCopy = null;
        ArraysBufferedCopier copier = ArraysBufferedCopier.getInstance(context, dest, src, numberOfTasks, strictMode, compare);
        boolean changed = copier.process();
        Arrays.CopyStatus copyStatus = result = compare ? new Arrays.ComparingCopyStatus(copier.usedAlgorithm, strictMode, changed) : new Arrays.CopyStatus(copier.usedAlgorithm, strictMode);
        if (srcCopy != null && strictMode && !srcCopy.equals(dest.subArr(0L, srcCopy.length()))) {
            throw new AssertionError((Object)("Error while copying " + String.valueOf(src) + " to " + String.valueOf(dest)));
        }
        if (Arrays.CONFIG_LOGGABLE && Arrays.SystemSettings.profilingMode() && (t2 = System.nanoTime()) - t1 > 3000000000L) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuilder stackInfo = new StringBuilder();
            for (int k = 1; k < stack.length; ++k) {
                String methodName = stack[k].getMethodName();
                String className = stack[k].getClassName();
                if (stackInfo.isEmpty()) {
                    if ("copy".equals(methodName) && (Arrays.class.getName().equals(className) || Matrices.class.getName().equals(className))) {
                        continue;
                    }
                } else {
                    stackInfo.append("/");
                }
                stackInfo.append(stack[k].getMethodName());
            }
            Arrays.LOGGER.config(String.format(Locale.US, "Array is copied in %.3f ms (%.2f ns/element, %d underlying) [%s -> %s] in %s", 1.0E-6 * (double)(t2 - t1), (double)(t2 - t1) / Math.max(1.0, (double)src.length()), Arrays.getUnderlyingArraysCount(src), src, dest, stackInfo));
        }
        return result;
    }

    static Array asConcatenation(Array ... arrays) {
        Objects.requireNonNull(arrays, "Null arrays argument");
        if (arrays.length == 0) {
            throw new IllegalArgumentException("Empty arrays[] (array of AlgART arrays)");
        }
        Class<?> elementType = arrays[0].elementType();
        for (int k = 0; k < arrays.length; ++k) {
            if (!arrays[k].isUnresizable()) {
                throw new IllegalArgumentException("asConcatenation method cannot be applied to resizable arrays: please use UpdatableArray.asUnresizable() method before constructing a concatenation");
            }
            if (k <= 0 || arrays[k].elementType() == elementType) continue;
            throw new IllegalArgumentException("asConcatenation method cannot be applied to arrays with different element type: arrays[" + k + "] is " + String.valueOf(arrays[k]) + ", but arrays[0] is " + String.valueOf(arrays[0]));
        }
        if (elementType == Boolean.TYPE) {
            BitArray[] a = new BitArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (BitArray)arrays[k];
            }
            return new ConcatenatedBitArray(a);
        }
        if (elementType == Character.TYPE) {
            CharArray[] a = new CharArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (CharArray)arrays[k];
            }
            return new ConcatenatedCharArray(a);
        }
        if (elementType == Byte.TYPE) {
            ByteArray[] a = new ByteArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (ByteArray)arrays[k];
            }
            return new ConcatenatedByteArray(a);
        }
        if (elementType == Short.TYPE) {
            ShortArray[] a = new ShortArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (ShortArray)arrays[k];
            }
            return new ConcatenatedShortArray(a);
        }
        if (elementType == Integer.TYPE) {
            IntArray[] a = new IntArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (IntArray)arrays[k];
            }
            return new ConcatenatedIntArray(a);
        }
        if (elementType == Long.TYPE) {
            LongArray[] a = new LongArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (LongArray)arrays[k];
            }
            return new ConcatenatedLongArray(a);
        }
        if (elementType == Float.TYPE) {
            FloatArray[] a = new FloatArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (FloatArray)arrays[k];
            }
            return new ConcatenatedFloatArray(a);
        }
        if (elementType == Double.TYPE) {
            DoubleArray[] a = new DoubleArray[arrays.length];
            for (int k = 0; k < arrays.length; ++k) {
                a[k] = (DoubleArray)arrays[k];
            }
            return new ConcatenatedDoubleArray(a);
        }
        ObjectArray[] a = (ObjectArray[])InternalUtils.cast(new ObjectArray[arrays.length]);
        for (int k = 0; k < arrays.length; ++k) {
            a[k] = ((ObjectArray)arrays[k]).cast(Object.class);
        }
        return new ConcatenatedObjectArray(a);
    }

    static Array asShifted(Array array, long shift) {
        Objects.requireNonNull(array, "Null array argument");
        if (!array.isUnresizable()) {
            throw new IllegalArgumentException("asShifted method cannot be applied to resizable array: please use UpdatableArray.asUnresizable() method before constructing a shifted array");
        }
        long len = array.length();
        if (len > 0L && (shift %= len) < 0L) {
            shift += len;
        }
        if (len > 0L) assert (0L <= shift && shift < len);
        if (array instanceof BitArray) {
            return new ShiftedBitArray((BitArray)array, shift);
        }
        if (array instanceof CharArray) {
            return new ShiftedCharArray((CharArray)array, shift);
        }
        if (array instanceof ByteArray) {
            return new ShiftedByteArray((ByteArray)array, shift);
        }
        if (array instanceof ShortArray) {
            return new ShiftedShortArray((ShortArray)array, shift);
        }
        if (array instanceof IntArray) {
            return new ShiftedIntArray((IntArray)array, shift);
        }
        if (array instanceof LongArray) {
            return new ShiftedLongArray((LongArray)array, shift);
        }
        if (array instanceof FloatArray) {
            return new ShiftedFloatArray((FloatArray)array, shift);
        }
        if (array instanceof DoubleArray) {
            return new ShiftedDoubleArray((DoubleArray)array, shift);
        }
        if (array instanceof ObjectArray) {
            ObjectArray a = (ObjectArray)array;
            return new ShiftedObjectArray<Object>(a.cast(Object.class), shift);
        }
        throw new AssertionError((Object)("The array does not implement necessary interfaces: " + String.valueOf(array.getClass())));
    }

    private static long sumOfLengths(Array[] arrays) throws TooLargeArrayException {
        long sum = 0L;
        for (Array array : arrays) {
            long len = array.length();
            assert (len >= 0L) : "illegal length() implementation in " + String.valueOf(array);
            if ((sum += len) >= 0L) continue;
            throw new TooLargeArrayException("The length of concatenation of arrays is greater than 2^63-1");
        }
        return sum;
    }

    private static long[] getStartPositions(Array[] arrays) {
        long[] result = new long[arrays.length];
        for (int k = 1; k < arrays.length; ++k) {
            result[k] = result[k - 1] + arrays[k - 1].length();
            assert (result[k] >= result[k - 1]);
        }
        return result;
    }

    private static int searchInConcatenatedArray(long[] startPositions, long index) {
        int result = java.util.Arrays.binarySearch(startPositions, index);
        if (result >= 0) {
            while (result < startPositions.length - 1 && startPositions[result + 1] == index) {
                ++result;
            }
        } else {
            result = -result - 2;
        }
        return result;
    }

    private static class ConcatenatedBitArray
    extends AbstractBitArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final BitArray[] arrays;

        ConcatenatedBitArray(BitArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getBit(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            long len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - count) {
                throw this.rangeException(arrayPos + count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = Math.min(count, nextStartPos - startPos - p);
                this.arrays[k].getBits(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0L);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            BitArray[] a = new BitArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (BitArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (BitArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedBitArray(a);
        }

        @Override
        public long nextQuickPosition(long position) {
            if (position >= this.length) {
                return -1L;
            }
            if (position < 0L) {
                position = 0L;
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, position);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + position + " (" + String.valueOf(this) + ")";
            long p = position - this.startPositions[k];
            assert (p >= 0L);
            long qp = this.arrays[k].nextQuickPosition(p);
            while (qp == -1L) {
                if (k == this.startPositions.length - 1) {
                    return -1L;
                }
                p = 0L;
                position = this.startPositions[++k];
                qp = this.arrays[k].nextQuickPosition(0L);
            }
            assert (qp >= p) : "illegal nextQuickPosition implementation in " + String.valueOf(this.arrays[k]);
            long result = position + (qp - p);
            return result >= this.length ? -1L : result;
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array bit[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " bits)";
        }
    }

    private static class ConcatenatedCharArray
    extends AbstractCharArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final CharArray[] arrays;

        ConcatenatedCharArray(CharArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getChar(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            CharArray[] a = new CharArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (CharArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (CharArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedCharArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array char[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " chars)";
        }
    }

    private static class ConcatenatedByteArray
    extends AbstractByteArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final ByteArray[] arrays;

        ConcatenatedByteArray(ByteArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getByte(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            ByteArray[] a = new ByteArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (ByteArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (ByteArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedByteArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array byte[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " bytes)";
        }
    }

    private static class ConcatenatedShortArray
    extends AbstractShortArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final ShortArray[] arrays;

        ConcatenatedShortArray(ShortArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getShort(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            ShortArray[] a = new ShortArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (ShortArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (ShortArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedShortArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array short[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " shorts)";
        }
    }

    private static class ConcatenatedIntArray
    extends AbstractIntArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final IntArray[] arrays;

        ConcatenatedIntArray(IntArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getInt(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            IntArray[] a = new IntArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (IntArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (IntArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedIntArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array int[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " ints)";
        }
    }

    private static class ConcatenatedLongArray
    extends AbstractLongArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final LongArray[] arrays;

        ConcatenatedLongArray(LongArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getLong(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            LongArray[] a = new LongArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (LongArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (LongArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedLongArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array long[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " longs)";
        }
    }

    private static class ConcatenatedFloatArray
    extends AbstractFloatArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final FloatArray[] arrays;

        ConcatenatedFloatArray(FloatArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getFloat(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            FloatArray[] a = new FloatArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (FloatArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (FloatArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedFloatArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array float[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " floats)";
        }
    }

    private static class ConcatenatedDoubleArray
    extends AbstractDoubleArray
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final DoubleArray[] arrays;

        ConcatenatedDoubleArray(DoubleArray[] arrays) {
            super(ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].getDouble(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            DoubleArray[] a = new DoubleArray[k2 - k1 + 1];
            a[0] = p1 == 0L ? this.arrays[k1] : (DoubleArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (DoubleArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedDoubleArray(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array double[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " doubles)";
        }
    }

    private static class ConcatenatedObjectArray<E>
    extends AbstractObjectArray<E>
    implements ConcatenatedArray {
        private final long[] startPositions;
        private final ObjectArray<E>[] arrays;

        ConcatenatedObjectArray(ObjectArray<E>[] arrays) {
            super(arrays[0].elementType(), ArraysOpImpl.sumOfLengths(arrays), false, (Array[])arrays);
            this.startPositions = ArraysOpImpl.getStartPositions(arrays);
            this.arrays = arrays;
        }

        @Override
        public E get(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, index);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + index + " (" + String.valueOf(this) + ")";
            return this.arrays[k].get(index - this.startPositions[k]);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            int len;
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            int k = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, arrayPos);
            assert (k >= 0 && k < this.startPositions.length) : "illegal underlying array index " + k + " for position " + arrayPos + " (" + String.valueOf(this) + ")";
            long startPos = this.startPositions[k];
            long p = arrayPos - startPos;
            assert (p >= 0L);
            do {
                assert (k < this.startPositions.length) : "startPositions array exhausted";
                long nextStartPos = k == this.startPositions.length - 1 ? this.length : this.startPositions[k + 1];
                len = (int)Math.min((long)count, nextStartPos - startPos - p);
                this.arrays[k].getData(p, destArray, destArrayOffset, len);
                destArrayOffset += len;
                ++k;
                startPos = nextStartPos;
                p = 0L;
            } while ((count -= len) > 0);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            this.checkSubArrayArguments(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            int k1 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, fromIndex);
            assert (k1 >= 0 && k1 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            int k2 = ArraysOpImpl.searchInConcatenatedArray(this.startPositions, toIndex - 1L);
            assert (k2 >= 0 && k2 < this.startPositions.length) : "illegal underlying array index " + k1 + " for position " + fromIndex + " (" + String.valueOf(this) + ")";
            assert (k2 >= k1);
            long p1 = fromIndex - this.startPositions[k1];
            long p2 = toIndex - 1L - this.startPositions[k2];
            if (k2 == k1) {
                return this.arrays[k1].subArray(p1, p2 + 1L).asImmutable();
            }
            long len1 = this.arrays[k1].length();
            long len2 = this.arrays[k2].length();
            ObjectArray[] a = (ObjectArray[])InternalUtils.cast(new ObjectArray[k2 - k1 + 1]);
            a[0] = p1 == 0L ? this.arrays[k1] : (ObjectArray)InternalUtils.cast(this.arrays[k1].subArray(p1, len1));
            for (int k = k1 + 1; k < k2; ++k) {
                a[k - k1] = this.arrays[k];
            }
            a[a.length - 1] = p2 == len2 - 1L ? this.arrays[k2] : (ObjectArray)InternalUtils.cast(this.arrays[k2].subArray(0L, p2 + 1L));
            return new ConcatenatedObjectArray<E>(a);
        }

        @Override
        public long[] startPositions() {
            return (long[])this.startPositions.clone();
        }

        @Override
        public String toString() {
            long[] lengths = new long[this.arrays.length];
            for (int k = 0; k < this.arrays.length; ++k) {
                lengths[k] = this.arrays[k].length();
            }
            return "immutable AlgART array " + this.elementType().getName() + "[" + this.length + "] built by concatenation of " + this.arrays.length + " arrays (" + JArrays.toString(lengths, ", ", 200) + " Es)";
        }
    }

    private static class ShiftedBitArray
    extends AbstractBitArray
    implements ShiftedArray {
        private final BitArray a;
        private final long shift;

        ShiftedBitArray(BitArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public boolean getBit(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getBit(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            if (arrayPos >= 0L && count > 0L && arrayPos + count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - count) {
                        long rear = this.length - arrayPos;
                        this.a.getBits(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long nextQuickPosition(long position) {
            long qp;
            long p;
            if (position >= this.length) {
                return -1L;
            }
            if (position < 0L) {
                position = 0L;
            }
            if ((p = position - this.shift) < 0L) {
                p = this.shift == 0L || this.shift > this.length / 2L ? (p += this.length) : (p & 0xFFL) % this.length;
            }
            if ((qp = this.a.nextQuickPosition(p)) == -1L) {
                return -1L;
            }
            assert (qp >= p) : "illegal nextQuickPosition implementation in " + String.valueOf(this.a);
            long result = position + (qp - p);
            return result >= this.length ? -1L : result;
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array boolean[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedCharArray
    extends AbstractCharArray
    implements ShiftedArray {
        private final CharArray a;
        private final long shift;

        ShiftedCharArray(CharArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public char getChar(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getChar(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array char[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedByteArray
    extends AbstractByteArray
    implements ShiftedArray {
        private final ByteArray a;
        private final long shift;

        ShiftedByteArray(ByteArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public int getByte(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getByte(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array byte[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedShortArray
    extends AbstractShortArray
    implements ShiftedArray {
        private final ShortArray a;
        private final long shift;

        ShiftedShortArray(ShortArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public int getShort(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getShort(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array short[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedIntArray
    extends AbstractIntArray
    implements ShiftedArray {
        private final IntArray a;
        private final long shift;

        ShiftedIntArray(IntArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public int getInt(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getInt(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array int[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedLongArray
    extends AbstractLongArray
    implements ShiftedArray {
        private final LongArray a;
        private final long shift;

        ShiftedLongArray(LongArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public long getLong(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getLong(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array long[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedFloatArray
    extends AbstractFloatArray
    implements ShiftedArray {
        private final FloatArray a;
        private final long shift;

        ShiftedFloatArray(FloatArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public float getFloat(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getFloat(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array float[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedDoubleArray
    extends AbstractDoubleArray
    implements ShiftedArray {
        private final DoubleArray a;
        private final long shift;

        ShiftedDoubleArray(DoubleArray a, long shift) {
            super(a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public double getDouble(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.getDouble(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array double[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    private static class ShiftedObjectArray<E>
    extends AbstractObjectArray<E>
    implements ShiftedArray {
        private final ObjectArray<E> a;
        private final long shift;

        ShiftedObjectArray(ObjectArray<E> a, long shift) {
            super(a.elementType(), a.length(), false, a);
            if (this.length > 0L) {
                if ((shift %= this.length) < 0L) {
                    shift += this.length;
                }
                assert (0L <= shift && shift < this.length);
            }
            this.a = a;
            this.shift = shift;
        }

        @Override
        public E get(long index) {
            if (index >= 0L && index < this.length && (index -= this.shift) < 0L) {
                index += this.length;
            }
            return this.a.get(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            if (arrayPos >= 0L && count > 0 && arrayPos + (long)count <= this.length) {
                long arrayPosSave = arrayPos;
                if ((arrayPos -= this.shift) < 0L) {
                    assert ((arrayPos += this.length) >= arrayPosSave && arrayPos < this.length) : "arrayPos=" + arrayPos + ", arrayPosSave=" + arrayPosSave + ", length=" + this.length;
                    if (arrayPos >= this.length - (long)count) {
                        int rear = (int)(this.length - arrayPos);
                        this.a.getData(arrayPos, destArray, destArrayOffset, rear);
                        count -= rear;
                        destArrayOffset += rear;
                        arrayPos = 0L;
                    }
                }
            }
            this.a.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public Array subArray(long fromIndex, long toIndex) {
            long toMinus1;
            if (fromIndex == toIndex) {
                return super.subArray(fromIndex, toIndex);
            }
            this.checkSubArrayArguments(fromIndex, toIndex);
            long from = fromIndex - this.shift;
            if (from < 0L) {
                from += this.length;
            }
            if ((toMinus1 = toIndex - 1L - this.shift) < 0L) {
                toMinus1 += this.length;
            }
            assert (from < this.length);
            assert (toMinus1 < this.length);
            if (from <= toMinus1) {
                return this.a.subArray(from, toMinus1 + 1L).asImmutable();
            }
            return super.subArray(fromIndex, toIndex);
        }

        @Override
        public long shift() {
            return this.shift;
        }

        @Override
        public String toString() {
            return "immutable AlgART array " + this.elementType().getName() + "[" + this.length + "] built by shifting by " + this.shift + " of " + String.valueOf(this.a);
        }
    }

    static interface ShiftedArray {
        public long shift();
    }

    static interface ConcatenatedArray {
        public long[] startPositions();
    }

    static class BothBitsUnpacker
    extends Arrays.ParallelExecutor {
        private final DataBitBuffer[] srcBuffers;
        private final DataBuffer[] destBuffers;
        private final double filler0;
        private final double filler1;

        public BothBitsUnpacker(ArrayContext context, UpdatablePArray array, BitArray bits, double filler0, double filler1) {
            super(context, array, bits, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null array argument");
            this.filler0 = filler0;
            this.filler1 = filler1;
            this.srcBuffers = new DataBitBuffer[this.numberOfTasks];
            this.destBuffers = new DataBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBuffer dataBuffer : this.destBuffers) {
                Arrays.dispose(dataBuffer);
            }
            for (DataBuffer dataBuffer : this.srcBuffers) {
                Arrays.dispose(dataBuffer);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer destBuf;
            DataBitBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = (DataBitBuffer)Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = Arrays.bufferInternal(this.dest, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.dest instanceof BitArray) {
                boolean b1;
                boolean b0 = this.filler0 != 0.0;
                boolean bl = b1 = this.filler1 != 0.0;
                if (b0 == b1) {
                    PackedBitArrays.fillBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.count(), b0);
                } else if (b1) {
                    assert (!b0);
                    PackedBitArrays.copyBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    assert (b0);
                    PackedBitArrays.notBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                }
            } else if (this.dest instanceof CharArray) {
                PackedBitArrays.unpackBits((char[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (char)this.filler0, (char)this.filler1);
            } else if (this.dest instanceof ByteArray) {
                PackedBitArrays.unpackBits((byte[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (byte)this.filler0, (byte)this.filler1);
            } else if (this.dest instanceof ShortArray) {
                PackedBitArrays.unpackBits((short[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (short)this.filler0, (short)this.filler1);
            } else if (this.dest instanceof IntArray) {
                PackedBitArrays.unpackBits((int[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (int)this.filler0, (int)this.filler1);
            } else if (this.dest instanceof LongArray) {
                PackedBitArrays.unpackBits((long[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (long)this.filler0, (long)this.filler1);
            } else if (this.dest instanceof FloatArray) {
                PackedBitArrays.unpackBits((float[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (float)this.filler0, (float)this.filler1);
            } else if (this.dest instanceof DoubleArray) {
                PackedBitArrays.unpackBits((double[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), this.filler0, this.filler1);
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class ZeroBitsUnpacker
    extends Arrays.ParallelExecutor {
        private final DataBitBuffer[] srcBuffers;
        private final DataBuffer[] destBuffers;
        private final double filler;

        public ZeroBitsUnpacker(ArrayContext context, UpdatablePArray array, BitArray bits, double filler) {
            super(context, array, bits, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null array argument");
            this.filler = filler;
            this.srcBuffers = new DataBitBuffer[this.numberOfTasks];
            this.destBuffers = new DataBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBuffer dataBuffer : this.destBuffers) {
                Arrays.dispose(dataBuffer);
            }
            for (DataBuffer dataBuffer : this.srcBuffers) {
                Arrays.dispose(dataBuffer);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer destBuf;
            DataBitBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = (DataBitBuffer)Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = Arrays.bufferInternal(this.dest, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.dest instanceof BitArray) {
                if (this.filler != 0.0) {
                    PackedBitArrays.orNotBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.andBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                }
            } else if (this.dest instanceof CharArray) {
                PackedBitArrays.unpackZeroBits((char[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (char)this.filler);
            } else if (this.dest instanceof ByteArray) {
                PackedBitArrays.unpackZeroBits((byte[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (byte)this.filler);
            } else if (this.dest instanceof ShortArray) {
                PackedBitArrays.unpackZeroBits((short[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (short)this.filler);
            } else if (this.dest instanceof IntArray) {
                PackedBitArrays.unpackZeroBits((int[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (int)this.filler);
            } else if (this.dest instanceof LongArray) {
                PackedBitArrays.unpackZeroBits((long[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (long)this.filler);
            } else if (this.dest instanceof FloatArray) {
                PackedBitArrays.unpackZeroBits((float[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (float)this.filler);
            } else if (this.dest instanceof DoubleArray) {
                PackedBitArrays.unpackZeroBits((double[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), this.filler);
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class UnitBitsUnpacker
    extends Arrays.ParallelExecutor {
        private final DataBitBuffer[] srcBuffers;
        private final DataBuffer[] destBuffers;
        private final double filler;

        public UnitBitsUnpacker(ArrayContext context, UpdatablePArray array, BitArray bits, double filler) {
            super(context, array, bits, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null array argument");
            this.filler = filler;
            this.srcBuffers = new DataBitBuffer[this.numberOfTasks];
            this.destBuffers = new DataBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBuffer dataBuffer : this.destBuffers) {
                Arrays.dispose(dataBuffer);
            }
            for (DataBuffer dataBuffer : this.srcBuffers) {
                Arrays.dispose(dataBuffer);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer destBuf;
            DataBitBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = (DataBitBuffer)Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = Arrays.bufferInternal(this.dest, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.dest instanceof BitArray) {
                if (this.filler != 0.0) {
                    PackedBitArrays.orBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.andNotBits((long[])destBuf.data(), destBuf.fromIndex(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                }
            } else if (this.dest instanceof CharArray) {
                PackedBitArrays.unpackUnitBits((char[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (char)this.filler);
            } else if (this.dest instanceof ByteArray) {
                PackedBitArrays.unpackUnitBits((byte[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (byte)this.filler);
            } else if (this.dest instanceof ShortArray) {
                PackedBitArrays.unpackUnitBits((short[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (short)this.filler);
            } else if (this.dest instanceof IntArray) {
                PackedBitArrays.unpackUnitBits((int[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (int)this.filler);
            } else if (this.dest instanceof LongArray) {
                PackedBitArrays.unpackUnitBits((long[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (long)this.filler);
            } else if (this.dest instanceof FloatArray) {
                PackedBitArrays.unpackUnitBits((float[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), (float)this.filler);
            } else if (this.dest instanceof DoubleArray) {
                PackedBitArrays.unpackUnitBits((double[])destBuf.data(), destBuf.from(), srcBuf.data(), srcBuf.fromIndex(), destBuf.cnt(), this.filler);
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class BitsLessOrEqualPacker
    extends Arrays.ParallelExecutor {
        private final UpdatableBitArray bits;
        private final DataBuffer[] srcBuffers;
        private final DataBitBuffer[] destBuffers;
        private final double threshold;

        public BitsLessOrEqualPacker(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
            super(context, bits, array, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null bits argument");
            this.bits = bits;
            this.threshold = threshold;
            this.srcBuffers = new DataBuffer[this.numberOfTasks];
            this.destBuffers = new DataBitBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBitBuffer destBuf : this.destBuffers) {
                Arrays.dispose(destBuf);
            }
            for (DataBuffer srcBuf : this.srcBuffers) {
                Arrays.dispose(srcBuf);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBitBuffer destBuf;
            DataBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = (DataBitBuffer)Arrays.bufferInternal(this.bits, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.src instanceof BitArray) {
                if (this.threshold < 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 1.0) {
                    PackedBitArrays.notBits(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof CharArray) {
                if (this.threshold < 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 65535.0) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (char[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (char)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ByteArray) {
                if (this.threshold < 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 255.0) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (byte[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ShortArray) {
                if (this.threshold < 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 65535.0) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (short[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof IntArray) {
                if (this.threshold < -2.147483648E9) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 2.147483647E9) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (int[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof LongArray) {
                if (this.threshold < -9.223372036854776E18) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < 9.223372036854776E18) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (long)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof FloatArray) {
                if (this.threshold < Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < Double.POSITIVE_INFINITY) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (float[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (float)this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof DoubleArray) {
                if (this.threshold < Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold < Double.POSITIVE_INFINITY) {
                    PackedBitArrays.packBitsLessOrEqual(destBuf.data(), destBuf.fromIndex(), (double[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class BitsGreaterOrEqualPacker
    extends Arrays.ParallelExecutor {
        private final UpdatableBitArray bits;
        private final DataBuffer[] srcBuffers;
        private final DataBitBuffer[] destBuffers;
        private final double threshold;

        public BitsGreaterOrEqualPacker(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
            super(context, bits, array, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null bits argument");
            this.bits = bits;
            this.threshold = threshold;
            this.srcBuffers = new DataBuffer[this.numberOfTasks];
            this.destBuffers = new DataBitBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBitBuffer destBuf : this.destBuffers) {
                Arrays.dispose(destBuf);
            }
            for (DataBuffer srcBuf : this.srcBuffers) {
                Arrays.dispose(srcBuf);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBitBuffer destBuf;
            DataBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = (DataBitBuffer)Arrays.bufferInternal(this.bits, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.src instanceof BitArray) {
                if (this.threshold > 1.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > 0.0) {
                    PackedBitArrays.copyBits(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof CharArray) {
                if (this.threshold > 65535.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > 0.0) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (char[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (char)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ByteArray) {
                if (this.threshold > 255.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > 0.0) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (byte[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ShortArray) {
                if (this.threshold > 65535.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > 0.0) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (short[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof IntArray) {
                if (this.threshold > 2.147483647E9) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > -2.147483648E9) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (int[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof LongArray) {
                if (this.threshold > 9.223372036854776E18) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > -9.223372036854776E18) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (long)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof FloatArray) {
                if (this.threshold > Double.POSITIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (float[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (float)this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof DoubleArray) {
                if (this.threshold > Double.POSITIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold > Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.packBitsGreaterOrEqual(destBuf.data(), destBuf.fromIndex(), (double[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class BitsLessPacker
    extends Arrays.ParallelExecutor {
        private final UpdatableBitArray bits;
        private final DataBuffer[] srcBuffers;
        private final DataBitBuffer[] destBuffers;
        private final double threshold;

        public BitsLessPacker(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
            super(context, bits, array, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null bits argument");
            this.bits = bits;
            this.threshold = threshold;
            this.srcBuffers = new DataBuffer[this.numberOfTasks];
            this.destBuffers = new DataBitBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBitBuffer destBuf : this.destBuffers) {
                Arrays.dispose(destBuf);
            }
            for (DataBuffer srcBuf : this.srcBuffers) {
                Arrays.dispose(srcBuf);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBitBuffer destBuf;
            DataBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = (DataBitBuffer)Arrays.bufferInternal(this.bits, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.src instanceof BitArray) {
                if (this.threshold <= 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 1.0) {
                    PackedBitArrays.notBits(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof CharArray) {
                if (this.threshold <= 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 65535.0) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (char[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (char)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ByteArray) {
                if (this.threshold <= 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 255.0) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (byte[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ShortArray) {
                if (this.threshold <= 0.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 65535.0) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (short[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof IntArray) {
                if (this.threshold <= -2.147483648E9) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 2.147483647E9) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (int[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof LongArray) {
                if (this.threshold <= -9.223372036854776E18) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= 9.223372036854776E18) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (long)StrictMath.ceil(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof FloatArray) {
                if (this.threshold <= Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= Double.POSITIVE_INFINITY) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (float[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (float)this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof DoubleArray) {
                if (this.threshold <= Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold <= Double.POSITIVE_INFINITY) {
                    PackedBitArrays.packBitsLess(destBuf.data(), destBuf.fromIndex(), (double[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class BitsGreaterPacker
    extends Arrays.ParallelExecutor {
        private final UpdatableBitArray bits;
        private final DataBuffer[] srcBuffers;
        private final DataBitBuffer[] destBuffers;
        private final double threshold;

        public BitsGreaterPacker(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
            super(context, bits, array, Math.min(AbstractArray.largeBufferCapacity(array), 32768), 0, 0L);
            Objects.requireNonNull(bits, "Null bits argument");
            this.bits = bits;
            this.threshold = threshold;
            this.srcBuffers = new DataBuffer[this.numberOfTasks];
            this.destBuffers = new DataBitBuffer[this.numberOfTasks];
        }

        @Override
        protected void finish() {
            for (DataBitBuffer destBuf : this.destBuffers) {
                Arrays.dispose(destBuf);
            }
            for (DataBuffer srcBuf : this.srcBuffers) {
                Arrays.dispose(srcBuf);
            }
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBitBuffer destBuf;
            DataBuffer srcBuf = this.srcBuffers[threadIndex];
            if (srcBuf == null) {
                srcBuf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(srcBuf);
                this.srcBuffers[threadIndex] = srcBuf;
            }
            if ((destBuf = this.destBuffers[threadIndex]) == null) {
                destBuf = (DataBitBuffer)Arrays.bufferInternal(this.bits, DataBuffer.AccessMode.READ_WRITE, this.blockSize, true);
                Arrays.enableCaching(destBuf);
                this.destBuffers[threadIndex] = destBuf;
            }
            srcBuf.map(position, count);
            destBuf.map(position, count);
            assert (srcBuf.count() == destBuf.count());
            if (this.src instanceof BitArray) {
                if (this.threshold >= 1.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= 0.0) {
                    PackedBitArrays.copyBits(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof CharArray) {
                if (this.threshold >= 65535.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= 0.0) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (char[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (char)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ByteArray) {
                if (this.threshold >= 255.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= 0.0) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (byte[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof ShortArray) {
                if (this.threshold >= 65535.0) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= 0.0) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (short[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof IntArray) {
                if (this.threshold >= 2.147483647E9) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= -2.147483648E9) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (int[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (int)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof LongArray) {
                if (this.threshold >= 9.223372036854776E18) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= -9.223372036854776E18) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (long[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (long)StrictMath.floor(this.threshold));
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof FloatArray) {
                if (this.threshold >= Double.POSITIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (float[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), (float)this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else if (this.src instanceof DoubleArray) {
                if (this.threshold >= Double.POSITIVE_INFINITY) {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), false);
                } else if (this.threshold >= Double.NEGATIVE_INFINITY) {
                    PackedBitArrays.packBitsGreater(destBuf.data(), destBuf.fromIndex(), (double[])srcBuf.data(), srcBuf.from(), srcBuf.cnt(), this.threshold);
                } else {
                    PackedBitArrays.fillBits(destBuf.data(), destBuf.fromIndex(), srcBuf.count(), true);
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            destBuf.force();
        }
    }

    static class HistogramCalculator
    extends Arrays.ParallelExecutor {
        private final DataBuffer[] buffers;
        private final long[] histogram;
        private final long[][] histograms;
        private final double from;
        private final double to;
        private final double multiplier;
        private long cardinality = 0L;
        boolean allInside = true;

        public HistogramCalculator(ArrayContext context, PArray src, long[] histogram, double from, double to) {
            super(context, null, src, AbstractArray.largeBufferCapacity(src), 0, 0L);
            if (histogram.length == 0) {
                throw new AssertionError((Object)"Empty histogram");
            }
            this.buffers = new DataBuffer[this.numberOfTasks];
            this.histogram = histogram;
            this.histograms = new long[this.numberOfTasks][histogram.length];
            this.from = from;
            this.to = to;
            this.multiplier = (double)histogram.length / (to - from);
        }

        @Override
        public void process() {
            if (this.from >= this.to) {
                this.allInside = false;
            } else {
                super.process();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer buf = this.buffers[threadIndex];
            long[] hist = this.histograms[threadIndex];
            boolean outside = false;
            if (buf == null) {
                buf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(buf);
                this.buffers[threadIndex] = buf;
            }
            buf.map(position, count);
            if (this.src instanceof BitArray) {
                long card = PackedBitArrays.cardinality((long[])buf.data(), buf.fromIndex(), buf.toIndex());
                HistogramCalculator histogramCalculator = this;
                synchronized (histogramCalculator) {
                    this.cardinality += card;
                }
            } else if (this.src instanceof ByteArray) {
                byte[] ja = (byte[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        int m = ja[k] & 0xFF;
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k] & 0xFF;
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof CharArray) {
                char[] ja = (char[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        char m = ja[k];
                        if (m >= '\u0000' && m < hist.length) {
                            char c = m;
                            hist[c] = hist[c] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof ShortArray) {
                short[] ja = (short[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        int m = ja[k] & 0xFFFF;
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k] & 0xFFFF;
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof IntArray) {
                int[] ja = (int[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        int m = ja[k];
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof LongArray) {
                long[] ja = (long[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)v;
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof FloatArray) {
                float[] ja = (float[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)v;
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else if (this.src instanceof DoubleArray) {
                double[] ja = (double[])buf.data();
                if (this.from == 0.0 && this.multiplier == 1.0) {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)v;
                        if (m >= 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                } else {
                    int kMax = buf.to();
                    for (int k = buf.from(); k < kMax; ++k) {
                        double v = ja[k];
                        int m = (int)(v = (v - this.from) * this.multiplier);
                        if (m > 0 && m < hist.length) {
                            int n = m;
                            hist[n] = hist[n] + 1L;
                            continue;
                        }
                        if (m == 0 && v >= 0.0) {
                            hist[0] = hist[0] + 1L;
                            continue;
                        }
                        outside = true;
                    }
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
            HistogramCalculator histogramCalculator = this;
            synchronized (histogramCalculator) {
                if (outside) {
                    this.allInside = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void finish() {
            block11: {
                for (DataBuffer buf : this.buffers) {
                    Arrays.dispose(buf);
                }
                HistogramCalculator histogramCalculator = this;
                synchronized (histogramCalculator) {
                    block9: {
                        block10: {
                            if (!(this.src instanceof BitArray)) break block9;
                            int m0 = (int)StrictMath.floor(-this.from * this.multiplier);
                            if (m0 >= 0 && m0 < this.histogram.length) {
                                int n = m0;
                                this.histogram[n] = this.histogram[n] + (this.src.length() - this.cardinality);
                            } else if (this.cardinality < this.src.length()) {
                                this.allInside = false;
                            }
                            int m1 = (int)StrictMath.floor((1.0 - this.from) * this.multiplier);
                            if (m1 < 0 || m1 >= this.histogram.length) break block10;
                            int n = m1;
                            this.histogram[n] = this.histogram[n] + this.cardinality;
                            break block11;
                        }
                        if (this.cardinality <= 0L) break block11;
                        this.allInside = false;
                        break block11;
                    }
                    for (int threadIndex = 0; threadIndex < this.numberOfTasks; ++threadIndex) {
                        long[] hist = this.histograms[threadIndex];
                        for (int k = 0; k < this.histogram.length; ++k) {
                            int n = k;
                            this.histogram[n] = this.histogram[n] + hist[k];
                        }
                    }
                }
            }
        }
    }

    static class PreciseSummator
    extends Arrays.ParallelExecutor {
        private final boolean checkOverflow;
        private final DataBuffer[] buffers;
        private long result = 0L;

        public PreciseSummator(ArrayContext context, PFixedArray src, boolean checkOverflow) {
            super(context, null, src, Math.min(AbstractArray.largeBufferCapacity(src), src instanceof IntArray ? 32768 : 65536), 0, 0L);
            this.checkOverflow = checkOverflow;
            this.buffers = new DataBuffer[this.numberOfTasks];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer buf = this.buffers[threadIndex];
            if (buf == null) {
                buf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(buf);
                this.buffers[threadIndex] = buf;
            }
            buf.map(position, count);
            assert (buf.count() == (long)count);
            if (this.src instanceof BitArray) {
                long card = PackedBitArrays.cardinality((long[])buf.data(), buf.fromIndex(), buf.toIndex());
                PreciseSummator preciseSummator = this;
                synchronized (preciseSummator) {
                    this.result += card;
                }
            }
            if (this.src instanceof ByteArray) {
                byte[] ja = (byte[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k] & 0xFF;
                }
                PreciseSummator k = this;
                synchronized (k) {
                    this.result += (long)sum;
                    if (this.checkOverflow && this.result < 0L) {
                        throw new ArithmeticException("Overflow while sum calculation");
                    }
                }
            }
            if (this.src instanceof CharArray) {
                char[] ja = (char[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k];
                }
                PreciseSummator k = this;
                synchronized (k) {
                    this.result += (long)sum;
                    if (this.checkOverflow && this.result < 0L) {
                        throw new ArithmeticException("Overflow while sum calculation");
                    }
                }
            }
            if (this.src instanceof ShortArray) {
                short[] ja = (short[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k] & 0xFFFF;
                }
                PreciseSummator preciseSummator = this;
                synchronized (preciseSummator) {
                    this.result += (long)sum;
                    if (this.checkOverflow && this.result < 0L) {
                        throw new ArithmeticException("Overflow while sum calculation");
                    }
                }
            }
            if (this.src instanceof IntArray) {
                int[] ja = (int[])buf.data();
                long sum = 0L;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += (long)ja[k];
                }
                PreciseSummator k = this;
                synchronized (k) {
                    if (this.checkOverflow && (sum > 0L ? this.result > 0L && this.result + sum <= 0L : this.result < 0L && this.result + sum >= 0L)) {
                        throw new ArithmeticException("Overflow while sum calculation");
                    }
                    this.result += sum;
                }
            }
            if (this.src instanceof LongArray) {
                long[] ja = (long[])buf.data();
                long sum = 0L;
                if (this.checkOverflow) {
                    int kMax = buf.to();
                    for (k = buf.from(); k < kMax; ++k) {
                        if (ja[k] > 0L ? sum > 0L && sum + ja[k] <= 0L : sum < 0L && sum + ja[k] >= 0L) {
                            throw new ArithmeticException("Overflow while sum calculation");
                        }
                        sum += ja[k];
                    }
                } else {
                    int kMax = buf.to();
                    for (k = buf.from(); k < kMax; ++k) {
                        sum += ja[k];
                    }
                }
                PreciseSummator preciseSummator = this;
                synchronized (preciseSummator) {
                    if (this.checkOverflow && (sum > 0L ? this.result > 0L && this.result + sum <= 0L : this.result < 0L && this.result + sum >= 0L)) {
                        throw new ArithmeticException("Overflow while sum calculation");
                    }
                    this.result += sum;
                }
            }
            throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
        }

        @Override
        protected void finish() {
            for (DataBuffer buf : this.buffers) {
                Arrays.dispose(buf);
            }
        }

        public synchronized long result() {
            return this.result;
        }
    }

    static class Summator
    extends Arrays.ParallelExecutor {
        private final DataBuffer[] buffers = new DataBuffer[this.numberOfTasks];
        private double result = 0.0;

        public Summator(ArrayContext context, PArray src) {
            super(context, null, src, Math.min(AbstractArray.largeBufferCapacity(src), src instanceof IntArray ? 32768 : 65536), 1, 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer buf = this.buffers[threadIndex];
            if (buf == null) {
                buf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(buf);
                this.buffers[threadIndex] = buf;
            }
            buf.map(position, count);
            assert (buf.count() == (long)count);
            if (this.src instanceof BitArray) {
                long card = PackedBitArrays.cardinality((long[])buf.data(), buf.fromIndex(), buf.toIndex());
                Summator summator = this;
                synchronized (summator) {
                    this.result += (double)card;
                }
            } else if (this.src instanceof ByteArray) {
                byte[] ja = (byte[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k] & 0xFF;
                }
                Summator k = this;
                synchronized (k) {
                    this.result += (double)sum;
                }
            } else if (this.src instanceof CharArray) {
                char[] ja = (char[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k];
                }
                Summator k = this;
                synchronized (k) {
                    this.result += (double)sum;
                }
            } else if (this.src instanceof ShortArray) {
                short[] ja = (short[])buf.data();
                int sum = 0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k] & 0xFFFF;
                }
                Summator summator = this;
                synchronized (summator) {
                    this.result += (double)sum;
                }
            } else if (this.src instanceof IntArray) {
                int[] ja = (int[])buf.data();
                long sum = 0L;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += (long)ja[k];
                }
                Summator k = this;
                synchronized (k) {
                    this.result += (double)sum;
                }
            } else if (this.src instanceof LongArray) {
                long[] ja = (long[])buf.data();
                double sum = 0.0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += (double)ja[k];
                }
                Summator k = this;
                synchronized (k) {
                    this.result += sum;
                }
            } else if (this.src instanceof FloatArray) {
                float[] ja = (float[])buf.data();
                double sum = 0.0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += (double)ja[k];
                }
                Summator k = this;
                synchronized (k) {
                    this.result += sum;
                }
            } else if (this.src instanceof DoubleArray) {
                double[] ja = (double[])buf.data();
                double sum = 0.0;
                int kMax = buf.to();
                for (int k = buf.from(); k < kMax; ++k) {
                    sum += ja[k];
                }
                Summator summator = this;
                synchronized (summator) {
                    this.result += sum;
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
        }

        @Override
        protected void finish() {
            for (DataBuffer buf : this.buffers) {
                Arrays.dispose(buf);
            }
        }

        public synchronized double result() {
            return this.result;
        }
    }

    static class RangeCalculator
    extends Arrays.ParallelExecutor {
        private final DataBuffer[] buffers;
        private final Arrays.MinMaxInfo result;
        private long indexOfMin = -1L;
        private long indexOfMax = -1L;
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;

        public RangeCalculator(ArrayContext context, PArray src, Arrays.MinMaxInfo result) {
            super(context, null, src, AbstractArray.largeBufferCapacity(src), 0, 0L);
            this.buffers = new DataBuffer[this.numberOfTasks];
            this.result = result;
        }

        @Override
        public void process() {
            if (this.src.isEmpty()) {
                this.result.setEmpty();
            } else if (this.src instanceof BitArray) {
                boolean v0 = ((BitArray)this.src).getBit(0L);
                if (v0) {
                    this.indexOfMax = 0L;
                } else {
                    this.indexOfMin = 0L;
                }
                DataBuffer buf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                buf.map(0L);
                block0: while (buf.hasData()) {
                    long[] ja = (long[])buf.data();
                    long kMin = buf.fromIndex();
                    long kMax = buf.toIndex();
                    for (long k = kMin; k < kMax; ++k) {
                        boolean v = PackedBitArrays.getBit(ja, k);
                        if (v == v0) continue;
                        if (v) {
                            this.indexOfMax = buf.position() + (k - kMin);
                            break block0;
                        }
                        this.indexOfMin = buf.position() + (k - kMin);
                        break block0;
                    }
                    buf.mapNext();
                }
                assert (this.indexOfMin != -1L || this.indexOfMax != -1L);
                if (this.indexOfMin == -1L) {
                    this.indexOfMin = 0L;
                }
                if (this.indexOfMax == -1L) {
                    this.indexOfMax = 0L;
                }
                this.finish();
            } else {
                super.process();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            DataBuffer buf = this.buffers[threadIndex];
            if (buf == null) {
                buf = Arrays.bufferInternal(this.src, DataBuffer.AccessMode.READ, this.blockSize, true);
                Arrays.enableCaching(buf);
                this.buffers[threadIndex] = buf;
            }
            buf.map(position, count);
            long index = position;
            if (this.src instanceof BitArray) {
                throw new AssertionError((Object)"Illegal usage");
            }
            if (this.src instanceof ByteArray) {
                int n;
                int n2;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                byte[] ja = (byte[])buf.data();
                int k232 = buf.from();
                int kMax = buf.to();
                while (k232 < kMax) {
                    int v = ja[k232] & 0xFF;
                    if (v < n2) {
                        n2 = v;
                        indexOfMin = index;
                    }
                    if (v > n) {
                        n = v;
                        indexOfMax = index;
                    }
                    ++k232;
                    ++index;
                }
                RangeCalculator k232 = this;
                synchronized (k232) {
                    if ((double)n2 < this.min || (double)n2 == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = n2;
                    }
                    if ((double)n > this.max || (double)n == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = n;
                    }
                }
            } else if (this.src instanceof CharArray) {
                char c;
                char c2;
                int n = Integer.MAX_VALUE;
                int n5 = Integer.MIN_VALUE;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                char[] ja = (char[])buf.data();
                int k332 = buf.from();
                int kMax = buf.to();
                while (k332 < kMax) {
                    char v = ja[k332];
                    if (v < c2) {
                        c2 = v;
                        indexOfMin = index;
                    }
                    if (v > c) {
                        c = v;
                        indexOfMax = index;
                    }
                    ++k332;
                    ++index;
                }
                RangeCalculator k332 = this;
                synchronized (k332) {
                    if ((double)c2 < this.min || (double)c2 == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = c2;
                    }
                    if ((double)c > this.max || (double)c == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = c;
                    }
                }
            } else if (this.src instanceof ShortArray) {
                int n;
                int n6;
                int n7 = Integer.MAX_VALUE;
                int n8 = Integer.MIN_VALUE;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                short[] ja = (short[])buf.data();
                int k432 = buf.from();
                int kMax = buf.to();
                while (k432 < kMax) {
                    int v = ja[k432] & 0xFFFF;
                    if (v < n6) {
                        n6 = v;
                        indexOfMin = index;
                    }
                    if (v > n) {
                        n = v;
                        indexOfMax = index;
                    }
                    ++k432;
                    ++index;
                }
                RangeCalculator k432 = this;
                synchronized (k432) {
                    if ((double)n6 < this.min || (double)n6 == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = n6;
                    }
                    if ((double)n > this.max || (double)n == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = n;
                    }
                }
            } else if (this.src instanceof IntArray) {
                int n;
                int n9;
                int n10 = Integer.MAX_VALUE;
                int n11 = Integer.MIN_VALUE;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                int[] ja = (int[])buf.data();
                int k532 = buf.from();
                int kMax = buf.to();
                while (k532 < kMax) {
                    int v = ja[k532];
                    if (v < n9) {
                        n9 = v;
                        indexOfMin = index;
                    }
                    if (v > n) {
                        n = v;
                        indexOfMax = index;
                    }
                    ++k532;
                    ++index;
                }
                RangeCalculator k532 = this;
                synchronized (k532) {
                    if ((double)n9 < this.min || (double)n9 == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = n9;
                    }
                    if ((double)n > this.max || (double)n == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = n;
                    }
                }
            } else if (this.src instanceof LongArray) {
                long l = Long.MAX_VALUE;
                long max = Long.MIN_VALUE;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                long[] ja = (long[])buf.data();
                int k632 = buf.from();
                int kMax = buf.to();
                while (k632 < kMax) {
                    long v = ja[k632];
                    if (v < l) {
                        l = v;
                        indexOfMin = index;
                    }
                    if (v > max) {
                        max = v;
                        indexOfMax = index;
                    }
                    ++k632;
                    ++index;
                }
                RangeCalculator k632 = this;
                synchronized (k632) {
                    if ((double)l < this.min || (double)l == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = l;
                    }
                    if ((double)max > this.max || (double)max == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = max;
                    }
                }
            } else if (this.src instanceof FloatArray) {
                float f = Float.POSITIVE_INFINITY;
                float f2 = Float.NEGATIVE_INFINITY;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                float[] ja = (float[])buf.data();
                int k = buf.from();
                int kMax = buf.to();
                while (k < kMax) {
                    float v = ja[k];
                    if (v < f) {
                        f = v;
                        indexOfMin = index;
                    }
                    if (v > f2) {
                        f2 = v;
                        indexOfMax = index;
                    }
                    ++k;
                    ++index;
                }
                RangeCalculator rangeCalculator = this;
                synchronized (rangeCalculator) {
                    if ((double)f < this.min || (double)f == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = f;
                    }
                    if ((double)f2 > this.max || (double)f2 == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = f2;
                    }
                }
            } else if (this.src instanceof DoubleArray) {
                double d = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                long indexOfMin = -1L;
                long indexOfMax = -1L;
                double[] ja = (double[])buf.data();
                int k = buf.from();
                int kMax = buf.to();
                while (k < kMax) {
                    double v = ja[k];
                    if (v < d) {
                        d = v;
                        indexOfMin = index;
                    }
                    if (v > max) {
                        max = v;
                        indexOfMax = index;
                    }
                    ++k;
                    ++index;
                }
                RangeCalculator rangeCalculator = this;
                synchronized (rangeCalculator) {
                    if (d < this.min || d == this.min && indexOfMin < this.indexOfMin) {
                        this.indexOfMin = indexOfMin;
                        this.min = d;
                    }
                    if (max > this.max || max == this.max && indexOfMax < this.indexOfMax) {
                        this.indexOfMax = indexOfMax;
                        this.max = max;
                    }
                }
            } else {
                throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(this.src.getClass())));
            }
        }

        @Override
        protected synchronized void finish() {
            if (!this.src.isEmpty()) {
                this.result.setAll(this.indexOfMin, this.indexOfMax, (PArray)this.src);
            }
            for (DataBuffer buf : this.buffers) {
                Arrays.dispose(buf);
            }
        }
    }

    static class ComparingCopier
    extends Arrays.ParallelExecutor {
        private static final MemoryModel smm = SimpleMemoryModel.getInstance();
        private static final int BIT_BLOCK_SIZE = 524288;
        private static final int BLOCK_SIZE = 32768;
        private static final ArrayPool BIT_ARRAYS = ArrayPool.getInstance(smm, Boolean.TYPE, 524288L);
        private static final ArrayPool CHAR_ARRAYS = ArrayPool.getInstance(smm, Character.TYPE, 32768L);
        private static final ArrayPool BYTE_ARRAYS = ArrayPool.getInstance(smm, Byte.TYPE, 32768L);
        private static final ArrayPool SHORT_ARRAYS = ArrayPool.getInstance(smm, Short.TYPE, 32768L);
        private static final ArrayPool INT_ARRAYS = ArrayPool.getInstance(smm, Integer.TYPE, 32768L);
        private static final ArrayPool LONG_ARRAYS = ArrayPool.getInstance(smm, Long.TYPE, 32768L);
        private static final ArrayPool FLOAT_ARRAYS = ArrayPool.getInstance(smm, Float.TYPE, 32768L);
        private static final ArrayPool DOUBLE_ARRAYS = ArrayPool.getInstance(smm, Double.TYPE, 32768L);
        private final ArrayPool arrayPool;
        volatile boolean changed = false;

        public ComparingCopier(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks) {
            super(context, src.length() <= dest.length() ? dest.subArr(0L, src.length()) : dest, src.length() <= dest.length() ? src : src.subArr(0L, dest.length()), src instanceof BitArray ? 524288 : 32768, numberOfTasks, 0L);
            if (!dest.elementType().isAssignableFrom(src.elementType())) {
                throw new IllegalArgumentException("Element types mismatch (" + String.valueOf(dest.elementType()) + " and " + String.valueOf(src.elementType()) + ")");
            }
            this.arrayPool = dest instanceof BitArray ? BIT_ARRAYS : (dest instanceof CharArray ? CHAR_ARRAYS : (dest instanceof ByteArray ? BYTE_ARRAYS : (dest instanceof ShortArray ? SHORT_ARRAYS : (dest instanceof IntArray ? INT_ARRAYS : (dest instanceof LongArray ? LONG_ARRAYS : (dest instanceof FloatArray ? FLOAT_ARRAYS : (dest instanceof DoubleArray ? DOUBLE_ARRAYS : null)))))));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            UpdatableArray buf = this.arrayPool == null ? SimpleMemoryModel.getInstance().newUnresizableArray(this.dest.elementType(), this.blockSize) : this.arrayPool.requestArray();
            try {
                UpdatableArray subBuf = buf.subArr(0L, count);
                Array subSrc = this.src.subArr(position, count);
                subBuf.copy(subSrc);
                UpdatableArray subDest = this.dest.subArr(position, count);
                if (!subDest.equals(subBuf)) {
                    this.changed = true;
                    subDest.copy(subBuf);
                }
            }
            finally {
                if (this.arrayPool != null) {
                    this.arrayPool.releaseArray(buf);
                }
            }
        }
    }
}

