/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.functions.Func;

class ArraysInterpolationsImpl {
    ArraysInterpolationsImpl() {
    }

    static class ContinuedTrivialDoubleInterpolation
    extends ContinuedTrivialInterpolation {
        private final double[] arr;
        private final int ofs;

        ContinuedTrivialDoubleInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class CheckedTrivialDoubleInterpolation
    extends CheckedTrivialInterpolation {
        private final double[] arr;
        private final int ofs;

        CheckedTrivialDoubleInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class UncheckedTrivialDoubleInterpolation
    extends UncheckedTrivialInterpolation {
        private final double[] arr;
        private final int ofs;

        UncheckedTrivialDoubleInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (double[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class ContinuedTrivialFloatInterpolation
    extends ContinuedTrivialInterpolation {
        private final float[] arr;
        private final int ofs;

        ContinuedTrivialFloatInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class CheckedTrivialFloatInterpolation
    extends CheckedTrivialInterpolation {
        private final float[] arr;
        private final int ofs;

        CheckedTrivialFloatInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class UncheckedTrivialFloatInterpolation
    extends UncheckedTrivialInterpolation {
        private final float[] arr;
        private final int ofs;

        UncheckedTrivialFloatInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (float[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class ContinuedTrivialLongInterpolation
    extends ContinuedTrivialInterpolation {
        private final long[] arr;
        private final int ofs;

        ContinuedTrivialLongInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class CheckedTrivialLongInterpolation
    extends CheckedTrivialInterpolation {
        private final long[] arr;
        private final int ofs;

        CheckedTrivialLongInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class UncheckedTrivialLongInterpolation
    extends UncheckedTrivialInterpolation {
        private final long[] arr;
        private final int ofs;

        UncheckedTrivialLongInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (long[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class ContinuedTrivialIntInterpolation
    extends ContinuedTrivialInterpolation {
        private final int[] arr;
        private final int ofs;

        ContinuedTrivialIntInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class CheckedTrivialIntInterpolation
    extends CheckedTrivialInterpolation {
        private final int[] arr;
        private final int ofs;

        CheckedTrivialIntInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class UncheckedTrivialIntInterpolation
    extends UncheckedTrivialInterpolation {
        private final int[] arr;
        private final int ofs;

        UncheckedTrivialIntInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (int[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class ContinuedTrivialShortInterpolation
    extends ContinuedTrivialInterpolation {
        private final short[] arr;
        private final int ofs;

        ContinuedTrivialShortInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix] & 0xFFFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFFFF;
        }
    }

    static class CheckedTrivialShortInterpolation
    extends CheckedTrivialInterpolation {
        private final short[] arr;
        private final int ofs;

        CheckedTrivialShortInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix] & 0xFFFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix] & 0xFFFF;
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFFFF;
        }
    }

    static class UncheckedTrivialShortInterpolation
    extends UncheckedTrivialInterpolation {
        private final short[] arr;
        private final int ofs;

        UncheckedTrivialShortInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (short[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix] & 0xFFFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix] & 0xFFFF;
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFFFF;
        }
    }

    static class ContinuedTrivialCharInterpolation
    extends ContinuedTrivialInterpolation {
        private final char[] arr;
        private final int ofs;

        ContinuedTrivialCharInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class CheckedTrivialCharInterpolation
    extends CheckedTrivialInterpolation {
        private final char[] arr;
        private final int ofs;

        CheckedTrivialCharInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class UncheckedTrivialCharInterpolation
    extends UncheckedTrivialInterpolation {
        private final char[] arr;
        private final int ofs;

        UncheckedTrivialCharInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (char[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix];
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix];
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix];
        }
    }

    static class ContinuedTrivialByteInterpolation
    extends ContinuedTrivialInterpolation {
        private final byte[] arr;
        private final int ofs;

        ContinuedTrivialByteInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m, outsideValue);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + ix] & 0xFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            return this.array.getDouble((long)iy * (long)this.idimX + (long)ix);
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            if (ix < 0 || ix >= this.idimX) {
                return this.outsideValue;
            }
            int iy = (int)y;
            if (iy < 0 || iy >= this.idimY) {
                return this.outsideValue;
            }
            int iz = (int)z;
            if (iz < 0 || iz >= this.idimZ) {
                return this.outsideValue;
            }
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFF;
        }
    }

    static class CheckedTrivialByteInterpolation
    extends CheckedTrivialInterpolation {
        private final byte[] arr;
        private final int ofs;

        CheckedTrivialByteInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            return this.arr[this.ofs + ix] & 0xFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            return this.arr[this.ofs + iy * this.idimX + ix] & 0xFF;
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            this.checkIntIndex0(ix);
            int iy = (int)y;
            this.checkIntIndex1(iy);
            int iz = (int)z;
            this.checkIntIndex2(iz);
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFF;
        }
    }

    static class UncheckedTrivialByteInterpolation
    extends UncheckedTrivialInterpolation {
        private final byte[] arr;
        private final int ofs;

        UncheckedTrivialByteInterpolation(Matrix<? extends PArray> m) {
            super(m);
            this.arr = (byte[])Arrays.javaArrayInternal(this.array);
            this.ofs = Arrays.javaArrayOffsetInternal(this.array);
        }

        @Override
        public double get(double x) {
            int ix = (int)x;
            return this.arr[this.ofs + ix] & 0xFF;
        }

        @Override
        public double get(double x, double y) {
            int ix = (int)x;
            int iy = (int)y;
            return this.arr[this.ofs + iy * this.idimX + ix] & 0xFF;
        }

        @Override
        public double get(double x, double y, double z) {
            int ix = (int)x;
            int iy = (int)y;
            int iz = (int)z;
            return this.arr[this.ofs + (iz * this.idimY + iy) * this.idimX + ix] & 0xFF;
        }
    }

    static class ContinuedTrivialInterpolation
    extends AbstractInterpolation {
        final double outsideValue;

        ContinuedTrivialInterpolation(Matrix<? extends PArray> m, double outsideValue) {
            super(m);
            this.outsideValue = outsideValue;
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            int n = this.dim.length < x.length ? this.dim.length - 1 : x.length - 1;
            long index = (long)x[n];
            if (index < 0L || index >= this.dim[n]) {
                return this.outsideValue;
            }
            while (--n >= 0) {
                long coord = (long)x[n];
                if (coord < 0L || coord >= this.dim[n]) {
                    return this.outsideValue;
                }
                index = this.dim[n] * index + coord;
            }
            return this.array.getDouble(index);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            if (ix < 0L || ix >= this.dimX) {
                return this.outsideValue;
            }
            return this.array.getDouble(ix);
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            if (ix < 0L || ix >= this.dimX) {
                return this.outsideValue;
            }
            long iy = (long)y;
            if (iy < 0L || iy >= this.dimY) {
                return this.outsideValue;
            }
            return this.array.getDouble(iy * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z) {
            long ix = (long)x;
            if (ix < 0L || ix >= this.dimX) {
                return this.outsideValue;
            }
            long iy = (long)y;
            if (iy < 0L || iy >= this.dimY) {
                return this.outsideValue;
            }
            long iz = (long)z;
            if (iz < 0L || iz >= this.dimZ) {
                return this.outsideValue;
            }
            return this.array.getDouble((iz * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z, double t) {
            long ix = (long)x;
            if (ix < 0L || ix >= this.dimX) {
                return this.outsideValue;
            }
            long iy = (long)y;
            if (iy < 0L || iy >= this.dimY) {
                return this.outsideValue;
            }
            long iz = (long)z;
            if (iz < 0L || iz >= this.dimZ) {
                return this.outsideValue;
            }
            long it = (long)t;
            if (it < 0L || it >= this.m.dim(3)) {
                return this.outsideValue;
            }
            return this.array.getDouble(((it * this.dimZ + iz) * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public Boolean isChecked() {
            return null;
        }

        @Override
        public Double outsideValue() {
            return this.outsideValue;
        }

        @Override
        public String toString() {
            return "continued (by " + this.outsideValue + ") step function based on " + String.valueOf(this.m);
        }
    }

    static class CheckedTrivialInterpolation
    extends AbstractInterpolation {
        CheckedTrivialInterpolation(Matrix<? extends PArray> m) {
            super(m);
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            int n = this.dim.length < x.length ? this.dim.length - 1 : x.length - 1;
            long index = (long)x[n];
            this.checkIndex(n, index);
            while (--n >= 0) {
                long coord = (long)x[n];
                this.checkIndex(n, coord);
                index = this.dim[n] * index + coord;
            }
            return this.array.getDouble(index);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            return this.array.getDouble(ix);
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            this.checkIndex0(ix);
            long iy = (long)y;
            this.checkIndex1(iy);
            return this.array.getDouble(iy * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z) {
            long ix = (long)x;
            this.checkIndex0(ix);
            long iy = (long)y;
            this.checkIndex1(iy);
            long iz = (long)z;
            this.checkIndex2(iz);
            return this.array.getDouble((iz * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z, double t) {
            long ix = (long)x;
            this.checkIndex0(ix);
            long iy = (long)y;
            this.checkIndex1(iy);
            long iz = (long)z;
            this.checkIndex2(iz);
            long it = (long)t;
            this.checkIndex(3, iz);
            return this.array.getDouble(((it * this.dimZ + iz) * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public Boolean isChecked() {
            return true;
        }

        @Override
        public Double outsideValue() {
            return null;
        }

        @Override
        public String toString() {
            return "step function based on " + String.valueOf(this.m);
        }
    }

    static class UncheckedTrivialInterpolation
    extends AbstractInterpolation {
        UncheckedTrivialInterpolation(Matrix<? extends PArray> m) {
            super(m);
        }

        @Override
        public double get(double ... x) {
            if (x.length == 0) {
                throw new IndexOutOfBoundsException("At least 1 argument required");
            }
            int n = this.dim.length < x.length ? this.dim.length - 1 : x.length - 1;
            long index = (long)x[n];
            while (--n >= 0) {
                long coord = (long)x[n];
                index = this.dim[n] * index + coord;
            }
            return this.array.getDouble(index);
        }

        @Override
        public double get(double x) {
            long ix = (long)x;
            return this.array.getDouble(ix);
        }

        @Override
        public double get(double x, double y) {
            long ix = (long)x;
            long iy = (long)y;
            return this.array.getDouble(iy * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z) {
            long ix = (long)x;
            long iy = (long)y;
            long iz = (long)z;
            return this.array.getDouble((iz * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public double get(double x, double y, double z, double t) {
            long ix = (long)x;
            long iy = (long)y;
            long iz = (long)z;
            long it = (long)t;
            return this.array.getDouble(((it * this.dimZ + iz) * this.dimY + iy) * this.dimX + ix);
        }

        @Override
        public Boolean isChecked() {
            return false;
        }

        @Override
        public Double outsideValue() {
            return null;
        }

        @Override
        public String toString() {
            return "step function (unchecked ranges) based on " + String.valueOf(this.m);
        }
    }

    static abstract class AbstractInterpolation
    implements Func {
        final Matrix<? extends PArray> m;
        final PArray array;
        final long[] dim;
        final long dimX;
        final long dimY;
        final long dimZ;
        final int idimX;
        final int idimY;
        final int idimZ;

        AbstractInterpolation(Matrix<? extends PArray> m) {
            Objects.requireNonNull(m, "Null m argument");
            this.m = m;
            this.array = m.array();
            this.dim = m.dimensions();
            this.dimX = m.dimX();
            this.dimY = m.dimY();
            this.dimZ = m.dimZ();
            this.idimX = (int)this.dimX;
            this.idimY = (int)this.dimY;
            this.idimZ = (int)this.dimZ;
        }

        void checkIndex(int coordIndex, long index) {
            if (index < 0L || index >= this.m.dim(coordIndex)) {
                throw new IndexOutOfBoundsException("Coordinate #" + coordIndex + " (" + index + (String)(index < 0L ? ") < 0" : ") >= dim(" + coordIndex + ") = " + this.m.dim(coordIndex)));
            }
        }

        void checkIndex0(long index) {
            if (index < 0L || index >= this.dimX) {
                throw new IndexOutOfBoundsException("X-coordinate (" + index + (String)(index < 0L ? ") < 0" : ") >= dim(0) = " + this.dimX));
            }
        }

        void checkIndex1(long index) {
            if (index < 0L || index >= this.dimY) {
                throw new IndexOutOfBoundsException("Y-coordinate (" + index + (String)(index < 0L ? ") < 0" : ") >= dim(1) = " + this.dimY));
            }
        }

        void checkIndex2(long index) {
            if (index < 0L || index >= this.dimZ) {
                throw new IndexOutOfBoundsException("Z-coordinate (" + index + (String)(index < 0L ? ") < 0" : ") >= dim(2) = " + this.dimZ));
            }
        }

        void checkIntIndex0(int index) {
            if (index < 0 || index >= this.idimX) {
                throw new IndexOutOfBoundsException("X-coordinate (" + index + (String)(index < 0 ? ") < 0" : ") >= dim(0) = " + this.idimX));
            }
        }

        void checkIntIndex1(int index) {
            if (index < 0 || index >= this.idimY) {
                throw new IndexOutOfBoundsException("Y-coordinate (" + index + (String)(index < 0 ? ") < 0" : ") >= dim(1) = " + this.idimY));
            }
        }

        void checkIntIndex2(int index) {
            if (index < 0 || index >= this.idimZ) {
                throw new IndexOutOfBoundsException("Z-coordinate (" + index + (String)(index < 0 ? ") < 0" : ") >= dim(2) = " + this.idimZ));
            }
        }

        @Override
        public final double get() {
            throw new IndexOutOfBoundsException("At least 1 argument required");
        }

        public Matrices.InterpolationMethod getInterpolationMethod() {
            return Matrices.InterpolationMethod.STEP_FUNCTION;
        }

        public abstract Boolean isChecked();

        public abstract Double outsideValue();

        public abstract String toString();
    }
}

