/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.ArrayList;
import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.AbstractUpdatableBitArray;
import net.algart.arrays.AbstractUpdatableByteArray;
import net.algart.arrays.AbstractUpdatableCharArray;
import net.algart.arrays.AbstractUpdatableDoubleArray;
import net.algart.arrays.AbstractUpdatableFloatArray;
import net.algart.arrays.AbstractUpdatableIntArray;
import net.algart.arrays.AbstractUpdatableLongArray;
import net.algart.arrays.AbstractUpdatableShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysAnyCoordFuncGetDataOp;
import net.algart.arrays.ArraysAnyFuncGetDataOp;
import net.algart.arrays.ArraysBitTableGetDataOp;
import net.algart.arrays.ArraysByteTableGetDataOp;
import net.algart.arrays.ArraysDiffGetDataOp;
import net.algart.arrays.ArraysInterpolationsImpl;
import net.algart.arrays.ArraysLinearGetDataOp;
import net.algart.arrays.ArraysLinearSetDataOp;
import net.algart.arrays.ArraysMinMaxGetDataOp;
import net.algart.arrays.ArraysShortTableGetDataOp;
import net.algart.arrays.ArraysTileMatrixImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.CopiesArraysImpl;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixImpl;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

class ArraysFuncImpl {
    private static final long MIN_LENGTH_OF_SHORT_ARRAYS_FOR_TABLE_OPTIMIZATION = 65536L;
    static final int BUFFER_SIZE = 65536;
    static final int BIT_BUFFER_LENGTH = 524288;
    static final int BITS_GAP = 256;
    static final JArrayPool BIT_BUFFERS = JArrayPool.getInstance(Long.TYPE, 8197);
    static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 32768);
    static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 65536);
    static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 32768);
    static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 16384);
    static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 16384);
    static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 16384);
    static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 16384);
    private static final JArrayPool SMALL_LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 256);
    static final int BIT_TYPE_CODE = 1;
    static final int CHAR_TYPE_CODE = 2;
    static final int BYTE_TYPE_CODE = 3;
    static final int SHORT_TYPE_CODE = 4;
    static final int INT_TYPE_CODE = 5;
    static final int LONG_TYPE_CODE = 6;
    static final int FLOAT_TYPE_CODE = 7;
    static final int DOUBLE_TYPE_CODE = 8;

    ArraysFuncImpl() {
    }

    static JArrayPool smallLongBuffers(int length) {
        if (length <= SMALL_LONG_BUFFERS.arrayLength()) {
            return SMALL_LONG_BUFFERS;
        }
        return JArrayPool.getInstance(Long.TYPE, length);
    }

    static <T extends PArray> T asCoordFuncMatrix(boolean truncateOverflows, Func f, Class<? extends T> requiredType, long[] dim) {
        Objects.requireNonNull(f, "Null f argument");
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        if (UpdatableArray.class.isAssignableFrom(requiredType)) {
            throw new IllegalArgumentException("requiredType, " + String.valueOf(requiredType) + ", must not be updatable");
        }
        long len = MatrixImpl.checkDimensions(dim);
        if (f instanceof ConstantFunc) {
            return ArraysFuncImpl.asConstantFuncArray(truncateOverflows, requiredType, f, len);
        }
        if (f instanceof ArraysInterpolationsImpl.AbstractInterpolation) {
            Matrix<? extends PArray> mParent = ((ArraysInterpolationsImpl.AbstractInterpolation)f).m;
            if (!java.util.Arrays.equals(mParent.dimensions(), dim)) {
                mParent = Matrices.isOnlyInsideInterpolationFunc(f) ? mParent.subMatrix(new long[dim.length], dim) : mParent.subMatrix(new long[dim.length], dim, Matrix.ContinuationMode.getConstantMode(Matrices.getOutsideValue(f)));
            }
            if (mParent.elementType() == Arrays.elementType(requiredType)) {
                return (T)((PArray)InternalUtils.cast(mParent.array().asImmutable()));
            }
            return ArraysFuncImpl.asIdentityFuncArray(truncateOverflows, requiredType, Func.IDENTITY, mParent.array());
        }
        if (Arrays.isBitType(requiredType)) {
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncBitArray(truncateOverflows, len, f, dim){

                    @Override
                    public boolean getBit(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)index) != 0.0;
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncBitArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public boolean getBit(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)(index % this.dimX), (double)(index / this.dimX)) != 0.0;
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncBitArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public boolean getBit(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY)) != 0.0;
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncBitArray(truncateOverflows, len, f, dim){

                @Override
                public boolean getBit(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return this.f.get(coordinates) != 0.0;
                }
            }));
        }
        if (Arrays.isCharType(requiredType)) {
            if (truncateOverflows) {
                if (dim.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){

                        @Override
                        public char getChar(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)index);
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }
                    }));
                }
                if (dim.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        {
                            this.dimX = this.dim[0];
                        }

                        @Override
                        public char getChar(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }
                    }));
                }
                if (dim.length == 3) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        final long dimXY;
                        {
                            this.dimX = this.dim[0];
                            this.dimXY = this.dimX * this.dim[1];
                        }

                        @Override
                        public char getChar(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){

                    @Override
                    public char getChar(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        double[] coordinates = new double[this.dim.length];
                        ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                        int v = (int)this.f.get(coordinates);
                        return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }
                }));
            }
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){

                    @Override
                    public char getChar(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (char)this.f.get((double)index);
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public char getChar(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (char)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public char getChar(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (char)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncCharArray(truncateOverflows, len, f, dim){

                @Override
                public char getChar(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (char)this.f.get(coordinates);
                }
            }));
        }
        if (Arrays.isByteType(requiredType)) {
            if (truncateOverflows) {
                if (dim.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){

                        @Override
                        public int getByte(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)index);
                            return v < 0 ? 0 : Math.min(v, 255);
                        }
                    }));
                }
                if (dim.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        {
                            this.dimX = this.dim[0];
                        }

                        @Override
                        public int getByte(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                            return v < 0 ? 0 : Math.min(v, 255);
                        }
                    }));
                }
                if (dim.length == 3) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        final long dimXY;
                        {
                            this.dimX = this.dim[0];
                            this.dimXY = this.dimX * this.dim[1];
                        }

                        @Override
                        public int getByte(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                            return v < 0 ? 0 : Math.min(v, 255);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getByte(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        double[] coordinates = new double[this.dim.length];
                        ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                        int v = (int)this.f.get(coordinates);
                        return v < 0 ? 0 : Math.min(v, 255);
                    }
                }));
            }
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getByte(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)index) & 0xFF;
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public int getByte(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX)) & 0xFF;
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public int getByte(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY)) & 0xFF;
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncByteArray(truncateOverflows, len, f, dim){

                @Override
                public int getByte(long index) {
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (int)this.f.get(coordinates) & 0xFF;
                }
            }));
        }
        if (Arrays.isShortType(requiredType)) {
            if (truncateOverflows) {
                if (dim.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){

                        @Override
                        public int getShort(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)index);
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }
                    }));
                }
                if (dim.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        {
                            this.dimX = this.dim[0];
                        }

                        @Override
                        public int getShort(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }
                    }));
                }
                if (dim.length == 3) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        final long dimXY;
                        {
                            this.dimX = this.dim[0];
                            this.dimXY = this.dimX * this.dim[1];
                        }

                        @Override
                        public int getShort(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            int v = (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getShort(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        double[] coordinates = new double[this.dim.length];
                        ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                        int v = (int)this.f.get(coordinates);
                        return v < 0 ? 0 : Math.min(v, 65535);
                    }
                }));
            }
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getShort(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)index) & 0xFFFF;
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public int getShort(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX)) & 0xFFFF;
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public int getShort(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY)) & 0xFFFF;
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncShortArray(truncateOverflows, len, f, dim){

                @Override
                public int getShort(long index) {
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (int)this.f.get(coordinates) & 0xFFFF;
                }
            }));
        }
        if (Arrays.isIntType(requiredType)) {
            if (truncateOverflows) {
                if (dim.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){

                        @Override
                        public int getInt(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            return (int)this.f.get((double)index);
                        }
                    }));
                }
                if (dim.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        {
                            this.dimX = this.dim[0];
                        }

                        @Override
                        public int getInt(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            return (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                        }
                    }));
                }
                if (dim.length == 3) {
                    return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){
                        final long dimX;
                        final long dimXY;
                        {
                            this.dimX = this.dim[0];
                            this.dimXY = this.dimX * this.dim[1];
                        }

                        @Override
                        public int getInt(long index) {
                            if (index < 0L || index >= this.length) {
                                throw this.rangeException(index);
                            }
                            return (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getInt(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        double[] coordinates = new double[this.dim.length];
                        ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                        return (int)this.f.get(coordinates);
                    }
                }));
            }
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){

                    @Override
                    public int getInt(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)index);
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public int getInt(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public int getInt(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (int)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncIntArray(truncateOverflows, len, f, dim){

                @Override
                public int getInt(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (int)this.f.get(coordinates);
                }
            }));
        }
        if (Arrays.isLongType(requiredType)) {
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncLongArray(truncateOverflows, len, f, dim){

                    @Override
                    public long getLong(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (long)this.f.get((double)index);
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncLongArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public long getLong(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (long)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncLongArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public long getLong(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (long)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncLongArray(truncateOverflows, len, f, dim){

                @Override
                public long getLong(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (long)this.f.get(coordinates);
                }
            }));
        }
        if (Arrays.isFloatType(requiredType)) {
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncFloatArray(truncateOverflows, len, f, dim){

                    @Override
                    public float getFloat(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (float)this.f.get((double)index);
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncFloatArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public float getFloat(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (float)this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncFloatArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public float getFloat(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return (float)this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncFloatArray(truncateOverflows, len, f, dim){

                @Override
                public float getFloat(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return (float)this.f.get(coordinates);
                }
            }));
        }
        if (Arrays.isDoubleType(requiredType)) {
            if (dim.length == 1) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncDoubleArray(truncateOverflows, len, f, dim){

                    @Override
                    public double getDouble(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)index);
                    }
                }));
            }
            if (dim.length == 2) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncDoubleArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    {
                        this.dimX = this.dim[0];
                    }

                    @Override
                    public double getDouble(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)(index % this.dimX), (double)(index / this.dimX));
                    }
                }));
            }
            if (dim.length == 3) {
                return (T)((PArray)InternalUtils.cast(new CoordFuncDoubleArray(truncateOverflows, len, f, dim){
                    final long dimX;
                    final long dimXY;
                    {
                        this.dimX = this.dim[0];
                        this.dimXY = this.dimX * this.dim[1];
                    }

                    @Override
                    public double getDouble(long index) {
                        if (index < 0L || index >= this.length) {
                            throw this.rangeException(index);
                        }
                        return this.f.get((double)(index % this.dimX), (double)(index % this.dimXY / this.dimX), (double)(index / this.dimXY));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new CoordFuncDoubleArray(truncateOverflows, len, f, dim){

                @Override
                public double getDouble(long index) {
                    if (index < 0L || index >= this.length) {
                        throw this.rangeException(index);
                    }
                    double[] coordinates = new double[this.dim.length];
                    ArraysFuncImpl.coordinatesInDoubles(index, this.dim, coordinates);
                    return this.f.get(coordinates);
                }
            }));
        }
        throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray interfaces");
    }

    static <T extends PArray> T asFuncArray(boolean truncateOverflows, Func f, Class<? extends T> requiredType, PArray[] x, long len) {
        boolean quickTableVersion;
        Objects.requireNonNull(f, "Null f argument");
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        if (UpdatableArray.class.isAssignableFrom(requiredType)) {
            throw new IllegalArgumentException("requiredType, " + String.valueOf(requiredType) + ", must not be updatable");
        }
        for (int k = 0; k < x.length; ++k) {
            Objects.requireNonNull(x[k], "Null x[" + k + "] argument");
            if (x[k].length() == len) continue;
            throw new SizeMismatchException("x[" + k + "].length() and x[0].length() mismatch");
        }
        long[] tileDimensions = null;
        long[] baseMatrixDimensions = null;
        for (PArray pArray : x) {
            if (Arrays.isNCopies(pArray)) continue;
            if (!Arrays.isTiled(pArray)) {
                tileDimensions = null;
                break;
            }
            ArraysTileMatrixImpl.TileMatrixArray tma = (ArraysTileMatrixImpl.TileMatrixArray)((Object)pArray);
            if (tileDimensions == null) {
                tileDimensions = tma.tileDimensions();
                baseMatrixDimensions = tma.baseMatrix().dimensions();
                continue;
            }
            if (java.util.Arrays.equals(tileDimensions, tma.tileDimensions()) && java.util.Arrays.equals(baseMatrixDimensions, tma.baseMatrix().dimensions())) continue;
            tileDimensions = null;
            break;
        }
        if (tileDimensions != null) {
            assert (baseMatrixDimensions != null);
            PArray[] baseArrays = new PArray[x.length];
            for (int k = 0; k < x.length; ++k) {
                if (Arrays.isNCopies(x[k])) {
                    baseArrays[k] = x[k];
                    continue;
                }
                assert (Arrays.isTiled(x[k]));
                ArraysTileMatrixImpl.TileMatrixArray tma = (ArraysTileMatrixImpl.TileMatrixArray)((Object)x[k]);
                assert (java.util.Arrays.equals(tileDimensions, tma.tileDimensions()));
                assert (java.util.Arrays.equals(baseMatrixDimensions, tma.baseMatrix().dimensions()));
                baseArrays[k] = (PArray)tma.baseMatrix().array();
            }
            T result = ArraysFuncImpl.asFuncArray(truncateOverflows, f, requiredType, baseArrays, len);
            return (T)((PArray)Matrices.matrix(result, baseMatrixDimensions).tile(tileDimensions).array());
        }
        boolean bl = quickTableVersion = x.length == 1 && (x[0] instanceof BitArray || x[0] instanceof ByteArray);
        if (f == Func.IDENTITY || f == Func.UPDATABLE_IDENTITY) {
            if (x.length < 1) {
                throw new IllegalArgumentException("At least one array is necessary for the identity function");
            }
            if (!quickTableVersion || !(x[0] instanceof BitArray)) {
                return ArraysFuncImpl.asIdentityFuncArray(truncateOverflows, requiredType, f, x[0]);
            }
        }
        if (f instanceof ConstantFunc) {
            return ArraysFuncImpl.asConstantFuncArray(truncateOverflows, requiredType, f, len);
        }
        if (f == Func.POSITIVE_DIFF) {
            if (x.length < 2) {
                throw new IllegalArgumentException("Insufficient number of arrays for the positive difference function");
            }
            Class<?> eType = x[0].elementType();
            if (eType == x[1].elementType() && eType == Arrays.elementType(requiredType) && (eType == Boolean.TYPE || truncateOverflows && (eType == Byte.TYPE || eType == Short.TYPE || eType == Character.TYPE))) {
                return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asSubtractionFunc(truncateOverflows, f, x)));
            }
        }
        if (f == Func.ABS_DIFF) {
            if (x.length < 2) {
                throw new IllegalArgumentException("Insufficient number of arrays for the absolute difference function");
            }
            Class<?> eType = x[0].elementType();
            if (eType != Long.TYPE && eType == x[1].elementType() && eType == Arrays.elementType(requiredType)) {
                return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asAbsDiffFuncArray(truncateOverflows, f, x)));
            }
        }
        if (f instanceof LinearFunc) {
            LinearFunc lf = (LinearFunc)f;
            int n = lf.n();
            if (x.length < n) {
                throw new IllegalArgumentException("Insufficient number of arrays for the linear function");
            }
            double[] dArray = lf.a();
            if (n != dArray.length) {
                throw new IllegalArgumentException("Illegal implementation of the linear function: n()!=a().length");
            }
            double b = lf.b();
            Class<?> eType = x[0].elementType();
            if (n == 1 && b == 1.0 && dArray[0] == -1.0 && eType == Boolean.TYPE && eType == Arrays.elementType(requiredType)) {
                return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asAbsDiffFuncArray(truncateOverflows, lf, x[0], Arrays.nBitCopies(x[0].length(), true))));
            }
            if (n == 2 && b == 0.0 && (dArray[0] == 1.0 && dArray[1] == -1.0 || dArray[0] == -1.0 && dArray[1] == 1.0) && eType != Long.TYPE && eType == x[1].elementType() && eType == Arrays.elementType(requiredType)) {
                if (eType == Boolean.TYPE) {
                    return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asAbsDiffFuncArray(truncateOverflows, lf, x)));
                }
                if (dArray[0] == 1.0) {
                    return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asSubtractionFunc(truncateOverflows, lf, x)));
                }
                return (T)((PArray)InternalUtils.cast(ArraysFuncImpl.asSubtractionFunc(truncateOverflows, lf, x[1], x[0])));
            }
            if (!quickTableVersion || !(x[0] instanceof BitArray) && b == 0.0 && dArray[0] == 1.0) {
                return ArraysFuncImpl.asLinearFuncArray(truncateOverflows, requiredType, lf, x, len);
            }
        }
        if (f == Func.MIN || f == Func.MAX) {
            if (x.length == 0) {
                return ArraysFuncImpl.asConstantFuncArray(truncateOverflows, requiredType, f, len);
            }
            if (x.length == 1) {
                if (!quickTableVersion || !(x[0] instanceof BitArray)) {
                    return ArraysFuncImpl.asIdentityFuncArray(truncateOverflows, requiredType, f, x[0]);
                }
            } else {
                boolean sameType = true;
                for (int k = 1; k < x.length; ++k) {
                    if (x[k].elementType() == x[0].elementType()) continue;
                    sameType = false;
                }
                if (sameType) {
                    PArray result;
                    x = ArraysFuncImpl.addUnderlyingArraysWithSameMinMaxFunc(f, x);
                    PArray pArray = result = f == Func.MIN ? ArraysFuncImpl.asMinFuncArray(f, x) : ArraysFuncImpl.asMaxFuncArray(f, x);
                    if (result.elementType() == Arrays.elementType(requiredType)) {
                        return (T)((PArray)InternalUtils.cast(result));
                    }
                    return ArraysFuncImpl.asIdentityFuncArray(truncateOverflows, requiredType, Func.IDENTITY, result);
                }
            }
        }
        if (Arrays.isBitType(requiredType)) {
            if (x.length == 1) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final boolean v0;
                        final boolean v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 1);
                            this.v0 = this.tgdo.booleanTable[0];
                            this.v1 = this.tgdo.booleanTable[1];
                        }

                        @Override
                        public boolean getBit(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final boolean[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 1);
                            this.v = this.tgdo.booleanTable;
                        }

                        @Override
                        public boolean getBit(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray && quickTableVersion) {
                    return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final boolean[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 1);
                            this.v = this.tgdo.booleanTable;
                        }

                        @Override
                        public boolean getBit(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public boolean getBit(long index) {
                        return this.f.get(this.x[0].getDouble(index)) != 0.0;
                    }
                }));
            }
            if (x.length == 2) {
                return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public boolean getBit(long index) {
                        return this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index)) != 0.0;
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){

                @Override
                public boolean getBit(long index) {
                    double[] args = new double[this.x.length];
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return this.f.get(args) != 0.0;
                }
            }));
        }
        if (Arrays.isCharType(requiredType)) {
            if (x.length == 1 && quickTableVersion) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final char v0;
                        final char v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 2);
                            this.v0 = this.tgdo.charTable[0];
                            this.v1 = this.tgdo.charTable[1];
                        }

                        @Override
                        public char getChar(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final char[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 2);
                            this.v = this.tgdo.charTable;
                        }

                        @Override
                        public char getChar(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final char[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 2);
                            this.v = this.tgdo.charTable;
                        }

                        @Override
                        public char getChar(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
            } else {
                if (truncateOverflows) {
                    if (x.length == 1) {
                        return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public char getChar(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index));
                                return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                            }
                        }));
                    }
                    if (x.length == 2) {
                        return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public char getChar(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                                return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                            }
                        }));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public char getChar(long index) {
                            double[] args = new double[this.x.length];
                            for (int k = 0; k < this.x.length; ++k) {
                                args[k] = this.x[k].getDouble(index);
                            }
                            int v = (int)this.f.get(args);
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }
                    }));
                }
                if (x.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public char getChar(long index) {
                            return (char)this.f.get(this.x[0].getDouble(index));
                        }
                    }));
                }
                if (x.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public char getChar(long index) {
                            return (char)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public char getChar(long index) {
                        double[] args = new double[this.x.length];
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        return (char)this.f.get(args);
                    }
                }));
            }
        }
        if (Arrays.isByteType(requiredType)) {
            if (x.length == 1 && quickTableVersion) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final int v0;
                        final int v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 3);
                            this.v0 = this.tgdo.byteTable[0] & 0xFF;
                            this.v1 = this.tgdo.byteTable[1] & 0xFF;
                        }

                        @Override
                        public int getByte(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final byte[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 3);
                            this.v = this.tgdo.byteTable;
                        }

                        @Override
                        public int getByte(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF] & 0xFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final byte[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 3);
                            this.v = this.tgdo.byteTable;
                        }

                        @Override
                        public int getByte(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF] & 0xFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
            } else {
                if (truncateOverflows) {
                    if (x.length == 1) {
                        return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getByte(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index));
                                return v < 0 ? 0 : Math.min(v, 255);
                            }
                        }));
                    }
                    if (x.length == 2) {
                        return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getByte(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                                return v < 0 ? 0 : Math.min(v, 255);
                            }
                        }));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getByte(long index) {
                            double[] args = new double[this.x.length];
                            for (int k = 0; k < this.x.length; ++k) {
                                args[k] = this.x[k].getDouble(index);
                            }
                            int v = (int)this.f.get(args);
                            return v < 0 ? 0 : Math.min(v, 255);
                        }
                    }));
                }
                if (x.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getByte(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index)) & 0xFF;
                        }
                    }));
                }
                if (x.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getByte(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index)) & 0xFF;
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public int getByte(long index) {
                        double[] args = new double[this.x.length];
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        return (int)this.f.get(args) & 0xFF;
                    }
                }));
            }
        }
        if (Arrays.isShortType(requiredType)) {
            if (x.length == 1 && quickTableVersion) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final int v0;
                        final int v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 4);
                            this.v0 = this.tgdo.shortTable[0] & 0xFFFF;
                            this.v1 = this.tgdo.shortTable[1] & 0xFFFF;
                        }

                        @Override
                        public int getShort(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final short[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 4);
                            this.v = this.tgdo.shortTable;
                        }

                        @Override
                        public int getShort(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF] & 0xFFFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final short[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 4);
                            this.v = this.tgdo.shortTable;
                        }

                        @Override
                        public int getShort(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF] & 0xFFFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
            } else {
                if (truncateOverflows) {
                    if (x.length == 1) {
                        return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getShort(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index));
                                return v < 0 ? 0 : Math.min(v, 65535);
                            }
                        }));
                    }
                    if (x.length == 2) {
                        return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getShort(long index) {
                                int v = (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                                return v < 0 ? 0 : Math.min(v, 65535);
                            }
                        }));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getShort(long index) {
                            double[] args = new double[this.x.length];
                            for (int k = 0; k < this.x.length; ++k) {
                                args[k] = this.x[k].getDouble(index);
                            }
                            int v = (int)this.f.get(args);
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }
                    }));
                }
                if (x.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getShort(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index)) & 0xFFFF;
                        }
                    }));
                }
                if (x.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getShort(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index)) & 0xFFFF;
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public int getShort(long index) {
                        double[] args = new double[this.x.length];
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        return (int)this.f.get(args) & 0xFFFF;
                    }
                }));
            }
        }
        if (Arrays.isIntType(requiredType)) {
            if (x.length == 1 && quickTableVersion) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final int v0;
                        final int v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 5);
                            this.v0 = this.tgdo.intTable[0];
                            this.v1 = this.tgdo.intTable[1];
                        }

                        @Override
                        public int getInt(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final int[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 5);
                            this.v = this.tgdo.intTable;
                        }

                        @Override
                        public int getInt(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final int[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 5);
                            this.v = this.tgdo.intTable;
                        }

                        @Override
                        public int getInt(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
            } else {
                if (truncateOverflows) {
                    if (x.length == 1) {
                        return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getInt(long index) {
                                return (int)this.f.get(this.x[0].getDouble(index));
                            }
                        }));
                    }
                    if (x.length == 2) {
                        return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                            @Override
                            public int getInt(long index) {
                                return (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                            }
                        }));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getInt(long index) {
                            double[] args = new double[this.x.length];
                            for (int k = 0; k < this.x.length; ++k) {
                                args[k] = this.x[k].getDouble(index);
                            }
                            return (int)this.f.get(args);
                        }
                    }));
                }
                if (x.length == 1) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getInt(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index));
                        }
                    }));
                }
                if (x.length == 2) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                        @Override
                        public int getInt(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public int getInt(long index) {
                        double[] args = new double[this.x.length];
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        return (int)this.f.get(args);
                    }
                }));
            }
        }
        if (Arrays.isLongType(requiredType)) {
            if (x.length == 1) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final long v0;
                        final long v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 6);
                            this.v0 = this.tgdo.longTable[0];
                            this.v1 = this.tgdo.longTable[1];
                        }

                        @Override
                        public long getLong(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final long[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 6);
                            this.v = this.tgdo.longTable;
                        }

                        @Override
                        public long getLong(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray && quickTableVersion) {
                    return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final long[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 6);
                            this.v = this.tgdo.longTable;
                        }

                        @Override
                        public long getLong(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public long getLong(long index) {
                        return (long)this.f.get(this.x[0].getDouble(index));
                    }
                }));
            }
            if (x.length == 2) {
                return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public long getLong(long index) {
                        return (long)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){

                @Override
                public long getLong(long index) {
                    double[] args = new double[this.x.length];
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (long)this.f.get(args);
                }
            }));
        }
        if (Arrays.isFloatType(requiredType)) {
            if (x.length == 1) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final float v0;
                        final float v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 7);
                            this.v0 = this.tgdo.floatTable[0];
                            this.v1 = this.tgdo.floatTable[1];
                        }

                        @Override
                        public float getFloat(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final float[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 7);
                            this.v = this.tgdo.floatTable;
                        }

                        @Override
                        public float getFloat(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray && quickTableVersion) {
                    return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final float[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 7);
                            this.v = this.tgdo.floatTable;
                        }

                        @Override
                        public float getFloat(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public float getFloat(long index) {
                        return (float)this.f.get(this.x[0].getDouble(index));
                    }
                }));
            }
            if (x.length == 2) {
                return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public float getFloat(long index) {
                        return (float)this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){

                @Override
                public float getFloat(long index) {
                    double[] args = new double[this.x.length];
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (float)this.f.get(args);
                }
            }));
        }
        if (Arrays.isDoubleType(requiredType)) {
            if (x.length == 1) {
                if (x[0] instanceof BitArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                        final BitArray x0;
                        final ArraysBitTableGetDataOp tgdo;
                        final double v0;
                        final double v1;
                        {
                            this.x0 = (BitArray)this.x[0];
                            this.tgdo = new ArraysBitTableGetDataOp(this.truncateOverflows, this.x0, this.f, 8);
                            this.v0 = this.tgdo.doubleTable[0];
                            this.v1 = this.tgdo.doubleTable[1];
                        }

                        @Override
                        public double getDouble(long index) {
                            return this.x0.getBit(index) ? this.v1 : this.v0;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ByteArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                        final ByteArray x0;
                        final ArraysByteTableGetDataOp tgdo;
                        final double[] v;
                        {
                            this.x0 = (ByteArray)this.x[0];
                            this.tgdo = new ArraysByteTableGetDataOp(this.truncateOverflows, this.x0, this.f, 8);
                            this.v = this.tgdo.doubleTable;
                        }

                        @Override
                        public double getDouble(long index) {
                            return this.v[this.x0.getByte(index) & 0xFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (x[0] instanceof ShortArray && quickTableVersion) {
                    return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                        final ShortArray x0;
                        final ArraysShortTableGetDataOp tgdo;
                        final double[] v;
                        {
                            this.x0 = (ShortArray)this.x[0];
                            this.tgdo = new ArraysShortTableGetDataOp(this.truncateOverflows, this.x0, this.f, 8);
                            this.v = this.tgdo.doubleTable;
                        }

                        @Override
                        public double getDouble(long index) {
                            return this.v[this.x0.getShort(index) & 0xFFFF];
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.tgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public double getDouble(long index) {
                        return this.f.get(this.x[0].getDouble(index));
                    }
                }));
            }
            if (x.length == 2) {
                return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){

                    @Override
                    public double getDouble(long index) {
                        return this.f.get(this.x[0].getDouble(index), this.x[1].getDouble(index));
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){

                @Override
                public double getDouble(long index) {
                    double[] args = new double[this.x.length];
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return this.f.get(args);
                }
            }));
        }
        throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray interfaces");
    }

    static <T extends UpdatablePArray> T asUpdatableFuncArray(boolean truncateOverflows, Func.Updatable f, Class<? extends T> requiredType, UpdatablePArray[] x) {
        Objects.requireNonNull(f, "Null f argument");
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        if (MutableArray.class.isAssignableFrom(requiredType)) {
            throw new IllegalArgumentException("requiredType, " + String.valueOf(requiredType) + ", must not be resizable");
        }
        if (x.length == 0) {
            throw new IllegalArgumentException("Empty x[] (array of AlgART arrays)");
        }
        long len = x[0].length();
        for (int k = 0; k < x.length; ++k) {
            Objects.requireNonNull(x[k], "Null x[" + k + "] argument");
            if (x[k].length() == len) continue;
            throw new SizeMismatchException("x[" + k + "].length() and x[0].length() mismatch");
        }
        if (f == Func.UPDATABLE_IDENTITY) {
            return ArraysFuncImpl.asUpdatableIdentityFunc(truncateOverflows, requiredType, f, x[0]);
        }
        if (f instanceof LinearFunc.Updatable) {
            LinearFunc.Updatable ulf = (LinearFunc.Updatable)f;
            int n = ulf.n();
            if (x.length < n) {
                throw new IllegalArgumentException("Insufficient number of arrays for the updatable linear function");
            }
            if (n == 1) {
                return ArraysFuncImpl.asUpdatableLinearFunc(truncateOverflows, requiredType, ulf, x[0]);
            }
        }
        final boolean[] truncateInSet = new boolean[x.length];
        final boolean[] longPrecisionInSet = new boolean[x.length];
        final double[] minXElement = new double[x.length];
        final double[] maxXElement = new double[x.length];
        for (int k = 0; k < x.length; ++k) {
            truncateInSet[k] = truncateOverflows && x[k] instanceof PFixedArray && !(x[k] instanceof LongArray) && !(x[k] instanceof BitArray);
            longPrecisionInSet[k] = !truncateOverflows && x[k] instanceof PFixedArray && !(x[k] instanceof LongArray) && !(x[k] instanceof BitArray);
            minXElement[k] = truncateInSet[k] ? (double)((PFixedArray)((Object)x[k])).minPossibleValue() : Double.MIN_VALUE;
            maxXElement[k] = truncateInSet[k] ? (double)((PFixedArray)((Object)x[k])).maxPossibleValue() : Double.MAX_VALUE;
        }
        final double[] args = new double[x.length];
        if (Arrays.isBitType(requiredType)) {
            if (x.length == 1) {
                final double[] argsFalse = args;
                final double[] argsTrue = new double[1];
                f.set(argsFalse, 0.0);
                f.set(argsTrue, 1.0);
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncBitArray(truncateOverflows, len, f, x){

                    @Override
                    public boolean getBit(long index) {
                        return this.f.get(this.x[0].getDouble(index)) != 0.0;
                    }

                    @Override
                    public void setBit(long index, boolean value) {
                        if (truncateInSet[0]) {
                            double v = value ? argsTrue[0] : argsFalse[0];
                            this.x[0].setDouble(index, v < minXElement[0] ? minXElement[0] : Math.min(v, maxXElement[0]));
                        } else {
                            this.x[0].setDouble(index, value ? argsTrue[0] : argsFalse[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncBitArray(truncateOverflows, len, f, x){

                @Override
                public boolean getBit(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return this.f.get(args) != 0.0;
                }

                @Override
                public void setBit(long index, boolean value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value ? 1.0 : 0.0);
                    for (k = 0; k < this.x.length; ++k) {
                        if (truncateInSet[k]) {
                            double v = args[k];
                            this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isCharType(requiredType)) {
            if (truncateOverflows) {
                if (x.length == 1) {
                    return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, len, f, x){

                        @Override
                        public char getChar(long index) {
                            int v = (int)this.f.get(this.x[0].getDouble(index));
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }

                        @Override
                        public void setChar(long index, char value) {
                            this.f.set(args, value);
                            if (truncateInSet[0]) {
                                this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                            } else {
                                this.x[0].setDouble(index, args[0]);
                            }
                        }
                    }));
                }
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, len, f, x){

                    @Override
                    public char getChar(long index) {
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        int v = (int)this.f.get(args);
                        return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }

                    @Override
                    public void setChar(long index, char value) {
                        int k;
                        for (k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        this.f.set(args, value);
                        for (k = 0; k < this.x.length; ++k) {
                            if (truncateInSet[k]) {
                                double v = args[k];
                                this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                                continue;
                            }
                            this.x[k].setDouble(index, args[k]);
                        }
                    }
                }));
            }
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, len, f, x){

                    @Override
                    public char getChar(long index) {
                        return (char)this.f.get(this.x[0].getDouble(index));
                    }

                    @Override
                    public void setChar(long index, char value) {
                        this.f.set(args, value);
                        if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, len, f, x){

                @Override
                public char getChar(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (char)this.f.get(args);
                }

                @Override
                public void setChar(long index, char value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value);
                    for (k = 0; k < this.x.length; ++k) {
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isByteType(requiredType)) {
            if (truncateOverflows) {
                if (x.length == 1) {
                    return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, len, f, x){

                        @Override
                        public int getByte(long index) {
                            int v = (int)this.f.get(this.x[0].getDouble(index));
                            return v < 0 ? 0 : Math.min(v, 255);
                        }

                        @Override
                        public void setByte(long index, byte value) {
                            this.f.set(args, value & 0xFF);
                            if (truncateInSet[0]) {
                                this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                            } else {
                                this.x[0].setDouble(index, args[0]);
                            }
                        }
                    }));
                }
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, len, f, x){

                    @Override
                    public int getByte(long index) {
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        int v = (int)this.f.get(args);
                        return v < 0 ? 0 : Math.min(v, 255);
                    }

                    @Override
                    public void setByte(long index, byte value) {
                        int k;
                        for (k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        this.f.set(args, value & 0xFF);
                        for (k = 0; k < this.x.length; ++k) {
                            if (truncateInSet[k]) {
                                double v = args[k];
                                this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                                continue;
                            }
                            this.x[k].setDouble(index, args[k]);
                        }
                    }
                }));
            }
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, len, f, x){

                    @Override
                    public int getByte(long index) {
                        return (int)this.f.get(this.x[0].getDouble(index)) & 0xFF;
                    }

                    @Override
                    public void setByte(long index, byte value) {
                        this.f.set(args, value & 0xFF);
                        if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, len, f, x){

                @Override
                public int getByte(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (int)this.f.get(args) & 0xFF;
                }

                @Override
                public void setByte(long index, byte value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value & 0xFF);
                    for (k = 0; k < this.x.length; ++k) {
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isShortType(requiredType)) {
            if (truncateOverflows) {
                if (x.length == 1) {
                    return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, len, f, x){

                        @Override
                        public int getShort(long index) {
                            int v = (int)this.f.get(this.x[0].getDouble(index));
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }

                        @Override
                        public void setShort(long index, short value) {
                            this.f.set(args, value & 0xFFFF);
                            if (truncateInSet[0]) {
                                this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                            } else {
                                this.x[0].setDouble(index, args[0]);
                            }
                        }
                    }));
                }
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, len, f, x){

                    @Override
                    public int getShort(long index) {
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        int v = (int)this.f.get(args);
                        return v < 0 ? 0 : Math.min(v, 65535);
                    }

                    @Override
                    public void setShort(long index, short value) {
                        int k;
                        for (k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        this.f.set(args, value & 0xFFFF);
                        for (k = 0; k < this.x.length; ++k) {
                            if (truncateInSet[k]) {
                                double v = args[k];
                                this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                                continue;
                            }
                            this.x[k].setDouble(index, args[k]);
                        }
                    }
                }));
            }
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, len, f, x){

                    @Override
                    public int getShort(long index) {
                        return (int)this.f.get(this.x[0].getDouble(index)) & 0xFFFF;
                    }

                    @Override
                    public void setShort(long index, short value) {
                        this.f.set(args, value & 0xFFFF);
                        if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, len, f, x){

                @Override
                public int getShort(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (int)this.f.get(args) & 0xFFFF;
                }

                @Override
                public void setShort(long index, short value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value & 0xFFFF);
                    for (k = 0; k < this.x.length; ++k) {
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isIntType(requiredType)) {
            if (truncateOverflows) {
                if (x.length == 1) {
                    return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, len, f, x){

                        @Override
                        public int getInt(long index) {
                            return (int)this.f.get(this.x[0].getDouble(index));
                        }

                        @Override
                        public void setInt(long index, int value) {
                            this.f.set(args, value);
                            if (truncateInSet[0]) {
                                this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                            } else {
                                this.x[0].setDouble(index, args[0]);
                            }
                        }
                    }));
                }
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, len, f, x){

                    @Override
                    public int getInt(long index) {
                        for (int k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        return (int)this.f.get(args);
                    }

                    @Override
                    public void setInt(long index, int value) {
                        int k;
                        for (k = 0; k < this.x.length; ++k) {
                            args[k] = this.x[k].getDouble(index);
                        }
                        this.f.set(args, value);
                        for (k = 0; k < this.x.length; ++k) {
                            if (truncateInSet[k]) {
                                double v = args[k];
                                this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                                continue;
                            }
                            this.x[k].setDouble(index, args[k]);
                        }
                    }
                }));
            }
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, len, f, x){

                    @Override
                    public int getInt(long index) {
                        return (int)this.f.get(this.x[0].getDouble(index));
                    }

                    @Override
                    public void setInt(long index, int value) {
                        this.f.set(args, value);
                        if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, len, f, x){

                @Override
                public int getInt(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (int)this.f.get(args);
                }

                @Override
                public void setInt(long index, int value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value);
                    for (k = 0; k < this.x.length; ++k) {
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isLongType(requiredType)) {
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncLongArray(truncateOverflows, len, f, x){

                    @Override
                    public long getLong(long index) {
                        return (long)this.f.get(this.x[0].getDouble(index));
                    }

                    @Override
                    public void setLong(long index, long value) {
                        this.f.set(args, value);
                        if (truncateInSet[0]) {
                            this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                        } else if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncLongArray(truncateOverflows, len, f, x){

                @Override
                public long getLong(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (long)this.f.get(args);
                }

                @Override
                public void setLong(long index, long value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value);
                    for (k = 0; k < this.x.length; ++k) {
                        if (truncateInSet[k]) {
                            double v = args[k];
                            this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                            continue;
                        }
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isFloatType(requiredType)) {
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncFloatArray(truncateOverflows, len, f, x){

                    @Override
                    public float getFloat(long index) {
                        return (float)this.f.get(this.x[0].getDouble(index));
                    }

                    @Override
                    public void setFloat(long index, float value) {
                        this.f.set(args, value);
                        if (truncateInSet[0]) {
                            this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                        } else if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncFloatArray(truncateOverflows, len, f, x){

                @Override
                public float getFloat(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return (float)this.f.get(args);
                }

                @Override
                public void setFloat(long index, float value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value);
                    for (k = 0; k < this.x.length; ++k) {
                        if (truncateInSet[k]) {
                            double v = args[k];
                            this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                            continue;
                        }
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        if (Arrays.isDoubleType(requiredType)) {
            if (x.length == 1) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncDoubleArray(truncateOverflows, len, f, x){

                    @Override
                    public double getDouble(long index) {
                        return this.f.get(this.x[0].getDouble(index));
                    }

                    @Override
                    public void setDouble(long index, double value) {
                        this.f.set(args, value);
                        if (truncateInSet[0]) {
                            this.x[0].setDouble(index, args[0] < minXElement[0] ? minXElement[0] : Math.min(args[0], maxXElement[0]));
                        } else if (longPrecisionInSet[0]) {
                            this.x[0].setLong(index, (long)args[0]);
                        } else {
                            this.x[0].setDouble(index, args[0]);
                        }
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncDoubleArray(truncateOverflows, len, f, x){

                @Override
                public double getDouble(long index) {
                    for (int k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    return this.f.get(args);
                }

                @Override
                public void setDouble(long index, double value) {
                    int k;
                    for (k = 0; k < this.x.length; ++k) {
                        args[k] = this.x[k].getDouble(index);
                    }
                    this.f.set(args, value);
                    for (k = 0; k < this.x.length; ++k) {
                        if (truncateInSet[k]) {
                            double v = args[k];
                            this.x[k].setDouble(index, v < minXElement[k] ? minXElement[k] : Math.min(v, maxXElement[k]));
                            continue;
                        }
                        if (longPrecisionInSet[k]) {
                            this.x[k].setLong(index, (long)args[k]);
                            continue;
                        }
                        this.x[k].setDouble(index, args[k]);
                    }
                }
            }));
        }
        throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray or UpdatableXxxArray interfaces");
    }

    private static <T extends PArray> PArray asMinFuncArray(Func f, PArray ... x) {
        if (x.length == 0) {
            throw new IllegalArgumentException("Empty x array");
        }
        if (x[0] instanceof BitArray) {
            final BitArray[] xClone = (BitArray[])ArraysFuncImpl.assertTypeAndCast(BitArray.class, (Array[])x);
            return new FuncBitArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, null, true);
                }

                @Override
                public boolean getBit(long index) {
                    boolean result = xClone[0].getBit(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        result &= xClone[k].getBit(index);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                    this.mmgdo.getBits(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public long nextQuickPosition(long position) {
                    return xClone[0].nextQuickPosition(position);
                }
            };
        }
        if (x[0] instanceof ByteArray) {
            final ByteArray[] xClone = (ByteArray[])ArraysFuncImpl.assertTypeAndCast(ByteArray.class, (Array[])x);
            return new FuncByteArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getByteMinOp(), true);
                }

                @Override
                public int getByte(long index) {
                    int result = xClone[0].getByte(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getByte(index);
                        if (v >= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof CharArray) {
            final CharArray[] xClone = (CharArray[])ArraysFuncImpl.assertTypeAndCast(CharArray.class, (Array[])x);
            return new FuncCharArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getCharMinOp(), true);
                }

                @Override
                public char getChar(long index) {
                    char result = xClone[0].getChar(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        char v = xClone[k].getChar(index);
                        if (v >= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof ShortArray) {
            final ShortArray[] xClone = (ShortArray[])ArraysFuncImpl.assertTypeAndCast(ShortArray.class, (Array[])x);
            return new FuncShortArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getShortMinOp(), true);
                }

                @Override
                public int getShort(long index) {
                    int result = xClone[0].getShort(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getShort(index);
                        if (v >= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof IntArray) {
            final IntArray[] xClone = (IntArray[])ArraysFuncImpl.assertTypeAndCast(IntArray.class, (Array[])x);
            return new FuncIntArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getIntMinOp(), true);
                }

                @Override
                public int getInt(long index) {
                    int result = xClone[0].getInt(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getInt(index);
                        if (v >= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof LongArray) {
            final LongArray[] xClone = (LongArray[])ArraysFuncImpl.assertTypeAndCast(LongArray.class, (Array[])x);
            return new FuncLongArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getLongMinOp(), true);
                }

                @Override
                public long getLong(long index) {
                    long result = xClone[0].getLong(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        long v = xClone[k].getLong(index);
                        if (v >= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof FloatArray) {
            final FloatArray[] xClone = (FloatArray[])ArraysFuncImpl.assertTypeAndCast(FloatArray.class, (Array[])x);
            return new FuncFloatArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getFloatMinOp(), true);
                }

                @Override
                public float getFloat(long index) {
                    float result = xClone[0].getFloat(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        float v = xClone[k].getFloat(index);
                        if (!(v < result)) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof DoubleArray) {
            final DoubleArray[] xClone = (DoubleArray[])ArraysFuncImpl.assertTypeAndCast(DoubleArray.class, (Array[])x);
            return new FuncDoubleArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getDoubleMinOp(), true);
                }

                @Override
                public double getDouble(long index) {
                    double result = xClone[0].getDouble(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        double v = xClone[k].getDouble(index);
                        if (!(v < result)) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        throw new IllegalArgumentException("Illegal array type (" + String.valueOf(x[0]) + "): it must implement one of primitive XxxArray interfaces");
    }

    private static <T extends PArray> PArray asMaxFuncArray(Func f, PArray ... x) {
        if (x.length == 0) {
            throw new IllegalArgumentException("Empty x array");
        }
        if (x[0] instanceof BitArray) {
            final BitArray[] xClone = (BitArray[])ArraysFuncImpl.assertTypeAndCast(BitArray.class, (Array[])x);
            return new FuncBitArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, null, false);
                }

                @Override
                public boolean getBit(long index) {
                    boolean result = xClone[0].getBit(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        result |= xClone[k].getBit(index);
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                    this.mmgdo.getBits(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public long nextQuickPosition(long position) {
                    return xClone[0].nextQuickPosition(position);
                }
            };
        }
        if (x[0] instanceof ByteArray) {
            final ByteArray[] xClone = (ByteArray[])ArraysFuncImpl.assertTypeAndCast(ByteArray.class, (Array[])x);
            return new FuncByteArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getByteMaxOp(), false);
                }

                @Override
                public int getByte(long index) {
                    int result = xClone[0].getByte(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getByte(index);
                        if (v <= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof CharArray) {
            final CharArray[] xClone = (CharArray[])ArraysFuncImpl.assertTypeAndCast(CharArray.class, (Array[])x);
            return new FuncCharArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getCharMaxOp(), false);
                }

                @Override
                public char getChar(long index) {
                    char result = xClone[0].getChar(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        char v = xClone[k].getChar(index);
                        if (v <= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof ShortArray) {
            final ShortArray[] xClone = (ShortArray[])ArraysFuncImpl.assertTypeAndCast(ShortArray.class, (Array[])x);
            return new FuncShortArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getShortMaxOp(), false);
                }

                @Override
                public int getShort(long index) {
                    int result = xClone[0].getShort(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getShort(index);
                        if (v <= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof IntArray) {
            final IntArray[] xClone = (IntArray[])ArraysFuncImpl.assertTypeAndCast(IntArray.class, (Array[])x);
            return new FuncIntArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getIntMaxOp(), false);
                }

                @Override
                public int getInt(long index) {
                    int result = xClone[0].getInt(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        int v = xClone[k].getInt(index);
                        if (v <= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof LongArray) {
            final LongArray[] xClone = (LongArray[])ArraysFuncImpl.assertTypeAndCast(LongArray.class, (Array[])x);
            return new FuncLongArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getLongMaxOp(), false);
                }

                @Override
                public long getLong(long index) {
                    long result = xClone[0].getLong(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        long v = xClone[k].getLong(index);
                        if (v <= result) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof FloatArray) {
            final FloatArray[] xClone = (FloatArray[])ArraysFuncImpl.assertTypeAndCast(FloatArray.class, (Array[])x);
            return new FuncFloatArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getFloatMaxOp(), false);
                }

                @Override
                public float getFloat(long index) {
                    float result = xClone[0].getFloat(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        float v = xClone[k].getFloat(index);
                        if (!(v > result)) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof DoubleArray) {
            final DoubleArray[] xClone = (DoubleArray[])ArraysFuncImpl.assertTypeAndCast(DoubleArray.class, (Array[])x);
            return new FuncDoubleArrayWithArguments(false, x[0].length(), f, x){
                final ArraysMinMaxGetDataOp mmgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.mmgdo = new ArraysMinMaxGetDataOp(this, xClone, ArraysMinMaxGetDataOp.getDoubleMaxOp(), false);
                }

                @Override
                public double getDouble(long index) {
                    double result = xClone[0].getDouble(index);
                    for (int k = 1; k < xClone.length; ++k) {
                        double v = xClone[k].getDouble(index);
                        if (!(v > result)) continue;
                        result = v;
                    }
                    return result;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.mmgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        throw new IllegalArgumentException("Illegal array type (" + String.valueOf(x[0]) + "): it must implement one of primitive XxxArray interfaces");
    }

    private static <T extends PArray> T asLinearFuncArray(boolean truncateOverflows, Class<? extends T> requiredType, Func f, PArray[] x, long len) {
        LinearFunc lf;
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        if (UpdatableArray.class.isAssignableFrom(requiredType)) {
            throw new IllegalArgumentException("requiredType must not be updatable");
        }
        if (f == Func.IDENTITY || f == Func.UPDATABLE_IDENTITY || x.length == 1 && (f == Func.MIN || f == Func.MAX)) {
            lf = LinearFunc.getInstance(0.0, 1.0);
        } else if (f instanceof ConstantFunc || x.length == 0 && (f == Func.MIN || f == Func.MAX)) {
            lf = LinearFunc.getInstance(f.get(), new double[0]);
        } else if (f instanceof LinearFunc) {
            lf = (LinearFunc)f;
        } else {
            throw new AssertionError((Object)("asLinearFunc is called for unsupported function " + String.valueOf(f)));
        }
        final int n = lf.n();
        final double b = lf.b();
        boolean allAZeroes = true;
        for (int k = 0; k < n; ++k) {
            Objects.requireNonNull(x[k], "Null x[" + k + "] argument");
            if (lf.a(k) == 0.0) continue;
            allAZeroes = false;
        }
        if (n <= 1 || allAZeroes) {
            double a0;
            double d = a0 = n == 0 ? 0.0 : lf.a(0);
            if (Arrays.isBitType(requiredType)) {
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesBitArray(len, b != 0.0, truncateOverflows, f)));
                }
                return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 1);
                    }

                    @Override
                    public boolean getBit(long index) {
                        return a0 * this.x0.getDouble(index) != -b;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isCharType(requiredType)) {
                if (truncateOverflows) {
                    if (allAZeroes) {
                        int v = (int)b;
                        return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesCharArray(len, v < 0 ? (char)'\u0000' : (v > 65535 ? (char)'\uffff' : (char)v), truncateOverflows, f)));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                        }

                        @Override
                        public char getChar(long index) {
                            int v = (int)(a0 * this.x0.getDouble(index) + b);
                            return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesCharArray(len, (char)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0 && x[0] instanceof PFixedArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                        final PFixedArray x0Fix;
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.x0Fix = (PFixedArray)this.x0;
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                        }

                        @Override
                        public char getChar(long index) {
                            return (char)this.x0Fix.getLong(index);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                    }

                    @Override
                    public char getChar(long index) {
                        return (char)(a0 * this.x0.getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isByteType(requiredType)) {
                if (truncateOverflows) {
                    if (allAZeroes) {
                        int v = (int)b;
                        return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesByteArray(len, (byte)(v < 0 ? 0 : Math.min(v, 255)), truncateOverflows, f)));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                        }

                        @Override
                        public int getByte(long index) {
                            int v = (int)(a0 * this.x0.getDouble(index) + b);
                            return v < 0 ? 0 : Math.min(v, 255);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesByteArray(len, (byte)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0 && x[0] instanceof PFixedArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                        final PFixedArray x0Fix;
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.x0Fix = (PFixedArray)this.x0;
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                        }

                        @Override
                        public int getByte(long index) {
                            return (int)this.x0Fix.getLong(index) & 0xFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                    }

                    @Override
                    public int getByte(long index) {
                        return (int)(a0 * this.x0.getDouble(index) + b) & 0xFF;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isShortType(requiredType)) {
                if (truncateOverflows) {
                    if (allAZeroes) {
                        int v = (int)b;
                        return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesShortArray(len, (short)(v < 0 ? 0 : Math.min(v, 65535)), truncateOverflows, f)));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                        }

                        @Override
                        public int getShort(long index) {
                            int v = (int)(a0 * this.x0.getDouble(index) + b);
                            return v < 0 ? 0 : Math.min(v, 65535);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesShortArray(len, (short)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0 && x[0] instanceof PFixedArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                        final PFixedArray x0Fix;
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.x0Fix = (PFixedArray)this.x0;
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                        }

                        @Override
                        public int getShort(long index) {
                            return (int)this.x0Fix.getLong(index) & 0xFFFF;
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                    }

                    @Override
                    public int getShort(long index) {
                        return (int)(a0 * this.x0.getDouble(index) + b) & 0xFFFF;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isIntType(requiredType)) {
                if (truncateOverflows) {
                    if (allAZeroes) {
                        return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesIntArray(len, (int)b, truncateOverflows, f)));
                    }
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                        }

                        @Override
                        public int getInt(long index) {
                            return (int)(a0 * this.x0.getDouble(index) + b);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesIntArray(len, (int)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0 && x[0] instanceof PFixedArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                        final PFixedArray x0Fix;
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.x0Fix = (PFixedArray)this.x0;
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                        }

                        @Override
                        public int getInt(long index) {
                            return (int)this.x0Fix.getLong(index);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                    }

                    @Override
                    public int getInt(long index) {
                        return (int)(a0 * this.x0.getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isLongType(requiredType)) {
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesLongArray(len, (long)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0 && x[0] instanceof PFixedArray) {
                    return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                        final PFixedArray x0Fix;
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.x0Fix = (PFixedArray)this.x0;
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                        }

                        @Override
                        public long getLong(long index) {
                            return this.x0Fix.getLong(index);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                    }

                    @Override
                    public long getLong(long index) {
                        return (long)(a0 * this.x0.getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isFloatType(requiredType)) {
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesFloatArray(len, (float)b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0) {
                    return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                        }

                        @Override
                        public float getFloat(long index) {
                            return (float)this.x0.getDouble(index);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                    }

                    @Override
                    public float getFloat(long index) {
                        return (float)(a0 * this.x0.getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            if (Arrays.isDoubleType(requiredType)) {
                if (allAZeroes) {
                    return (T)((PArray)InternalUtils.cast(new CopiesArraysImpl.CopiesDoubleArray(len, b, truncateOverflows, f)));
                }
                if (a0 == 1.0 && b == 0.0) {
                    return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                        final ArraysLinearGetDataOp lgdo;
                        {
                            super(truncateOverflows, length, f, x);
                            this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                        }

                        @Override
                        public double getDouble(long index) {
                            return this.x0.getDouble(index);
                        }

                        @Override
                        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                            this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                        }
                    }));
                }
                return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                    }

                    @Override
                    public double getDouble(long index) {
                        return a0 * this.x0.getDouble(index) + b;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray interfaces");
        }
        final double[] a = lf.isNonweighted() ? null : lf.a();
        final double a0 = lf.a(0);
        if (a != null) assert (a.length == n);
        if (Arrays.isBitType(requiredType)) {
            return (T)((PArray)InternalUtils.cast(new FuncBitArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 1);
                }

                @Override
                public boolean getBit(long index) {
                    double sum = 0.0;
                    if (a == null) {
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        sum *= a0;
                    } else {
                        for (int k = 0; k < n; ++k) {
                            sum += a[k] * this.x[k].getDouble(index);
                        }
                    }
                    return sum + b != 0.0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isCharType(requiredType)) {
            if (truncateOverflows) {
                return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                    }

                    @Override
                    public char getChar(long index) {
                        int v;
                        if (a == null) {
                            double sum = 0.0;
                            for (int k = 0; k < n; ++k) {
                                sum += this.x[k].getDouble(index);
                            }
                            v = (int)(sum * a0 + b);
                        } else {
                            double sum = b;
                            for (int k = 0; k < n; ++k) {
                                sum += a[k] * this.x[k].getDouble(index);
                            }
                            v = (int)sum;
                        }
                        return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncCharArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                }

                @Override
                public char getChar(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (char)(sum * a0 + b);
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (char)sum;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isByteType(requiredType)) {
            if (truncateOverflows) {
                return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                    }

                    @Override
                    public int getByte(long index) {
                        int v;
                        if (a == null) {
                            double sum = 0.0;
                            for (int k = 0; k < n; ++k) {
                                sum += this.x[k].getDouble(index);
                            }
                            v = (int)(sum * a0 + b);
                        } else {
                            double sum = b;
                            for (int k = 0; k < n; ++k) {
                                sum += a[k] * this.x[k].getDouble(index);
                            }
                            v = (int)sum;
                        }
                        return v < 0 ? 0 : Math.min(v, 255);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncByteArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                }

                @Override
                public int getByte(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (int)(sum * a0 + b) & 0xFF;
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (int)sum & 0xFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isShortType(requiredType)) {
            if (truncateOverflows) {
                return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                    }

                    @Override
                    public int getShort(long index) {
                        int v;
                        if (a == null) {
                            double sum = 0.0;
                            for (int k = 0; k < n; ++k) {
                                sum += this.x[k].getDouble(index);
                            }
                            v = (int)(sum * a0 + b);
                        } else {
                            double sum = b;
                            for (int k = 0; k < n; ++k) {
                                sum += a[k] * this.x[k].getDouble(index);
                            }
                            v = (int)sum;
                        }
                        return v < 0 ? 0 : Math.min(v, 65535);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncShortArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                }

                @Override
                public int getShort(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (int)(sum * a0 + b) & 0xFFFF;
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (int)sum & 0xFFFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isIntType(requiredType)) {
            if (truncateOverflows) {
                return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                    final ArraysLinearGetDataOp lgdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                    }

                    @Override
                    public int getInt(long index) {
                        if (a == null) {
                            double sum = 0.0;
                            for (int k = 0; k < n; ++k) {
                                sum += this.x[k].getDouble(index);
                            }
                            return (int)(sum * a0 + b);
                        }
                        double sum = b;
                        for (int k = 0; k < n; ++k) {
                            sum += a[k] * this.x[k].getDouble(index);
                        }
                        return (int)sum;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                }));
            }
            return (T)((PArray)InternalUtils.cast(new FuncIntArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                }

                @Override
                public int getInt(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (int)(sum * a0 + b);
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (int)sum;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isLongType(requiredType)) {
            return (T)((PArray)InternalUtils.cast(new FuncLongArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                }

                @Override
                public long getLong(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (long)(sum * a0 + b);
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (long)sum;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isFloatType(requiredType)) {
            return (T)((PArray)InternalUtils.cast(new FuncFloatArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                }

                @Override
                public float getFloat(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return (float)(sum * a0 + b);
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return (float)sum;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        if (Arrays.isDoubleType(requiredType)) {
            return (T)((PArray)InternalUtils.cast(new FuncDoubleArrayWithArguments(truncateOverflows, len, f, x){
                final ArraysLinearGetDataOp lgdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                }

                @Override
                public double getDouble(long index) {
                    if (a == null) {
                        double sum = 0.0;
                        for (int k = 0; k < n; ++k) {
                            sum += this.x[k].getDouble(index);
                        }
                        return sum * a0 + b;
                    }
                    double sum = b;
                    for (int k = 0; k < n; ++k) {
                        sum += a[k] * this.x[k].getDouble(index);
                    }
                    return sum;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            }));
        }
        throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray interfaces");
    }

    private static <T extends UpdatablePArray> T asUpdatableLinearFunc(boolean truncateOverflows, Class<? extends T> requiredType, Func.Updatable f, UpdatablePArray x) {
        double maxXElement;
        double aInv;
        double b;
        double a;
        Objects.requireNonNull(x, "Null x argument");
        Objects.requireNonNull(requiredType, "Null requiredType argument");
        if (f == Func.UPDATABLE_IDENTITY) {
            a = 1.0;
            b = 0.0;
            aInv = 1.0;
        } else if (f instanceof LinearFunc.Updatable) {
            double[] allA = ((LinearFunc)((Object)f)).a();
            a = allA[0];
            b = ((LinearFunc)((Object)f)).b();
            aInv = 1.0 / a;
            if (allA.length != ((LinearFunc)((Object)f)).n()) {
                throw new AssertionError((Object)"Illegal implementation of LinearFunc: n()!=a().length");
            }
        } else {
            throw new AssertionError((Object)("asUpdatableLinearFunc is called for unsupported function " + String.valueOf(f)));
        }
        final LinearFunc.Updatable lf = LinearFunc.getUpdatableInstance(b, a);
        final boolean truncateInSet = truncateOverflows && x instanceof PFixedArray && !(x instanceof LongArray) && !(x instanceof BitArray);
        final boolean longPrecisionInSet = !truncateOverflows && x instanceof PFixedArray && !(x instanceof LongArray) && !(x instanceof BitArray);
        final double minXElement = truncateInSet ? (double)((PFixedArray)((Object)x)).minPossibleValue() : Double.MIN_VALUE;
        double d = maxXElement = truncateInSet ? (double)((PFixedArray)((Object)x)).maxPossibleValue() : Double.MAX_VALUE;
        if (Arrays.isBitType(requiredType)) {
            final double vFalse = -b / a + 0.0;
            final double vTrue = (1.0 - b) / a + 0.0;
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncBitArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 1);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 1);
                }

                @Override
                public boolean getBit(long index) {
                    return a * this.x[0].getDouble(index) != -b;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setBit(long index, boolean value) {
                    if (truncateInSet) {
                        double v = value ? vTrue : vFalse;
                        this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                    } else {
                        this.x[0].setDouble(index, value ? vTrue : vFalse);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isCharType(requiredType)) {
            if (truncateOverflows) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 2);
                    }

                    @Override
                    public char getChar(long index) {
                        int v = (int)(a * this.x[0].getDouble(index) + b);
                        return (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setChar(long index, char value) {
                        if (truncateInSet) {
                            double v = ((double)value - b) * aInv;
                            this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                        } else {
                            this.x[0].setDouble(index, ((double)value - b) * aInv);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0 && x instanceof PFixedArray) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final PFixedArray x0Fix;
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.x0Fix = (PFixedArray)((Object)this.x[0]);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 2);
                    }

                    @Override
                    public char getChar(long index) {
                        return (char)this.x0Fix.getLong(index);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setChar(long index, char value) {
                        this.x[0].setInt(index, value);
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncCharArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 2);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 2);
                }

                @Override
                public char getChar(long index) {
                    return (char)(a * this.x[0].getDouble(index) + b);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setChar(long index, char value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)value - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)value - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isByteType(requiredType)) {
            if (truncateOverflows) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 3);
                    }

                    @Override
                    public int getByte(long index) {
                        int v = (int)(a * this.x[0].getDouble(index) + b);
                        return v < 0 ? 0 : Math.min(v, 255);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setByte(long index, byte value) {
                        if (truncateInSet) {
                            double v = ((double)(value & 0xFF) - b) * aInv;
                            this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                        } else {
                            this.x[0].setDouble(index, ((double)(value & 0xFF) - b) * aInv);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0 && x instanceof PFixedArray) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final PFixedArray x0Fix;
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.x0Fix = (PFixedArray)((Object)this.x[0]);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 3);
                    }

                    @Override
                    public int getByte(long index) {
                        return (int)this.x0Fix.getLong(index) & 0xFF;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setByte(long index, byte value) {
                        this.x[0].setInt(index, value & 0xFF);
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncByteArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 3);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 3);
                }

                @Override
                public int getByte(long index) {
                    return (int)(a * this.x[0].getDouble(index) + b) & 0xFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setByte(long index, byte value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)(value & 0xFF) - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)(value & 0xFF) - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isShortType(requiredType)) {
            if (truncateOverflows) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 4);
                    }

                    @Override
                    public int getShort(long index) {
                        int v = (int)(a * this.x[0].getDouble(index) + b);
                        return v < 0 ? 0 : Math.min(v, 65535);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setShort(long index, short value) {
                        if (truncateInSet) {
                            double v = ((double)(value & 0xFFFF) - b) * aInv;
                            this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                        } else {
                            this.x[0].setDouble(index, ((double)(value & 0xFFFF) - b) * aInv);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0 && x instanceof PFixedArray) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final PFixedArray x0Fix;
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.x0Fix = (PFixedArray)((Object)this.x[0]);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 4);
                    }

                    @Override
                    public int getShort(long index) {
                        return (int)this.x0Fix.getLong(index) & 0xFFFF;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setShort(long index, short value) {
                        this.x[0].setInt(index, value & 0xFFFF);
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncShortArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 4);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 4);
                }

                @Override
                public int getShort(long index) {
                    return (int)(a * this.x[0].getDouble(index) + b) & 0xFFFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setShort(long index, short value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)(value & 0xFFFF) - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)(value & 0xFFFF) - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isIntType(requiredType)) {
            if (truncateOverflows) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 5);
                    }

                    @Override
                    public int getInt(long index) {
                        return (int)(a * this.x[0].getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setInt(long index, int value) {
                        if (truncateInSet) {
                            double v = ((double)value - b) * aInv;
                            this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                        } else {
                            this.x[0].setDouble(index, ((double)value - b) * aInv);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0 && x instanceof PFixedArray) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final PFixedArray x0Fix;
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.x0Fix = (PFixedArray)((Object)this.x[0]);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 5);
                    }

                    @Override
                    public int getInt(long index) {
                        return (int)this.x0Fix.getLong(index);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setInt(long index, int value) {
                        this.x[0].setInt(index, value);
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncIntArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 5);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 5);
                }

                @Override
                public int getInt(long index) {
                    return (int)(a * this.x[0].getDouble(index) + b);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setInt(long index, int value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)value - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)value - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isLongType(requiredType)) {
            if (truncateInSet) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncLongArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 6);
                    }

                    @Override
                    public long getLong(long index) {
                        return (long)(a * this.x[0].getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setLong(long index, long value) {
                        double v = ((double)value - b) * aInv;
                        this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0 && x instanceof PFixedArray) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncLongArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final PFixedArray x0Fix;
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.x0Fix = (PFixedArray)((Object)this.x[0]);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 6);
                    }

                    @Override
                    public long getLong(long index) {
                        return this.x0Fix.getLong(index);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setLong(long index, long value) {
                        this.x[0].setLong(index, value);
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncLongArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 6);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 6);
                }

                @Override
                public long getLong(long index) {
                    return (long)(a * this.x[0].getDouble(index) + b);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setLong(long index, long value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)value - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)value - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isFloatType(requiredType)) {
            if (truncateInSet) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncFloatArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 7);
                    }

                    @Override
                    public float getFloat(long index) {
                        return (float)(a * this.x[0].getDouble(index) + b);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setFloat(long index, float value) {
                        double v = ((double)value - b) * aInv;
                        this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncFloatArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 7);
                    }

                    @Override
                    public float getFloat(long index) {
                        return (float)this.x[0].getDouble(index);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setFloat(long index, float value) {
                        if (longPrecisionInSet) {
                            this.x[0].setLong(index, (long)value);
                        } else {
                            this.x[0].setDouble(index, value);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncFloatArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 7);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 7);
                }

                @Override
                public float getFloat(long index) {
                    return (float)(a * this.x[0].getDouble(index) + b);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setFloat(long index, float value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)(((double)value - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, ((double)value - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        if (Arrays.isDoubleType(requiredType)) {
            if (truncateInSet) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncDoubleArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 8);
                    }

                    @Override
                    public double getDouble(long index) {
                        return a * this.x[0].getDouble(index) + b;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setDouble(long index, double value) {
                        double v = (value - b) * aInv;
                        this.x[0].setDouble(index, v < minXElement ? minXElement : Math.min(v, maxXElement));
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            if (a == 1.0 && b == 0.0) {
                return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncDoubleArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                    final ArraysLinearGetDataOp lgdo;
                    final ArraysLinearSetDataOp lsdo;
                    {
                        super(truncateOverflows, length, f, x);
                        this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                        this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 8);
                    }

                    @Override
                    public double getDouble(long index) {
                        return this.x[0].getDouble(index);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }

                    @Override
                    public void setDouble(long index, double value) {
                        if (longPrecisionInSet) {
                            this.x[0].setLong(index, (long)value);
                        } else {
                            this.x[0].setDouble(index, value);
                        }
                    }

                    @Override
                    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                        this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                        return this;
                    }
                }));
            }
            return (T)((UpdatablePArray)InternalUtils.cast(new UpdatableFuncDoubleArray(truncateOverflows, x.length(), f, new UpdatablePArray[]{x}){
                final ArraysLinearGetDataOp lgdo;
                final ArraysLinearSetDataOp lsdo;
                {
                    super(truncateOverflows, length, f, x);
                    this.lgdo = new ArraysLinearGetDataOp(this.truncateOverflows, this.x, lf, 8);
                    this.lsdo = new ArraysLinearSetDataOp(this.truncateOverflows, this.x[0], lf, 8);
                }

                @Override
                public double getDouble(long index) {
                    return a * this.x[0].getDouble(index) + b;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.lgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void setDouble(long index, double value) {
                    if (longPrecisionInSet) {
                        this.x[0].setLong(index, (long)((value - b) * aInv));
                    } else {
                        this.x[0].setDouble(index, (value - b) * aInv);
                    }
                }

                @Override
                public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                    this.lsdo.setData(arrayPos, srcArray, srcArrayOffset, count);
                    return this;
                }
            }));
        }
        throw new IllegalArgumentException("Illegal required type (" + String.valueOf(requiredType) + "): it must be one of primitive XxxArray or UpdatableXxxArray interfaces");
    }

    private static <T extends PArray> PArray asSubtractionFunc(boolean truncateOverflows, Func f, PArray ... x) {
        if (x.length != 2) {
            throw new IllegalArgumentException("x.length must be 2");
        }
        if (x[0] instanceof BitArray) {
            return new FuncBitArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final BitArray x0;
                final BitArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (BitArray)this.x[0];
                    this.x1 = (BitArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, null, false, false);
                }

                @Override
                public boolean getBit(long index) {
                    return this.x0.getBit(index) & !this.x1.getBit(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                    this.dgdo.getBits(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public long nextQuickPosition(long position) {
                    return this.x0.nextQuickPosition(position);
                }
            };
        }
        if (x[0] instanceof ByteArray) {
            if (truncateOverflows) {
                return new FuncByteArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                    final ByteArray x0;
                    final ByteArray x1;
                    final ArraysDiffGetDataOp dgdo;
                    {
                        this.x0 = (ByteArray)this.x[0];
                        this.x1 = (ByteArray)this.x[1];
                        this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getByteSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                    }

                    @Override
                    public int getByte(long index) {
                        int v = this.x0.getByte(index) - this.x1.getByte(index);
                        return Math.max(v, 0);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                };
            }
            return new FuncByteArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final ByteArray x0;
                final ByteArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (ByteArray)this.x[0];
                    this.x1 = (ByteArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getByteSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public int getByte(long index) {
                    int v = this.x0.getByte(index) - this.x1.getByte(index);
                    return v & 0xFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof CharArray) {
            if (truncateOverflows) {
                return new FuncCharArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                    final CharArray x0;
                    final CharArray x1;
                    final ArraysDiffGetDataOp dgdo;
                    {
                        this.x0 = (CharArray)this.x[0];
                        this.x1 = (CharArray)this.x[1];
                        this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getCharSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                    }

                    @Override
                    public char getChar(long index) {
                        int v = this.x0.getChar(index) - this.x1.getChar(index);
                        return (char)Math.max(v, 0);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                };
            }
            return new FuncCharArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final CharArray x0;
                final CharArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (CharArray)this.x[0];
                    this.x1 = (CharArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getCharSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public char getChar(long index) {
                    int v = this.x0.getChar(index) - this.x1.getChar(index);
                    return (char)(v & 0xFFFF);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof ShortArray) {
            if (truncateOverflows) {
                return new FuncShortArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                    final ShortArray x0;
                    final ShortArray x1;
                    final ArraysDiffGetDataOp dgdo;
                    {
                        this.x0 = (ShortArray)this.x[0];
                        this.x1 = (ShortArray)this.x[1];
                        this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getShortSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                    }

                    @Override
                    public int getShort(long index) {
                        int v = this.x0.getShort(index) - this.x1.getShort(index);
                        return Math.max(v, 0);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                };
            }
            return new FuncShortArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final ShortArray x0;
                final ShortArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (ShortArray)this.x[0];
                    this.x1 = (ShortArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getShortSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public int getShort(long index) {
                    int v = this.x0.getShort(index) - this.x1.getShort(index);
                    return v & 0xFFFF;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof IntArray) {
            if (truncateOverflows) {
                return new FuncIntArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                    final IntArray x0;
                    final IntArray x1;
                    final ArraysDiffGetDataOp dgdo;
                    {
                        this.x0 = (IntArray)this.x[0];
                        this.x1 = (IntArray)this.x[1];
                        this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getIntSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                    }

                    @Override
                    public int getInt(long index) {
                        long v = (long)this.x0.getInt(index) - (long)this.x1.getInt(index);
                        return v < Integer.MIN_VALUE ? Integer.MIN_VALUE : (v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v);
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                };
            }
            return new FuncIntArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final IntArray x0;
                final IntArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (IntArray)this.x[0];
                    this.x1 = (IntArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getIntSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public int getInt(long index) {
                    return this.x0.getInt(index) - this.x1.getInt(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof LongArray) {
            return new FuncLongArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final LongArray x0;
                final LongArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (LongArray)this.x[0];
                    this.x1 = (LongArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getLongSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public long getLong(long index) {
                    return this.x0.getLong(index) - this.x1.getLong(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof FloatArray) {
            return new FuncFloatArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final FloatArray x0;
                final FloatArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (FloatArray)this.x[0];
                    this.x1 = (FloatArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getFloatSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public float getFloat(long index) {
                    return this.x0.getFloat(index) - this.x1.getFloat(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof DoubleArray) {
            return new FuncDoubleArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final DoubleArray x0;
                final DoubleArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (DoubleArray)this.x[0];
                    this.x1 = (DoubleArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getDoubleSubtractOp(this.truncateOverflows), false, this.truncateOverflows);
                }

                @Override
                public double getDouble(long index) {
                    return this.x0.getDouble(index) - this.x1.getDouble(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        throw new IllegalArgumentException("Illegal array type (" + String.valueOf(x[0]) + "): it must implement one of primitive XxxArray interfaces");
    }

    private static <T extends PArray> PArray asAbsDiffFuncArray(boolean truncateOverflows, Func f, PArray ... x) {
        if (x.length != 2) {
            throw new IllegalArgumentException("x.length must be 2");
        }
        if (x[0] instanceof BitArray) {
            return new FuncBitArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final BitArray x0;
                final BitArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (BitArray)this.x[0];
                    this.x1 = (BitArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, null, true, false);
                }

                @Override
                public boolean getBit(long index) {
                    return this.x0.getBit(index) ^ this.x1.getBit(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
                    this.dgdo.getBits(arrayPos, destArray, destArrayOffset, count);
                }

                @Override
                public long nextQuickPosition(long position) {
                    return this.x0.nextQuickPosition(position);
                }
            };
        }
        if (x[0] instanceof ByteArray) {
            return new FuncByteArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final ByteArray x0;
                final ByteArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (ByteArray)this.x[0];
                    this.x1 = (ByteArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getByteAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public int getByte(long index) {
                    int v1;
                    int v0 = this.x0.getByte(index);
                    return v0 >= (v1 = this.x1.getByte(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof CharArray) {
            return new FuncCharArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final CharArray x0;
                final CharArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (CharArray)this.x[0];
                    this.x1 = (CharArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getCharAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public char getChar(long index) {
                    char v1;
                    char v0 = this.x0.getChar(index);
                    return (char)(v0 >= (v1 = this.x1.getChar(index)) ? v0 - v1 : v1 - v0);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof ShortArray) {
            return new FuncShortArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final ShortArray x0;
                final ShortArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (ShortArray)this.x[0];
                    this.x1 = (ShortArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getShortAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public int getShort(long index) {
                    int v1;
                    int v0 = this.x0.getShort(index);
                    return v0 >= (v1 = this.x1.getShort(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof LongArray) {
            return new FuncLongArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final LongArray x0;
                final LongArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (LongArray)this.x[0];
                    this.x1 = (LongArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getLongAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public long getLong(long index) {
                    long v1;
                    long v0 = this.x0.getLong(index);
                    return v0 >= (v1 = this.x1.getLong(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof FloatArray) {
            return new FuncFloatArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final FloatArray x0;
                final FloatArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (FloatArray)this.x[0];
                    this.x1 = (FloatArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getFloatAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public float getFloat(long index) {
                    float v1;
                    float v0 = this.x0.getFloat(index);
                    return v0 >= (v1 = this.x1.getFloat(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof DoubleArray) {
            return new FuncDoubleArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final DoubleArray x0;
                final DoubleArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (DoubleArray)this.x[0];
                    this.x1 = (DoubleArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getDoubleAbsDiffOp(), true, this.truncateOverflows);
                }

                @Override
                public double getDouble(long index) {
                    double v1;
                    double v0 = this.x0.getDouble(index);
                    return v0 >= (v1 = this.x1.getDouble(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        if (x[0] instanceof IntArray) {
            if (truncateOverflows) {
                return new FuncIntArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                    final IntArray x0;
                    final IntArray x1;
                    final ArraysDiffGetDataOp dgdo;
                    {
                        this.x0 = (IntArray)this.x[0];
                        this.x1 = (IntArray)this.x[1];
                        this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getIntAbsDiffOp(this.truncateOverflows), true, this.truncateOverflows);
                    }

                    @Override
                    public int getInt(long index) {
                        long v = (long)this.x0.getInt(index) - (long)this.x1.getInt(index);
                        if (v < 0L) {
                            v = -v;
                        }
                        return v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v;
                    }

                    @Override
                    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                        this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                    }
                };
            }
            return new FuncIntArrayWithArguments(truncateOverflows, x[0].length(), f, x){
                final IntArray x0;
                final IntArray x1;
                final ArraysDiffGetDataOp dgdo;
                {
                    this.x0 = (IntArray)this.x[0];
                    this.x1 = (IntArray)this.x[1];
                    this.dgdo = new ArraysDiffGetDataOp(this, this.x0, this.x1, ArraysDiffGetDataOp.getIntAbsDiffOp(this.truncateOverflows), true, this.truncateOverflows);
                }

                @Override
                public int getInt(long index) {
                    int v1;
                    int v0 = this.x0.getInt(index);
                    return v0 >= (v1 = this.x1.getInt(index)) ? v0 - v1 : v1 - v0;
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    this.dgdo.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
        }
        throw new IllegalArgumentException("Illegal array type (" + String.valueOf(x[0]) + "): it must implement one of primitive XxxArray interfaces");
    }

    private static <T extends PArray> T asConstantFuncArray(boolean truncateOverflows, Class<? extends T> requiredType, Func f, long len) {
        return ArraysFuncImpl.asLinearFuncArray(truncateOverflows, requiredType, f, new PArray[0], len);
    }

    private static <T extends PArray> T asIdentityFuncArray(boolean truncateOverflows, Class<? extends T> requiredType, Func f, PArray x) {
        return ArraysFuncImpl.asLinearFuncArray(truncateOverflows, requiredType, f, new PArray[]{x}, x.length());
    }

    private static <T extends UpdatablePArray> T asUpdatableIdentityFunc(boolean truncateOverflows, Class<? extends T> requiredType, Func.Updatable f, UpdatablePArray x) {
        return ArraysFuncImpl.asUpdatableLinearFunc(truncateOverflows, requiredType, f, x);
    }

    private static <T extends Array> T[] assertTypeAndCast(Class<T> requiredType, Array[] x) {
        for (int k = 0; k < x.length; ++k) {
            if (!requiredType.isInstance(x[k])) {
                throw new AssertionError((Object)("x[" + k + "] is not an instance of " + String.valueOf(requiredType)));
            }
        }
        Array[] result = (Array[])InternalUtils.cast(java.lang.reflect.Array.newInstance(requiredType, x.length));
        System.arraycopy(x, 0, result, 0, x.length);
        return result;
    }

    private static PArray[] addUnderlyingArraysWithSameMinMaxFunc(Func f, PArray[] arrays) {
        assert (f == Func.MIN || f == Func.MAX);
        ArrayList<Array> expanded = new ArrayList<Array>(arrays.length);
        for (PArray a : arrays) {
            if (a instanceof FuncArray && ((FuncArray)((Object)a)).f() == f) {
                Array[] underlyings = ((AbstractArray)((Object)a)).underlyingArrays;
                boolean sameType = true;
                for (Array u : underlyings) {
                    assert (u instanceof PArray);
                    if (u.elementType() == a.elementType()) continue;
                    sameType = false;
                }
                if (sameType) {
                    expanded.addAll(java.util.Arrays.asList(underlyings));
                    continue;
                }
            }
            expanded.add(a);
        }
        assert (!expanded.isEmpty()) : "Empty list after extracting underlying functions";
        return expanded.toArray(new PArray[0]);
    }

    static void coordinatesInDoubles(long index, long[] dim, double[] result) {
        if (index < 0L) {
            throw new AssertionError((Object)"Negative index argument");
        }
        if (result.length < dim.length) {
            throw new AssertionError((Object)("Too short result array: long[" + result.length + "]; " + dim.length + " elements required to store coordinates"));
        }
        long a = index;
        for (int k = 0; k < dim.length - 1; ++k) {
            long b = a / dim[k];
            result[k] = a - b * dim[k];
            a = b;
        }
        if (a >= dim[dim.length - 1]) {
            throw new IndexOutOfBoundsException("Too large index argument: " + index + " >= matrix size " + JArrays.toString(dim, "*", 10000));
        }
        result[dim.length - 1] = a;
    }

    static interface FuncArray {
        public Func f();

        public boolean truncateOverflows();
    }

    private static abstract class UpdatableFuncDoubleArray
    extends AbstractUpdatableDoubleArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncDoubleArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 8);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public DoubleArray asImmutable() {
            final UpdatableFuncDoubleArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncDoubleArrayWithArguments result = new FuncDoubleArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public double getDouble(long index) {
                    return parent.getDouble(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array double[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncFloatArray
    extends AbstractUpdatableFloatArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncFloatArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 7);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public FloatArray asImmutable() {
            final UpdatableFuncFloatArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncFloatArrayWithArguments result = new FuncFloatArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public float getFloat(long index) {
                    return parent.getFloat(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array float[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncLongArray
    extends AbstractUpdatableLongArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncLongArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 6);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public LongArray asImmutable() {
            final UpdatableFuncLongArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncLongArrayWithArguments result = new FuncLongArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public long getLong(long index) {
                    return parent.getLong(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array long[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncIntArray
    extends AbstractUpdatableIntArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncIntArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 5);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public IntArray asImmutable() {
            final UpdatableFuncIntArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncIntArrayWithArguments result = new FuncIntArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public int getInt(long index) {
                    return parent.getInt(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array int[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncShortArray
    extends AbstractUpdatableShortArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncShortArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 4);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public ShortArray asImmutable() {
            final UpdatableFuncShortArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncShortArrayWithArguments result = new FuncShortArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public int getShort(long index) {
                    return parent.getShort(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array short[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncByteArray
    extends AbstractUpdatableByteArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncByteArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 3);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public ByteArray asImmutable() {
            final UpdatableFuncByteArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncByteArrayWithArguments result = new FuncByteArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public int getByte(long index) {
                    return parent.getByte(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array byte[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncCharArray
    extends AbstractUpdatableCharArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncCharArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 2);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public CharArray asImmutable() {
            final UpdatableFuncCharArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncCharArrayWithArguments result = new FuncCharArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public char getChar(long index) {
                    return parent.getChar(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array char[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class UpdatableFuncBitArray
    extends AbstractUpdatableBitArray
    implements FuncArrayWithArguments,
    OptimizationHelperInfo {
        final Func.Updatable f;
        final boolean truncateOverflows;
        final UpdatablePArray[] x;
        private final ArraysAnyFuncGetDataOp afgdo;
        private volatile Object optimizationHelperInfo;

        UpdatableFuncBitArray(boolean truncateOverflows, long length, Func.Updatable f, UpdatablePArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
            this.x = (UpdatablePArray[])x.clone();
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 1);
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public BitArray asImmutable() {
            final UpdatableFuncBitArray parent = this;
            PArray[] ua = new PArray[this.x.length];
            for (int k = 0; k < ua.length; ++k) {
                ua[k] = this.x[k];
            }
            FuncBitArrayWithArguments result = new FuncBitArrayWithArguments(this, this.truncateOverflows, this.length, this.f, ua){

                @Override
                public boolean getBit(long index) {
                    return parent.getBit(index);
                }

                @Override
                public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                    parent.getData(arrayPos, destArray, destArrayOffset, count);
                }
            };
            return result;
        }

        @Override
        public String toString() {
            return "unresizable AlgART array boolean[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class FuncDoubleArrayWithArguments
    extends AbstractFuncDoubleArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncDoubleArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 8);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array double[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncDoubleArray
    extends AbstractFuncDoubleArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncDoubleArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 8);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array double[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncDoubleArray
    extends AbstractDoubleArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncDoubleArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncFloatArrayWithArguments
    extends AbstractFuncFloatArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncFloatArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 7);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array float[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncFloatArray
    extends AbstractFuncFloatArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncFloatArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 7);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array float[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncFloatArray
    extends AbstractFloatArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncFloatArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncLongArrayWithArguments
    extends AbstractFuncLongArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncLongArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 6);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array long[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncLongArray
    extends AbstractFuncLongArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncLongArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 6);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array long[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncLongArray
    extends AbstractLongArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncLongArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncIntArrayWithArguments
    extends AbstractFuncIntArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncIntArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 5);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array int[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncIntArray
    extends AbstractFuncIntArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncIntArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 5);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array int[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncIntArray
    extends AbstractIntArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncIntArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncShortArrayWithArguments
    extends AbstractFuncShortArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncShortArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 4);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array short[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncShortArray
    extends AbstractFuncShortArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncShortArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 4);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array short[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncShortArray
    extends AbstractShortArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncShortArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncByteArrayWithArguments
    extends AbstractFuncByteArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncByteArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 3);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array byte[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncByteArray
    extends AbstractFuncByteArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncByteArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 3);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array byte[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncByteArray
    extends AbstractByteArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncByteArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncCharArrayWithArguments
    extends AbstractFuncCharArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncCharArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 2);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array char[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncCharArray
    extends AbstractFuncCharArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncCharArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 2);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array char[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncCharArray
    extends AbstractCharArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncCharArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    private static abstract class FuncBitArrayWithArguments
    extends AbstractFuncBitArray
    implements FuncArrayWithArguments {
        private final ArraysAnyFuncGetDataOp afgdo;
        final PArray[] x;
        final PArray x0;

        FuncBitArrayWithArguments(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(truncateOverflows, length, f, x);
            this.x = (PArray[])x.clone();
            this.x0 = x[0];
            this.afgdo = new ArraysAnyFuncGetDataOp(truncateOverflows, this.x, f, 1);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.afgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public String toString() {
            return "immutable AlgART array boolean[" + this.length + "] built by " + String.valueOf(this.f) + " with " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : "");
        }
    }

    private static abstract class CoordFuncBitArray
    extends AbstractFuncBitArray
    implements CoordFuncArray {
        private final ArraysAnyCoordFuncGetDataOp acfgdo;
        final long[] dim;

        protected CoordFuncBitArray(boolean truncateOverflows, long length, Func f, long[] dim) {
            super(truncateOverflows, length, f, new PArray[0]);
            this.dim = (long[])dim.clone();
            this.acfgdo = new ArraysAnyCoordFuncGetDataOp(this, truncateOverflows, dim, f, 1);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            this.acfgdo.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dim.clone();
        }

        @Override
        public String toString() {
            return "immutable AlgART array boolean[" + this.length + "] built by " + String.valueOf(this.f) + " (function of " + this.dim.length + " indexes in " + (String)(this.dim.length == 1 ? "one-dimensional array)" : JArrays.toString(this.dim, "x", 1000) + " matrix)");
        }
    }

    private static abstract class AbstractFuncBitArray
    extends AbstractBitArray
    implements FuncArray,
    OptimizationHelperInfo {
        final Func f;
        final boolean truncateOverflows;
        private volatile Object optimizationHelperInfo;

        AbstractFuncBitArray(boolean truncateOverflows, long length, Func f, PArray ... x) {
            super(length, true, (Array[])x);
            this.truncateOverflows = truncateOverflows;
            this.f = f;
        }

        @Override
        public boolean truncateOverflows() {
            return this.truncateOverflows;
        }

        @Override
        public Func f() {
            return this.f;
        }

        @Override
        public Object getOptimizationHelperInfo() {
            return this.optimizationHelperInfo;
        }

        @Override
        public void setOptimizationHelperInfo(Object optimizationHelperInfo) {
            this.optimizationHelperInfo = optimizationHelperInfo;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public abstract String toString();
    }

    static interface OptimizationHelperInfo {
        public Object getOptimizationHelperInfo();

        public void setOptimizationHelperInfo(Object var1);
    }

    static interface FuncArrayWithArguments
    extends FuncArray {
    }

    static interface CoordFuncArray
    extends FuncArray {
        public long[] dimensions();
    }
}

