/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;

class ArraysComparisonWithThresholdGetBitsOp {
    private final ReentrantLock lock = new ReentrantLock();
    private final PArray x0;
    private final boolean isBit;
    private final DataBuffer dbuf;
    private final double threshold;
    private final boolean greater;
    private final boolean inclusive;
    private final JArrayPool bufferPool;

    ArraysComparisonWithThresholdGetBitsOp(PArray x0, double threshold, boolean greater, boolean inclusive) {
        this.x0 = x0;
        this.isBit = x0 instanceof BitArray;
        this.dbuf = Arrays.bufferInternal(x0, DataBuffer.AccessMode.READ);
        this.threshold = threshold;
        this.greater = greater;
        this.inclusive = inclusive;
        this.bufferPool = x0 instanceof CharArray ? ArraysFuncImpl.CHAR_BUFFERS : (x0 instanceof ByteArray ? ArraysFuncImpl.BYTE_BUFFERS : (x0 instanceof ShortArray ? ArraysFuncImpl.SHORT_BUFFERS : (x0 instanceof IntArray ? ArraysFuncImpl.INT_BUFFERS : (x0 instanceof LongArray ? ArraysFuncImpl.LONG_BUFFERS : (x0 instanceof FloatArray ? ArraysFuncImpl.FLOAT_BUFFERS : (x0 instanceof DoubleArray ? ArraysFuncImpl.DOUBLE_BUFFERS : null))))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0L) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x0.length(), this.getClass());
        }
        if (arrayPos > this.x0.length() - count) {
            throw AbstractArray.rangeException(arrayPos + count - 1L, this.x0.length(), this.getClass());
        }
        while (count > 0L) {
            int len;
            boolean usePool = false;
            Object data = null;
            try {
                boolean bl = usePool = !this.dbuf.isDirect();
                if (usePool) {
                    if (this.isBit) {
                        ((BitArray)this.x0).getBits(arrayPos, destArray, destArrayOffset, count);
                        this.bufferPool.releaseArray(data);
                        return;
                    }
                    data = this.bufferPool.requestArray();
                    len = (int)Math.min(count, (long)this.bufferPool.arrayLength());
                    this.x0.getData(arrayPos, data, 0, len);
                    from = 0;
                    to = len;
                } else {
                    this.lock.lock();
                    try {
                        this.dbuf.map(arrayPos, count);
                        len = this.dbuf.cnt();
                        assert ((long)len == this.dbuf.count()) : "too large buffer";
                        data = this.dbuf.data();
                        from = this.dbuf.from();
                        to = this.dbuf.to();
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                this.bufferPool.releaseArray(data);
            }
            catch (Throwable throwable) {
                this.bufferPool.releaseArray(data);
                throw throwable;
            }
            destArrayOffset += (long)len;
            arrayPos += (long)len;
            count -= (long)len;
        }
    }
}

