/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.nio.ByteOrder;
import java.util.AbstractList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayComparator;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.ArraysOpImpl;
import net.algart.arrays.ArraysSerializationImpl;
import net.algart.arrays.ArraysSubMatrixImpl;
import net.algart.arrays.ArraysTileMatrixImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.CombinedMemoryModel;
import net.algart.arrays.CopiesArraysImpl;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataBuffersImpl;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DefaultThreadPoolFactory;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DirectDataStorages;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrays;
import net.algart.arrays.LargeMemoryModel;
import net.algart.arrays.LongArray;
import net.algart.arrays.MappedDataStorages;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.MutablePFloatingArray;
import net.algart.arrays.MutablePIntegerArray;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleArraysImpl;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public class Arrays {
    static final Logger LOGGER = Logger.getLogger(Arrays.class.getName());
    static final boolean CONFIG_LOGGABLE = LargeMemoryModel.LOGGER.isLoggable(Level.CONFIG);
    static final boolean DEBUG_MODE = false;
    private static final int MAX_NUMBER_OF_RANGES_FOR_PRECISE_LENGTH_PER_TASK_ESTIMATION = 10000;
    public static final SimpleMemoryModel SMM;
    public static final BufferMemoryModel BMM;
    public static List<Class<?>> PRIMITIVE_TYPES;
    public static final int BITS_PER_BIT = 1;
    public static final int BITS_PER_CHAR = 16;
    public static final int BITS_PER_BYTE = 8;
    public static final int BITS_PER_SHORT = 16;
    public static final int BITS_PER_INT = 32;
    public static final int BITS_PER_LONG = 64;
    public static final int BITS_PER_FLOAT = 32;
    public static final int BITS_PER_DOUBLE = 64;
    static final int BITS_PER_OBJECT = -1;

    private Arrays() {
    }

    public static Class<?> elementType(Class<? extends PArray> arrayType) {
        Objects.requireNonNull(arrayType, "Null arrayType argument");
        if (BitArray.class.isAssignableFrom(arrayType)) {
            return Boolean.TYPE;
        }
        if (CharArray.class.isAssignableFrom(arrayType)) {
            return Character.TYPE;
        }
        if (ByteArray.class.isAssignableFrom(arrayType)) {
            return Byte.TYPE;
        }
        if (ShortArray.class.isAssignableFrom(arrayType)) {
            return Short.TYPE;
        }
        if (IntArray.class.isAssignableFrom(arrayType)) {
            return Integer.TYPE;
        }
        if (LongArray.class.isAssignableFrom(arrayType)) {
            return Long.TYPE;
        }
        if (FloatArray.class.isAssignableFrom(arrayType)) {
            return Float.TYPE;
        }
        if (DoubleArray.class.isAssignableFrom(arrayType)) {
            return Double.TYPE;
        }
        throw new IllegalArgumentException("Only primitive array types BitArray, CharArray, ByteArray, ShortArray, IntArray, LongArray, FloatArray, DoubleArray and their inheritors allowed here (passed type: " + String.valueOf(arrayType) + ")");
    }

    public static <T extends Array> Class<T> type(Class<T> arraySupertype, Class<?> elementType) {
        Class result;
        Objects.requireNonNull(arraySupertype, "Null arraySupertype argument");
        Objects.requireNonNull(elementType, "Null elementType argument");
        boolean updatable = UpdatableArray.class.isAssignableFrom(arraySupertype);
        boolean mutable = MutableArray.class.isAssignableFrom(arraySupertype);
        if (elementType == Boolean.TYPE) {
            result = mutable ? MutableBitArray.class : (updatable ? UpdatableBitArray.class : BitArray.class);
        } else if (elementType == Character.TYPE) {
            result = mutable ? MutableCharArray.class : (updatable ? UpdatableCharArray.class : CharArray.class);
        } else if (elementType == Byte.TYPE) {
            result = mutable ? MutableByteArray.class : (updatable ? UpdatableByteArray.class : ByteArray.class);
        } else if (elementType == Short.TYPE) {
            result = mutable ? MutableShortArray.class : (updatable ? UpdatableShortArray.class : ShortArray.class);
        } else if (elementType == Integer.TYPE) {
            result = mutable ? MutableIntArray.class : (updatable ? UpdatableIntArray.class : IntArray.class);
        } else if (elementType == Long.TYPE) {
            result = mutable ? MutableLongArray.class : (updatable ? UpdatableLongArray.class : LongArray.class);
        } else if (elementType == Float.TYPE) {
            result = mutable ? MutableFloatArray.class : (updatable ? UpdatableFloatArray.class : FloatArray.class);
        } else if (elementType == Double.TYPE) {
            result = mutable ? MutableDoubleArray.class : (updatable ? UpdatableDoubleArray.class : DoubleArray.class);
        } else {
            Class clazz = mutable ? MutableObjectArray.class : (result = updatable ? UpdatableObjectArray.class : ObjectArray.class);
        }
        if (!arraySupertype.isAssignableFrom(result)) {
            throw new ClassCastException("The passed array supertype " + arraySupertype.getName() + " cannot contain required " + elementType.getCanonicalName() + " elements");
        }
        return (Class)InternalUtils.cast(result);
    }

    public static boolean isBitType(Class<? extends Array> arrayType) {
        return arrayType == BitArray.class || arrayType == UpdatableBitArray.class || arrayType == MutableBitArray.class;
    }

    public static boolean isCharType(Class<? extends Array> arrayType) {
        return arrayType == CharArray.class || arrayType == UpdatableCharArray.class || arrayType == MutableCharArray.class;
    }

    public static boolean isByteType(Class<? extends Array> arrayType) {
        return arrayType == ByteArray.class || arrayType == UpdatableByteArray.class || arrayType == MutableByteArray.class;
    }

    public static boolean isShortType(Class<? extends Array> arrayType) {
        return arrayType == ShortArray.class || arrayType == UpdatableShortArray.class || arrayType == MutableShortArray.class;
    }

    public static boolean isIntType(Class<? extends Array> arrayType) {
        return arrayType == IntArray.class || arrayType == UpdatableIntArray.class || arrayType == MutableIntArray.class;
    }

    public static boolean isLongType(Class<? extends Array> arrayType) {
        return arrayType == LongArray.class || arrayType == UpdatableLongArray.class || arrayType == MutableLongArray.class;
    }

    public static boolean isFloatType(Class<? extends Array> arrayType) {
        return arrayType == FloatArray.class || arrayType == UpdatableFloatArray.class || arrayType == MutableFloatArray.class;
    }

    public static boolean isDoubleType(Class<? extends Array> arrayType) {
        return arrayType == DoubleArray.class || arrayType == UpdatableDoubleArray.class || arrayType == MutableDoubleArray.class;
    }

    public static boolean isObjectType(Class<? extends Array> arrayType) {
        return arrayType == ObjectArray.class || arrayType == UpdatableObjectArray.class || arrayType == MutableObjectArray.class;
    }

    public static long sizeOf(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (array instanceof BitArray) {
            return PackedBitArrays.packedLength(array.length()) << 3;
        }
        if (array instanceof PArray) {
            long bytesPerElementLog;
            long len = array.length();
            if (len > Long.MAX_VALUE >> (int)(bytesPerElementLog = (long)(31 - Integer.numberOfLeadingZeros((int)((PArray)array).bitsPerElement() >>> 3)))) {
                return Long.MAX_VALUE;
            }
            return len << (int)bytesPerElementLog;
        }
        if (CombinedMemoryModel.isCombinedArray(array)) {
            Array[] storage = ((CombinedMemoryModel.CombinedArray)array).storage;
            long result = 0L;
            for (Array a : storage) {
                long size = Arrays.sizeOf(a);
                if (size == -1L) {
                    return -1L;
                }
                if (result > Long.MAX_VALUE - size) {
                    return Long.MAX_VALUE;
                }
                result += size;
            }
            return result;
        }
        return -1L;
    }

    public static long sizeOf(Class<?> elementType, long arrayLength) {
        if (arrayLength < 0L) {
            return -1L;
        }
        if (elementType == Boolean.TYPE) {
            return PackedBitArrays.packedLength(arrayLength) << 3;
        }
        if (elementType == Character.TYPE) {
            return arrayLength > 0x3FFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 1;
        }
        if (elementType == Byte.TYPE) {
            return arrayLength;
        }
        if (elementType == Short.TYPE) {
            return arrayLength > 0x3FFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 1;
        }
        if (elementType == Integer.TYPE) {
            return arrayLength > 0x1FFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 2;
        }
        if (elementType == Long.TYPE) {
            return arrayLength > 0xFFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 3;
        }
        if (elementType == Float.TYPE) {
            return arrayLength > 0x1FFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 2;
        }
        if (elementType == Double.TYPE) {
            return arrayLength > 0xFFFFFFFFFFFFFFFL ? Long.MAX_VALUE : arrayLength << 3;
        }
        return -1L;
    }

    public static double sizeOf(Class<?> elementType) {
        if (elementType == Boolean.TYPE) {
            return 0.125;
        }
        if (elementType == Character.TYPE) {
            return 2.0;
        }
        if (elementType == Byte.TYPE) {
            return 1.0;
        }
        if (elementType == Short.TYPE) {
            return 2.0;
        }
        if (elementType == Integer.TYPE) {
            return 4.0;
        }
        if (elementType == Long.TYPE) {
            return 8.0;
        }
        if (elementType == Float.TYPE) {
            return 4.0;
        }
        if (elementType == Double.TYPE) {
            return 8.0;
        }
        return -1.0;
    }

    public static int bytesPerElement(Class<?> elementType) {
        if (elementType == Boolean.TYPE) {
            return 1;
        }
        if (elementType == Character.TYPE) {
            return 2;
        }
        if (elementType == Byte.TYPE) {
            return 1;
        }
        if (elementType == Short.TYPE) {
            return 2;
        }
        if (elementType == Integer.TYPE) {
            return 4;
        }
        if (elementType == Long.TYPE) {
            return 8;
        }
        if (elementType == Float.TYPE) {
            return 4;
        }
        if (elementType == Double.TYPE) {
            return 8;
        }
        return -1;
    }

    public static long bitsPerElement(Class<?> elementType) {
        if (elementType == Boolean.TYPE) {
            return 1L;
        }
        if (elementType == Character.TYPE) {
            return 16L;
        }
        if (elementType == Byte.TYPE) {
            return 8L;
        }
        if (elementType == Short.TYPE) {
            return 16L;
        }
        if (elementType == Integer.TYPE) {
            return 32L;
        }
        if (elementType == Long.TYPE) {
            return 64L;
        }
        if (elementType == Float.TYPE) {
            return 32L;
        }
        if (elementType == Double.TYPE) {
            return 64L;
        }
        return -1L;
    }

    public static boolean isPrimitiveElementType(Class<?> elementType) {
        return elementType != null && elementType.isPrimitive();
    }

    public static boolean isNumberElementType(Class<?> elementType) {
        return elementType == Byte.TYPE || elementType == Short.TYPE || elementType == Integer.TYPE || elementType == Long.TYPE || elementType == Float.TYPE || elementType == Double.TYPE;
    }

    public static boolean isFloatingPointElementType(Class<?> elementType) {
        return elementType == Float.TYPE || elementType == Double.TYPE;
    }

    public static boolean isUnsignedElementType(Class<?> elementType) {
        return elementType == Boolean.TYPE || elementType == Character.TYPE || elementType == Byte.TYPE || elementType == Short.TYPE;
    }

    public static Class<?> primitiveType(long bitsPerElement, boolean floatingPoint) {
        Class<Constable> clazz;
        block14: {
            block13: {
                if (bitsPerElement <= 0L) {
                    throw new IllegalArgumentException("Zero or negative number of bits/element = " + bitsPerElement);
                }
                if (bitsPerElement > 64L) {
                    throw new IllegalArgumentException("Too large number of bits/element = " + bitsPerElement + ": there are no primitive types with >64 bits/element");
                }
                if (!floatingPoint) break block13;
                switch ((int)bitsPerElement) {
                    case 32: {
                        clazz = Float.TYPE;
                        break block14;
                    }
                    case 64: {
                        clazz = Double.TYPE;
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException(bitsPerElement + " bits/element is impossible for floating-point primitive types");
                    }
                }
            }
            switch ((int)bitsPerElement) {
                case 1: {
                    clazz = Boolean.TYPE;
                    break;
                }
                case 8: {
                    clazz = Byte.TYPE;
                    break;
                }
                case 16: {
                    clazz = Short.TYPE;
                    break;
                }
                case 32: {
                    clazz = Integer.TYPE;
                    break;
                }
                case 64: {
                    clazz = Long.TYPE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(bitsPerElement + " bits/element is impossible for fixed-point primitive types");
                }
            }
        }
        return clazz;
    }

    public static long minPossibleIntegerValue(Class<? extends PFixedArray> arrayType) {
        Objects.requireNonNull(arrayType, "Null arrayType argument");
        if (BitArray.class.isAssignableFrom(arrayType)) {
            return 0L;
        }
        if (CharArray.class.isAssignableFrom(arrayType)) {
            return 0L;
        }
        if (ByteArray.class.isAssignableFrom(arrayType)) {
            return 0L;
        }
        if (ShortArray.class.isAssignableFrom(arrayType)) {
            return 0L;
        }
        if (IntArray.class.isAssignableFrom(arrayType)) {
            return Integer.MIN_VALUE;
        }
        if (LongArray.class.isAssignableFrom(arrayType)) {
            return Long.MIN_VALUE;
        }
        throw new IllegalArgumentException("Only BitArray, CharArray, ByteArray, ShortArray, IntArray, LongArray and their inheritors are allowed here (passed type: " + String.valueOf(arrayType) + ")");
    }

    public static long maxPossibleIntegerValue(Class<? extends PFixedArray> arrayType) {
        Objects.requireNonNull(arrayType, "Null arrayType argument");
        if (BitArray.class.isAssignableFrom(arrayType)) {
            return 1L;
        }
        if (CharArray.class.isAssignableFrom(arrayType)) {
            return 65535L;
        }
        if (ByteArray.class.isAssignableFrom(arrayType)) {
            return 255L;
        }
        if (ShortArray.class.isAssignableFrom(arrayType)) {
            return 65535L;
        }
        if (IntArray.class.isAssignableFrom(arrayType)) {
            return Integer.MAX_VALUE;
        }
        if (LongArray.class.isAssignableFrom(arrayType)) {
            return Long.MAX_VALUE;
        }
        throw new IllegalArgumentException("Only BitArray, CharArray, ByteArray, ShortArray, IntArray, LongArray and their inheritors are allowed here (passed type: " + String.valueOf(arrayType) + ")");
    }

    public static double minPossibleValue(Class<? extends Array> arrayType, double valueForFloatingPoint) {
        Objects.requireNonNull(arrayType, "Null arrayType argument");
        if (PFixedArray.class.isAssignableFrom(arrayType)) {
            return Arrays.minPossibleIntegerValue(arrayType.asSubclass(PFixedArray.class));
        }
        if (DoubleArray.class.isAssignableFrom(arrayType) || FloatArray.class.isAssignableFrom(arrayType) || ObjectArray.class.isAssignableFrom(arrayType)) {
            return valueForFloatingPoint;
        }
        throw new IllegalArgumentException("Only BitArray, CharArray, ByteArray, ShortArray, IntArray, LongArray, FloatArray, DoubleArray, ObjectArray and their inheritors are allowed here (passed type: " + String.valueOf(arrayType) + ")");
    }

    public static double maxPossibleValue(Class<? extends Array> arrayType, double valueForFloatingPoint) {
        Objects.requireNonNull(arrayType, "Null arrayType argument");
        if (PFixedArray.class.isAssignableFrom(arrayType)) {
            return Arrays.maxPossibleIntegerValue(arrayType.asSubclass(PFixedArray.class));
        }
        if (DoubleArray.class.isAssignableFrom(arrayType) || FloatArray.class.isAssignableFrom(arrayType) || ObjectArray.class.isAssignableFrom(arrayType)) {
            return valueForFloatingPoint;
        }
        throw new IllegalArgumentException("Only BitArray, CharArray, ByteArray, ShortArray, IntArray, LongArray, FloatArray, DoubleArray, ObjectArray and their inheritors are allowed here (passed type: " + String.valueOf(arrayType) + ")");
    }

    public static double minPossibleValue(Class<? extends Array> arrayType) {
        return Arrays.minPossibleValue(arrayType, 0.0);
    }

    public static double maxPossibleValue(Class<? extends Array> arrayType) {
        return Arrays.maxPossibleValue(arrayType, 1.0);
    }

    public static BitArray nBitCopies(long n, boolean element) {
        return new CopiesArraysImpl.CopiesBitArray(n, element);
    }

    public static CharArray nCharCopies(long n, char element) {
        return new CopiesArraysImpl.CopiesCharArray(n, element);
    }

    public static ByteArray nByteCopies(long n, byte element) {
        return new CopiesArraysImpl.CopiesByteArray(n, element);
    }

    public static ShortArray nShortCopies(long n, short element) {
        return new CopiesArraysImpl.CopiesShortArray(n, element);
    }

    public static IntArray nIntCopies(long n, int element) {
        return new CopiesArraysImpl.CopiesIntArray(n, element);
    }

    public static LongArray nLongCopies(long n, long element) {
        return new CopiesArraysImpl.CopiesLongArray(n, element);
    }

    public static FloatArray nFloatCopies(long n, float element) {
        return new CopiesArraysImpl.CopiesFloatArray(n, element);
    }

    public static DoubleArray nDoubleCopies(long n, double element) {
        return new CopiesArraysImpl.CopiesDoubleArray(n, element);
    }

    public static <T> ObjectArray<T> nObjectCopies(long n, T element) {
        return new CopiesArraysImpl.CopiesObjectArray<T>(n, element);
    }

    public static PArray nPCopies(long n, Class<?> elementType, double element) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE) {
            return Arrays.nBitCopies(n, element != 0.0);
        }
        if (elementType == Character.TYPE) {
            return Arrays.nCharCopies(n, (char)element);
        }
        if (elementType == Byte.TYPE) {
            return Arrays.nByteCopies(n, (byte)element);
        }
        if (elementType == Short.TYPE) {
            return Arrays.nShortCopies(n, (short)element);
        }
        if (elementType == Integer.TYPE) {
            return Arrays.nIntCopies(n, (int)element);
        }
        if (elementType == Long.TYPE) {
            return Arrays.nLongCopies(n, (long)element);
        }
        if (elementType == Float.TYPE) {
            return Arrays.nFloatCopies(n, (float)element);
        }
        if (elementType == Double.TYPE) {
            return Arrays.nDoubleCopies(n, element);
        }
        throw new IllegalArgumentException("Only primitive types are allowed here (passed element type: " + String.valueOf(elementType) + ")");
    }

    public static PFixedArray nPFixedCopies(long n, Class<?> elementType, long element) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE) {
            return Arrays.nBitCopies(n, element != 0L);
        }
        if (elementType == Character.TYPE) {
            return Arrays.nCharCopies(n, (char)element);
        }
        if (elementType == Byte.TYPE) {
            return Arrays.nByteCopies(n, (byte)element);
        }
        if (elementType == Short.TYPE) {
            return Arrays.nShortCopies(n, (short)element);
        }
        if (elementType == Integer.TYPE) {
            return Arrays.nIntCopies(n, (int)element);
        }
        if (elementType == Long.TYPE) {
            return Arrays.nLongCopies(n, element);
        }
        throw new IllegalArgumentException("Only boolean.class, char.class, byte.class, short.class, int.class and long.class are allowed here (passed element type: " + String.valueOf(elementType) + ")");
    }

    public static <E> ObjectArray<E> nNullCopies(long n, Class<E> elementType) {
        CopiesArraysImpl.CopiesObjectArray<Object> result = new CopiesArraysImpl.CopiesObjectArray<Object>(n, null);
        result.elementType = elementType;
        return result;
    }

    public static boolean isNCopies(Array array) {
        return array instanceof CopiesArraysImpl.CopiesArray;
    }

    public static <T extends PArray> T asIndexFuncArray(Func f, Class<? extends T> requiredType, long length) {
        return Arrays.asIndexFuncArray(true, f, requiredType, length);
    }

    public static <T extends PArray> T asIndexFuncArray(boolean truncateOverflows, Func f, Class<? extends T> requiredType, long length) {
        return ArraysFuncImpl.asCoordFuncMatrix(truncateOverflows, f, requiredType, new long[]{length});
    }

    public static <T extends PArray> T asFuncArray(Func f, Class<? extends T> requiredType, PArray ... x) {
        return Arrays.asFuncArray(true, f, requiredType, x);
    }

    public static <T extends PArray> T asFuncArray(boolean truncateOverflows, Func f, Class<? extends T> requiredType, PArray ... x) {
        Objects.requireNonNull(x, "Null x");
        if (x.length == 0) {
            throw new IllegalArgumentException("Empty x[] (array of AlgART arrays)");
        }
        Objects.requireNonNull(x[0], "Null x[0] argument");
        return ArraysFuncImpl.asFuncArray(truncateOverflows, f, requiredType, x, x[0].length());
    }

    public static <T extends UpdatablePArray> T asUpdatableFuncArray(Func.Updatable f, Class<? extends T> requiredType, UpdatablePArray ... x) {
        return ArraysFuncImpl.asUpdatableFuncArray(true, f, requiredType, x);
    }

    public static <T extends UpdatablePArray> T asUpdatableFuncArray(boolean truncateOverflows, Func.Updatable f, Class<? extends T> requiredType, UpdatablePArray ... x) {
        return ArraysFuncImpl.asUpdatableFuncArray(truncateOverflows, f, requiredType, x);
    }

    public static void applyFunc(Func f, UpdatablePArray result, PArray ... x) {
        Arrays.applyFunc(null, f, result, x);
    }

    public static void applyFunc(ArrayContext context, Func f, UpdatablePArray result, PArray ... x) {
        Arrays.applyFunc(context, true, 0, true, f, result, x);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, Func f, UpdatablePArray result, PArray ... x) {
        Arrays.applyFunc(context, truncateOverflows, 0, true, f, result, x);
    }

    public static void applyFunc(ArrayContext context, boolean truncateOverflows, int numberOfTasks, boolean strictMode, Func f, UpdatablePArray result, PArray ... x) {
        Objects.requireNonNull(result, "Null result argument");
        long len = result.length();
        for (int k = 0; k < x.length; ++k) {
            Objects.requireNonNull(x[k], "Null x[" + k + "] argument");
            if (x[k].length() == len) continue;
            throw new SizeMismatchException("x[" + k + "].length() and result.length() mismatch");
        }
        PArray lazy = x.length == 0 ? Arrays.asIndexFuncArray(truncateOverflows, f, result.type(), result.length()) : Arrays.asFuncArray(truncateOverflows, f, result.type(), x);
        Arrays.copy(context, result, lazy, numberOfTasks, strictMode);
    }

    public static boolean isFuncArray(Array array) {
        return array instanceof ArraysFuncImpl.FuncArray;
    }

    public static boolean isIndexFuncArray(Array array) {
        return array instanceof ArraysFuncImpl.CoordFuncArray;
    }

    public static Func getFunc(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!Arrays.isFuncArray(array)) {
            throw new IllegalArgumentException("The passed argument is not a functional array");
        }
        return ((ArraysFuncImpl.FuncArray)((Object)array)).f();
    }

    public static boolean getTruncationMode(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!Arrays.isFuncArray(array)) {
            throw new IllegalArgumentException("The passed argument is not a functional array");
        }
        return ((ArraysFuncImpl.FuncArray)((Object)array)).truncateOverflows();
    }

    public static long[] getIndexDimensions(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!Arrays.isIndexFuncArray(array)) {
            throw new IllegalArgumentException("The passed argument is not an index-based functional array");
        }
        return ((ArraysFuncImpl.CoordFuncArray)((Object)array)).dimensions();
    }

    public static Array asConcatenation(Array ... arrays) {
        return ArraysOpImpl.asConcatenation(arrays);
    }

    public static boolean isConcatenation(Array array) {
        return array instanceof ArraysOpImpl.ConcatenatedArray;
    }

    public static Array asShifted(Array array, long shift) {
        return ArraysOpImpl.asShifted(array, shift);
    }

    public static boolean isShifted(Array array) {
        return array instanceof ArraysOpImpl.ShiftedArray;
    }

    public static long getShift(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!Arrays.isShifted(array)) {
            throw new IllegalArgumentException("The passed argument is not a shifted array");
        }
        return ((ArraysOpImpl.ShiftedArray)((Object)array)).shift();
    }

    public static CopyStatus copy(UpdatableArray dest, Array src) {
        return Arrays.copy(ArrayContext.DEFAULT_SINGLE_THREAD, dest, src);
    }

    public static CopyStatus copy(ArrayContext context, UpdatableArray dest, Array src) {
        return Arrays.copy(context, dest, src, 0);
    }

    public static CopyStatus copy(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks) {
        return ArraysOpImpl.copy(context, dest, src, numberOfTasks, true, false);
    }

    public static CopyStatus copy(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, boolean strictMode) {
        return ArraysOpImpl.copy(context, dest, src, numberOfTasks, strictMode, false);
    }

    public static ComparingCopyStatus compareAndCopy(ArrayContext context, UpdatableArray dest, Array src) {
        return (ComparingCopyStatus)ArraysOpImpl.copy(context, dest, src, 0, true, true);
    }

    public static UpdatablePArray clone(PArray array) {
        return Arrays.clone((MemoryModel)SMM, array);
    }

    public static UpdatablePArray clone(MemoryModel memoryModel, PArray array) {
        return (UpdatablePArray)Arrays.clone(memoryModel, (Array)array);
    }

    public static UpdatableArray clone(MemoryModel memoryModel, Array array) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        Objects.requireNonNull(array, "Null array");
        UpdatableArray result = memoryModel.newUnresizableArray(array);
        Arrays.copy(null, result, array);
        return result;
    }

    public static Range rangeOf(PArray array, MinMaxInfo minMaxInfo) {
        return Arrays.rangeOf(null, array, minMaxInfo);
    }

    public static Range rangeOf(ArrayContext context, PArray array, MinMaxInfo minMaxInfo) {
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array)) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
        }
        if (minMaxInfo == null) {
            minMaxInfo = new MinMaxInfo();
        }
        ArraysOpImpl.RangeCalculator rangeCalculator = new ArraysOpImpl.RangeCalculator(context, array, minMaxInfo);
        rangeCalculator.process();
        return minMaxInfo.range();
    }

    public static Range rangeOf(PArray array) {
        return Arrays.rangeOf(null, array, null);
    }

    public static Range rangeOf(ArrayContext context, PArray array) {
        return Arrays.rangeOf(context, array, null);
    }

    public static double sumOf(PArray array) {
        return Arrays.sumOf(null, array);
    }

    public static double sumOf(ArrayContext context, PArray array) {
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array)) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
        }
        ArraysOpImpl.Summator summator = new ArraysOpImpl.Summator(context, array);
        summator.process();
        return summator.result();
    }

    public static long preciseSumOf(PFixedArray array, boolean checkOverflow) throws ArithmeticException {
        return Arrays.preciseSumOf(null, array, checkOverflow);
    }

    public static long preciseSumOf(ArrayContext context, PFixedArray array, boolean checkOverflow) throws ArithmeticException {
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array)) {
            array = (PFixedArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
        }
        ArraysOpImpl.PreciseSummator summator = new ArraysOpImpl.PreciseSummator(context, array, checkOverflow);
        summator.process();
        return summator.result();
    }

    public static long preciseSumOf(PFixedArray array) {
        return Arrays.preciseSumOf(null, array, false);
    }

    public static long preciseSumOf(ArrayContext context, PFixedArray array) {
        return Arrays.preciseSumOf(context, array, false);
    }

    public static long cardinality(ArrayContext context, BitArray bitArray) {
        return Arrays.preciseSumOf(context, bitArray, false);
    }

    public static long cardinality(BitArray bitArray) {
        return Arrays.preciseSumOf(null, bitArray, false);
    }

    public static boolean histogramOf(PArray array, long[] histogram, double from, double to) {
        return Arrays.histogramOf(null, array, histogram, from, to);
    }

    public static boolean histogramOf(ArrayContext context, PArray array, long[] histogram, double from, double to) {
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array)) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
        }
        Objects.requireNonNull(histogram, "Null histogram argument");
        if (histogram.length == 0) {
            throw new IllegalArgumentException("Empty histogram argument (histogram.length=0)");
        }
        ArraysOpImpl.HistogramCalculator histogramCalculator = new ArraysOpImpl.HistogramCalculator(context, array, histogram, from, to);
        histogramCalculator.process();
        return histogramCalculator.allInside;
    }

    public static void packBitsGreater(UpdatableBitArray bits, PArray array, double threshold) {
        Arrays.packBitsGreater(ArrayContext.DEFAULT_SINGLE_THREAD, bits, array, threshold);
    }

    public static void packBitsGreater(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (UpdatableBitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.BitsGreaterPacker packer = new ArraysOpImpl.BitsGreaterPacker(context, bits, array, threshold);
        packer.process();
    }

    public static void packBitsLess(UpdatableBitArray bits, PArray array, double threshold) {
        Arrays.packBitsLess(ArrayContext.DEFAULT_SINGLE_THREAD, bits, array, threshold);
    }

    public static void packBitsLess(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (UpdatableBitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.BitsLessPacker packer = new ArraysOpImpl.BitsLessPacker(context, bits, array, threshold);
        packer.process();
    }

    public static void packBitsGreaterOrEqual(UpdatableBitArray bits, PArray array, double threshold) {
        Arrays.packBitsGreaterOrEqual(ArrayContext.DEFAULT_SINGLE_THREAD, bits, array, threshold);
    }

    public static void packBitsGreaterOrEqual(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (UpdatableBitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.BitsGreaterOrEqualPacker packer = new ArraysOpImpl.BitsGreaterOrEqualPacker(context, bits, array, threshold);
        packer.process();
    }

    public static void packBitsLessOrEqual(UpdatableBitArray bits, PArray array, double threshold) {
        Arrays.packBitsLessOrEqual(ArrayContext.DEFAULT_SINGLE_THREAD, bits, array, threshold);
    }

    public static void packBitsLessOrEqual(ArrayContext context, UpdatableBitArray bits, PArray array, double threshold) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (PArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (UpdatableBitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.BitsLessOrEqualPacker packer = new ArraysOpImpl.BitsLessOrEqualPacker(context, bits, array, threshold);
        packer.process();
    }

    public static void unpackBits(UpdatablePArray array, BitArray bits, double filler0, double filler1) {
        Arrays.unpackBits(ArrayContext.DEFAULT_SINGLE_THREAD, array, bits, filler0, filler1);
    }

    public static void unpackBits(ArrayContext context, UpdatablePArray array, BitArray bits, double filler0, double filler1) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (UpdatablePArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (BitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.BothBitsUnpacker unpacker = new ArraysOpImpl.BothBitsUnpacker(context, array, bits, filler0, filler1);
        unpacker.process();
    }

    public static void unpackUnitBits(UpdatablePArray array, BitArray bits, double filler1) {
        Arrays.unpackUnitBits(ArrayContext.DEFAULT_SINGLE_THREAD, array, bits, filler1);
    }

    public static void unpackUnitBits(ArrayContext context, UpdatablePArray array, BitArray bits, double filler1) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (UpdatablePArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (BitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.UnitBitsUnpacker unpacker = new ArraysOpImpl.UnitBitsUnpacker(context, array, bits, filler1);
        unpacker.process();
    }

    public static void unpackZeroBits(UpdatablePArray array, BitArray bits, double filler0) {
        Arrays.unpackZeroBits(ArrayContext.DEFAULT_SINGLE_THREAD, array, bits, filler0);
    }

    public static void unpackZeroBits(ArrayContext context, UpdatablePArray array, BitArray bits, double filler0) {
        Objects.requireNonNull(bits, "Null bits argument");
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array) && Arrays.isTiled(bits) && java.util.Arrays.equals(Arrays.tiledMatrixDimensions(array), Arrays.tiledMatrixDimensions(bits)) && java.util.Arrays.equals(Arrays.tileDimensions(array), Arrays.tileDimensions(bits))) {
            array = (UpdatablePArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
            bits = (BitArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)bits)).baseMatrix().array();
        }
        ArraysOpImpl.ZeroBitsUnpacker unpacker = new ArraysOpImpl.ZeroBitsUnpacker(context, array, bits, filler0);
        unpacker.process();
    }

    public static PArray asPrecision(PArray array, Class<?> newElementType) {
        Objects.requireNonNull(array, "Null array");
        Objects.requireNonNull(newElementType, "Null newElementType");
        if (Arrays.bitsPerElement(newElementType) <= 0L) {
            throw new IllegalArgumentException("Element type must be primitive (boolean, char, byte, short, int, long, float or double");
        }
        if (newElementType == array.elementType()) {
            return array;
        }
        Class<PArray> newType = Arrays.type(PArray.class, newElementType);
        Range destRange = Range.of(0.0, Arrays.maxPossibleValue(newType));
        Range srcRange = Range.of(0.0, array.maxPossibleValue(1.0));
        return Arrays.asFuncArray(LinearFunc.getInstance(destRange, srcRange), newType, array);
    }

    public static void applyPrecision(UpdatablePArray result, PArray array) {
        Arrays.applyPrecision(null, result, array);
    }

    public static void applyPrecision(ArrayContext context, UpdatablePArray result, PArray array) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(array, "Null array");
        if (result.length() != array.length()) {
            throw new SizeMismatchException("array.length() and result.length() mismatch");
        }
        if (result.elementType() == array.elementType()) {
            Arrays.copy(context, result, array);
        } else if (array.elementType() == Boolean.TYPE) {
            Arrays.unpackBits(context, result, (BitArray)array, 0.0, result.maxPossibleValue(1.0));
        } else {
            Arrays.copy(context, result, Arrays.asPrecision(array, result.elementType()));
        }
    }

    public static void zeroFill(UpdatableArray array) {
        Objects.requireNonNull(array, "Null array argument");
        if (Arrays.isTiled(array)) {
            array = (UpdatableArray)((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().array();
        }
        if (array instanceof BitArray) {
            ((UpdatableBitArray)array).fill(false);
        } else if (array instanceof CharArray) {
            ((UpdatableCharArray)array).fill('\u0000');
        } else if (array instanceof ByteArray) {
            ((UpdatableByteArray)array).fill((byte)0);
        } else if (array instanceof ShortArray) {
            ((UpdatableShortArray)array).fill((short)0);
        } else if (array instanceof IntArray) {
            ((UpdatableIntArray)array).fill(0);
        } else if (array instanceof LongArray) {
            ((UpdatableLongArray)array).fill(0L);
        } else if (array instanceof FloatArray) {
            ((UpdatableFloatArray)array).fill(0.0f);
        } else if (array instanceof DoubleArray) {
            ((UpdatableDoubleArray)array).fill(0.0);
        } else if (array instanceof ObjectArray) {
            ((UpdatableObjectArray)array).fill(null);
        } else {
            throw new AssertionError((Object)("The array does not implement necessary interfaces: " + String.valueOf(array.getClass())));
        }
    }

    public static byte[] toBytes(byte[] bytes, PArray array, ByteOrder byteOrder) {
        Objects.requireNonNull(array, "Null array");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        long requiredLength = Arrays.sizeOfBytes(array);
        assert (requiredLength == (long)((int)requiredLength));
        if (bytes == null) {
            bytes = new byte[(int)requiredLength];
        } else if ((long)bytes.length < requiredLength) {
            throw new IllegalArgumentException("Not enough space to copy the AlgART array into byte[] array: " + requiredLength + " bytes required, but only " + bytes.length + " available");
        }
        if (array instanceof ByteArray) {
            assert (requiredLength == array.length());
            array.getData(0L, bytes, 0, (int)requiredLength);
        } else if (array instanceof BitArray) {
            BitArray a = (BitArray)array;
            long[] data = a.jaBit();
            assert ((long)data.length * 8L >= requiredLength);
            PackedBitArraysPer8.toByteArray(bytes, data, array.length());
        } else if (array instanceof CharArray) {
            CharArray a = (CharArray)array;
            char[] data = a.ja();
            JArrays.charArrayToBytes(bytes, data, data.length, byteOrder);
        } else if (array instanceof ShortArray) {
            ShortArray a = (ShortArray)array;
            short[] data = a.ja();
            JArrays.shortArrayToBytes(bytes, data, data.length, byteOrder);
        } else if (array instanceof IntArray) {
            IntArray a = (IntArray)array;
            int[] data = a.ja();
            JArrays.intArrayToBytes(bytes, data, data.length, byteOrder);
        } else if (array instanceof LongArray) {
            LongArray a = (LongArray)array;
            long[] data = a.ja();
            JArrays.longArrayToBytes(bytes, data, data.length, byteOrder);
        } else if (array instanceof FloatArray) {
            FloatArray a = (FloatArray)array;
            float[] data = a.ja();
            JArrays.floatArrayToBytes(bytes, data, data.length, byteOrder);
        } else if (array instanceof DoubleArray) {
            DoubleArray a = (DoubleArray)array;
            double[] data = a.ja();
            JArrays.doubleArrayToBytes(bytes, data, data.length, byteOrder);
        } else {
            throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(array.getClass())));
        }
        return bytes;
    }

    public static void toArray(UpdatablePArray array, byte[] bytes, ByteOrder byteOrder) {
        Objects.requireNonNull(array, "Null array");
        Objects.requireNonNull(bytes, "Null bytes Java array");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        long requiredLength = Arrays.sizeOfBytes(array);
        if ((long)bytes.length < requiredLength) {
            throw new IllegalArgumentException("byte[] array is too short to copy into all elements of the AlgART array: " + requiredLength + " bytes required, but only " + bytes.length + " available");
        }
        if (array instanceof UpdatableByteArray) {
            assert (requiredLength == array.length());
            array.setData(0L, bytes, 0, (int)requiredLength);
        } else if (array instanceof UpdatableBitArray) {
            UpdatableBitArray a = (UpdatableBitArray)array;
            long packedLength = PackedBitArrays.packedLength(a.length());
            assert (packedLength <= Integer.MAX_VALUE);
            assert (packedLength * 8L >= requiredLength);
            long[] data = PackedBitArraysPer8.toLongArray(bytes, a.length());
            a.setBits(0L, data, 0L, a.length());
        } else if (array instanceof UpdatableCharArray) {
            char[] data = JArrays.bytesToCharArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else if (array instanceof UpdatableShortArray) {
            short[] data = JArrays.bytesToShortArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else if (array instanceof UpdatableIntArray) {
            int[] data = JArrays.bytesToIntArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else if (array instanceof UpdatableLongArray) {
            long[] data = JArrays.bytesToLongArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else if (array instanceof UpdatableFloatArray) {
            float[] data = JArrays.bytesToFloatArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else if (array instanceof UpdatableDoubleArray) {
            double[] data = JArrays.bytesToDoubleArray(bytes, array.length32(), byteOrder);
            array.setData(0L, data, 0, data.length);
        } else {
            throw new AssertionError((Object)("Unallowed type of passed array: " + String.valueOf(array.getClass())));
        }
    }

    public static int sizeOfBytes(PArray array) {
        long requiredLength;
        Objects.requireNonNull(array, "Null array");
        long l = requiredLength = array instanceof BitArray ? array.length() + 7L >>> 3 : Arrays.sizeOf(array);
        if (requiredLength > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot calculate required number of bytes for  copying AlgART array to byte[] array, because it is too large: " + String.valueOf(array));
        }
        return (int)requiredLength;
    }

    public static void write(OutputStream outputStream, PArray array, ByteOrder byteOrder) throws IOException {
        ArraysSerializationImpl.write(outputStream, array, byteOrder);
    }

    public static void read(InputStream inputStream, UpdatablePArray array, ByteOrder byteOrder) throws IOException {
        ArraysSerializationImpl.read(inputStream, array, byteOrder);
    }

    public static String toString(CharArray charArray) {
        int count;
        int offset;
        Objects.requireNonNull(charArray, "Null charArray argument");
        char[] array = (char[])Arrays.javaArrayInternal(charArray);
        if (array != null) {
            offset = Arrays.javaArrayOffsetInternal(charArray);
            count = (int)charArray.length();
        } else {
            array = charArray.toJavaArray();
            offset = 0;
            count = array.length;
        }
        return new String(array, offset, count);
    }

    public static String toString(Array array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        long n = array.length();
        if (n == 0L) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        if (array instanceof BitArray) {
            BitArray a = (BitArray)array;
            ca.append(String.valueOf(a.getBit(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getBit(k)));
            }
        } else if (array instanceof CharArray) {
            CharArray a = (CharArray)array;
            ca.append(String.valueOf(a.getChar(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getChar(k)));
            }
        } else if (array instanceof ByteArray) {
            ByteArray a = (ByteArray)array;
            ca.append(String.valueOf(a.getByte(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getByte(k)));
            }
        } else if (array instanceof ShortArray) {
            ShortArray a = (ShortArray)array;
            ca.append(String.valueOf(a.getShort(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getShort(k)));
            }
        } else if (array instanceof IntArray) {
            IntArray a = (IntArray)array;
            ca.append(String.valueOf(a.getInt(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getInt(k)));
            }
        } else if (array instanceof LongArray) {
            LongArray a = (LongArray)array;
            ca.append(String.valueOf(a.getLong(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getLong(k)));
            }
        } else if (array instanceof FloatArray) {
            FloatArray a = (FloatArray)array;
            ca.append(String.valueOf(a.getFloat(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getFloat(k)));
            }
        } else if (array instanceof DoubleArray) {
            DoubleArray a = (DoubleArray)array;
            ca.append(String.valueOf(a.getDouble(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.getDouble(k)));
            }
        } else if (array instanceof ObjectArray) {
            ObjectArray a = (ObjectArray)array;
            ca.append(String.valueOf(a.get(0L)));
            for (long k = 1L; k < n; ++k) {
                if (ca.length() >= (long)maxStringLength) {
                    ca.append(separator).append("...");
                    break;
                }
                ca.append(separator).append(String.valueOf(a.get(k)));
            }
        } else {
            throw new AssertionError((Object)("Unallowed type of passed argument: " + String.valueOf(array.getClass())));
        }
        return Arrays.toString(ca);
    }

    public static String toString(Array array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        long n = array.length();
        if (n == 0L) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        if (array instanceof ByteArray) {
            ByteArray a = (ByteArray)array;
            cv.append(String.format(locale, format, a.getByte(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, a.getByte(k)));
            }
        } else if (array instanceof ShortArray) {
            ShortArray a = (ShortArray)array;
            cv.append(String.format(locale, format, a.getShort(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, a.getShort(k)));
            }
        } else if (array instanceof IntArray) {
            IntArray a = (IntArray)array;
            cv.append(String.format(locale, format, a.getInt(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, a.getInt(k)));
            }
        } else if (array instanceof LongArray) {
            LongArray a = (LongArray)array;
            cv.append(String.format(locale, format, a.getLong(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, a.getLong(k)));
            }
        } else if (array instanceof FloatArray) {
            FloatArray a = (FloatArray)array;
            cv.append(String.format(locale, format, Float.valueOf(a.getFloat(0L))));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, Float.valueOf(a.getFloat(k))));
            }
        } else if (array instanceof DoubleArray) {
            DoubleArray a = (DoubleArray)array;
            cv.append(String.format(locale, format, a.getDouble(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(String.format(locale, format, a.getDouble(k)));
            }
        } else {
            return Arrays.toString(array, separator, maxStringLength);
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(Array array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        long n = array.length();
        if (n == 0L) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        if (array instanceof BitArray) {
            BitArray a = (BitArray)array;
            cv.append(a.getBit(0L) ? "1" : "0");
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(a.getBit(k) ? "1" : "0");
            }
        } else if (array instanceof CharArray) {
            CharArray a = (CharArray)array;
            cv.append(InternalUtils.toHexString((short)a.getChar(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(InternalUtils.toHexString((short)a.getChar(k)));
            }
        } else if (array instanceof ByteArray) {
            ByteArray a = (ByteArray)array;
            cv.append(InternalUtils.toHexString((byte)a.getByte(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(InternalUtils.toHexString((byte)a.getByte(k)));
            }
        } else if (array instanceof ShortArray) {
            ShortArray a = (ShortArray)array;
            cv.append(InternalUtils.toHexString((short)a.getShort(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(InternalUtils.toHexString((short)a.getShort(k)));
            }
        } else if (array instanceof IntArray) {
            IntArray a = (IntArray)array;
            cv.append(InternalUtils.toHexString(a.getInt(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(InternalUtils.toHexString(a.getInt(k)));
            }
        } else if (array instanceof LongArray) {
            LongArray a = (LongArray)array;
            cv.append(InternalUtils.toHexString(a.getLong(0L)));
            for (long k = 1L; k < n; ++k) {
                if (cv.length() >= (long)maxStringLength) {
                    cv.append(separator).append("...");
                    break;
                }
                cv.append(separator).append(InternalUtils.toHexString(a.getLong(k)));
            }
        } else {
            return Arrays.toString(array, separator, maxStringLength);
        }
        return Arrays.toString(cv);
    }

    public static void lengthUnsigned(MutableArray array, long newUnsignedLength) {
        if (newUnsignedLength < 0L) {
            throw new TooLargeArrayException("Too large desired array length (>=2^63)");
        }
        array.length(newUnsignedLength);
    }

    public static int goodStartOffsetInArrayOfLongs(BitArray bitArray, long position, int maxAvailableGap) {
        Objects.requireNonNull(bitArray, "Null bitArray argument");
        if (maxAvailableGap < 0) {
            throw new IllegalArgumentException("Negative maxAvailableGap argument");
        }
        if (maxAvailableGap == 0) {
            return 0;
        }
        long qp = bitArray.nextQuickPosition(position -= (long)Math.max(maxAvailableGap = Integer.highestOneBit(maxAvailableGap), 64));
        if (qp == -1L) {
            return 0;
        }
        if (qp < position || qp >= bitArray.length()) {
            throw new AssertionError((Object)("Illegal nextQuickPosition implementation in " + String.valueOf(bitArray) + ": nextQuickPosition(" + position + ") = " + qp + (String)(qp < position ? " < " + position : " >= array.length()")));
        }
        return (int)(position - qp) & maxAvailableGap - 1;
    }

    public static void insertBit(MutableBitArray array, long index, boolean value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertBit method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertBit method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.setBit(index, value);
    }

    public static void insertChar(MutableCharArray array, long index, char value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertChar method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertChar method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.setChar(index, value);
    }

    public static void insertInt(MutablePIntegerArray array, long index, int value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertInt method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertInt method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.setInt(index, value);
    }

    public static void insertLong(MutablePIntegerArray array, long index, long value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertLong method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertLong method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.setLong(index, value);
    }

    public static void insertDouble(MutablePFloatingArray array, long index, double value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertDouble method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertDouble method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.setDouble(index, value);
    }

    public static <E> void insertObject(MutableObjectArray<E> array, long index, E value) {
        long len = array.length();
        if (index < 0L) {
            throw new IndexOutOfBoundsException("Negative index (" + index + ") in insertObject method");
        }
        if (index > len) {
            throw new IndexOutOfBoundsException("Index (" + index + ") > length (" + len + ") in insertObject method");
        }
        Arrays.lengthUnsigned(array, len + 1L);
        array.copy(index + 1L, index, len - index);
        array.set(index, value);
    }

    public static void insertEmptyRange(MutableArray array, long position, long count) {
        long len = array.length();
        if (position < 0L) {
            throw new IndexOutOfBoundsException("Negative position (" + position + ") in insertEmptyRange method");
        }
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of elements (" + count + ") in insertEmptyRange method");
        }
        if (count > 0L) {
            Arrays.lengthUnsigned(array, len + count);
            array.copy(position + count, position, len - position);
        }
    }

    public static void remove(MutableArray array, long position) {
        Arrays.removeRange(array, position, 1L);
    }

    public static void removeRange(MutableArray array, long position, long count) {
        long len = array.length();
        if (position < 0L) {
            throw new IndexOutOfBoundsException("Negative position (" + position + ") in removeRange method");
        }
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of elements (" + count + ") in removeRange method");
        }
        if (position + count > len) {
            throw new IndexOutOfBoundsException("High index (" + (position + count - 1L) + ") > length (" + len + ") in removeRange method");
        }
        array.copy(position, position + count, len - (position + count));
        array.length(len - count);
    }

    public static void sort(UpdatableArray array, ArrayComparator comparator) {
        Objects.requireNonNull(array, "Null array argument");
        if (array instanceof UpdatableBitArray) {
            UpdatableBitArray bitArray = (UpdatableBitArray)array;
            MinMaxInfo mmInfo = new MinMaxInfo();
            Arrays.rangeOf(null, bitArray, mmInfo);
            if (mmInfo.min() == mmInfo.max()) {
                return;
            }
            boolean lessElement = !comparator.less(mmInfo.indexOfMin(), mmInfo.indexOfMax());
            boolean greaterElement = !lessElement;
            long len = bitArray.length();
            long cardinality = Arrays.cardinality(bitArray);
            long numberOfLessElements = lessElement ? cardinality : len - cardinality;
            bitArray.fill(0L, numberOfLessElements, lessElement);
            bitArray.fill(numberOfLessElements, len - numberOfLessElements, greaterElement);
        } else {
            ArraySorter.getQuickSorter().sort(0L, array.length(), comparator, array);
        }
    }

    public static ArrayComparator normalOrderComparator(UpdatableArray array) {
        return ArraysOpImpl.defaultComparator(array, false);
    }

    public static ArrayComparator reverseOrderComparator(UpdatableArray array) {
        return ArraysOpImpl.defaultComparator(array, true);
    }

    public static CharSequence asCharSequence(CharArray charArray) {
        return new AlgARTArrayCharSequence(charArray);
    }

    public static <E> List<E> asList(Array array, Class<E> listElementType) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(listElementType, "Null listElementType argument");
        Class<Object> eType = array.elementType();
        if (eType == Boolean.TYPE) {
            eType = Boolean.class;
        } else if (eType == Character.TYPE) {
            eType = Character.class;
        } else if (eType == Byte.TYPE) {
            eType = Byte.class;
        } else if (eType == Short.TYPE) {
            eType = Short.class;
        } else if (eType == Integer.TYPE) {
            eType = Integer.class;
        } else if (eType == Long.TYPE) {
            eType = Long.class;
        } else if (eType == Float.TYPE) {
            eType = Float.class;
        } else if (eType == Double.TYPE) {
            eType = Double.class;
        }
        if (!listElementType.isAssignableFrom(eType)) {
            throw new ClassCastException("The passed array element type cannot be stored in List<" + String.valueOf(listElementType) + "> (" + String.valueOf(array) + ")");
        }
        return new AlgARTArrayList(array);
    }

    public static <E> List<E> asList(ObjectArray<E> array) {
        Objects.requireNonNull(array, "Null array argument");
        return new AlgARTArrayList(array);
    }

    public static Array[] getUnderlyingArrays(Array array) {
        return Arrays.getUnderlyingArrays(array, false);
    }

    public static boolean[] getUnderlyingArraysNewStatus(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!(array instanceof AbstractArray)) {
            return new boolean[0];
        }
        Array[] underlyingArrays = ((AbstractArray)array).underlyingArrays;
        boolean[] result = new boolean[underlyingArrays.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = underlyingArrays[k].isNew();
        }
        return result;
    }

    public static int getUnderlyingArraysCount(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        if (!(array instanceof AbstractArray)) {
            return 0;
        }
        return ((AbstractArray)array).underlyingArrays.length;
    }

    public static int round32(double value) {
        long i = StrictMath.round(value);
        return i < -2147483647L ? -2147483647 : (i > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)i);
    }

    public static long longMul(long[] multipliers, int from, int to) {
        if (to > multipliers.length || from < 0) {
            throw new IndexOutOfBoundsException("Indexes out of bounds 0.." + multipliers.length + ": from = " + from + ", to = " + to);
        }
        if (from > to) {
            throw new IllegalArgumentException("Illegal indexes: from = " + from + " > to = " + to);
        }
        if (from == to) {
            return 1L;
        }
        long result = multipliers[from];
        for (int k = from + 1; k < to; ++k) {
            result = Arrays.longMul(result, multipliers[k]);
        }
        return result;
    }

    public static long longMul(long ... multipliers) {
        if (multipliers.length == 0) {
            return 1L;
        }
        long result = multipliers[0];
        for (int k = 1; k < multipliers.length; ++k) {
            result = Arrays.longMul(result, multipliers[k]);
        }
        return result;
    }

    public static long longMul(long a, long b) {
        long c;
        long d;
        boolean sign = false;
        if (a < 0L) {
            a = -a;
            sign = true;
        }
        if (b < 0L) {
            b = -b;
            sign = !sign;
        }
        long aL = a & 0xFFFFFFFFL;
        long aH = a >>> 32;
        long bL = b & 0xFFFFFFFFL;
        long bH = b >>> 32;
        if (aH == 0L) {
            if (bH == 0L) {
                long d2 = aL * bL;
                if (d2 < 0L) {
                    return Long.MIN_VALUE;
                }
                return sign ? -d2 : d2;
            }
            d = aL * bL;
            if (d < 0L) {
                return Long.MIN_VALUE;
            }
            c = aL * bH;
        } else if (bH == 0L) {
            d = aL * bL;
            if (d < 0L) {
                return Long.MIN_VALUE;
            }
            c = aH * bL;
        } else {
            return Long.MIN_VALUE;
        }
        if (c > Integer.MAX_VALUE) {
            return Long.MIN_VALUE;
        }
        long result = (c << 32) + d;
        if (result < 0L) {
            return Long.MIN_VALUE;
        }
        return sign ? -result : result;
    }

    public static long compactCyclicPositions(long length, long[] positions) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Negative or zero length argument: " + length);
        }
        Objects.requireNonNull(positions, "Null positions array");
        for (int k = 0; k < positions.length; ++k) {
            if (positions[k] >= 0L && positions[k] < length) continue;
            throw new IllegalArgumentException("positions[" + k + "] is out of range 0..length-1=" + (length - 1L));
        }
        if (positions.length == 0) {
            return 0L;
        }
        if (positions.length == 1) {
            long result = positions[0];
            positions[0] = 0L;
            return result;
        }
        long half = length / 2L;
        boolean sorted = true;
        for (int k = 0; k < positions.length; ++k) {
            int n = k;
            positions[n] = positions[n] - half;
            if (k <= 0 || positions[k] >= positions[k - 1]) continue;
            sorted = false;
        }
        if (!sorted) {
            java.util.Arrays.sort(positions);
        }
        long maxGap = positions[0] - positions[positions.length - 1] + length;
        int maxGapRightIndex = 0;
        if (maxGap > half) {
            assert (positions[positions.length - 1] - positions[0] <= half);
        } else {
            for (int k = 1; k < positions.length; ++k) {
                assert (positions[k] >= positions[k - 1]) : "not sorted!";
                if (positions[k] - positions[k - 1] <= maxGap) continue;
                maxGap = positions[k] - positions[k - 1];
                maxGapRightIndex = k;
            }
        }
        long result = positions[maxGapRightIndex];
        for (int k = 0; k < positions.length; ++k) {
            int n = k;
            positions[n] = positions[n] - result;
            if (positions[k] >= 0L) continue;
            assert (maxGapRightIndex > 0);
            int n2 = k;
            positions[n2] = positions[n2] + length;
        }
        if (maxGapRightIndex > 0) {
            Arrays.rotate(positions, positions.length - maxGapRightIndex);
        }
        return result + half;
    }

    public static void splitToRanges(int[] result, int n) {
        Objects.requireNonNull(result, "Null result");
        if (result.length == 0) {
            throw new IllegalArgumentException("Result ranges array must contain at least 1 element");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative number of elements: " + n);
        }
        int numberOfRanges = result.length - 1;
        result[0] = 0;
        result[numberOfRanges] = n;
        for (int k = 1; k < numberOfRanges; ++k) {
            result[k] = (int)((double)n * (double)k / (double)numberOfRanges);
        }
    }

    public static void splitToRanges(long[] result, long n) {
        Objects.requireNonNull(result, "Null result");
        if (result.length == 0) {
            throw new IllegalArgumentException("Result ranges array must contain at least 1 element");
        }
        if (n < 0L) {
            throw new IllegalArgumentException("Negative number of elements: " + n);
        }
        int numberOfRanges = result.length - 1;
        result[0] = 0L;
        result[numberOfRanges] = n;
        for (int k = 1; k < numberOfRanges; ++k) {
            result[k] = (long)((double)n * (double)k / (double)numberOfRanges);
        }
    }

    public static ThreadPoolFactory getThreadPoolFactory(ArrayContext context) {
        return context == null ? DefaultThreadPoolFactory.getDefaultThreadPoolFactory() : context.getThreadPoolFactory();
    }

    public static void freeAllResources() {
        DataStorage.freeAllResources();
    }

    public static boolean gcAndAwaitFinalization(int timeoutInMilliseconds) throws InterruptedException {
        if (timeoutInMilliseconds <= 0) {
            throw new IllegalArgumentException("timeoutInMilliseconds must be positive");
        }
        long tFix = System.currentTimeMillis();
        long delay = 100L;
        while (LargeMemoryModel.activeFinalizationTasksCount() > 0) {
            long t1 = System.currentTimeMillis();
            if (t1 - tFix > (long)timeoutInMilliseconds) {
                return false;
            }
            System.gc();
            long t2 = System.currentTimeMillis();
            if (LargeMemoryModel.activeFinalizationTasksCount() == 0) break;
            long sleepTime = Math.min(t2 - t1 + delay, 10000L);
            sleepTime = Math.min(sleepTime, (long)timeoutInMilliseconds - (t2 - tFix));
            Thread.sleep(Math.max(50L, sleepTime));
            delay += 200L;
        }
        for (int k = 0; k < 4; ++k) {
            System.gc();
            Thread.sleep(50L);
        }
        return true;
    }

    public static <T extends Exception> void throwException(Class<? extends T> exceptionClass, Throwable exception) throws T {
        if (exceptionClass.isInstance(exception)) {
            throw (Exception)exceptionClass.cast(exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw new AssertionError((Object)("Impossible exception: " + String.valueOf(exception)));
    }

    public static void throwUncheckedException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        throw new AssertionError((Object)("Impossible checked exception: " + String.valueOf(exception)));
    }

    public static void addShutdownTask(Runnable task, TaskExecutionOrder whenToExecute) {
        Objects.requireNonNull(task, "Null task argument");
        Objects.requireNonNull(whenToExecute, "Null whenToExecute argument");
        InternalUtils.addShutdownTask(task, whenToExecute);
    }

    static long lengthOf(Array array, long sizeInBytes) {
        if (sizeInBytes < 0L) {
            throw new IllegalArgumentException("Negative sizeInBytes");
        }
        long len = array.length();
        long size = Arrays.sizeOf(array);
        if (len == 0L) {
            return 0L;
        }
        if (size < 0L) {
            return sizeInBytes / 4L;
        }
        return (long)((double)sizeInBytes * ((double)len / (double)size));
    }

    static Object javaArrayInternal(Array array) {
        if (array instanceof AbstractArray) {
            return ((AbstractArray)array).javaArrayInternal();
        }
        if (array instanceof DirectAccessible && ((DirectAccessible)((Object)array)).hasJavaArray()) {
            return ((DirectAccessible)((Object)array)).javaArray();
        }
        return null;
    }

    static int javaArrayOffsetInternal(Array array) {
        if (array instanceof AbstractArray) {
            return ((AbstractArray)array).javaArrayOffsetInternal();
        }
        if (array instanceof DirectAccessible && ((DirectAccessible)((Object)array)).hasJavaArray()) {
            return ((DirectAccessible)((Object)array)).javaArrayOffset();
        }
        return 0;
    }

    static long[] longJavaArrayInternal(BitArray bitArray) {
        if (bitArray instanceof SimpleArraysImpl.JABitArray) {
            return ((SimpleArraysImpl.JABitArray)bitArray).bitArray;
        }
        if (bitArray instanceof SimpleArraysImpl.JABitSubArray) {
            return ((SimpleArraysImpl.JABitSubArray)bitArray).bitArray;
        }
        return null;
    }

    static long longJavaArrayOffsetInternal(BitArray bitArray) {
        if (bitArray instanceof SimpleArraysImpl.JABitSubArray) {
            return ((SimpleArraysImpl.JABitSubArray)bitArray).offset;
        }
        return 0L;
    }

    static boolean isTiled(Array array) {
        return array instanceof ArraysTileMatrixImpl.TileMatrixArray;
    }

    static boolean isTiledOrSubMatrixOfTiled(Array array) {
        if (array instanceof ArraysSubMatrixImpl.SubMatrixArray) {
            return Arrays.isTiledOrSubMatrixOfTiled(((ArraysSubMatrixImpl.SubMatrixArray)((Object)array)).baseMatrix().array());
        }
        return array instanceof ArraysTileMatrixImpl.TileMatrixArray;
    }

    static long[] tileDimensions(Array array) {
        return ((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).tileDimensions();
    }

    static long[] tiledMatrixDimensions(Array array) {
        return ((ArraysTileMatrixImpl.TileMatrixArray)((Object)array)).baseMatrix().dimensions();
    }

    static Array[] getUnderlyingArrays(Array array, boolean trusted) {
        Objects.requireNonNull(array, "Null array argument");
        if (!(array instanceof AbstractArray)) {
            return new Array[0];
        }
        Array[] underlyingArrays = ((AbstractArray)array).underlyingArrays;
        if (trusted) {
            return underlyingArrays;
        }
        Array[] result = new Array[underlyingArrays.length];
        boolean thisImmutable = array.isImmutable();
        for (int k = 0; k < result.length; ++k) {
            result[k] = thisImmutable ? underlyingArrays[k].asImmutable() : underlyingArrays[k].shallowClone();
        }
        return result;
    }

    static DataBuffer bufferInternal(Array array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
        if (array instanceof BitArray) {
            return new DataBuffersImpl.ArrayBitBuffer((BitArray)array, mode, capacity, trusted);
        }
        if (array instanceof CharArray) {
            return new DataBuffersImpl.ArrayCharBuffer((CharArray)array, mode, capacity, trusted);
        }
        if (array instanceof ByteArray) {
            return new DataBuffersImpl.ArrayByteBuffer((ByteArray)array, mode, capacity, trusted);
        }
        if (array instanceof ShortArray) {
            return new DataBuffersImpl.ArrayShortBuffer((ShortArray)array, mode, capacity, trusted);
        }
        if (array instanceof IntArray) {
            return new DataBuffersImpl.ArrayIntBuffer((IntArray)array, mode, capacity, trusted);
        }
        if (array instanceof LongArray) {
            return new DataBuffersImpl.ArrayLongBuffer((LongArray)array, mode, capacity, trusted);
        }
        if (array instanceof FloatArray) {
            return new DataBuffersImpl.ArrayFloatBuffer((FloatArray)array, mode, capacity, trusted);
        }
        if (array instanceof DoubleArray) {
            return new DataBuffersImpl.ArrayDoubleBuffer((DoubleArray)array, mode, capacity, trusted);
        }
        if (array instanceof ObjectArray) {
            return new DataBuffersImpl.ArrayObjectBuffer((ObjectArray)InternalUtils.cast(array), mode, capacity, trusted);
        }
        return new DataBuffersImpl.ArrayBuffer(array, mode, capacity, trusted);
    }

    static DataBuffer bufferInternal(Array array, DataBuffer.AccessMode mode) {
        return Arrays.bufferInternal(array, mode, AbstractArray.defaultBufferCapacity(array), true);
    }

    static void enableCaching(DataBuffer dataBuffer) {
        if (dataBuffer instanceof DataBuffersImpl.ArrayBuffer) {
            ((DataBuffersImpl.ArrayBuffer)dataBuffer).caching = true;
        }
    }

    static void dispose(DataBuffer dataBuffer) {
        if (dataBuffer instanceof DataBuffersImpl.ArrayBuffer) {
            ((DataBuffersImpl.ArrayBuffer)dataBuffer).dispose();
        }
    }

    static int truncateLongToInt(long value) {
        return value == (long)((int)value) ? (int)value : (value > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE);
    }

    static ObjectArray<?> nObjectCopies(long n, Object element, Class<?> nullType) {
        return element != null ? Arrays.nObjectCopies(n, element) : Arrays.nNullCopies(n, nullType);
    }

    static void checkElementTypeForNullAndVoid(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType");
        if (elementType == Void.TYPE) {
            throw new IllegalArgumentException("Illegal elementType: it cannot be void.class");
        }
    }

    private static void rotate(long[] array, int distance) {
        if (array.length == 0) {
            return;
        }
        if ((distance %= array.length) < 0) {
            distance += array.length;
        }
        if (distance == 0) {
            return;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != array.length) {
            long displaced = array[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= array.length) {
                    i -= array.length;
                }
                long temp = array[i];
                array[i] = displaced;
                displaced = temp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
    }

    static {
        Class dummy = InternalUtils.class;
        SimpleMemoryModel.getInstance();
        BufferMemoryModel.getInstance();
        LargeMemoryModel.getInstance();
        dummy = MappedDataStorages.class;
        dummy = DirectDataStorages.class;
        SystemSettings.globalMemoryModel();
        SMM = SimpleMemoryModel.INSTANCE;
        BMM = BufferMemoryModel.INSTANCE;
        PRIMITIVE_TYPES = List.of(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    }

    public static class CopyStatus {
        private final CopyAlgorithm algorithm;
        private final boolean strictMode;

        CopyStatus(CopyAlgorithm algorithm, boolean strictMode) {
            this.algorithm = algorithm;
            this.strictMode = strictMode;
        }

        public CopyAlgorithm algorithm() {
            return this.algorithm;
        }

        public boolean strictMode() {
            return this.strictMode;
        }

        public String toString() {
            return "copied by " + String.valueOf((Object)this.algorithm) + (this.strictMode ? "" : ", non-strict mode");
        }
    }

    public static class ComparingCopyStatus
    extends CopyStatus {
        private final boolean changed;

        ComparingCopyStatus(CopyAlgorithm algorithm, boolean strictMode, boolean changed) {
            super(algorithm, strictMode);
            this.changed = changed;
        }

        public boolean changed() {
            return this.changed;
        }

        @Override
        public String toString() {
            return super.toString() + ", " + (this.changed ? "changed" : "not changed");
        }
    }

    public static final class MinMaxInfo {
        private final Object lock = new Object();
        private boolean initialized = false;
        private long indexOfMin;
        private long indexOfMax;
        private Range range;
        private boolean allNaN = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInitialized() {
            Object object = this.lock;
            synchronized (object) {
                return this.initialized;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long indexOfMin() {
            Object object = this.lock;
            synchronized (object) {
                this.checkInitialized();
                return this.indexOfMin;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long indexOfMax() {
            Object object = this.lock;
            synchronized (object) {
                this.checkInitialized();
                return this.indexOfMax;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double min() {
            Object object = this.lock;
            synchronized (object) {
                this.checkInitialized();
                return this.range.min();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double max() {
            Object object = this.lock;
            synchronized (object) {
                this.checkInitialized();
                return this.range.max();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Range range() {
            Object object = this.lock;
            synchronized (object) {
                this.checkInitialized();
                return this.range;
            }
        }

        public boolean allNaN() {
            return this.allNaN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    return "not initialized MinMaxInfo";
                }
                return this.allNaN ? "NaN-filled" : String.valueOf(this.range) + " (minimum at " + this.indexOfMin + ", maximum at " + this.indexOfMax + ")";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                int iMin = (int)this.indexOfMin * 37 + (int)(this.indexOfMin >>> 32);
                int iMax = (int)this.indexOfMax * 37 + (int)(this.indexOfMax >>> 32);
                return (iMin * 37 + iMax) * 37 + this.range.hashCode() + (this.initialized ? 157 : 11) + (this.allNaN ? 73812 : 327);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof MinMaxInfo)) {
                return false;
            }
            MinMaxInfo o = (MinMaxInfo)obj;
            Object object = this.lock;
            synchronized (object) {
                Object object2 = o.lock;
                synchronized (object2) {
                    o.initialized = this.initialized && o.indexOfMin == this.indexOfMin && o.indexOfMax == this.indexOfMax && o.range.equals(this.range) && o.allNaN == this.allNaN;
                    return o.initialized;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setEmpty() {
            Object object = this.lock;
            synchronized (object) {
                this.indexOfMin = -1L;
                this.indexOfMax = -1L;
                this.range = Range.of(0.0, 0.0);
                this.allNaN = false;
                this.initialized = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setAll(long indexOfMin, long indexOfMax, PArray src) {
            Object object = this.lock;
            synchronized (object) {
                if (indexOfMin == -1L && indexOfMax == -1L) {
                    this.indexOfMax = 0L;
                    this.indexOfMin = 0L;
                    this.range = Range.of(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    this.allNaN = true;
                } else {
                    double min;
                    double max;
                    if (indexOfMin == -1L) {
                        indexOfMin = indexOfMax;
                        min = max = src.getDouble(indexOfMax);
                        assert (min == Double.POSITIVE_INFINITY);
                    } else if (indexOfMax == -1L) {
                        indexOfMax = indexOfMin;
                        min = max = src.getDouble(indexOfMin);
                        assert (max == Double.NEGATIVE_INFINITY);
                    } else {
                        min = src.getDouble(indexOfMin);
                        if (min > (max = src.getDouble(indexOfMax))) {
                            throw new AssertionError((Object)"Illegal min and max");
                        }
                    }
                    this.indexOfMin = indexOfMin;
                    this.indexOfMax = indexOfMax;
                    this.range = Range.of(min, max);
                    this.allNaN = false;
                }
                this.initialized = true;
            }
        }

        private void checkInitialized() {
            if (!this.initialized) {
                throw new IllegalStateException("This instance is not initialized by rangeOf method yet");
            }
        }
    }

    private static class AlgARTArrayCharSequence
    implements CharSequence {
        private final CharArray charArray;

        private AlgARTArrayCharSequence(CharArray charArray) {
            Objects.requireNonNull(charArray, "Null charArray argument");
            if (charArray.length() > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Cannot view AlgART array as CharSequence, because it is too large: " + String.valueOf(charArray));
            }
            this.charArray = charArray;
        }

        @Override
        public int length() {
            return (int)this.charArray.length();
        }

        @Override
        public char charAt(int index) {
            return this.charArray.getChar(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new AlgARTArrayCharSequence((CharArray)this.charArray.subArray(start, end));
        }

        @Override
        public String toString() {
            return Arrays.toString(this.charArray);
        }
    }

    private static class AlgARTArrayList<E>
    extends AbstractList<E>
    implements RandomAccess {
        private final Array array;

        AlgARTArrayList(Array array) {
            Objects.requireNonNull(array);
            if (array.length() > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Cannot view AlgART array as List, because it is too large: " + String.valueOf(array));
            }
            this.array = array;
        }

        @Override
        public int size() {
            long len = this.array.length();
            if (len > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("Cannot access List based on AlgART array, because it is too large: " + String.valueOf(this.array));
            }
            return (int)len;
        }

        @Override
        public Object[] toArray() {
            Comparable<Boolean>[] result;
            if (!(this.array instanceof PArray)) {
                return (Object[])this.array.toJavaArray();
            }
            long len = this.array.length();
            if (len != (long)((int)len)) {
                throw new TooLargeArrayException("Cannot convert List based on AlgART array to Java array, because it is too large: " + String.valueOf(this.array));
            }
            Class<?> et = this.array.elementType();
            if (et == Boolean.TYPE) {
                result = new Boolean[(int)len];
            } else if (et == Character.TYPE) {
                result = new Character[(int)len];
            } else if (et == Byte.TYPE) {
                result = new Byte[(int)len];
            } else if (et == Short.TYPE) {
                result = new Short[(int)len];
            } else if (et == Integer.TYPE) {
                result = new Integer[(int)len];
            } else if (et == Long.TYPE) {
                result = new Long[(int)len];
            } else if (et == Float.TYPE) {
                result = new Float[(int)len];
            } else if (et == Double.TYPE) {
                result = new Double[(int)len];
            } else {
                throw new AssertionError((Object)("Illegal array element type: " + String.valueOf(this.array)));
            }
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.array.getElement(k);
            }
            return result;
        }

        @Override
        public E get(int index) {
            return (E)InternalUtils.cast(this.array.getElement(index));
        }

        @Override
        public E set(int index, E element) {
            if (this.array instanceof UpdatableArray) {
                Object oldValue = InternalUtils.cast(this.array.getElement(index));
                ((UpdatableArray)this.array).setElement(index, element);
                return (E)oldValue;
            }
            throw new UnsupportedOperationException("AlgART array is not updatable");
        }

        @Override
        public int indexOf(Object o) {
            long len = this.array.length();
            if (len != (long)((int)len)) {
                throw new TooLargeArrayException("Cannot run indexOf in List based on AlgART array, because it is too large: " + String.valueOf(this.array));
            }
            if (o == null) {
                for (int k = 0; k < (int)len; ++k) {
                    if (this.array.getElement(k) != null) continue;
                    return k;
                }
            } else {
                for (int k = 0; k < (int)len; ++k) {
                    if (!o.equals(this.array.getElement(k))) continue;
                    return k;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }

    public static enum TaskExecutionOrder {
        BEFORE_STANDARD,
        AFTER_STANDARD;

    }

    public static class SystemSettings {
        private static final String VERSION = "1.5.1";
        private static final int[] PARSED_VERSION = java.util.Arrays.stream("1.5.1".split("\\.")).mapToInt(Integer::parseInt).toArray();
        private static final MemoryModel GLOBAL_MEMORY_MODEL;
        private static final double MAX_FREE_HEAP_SPACE_USAGE_FOR_TILING = 0.8;
        private static final DiskSynchronizer GLOBAL_DISK_SYNCHRONIZER;
        public static final int MAX_AVAILABLE_PROCESSORS;
        public static final String CPU_COUNT_PROPERTY_NAME = "net.algart.arrays.CPUCount";
        public static final int RECOMMENDED_TIME_OF_NON_INTERRUPTIBLE_PROCESSING = 250;
        public static final int RECOMMENDED_ELAPSED_TIME_FOR_ADDITIONAL_LOGGING = 3000;
        public static final int MIN_OPTIMIZATION_JAVA_MEMORY;
        public static final boolean BLOCK_OPTIMIZATION_FOR_COORDINATE_TRANSFORMATION;
        public static final boolean BLOCK_OPTIMIZATION_FOR_RESIZING_WHOLE_MATRIX;
        public static final boolean BLOCK_OPTIMIZATION_FOR_RESIZING_TRANSFORMATION;
        public static final boolean BLOCK_OPTIMIZATION_FOR_AFFINE_TRANSFORMATION;
        public static final boolean BLOCK_OPTIMIZATION_FOR_PROJECTIVE_TRANSFORMATION;
        public static final double MIN_USED_PART_FOR_PRELOADING_WHOLE_MATRIX_WITH_BLOCK_OPTIMIZATION = 0.7;
        public static final double MIN_USED_PART_FOR_PRELOADING_WHOLE_MATRIX_WITHOUT_BLOCK_OPTIMIZATION = 0.01;
        public static final double MIN_NON_OPTIMIZED_SIMPLE_COORDINATE_COMPRESSION = 200.0;
        public static final double MIN_LAYER_USED_PART_FOR_LAYER_OPTIMIZATION = 0.7;
        public static final double MIN_NON_OPTIMIZED_COMPRESSION_FOR_TILING = 100.0;
        public static final int MIN_OPTIMIZATION_RESULT_TILE_VOLUME = 100;

        private SystemSettings() {
        }

        private static MemoryModel getGlobalMemoryModel() {
            MemoryModel mm = InternalUtils.getClassInstance("net.algart.arrays.globalMemoryModel", "SIMPLE", MemoryModel.class, LOGGER, "Simple memory model will be used", "SIMPLE", SimpleMemoryModel.class.getName(), "BUFFER", BufferMemoryModel.class.getName(), "LARGE", LargeMemoryModel.class.getName());
            if (!mm.areAllPrimitiveElementTypesSupported()) {
                LOGGER.severe("Illegal global memory model " + mm.getClass().getName() + ": it does not support all primitive element types");
                LOGGER.severe("Simple memory model will be used");
            }
            return mm;
        }

        public static String version() {
            return VERSION;
        }

        public static int[] parsedVersion() {
            return java.util.Arrays.copyOf(PARSED_VERSION, 4);
        }

        public static int availableProcessors() {
            return InternalUtils.availableProcessors();
        }

        public static int cpuCountProperty() {
            Integer prop = InternalUtils.getIntegerWrapperProperty(CPU_COUNT_PROPERTY_NAME, null);
            if (prop == null) {
                return 0;
            }
            if (prop < 0) {
                return 0;
            }
            if (prop > MAX_AVAILABLE_PROCESSORS) {
                return MAX_AVAILABLE_PROCESSORS;
            }
            return prop;
        }

        public static int cpuCount() {
            int result = SystemSettings.cpuCountProperty();
            if (result == 0) {
                result = SystemSettings.availableProcessors();
            }
            return result;
        }

        public static MemoryModel globalMemoryModel() {
            return GLOBAL_MEMORY_MODEL;
        }

        public static MemoryModel globalMemoryModel(Class<?> elementType) {
            return GLOBAL_MEMORY_MODEL.isElementTypeSupported(elementType) ? GLOBAL_MEMORY_MODEL : SimpleMemoryModel.getInstance();
        }

        public static long maxTempJavaMemory() {
            return InternalUtils.MAX_TEMP_JAVA_MEMORY;
        }

        public static long maxTempJavaMemoryForTiling() {
            return InternalUtils.MAX_TEMP_JAVA_MEMORY_FOR_TILING;
        }

        public static long availableTempJavaMemoryForTiling() {
            Runtime rt = Runtime.getRuntime();
            long available = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
            return Math.min(SystemSettings.maxTempJavaMemoryForTiling(), (long)((double)available * 0.8));
        }

        public static long maxMultithreadingMemory() {
            return InternalUtils.MAX_MULTITHREADING_MEMORY;
        }

        public static DiskSynchronizer globalDiskSynchronizer() {
            return GLOBAL_DISK_SYNCHRONIZER;
        }

        public static boolean isJava32() {
            return InternalUtils.JAVA_32;
        }

        public static boolean profilingMode() {
            return InternalUtils.PROFILING;
        }

        public static int parseIntWithMetricalSuffixes(String s) {
            return InternalUtils.parseIntWithMetricalSuffixes(s);
        }

        public static long parseLongWithMetricalSuffixes(String s) {
            return InternalUtils.parseLongWithMetricalSuffixes(s);
        }

        public static String getStringProperty(String propertyName, String defaultValue) {
            return InternalUtils.getStringProperty(propertyName, defaultValue);
        }

        public static String getStringEnv(String envVarName, String defaultValue) {
            try {
                String s = System.getenv(envVarName);
                return s != null ? s : defaultValue;
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public static int getIntProperty(String propertyName, int defaultValue) {
            return InternalUtils.getIntProperty(propertyName, defaultValue);
        }

        public static int getIntEnv(String envVarName, int defaultValue) {
            try {
                String s = System.getenv(envVarName);
                return s == null ? defaultValue : InternalUtils.parseIntWithMetricalSuffixes(s);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public static long getLongProperty(String propertyName, long defaultValue) {
            return InternalUtils.getLongProperty(propertyName, defaultValue);
        }

        public static long getLongEnv(String envVarName, long defaultValue) {
            try {
                String s = System.getenv(envVarName);
                return s == null ? defaultValue : InternalUtils.parseLongWithMetricalSuffixes(s);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
            return InternalUtils.getBooleanProperty(propertyName, defaultValue);
        }

        public static boolean getBooleanEnv(String envVarName, boolean defaultValue) {
            try {
                String s = System.getenv(envVarName);
                return s == null ? defaultValue : (s.equalsIgnoreCase("true") ? true : (s.equalsIgnoreCase("false") ? false : defaultValue));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        static {
            if (PARSED_VERSION.length > 4) {
                throw new ExceptionInInitializerError("Too many elements (>4) in AlgART version: 1.5.1");
            }
            GLOBAL_MEMORY_MODEL = SystemSettings.getGlobalMemoryModel();
            GLOBAL_DISK_SYNCHRONIZER = InternalUtils.getClassInstance("net.algart.arrays.globalDiskSynchronizer", DefaultDiskSynchronizerLocking.class.getName(), DiskSynchronizer.class, LOGGER, "Default (single-thread) disk synchronizer will be used", new String[0]);
            MAX_AVAILABLE_PROCESSORS = InternalUtils.MAX_AVAILABLE_PROCESSORS;
            MIN_OPTIMIZATION_JAVA_MEMORY = Math.min(0x40000000, InternalUtils.getIntProperty("net.algart.arrays.minOptimizationJavaMemory", 524288));
            BLOCK_OPTIMIZATION_FOR_COORDINATE_TRANSFORMATION = InternalUtils.getBooleanProperty("net.algart.arrays.blockOptimizationForCoordinateTransformation", true);
            BLOCK_OPTIMIZATION_FOR_RESIZING_WHOLE_MATRIX = InternalUtils.getBooleanProperty("net.algart.arrays.blockOptimizationForResizingWholeMatrix", true);
            BLOCK_OPTIMIZATION_FOR_RESIZING_TRANSFORMATION = InternalUtils.getBooleanProperty("net.algart.arrays.blockOptimizationForResizingTransformation", true);
            BLOCK_OPTIMIZATION_FOR_AFFINE_TRANSFORMATION = InternalUtils.getBooleanProperty("net.algart.arrays.blockOptimizationForAffineTransformation", true);
            BLOCK_OPTIMIZATION_FOR_PROJECTIVE_TRANSFORMATION = InternalUtils.getBooleanProperty("net.algart.arrays.blockOptimizationForProjectiveTransformation", true);
        }

        public static interface DiskSynchronizer {
            public <T> T doSynchronously(String var1, Callable<T> var2) throws Exception;
        }

        static class DefaultDiskSynchronizerLocking
        implements DiskSynchronizer {
            private static final ReentrantLock globalLock = new ReentrantLock();

            DefaultDiskSynchronizerLocking() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T doSynchronously(String fileName, Callable<T> action) throws Exception {
                globalLock.lock();
                try {
                    T t = action.call();
                    return t;
                }
                finally {
                    globalLock.unlock();
                }
            }
        }

        private static class DiskThreadPoolHolder {
            private static final ExecutorService globalDiskThreadPool = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r, "AlgART-disk-thread");
                t.setDaemon(true);
                return t;
            });

            private DiskThreadPoolHolder() {
            }
        }

        static class DefaultDiskSynchronizerPooling
        implements DiskSynchronizer {
            DefaultDiskSynchronizerPooling() {
            }

            @Override
            public <T> T doSynchronously(String fileName, Callable<T> action) {
                Future<T> result = DiskThreadPoolHolder.globalDiskThreadPool.submit(action);
                try {
                    return result.get();
                }
                catch (ExecutionException e) {
                    Arrays.throwUncheckedException(e.getCause());
                    throw new AssertionError((Object)"Cannot occur");
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)("Unexpected InterruptedException in " + String.valueOf(this) + ": " + String.valueOf(e)));
                }
            }
        }
    }

    public static class Copier
    extends ParallelExecutor {
        private static final boolean VERY_SIMPLE_COPYING = false;

        public Copier(ArrayContext context, UpdatableArray dest, Array src, int numberOfTasks, long numberOfRanges) {
            super(context, src.length() <= dest.length() ? dest.subArr(0L, src.length()) : dest, src.length() <= dest.length() ? src : src.subArr(0L, dest.length()), src instanceof BitArray ? 524288 : 131072, numberOfTasks, numberOfRanges);
            if (!dest.elementType().isAssignableFrom(src.elementType())) {
                throw new IllegalArgumentException("Element types mismatch (" + String.valueOf(dest.elementType()) + " and " + String.valueOf(src.elementType()) + ")");
            }
        }

        @Override
        public void process() {
            super.process();
        }

        @Override
        protected void processSubArr(long position, int count, int threadIndex) {
            UpdatableArray subDest = this.dest.subArr(position, count);
            Array subSrc = this.src.subArr(position, count);
            subDest.copy(subSrc);
        }
    }

    public static abstract class ParallelExecutor {
        protected final UpdatableArray dest;
        protected final Array src;
        protected final int blockSize;
        protected final int numberOfTasks;
        protected final long numberOfRanges;
        private final ArrayContext context;
        private final long length;
        private final double approximateRangeLength;
        private final ThreadPoolFactory threadPoolFactory;
        private final ReentrantLock lock = new ReentrantLock();
        private final long[] readyCountPerTask;
        private final long[] lengthPerTask;
        private volatile boolean interruptionRequested;
        private RuntimeException interruptionReason = null;
        private long lastInterruptionTime = Long.MIN_VALUE;
        private long lastProgressTime = Long.MIN_VALUE;
        private static final ProcessSynchronizationAlgorithm PROCESS_SYNCHRONIZATION_ALGORITHM = ProcessSynchronizationAlgorithm.NO_SYNCHRONIZATION;

        protected ParallelExecutor(ArrayContext context, UpdatableArray dest, Array src, int blockSize, int numberOfTasks, long numberOfRanges) {
            long m;
            Objects.requireNonNull(src, "Null src argument");
            if (blockSize <= 0) {
                throw new IllegalArgumentException("Negative or zero blockSize=" + blockSize);
            }
            if (numberOfTasks < 0) {
                throw new IllegalArgumentException("Negative numberOfTasks=" + numberOfTasks);
            }
            if (numberOfRanges < 0L) {
                throw new IllegalArgumentException("Negative numberOfRanges=" + numberOfRanges);
            }
            this.context = context;
            this.dest = dest;
            this.src = src;
            if (dest != null && src.length() != dest.length()) {
                throw new SizeMismatchException("dest.length() and src.length() mismatch");
            }
            this.length = src.length();
            this.blockSize = blockSize;
            this.threadPoolFactory = Arrays.getThreadPoolFactory(context);
            this.numberOfTasks = numberOfTasks > 0 ? numberOfTasks : (this.getClass() == Copier.class && !src.isLazy() ? 1 : Math.max(1, this.threadPoolFactory.recommendedNumberOfTasks(src)));
            long l = m = numberOfRanges > 0L ? numberOfRanges : ParallelExecutor.recommendedNumberOfRanges(src, true);
            assert (m > 0L) : "A bug in recommendedNumberOfRanges(Array): it returns non-positive value " + m;
            this.numberOfRanges = ParallelExecutor.correctNumberOfRanges(m, this.numberOfTasks);
            this.approximateRangeLength = (double)this.length / (double)this.numberOfRanges;
            this.readyCountPerTask = new long[this.numberOfTasks];
            this.lengthPerTask = new long[this.numberOfTasks];
        }

        public static long recommendedNumberOfRanges(Array src, boolean recursive) {
            Objects.requireNonNull(src, "Null src argument");
            long rangeLen = Math.max(1L, Arrays.lengthOf(src, SystemSettings.maxMultithreadingMemory()));
            long result = Math.max(1L, (src.length() - 1L) / rangeLen + 1L);
            if (recursive) {
                for (Array a : Arrays.getUnderlyingArrays(src, true)) {
                    result = Math.max(result, ParallelExecutor.recommendedNumberOfRanges(a, true));
                }
            }
            return result;
        }

        public static long correctNumberOfRanges(long numberOfRanges, int numberOfTasks) {
            if (numberOfTasks <= 0) {
                throw new IllegalArgumentException("Zero or negative numberOfTasks=" + numberOfTasks);
            }
            if (numberOfRanges <= 0L) {
                throw new IllegalArgumentException("Zero or negative numberOfRanges=" + numberOfRanges);
            }
            return numberOfRanges % (long)numberOfTasks == 0L ? numberOfRanges : numberOfRanges - numberOfRanges % (long)numberOfTasks + (long)numberOfTasks;
        }

        public ArrayContext context() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            if (this.length == 0L) {
                return;
            }
            Runnable[] tasks = new Runnable[this.numberOfTasks];
            assert (this.numberOfRanges >= (long)this.numberOfTasks);
            assert (this.numberOfRanges % (long)this.numberOfTasks == 0L);
            this.interruptionRequested = false;
            if (PROCESS_SYNCHRONIZATION_ALGORITHM == ProcessSynchronizationAlgorithm.NO_SYNCHRONIZATION) {
                for (int threadIndex = 0; threadIndex < this.numberOfTasks; ++threadIndex) {
                    long summaryLen = 0L;
                    if (this.numberOfRanges > 10000L) {
                        summaryLen = this.length / (long)this.numberOfTasks;
                    } else {
                        for (long rangeIndex = (long)threadIndex; rangeIndex < this.numberOfRanges; rangeIndex += (long)this.numberOfTasks) {
                            summaryLen += this.rangeLength(rangeIndex);
                        }
                    }
                    this.readyCountPerTask[threadIndex] = 0L;
                    this.lengthPerTask[threadIndex] = summaryLen;
                }
                boolean noExceptions = false;
                try {
                    for (long rangeStart = 0L; rangeStart < this.numberOfRanges; rangeStart += (long)this.numberOfTasks) {
                        for (int threadIndex = 0; threadIndex < this.numberOfTasks; ++threadIndex) {
                            int ti = threadIndex;
                            long ri = rangeStart + (long)threadIndex;
                            long rFrom = this.rangeFrom(ri);
                            long rTo = this.rangeTo(ri);
                            this.src.subArray(rFrom, rTo).loadResources(null);
                            tasks[ti] = () -> {
                                Thread th = Thread.currentThread();
                                if (th instanceof ThreadForRanges) {
                                    th.setName("thread #" + (ti + 1) + "/" + this.numberOfTasks + ", range # " + (ri + 1L) + "/" + this.numberOfRanges + " (" + String.valueOf(this.src) + ")");
                                }
                                try {
                                    this.processRange(rFrom, rTo, ti, ri);
                                }
                                catch (Throwable ex) {
                                    this.interruptionRequested = true;
                                    Arrays.throwUncheckedException(ex);
                                }
                            };
                        }
                        if (this.numberOfTasks == 1) {
                            tasks[0].run();
                        } else {
                            ThreadFactory threadFactory = ThreadForRanges::new;
                            this.threadPoolFactory.performTasks(this.src, threadFactory, tasks);
                        }
                        if (this.interruptionReason != null) {
                            throw this.interruptionReason;
                        }
                        noExceptions = true;
                    }
                }
                finally {
                    block42: {
                        try {
                            this.finish();
                        }
                        catch (RuntimeException ex) {
                            if (!noExceptions) break block42;
                            throw ex;
                        }
                    }
                }
            }
            AtomicLong readyRanges = new AtomicLong(0L);
            Object synchronizer = new Object();
            for (int threadIndex = 0; threadIndex < this.numberOfTasks; ++threadIndex) {
                int ti = threadIndex;
                tasks[ti] = () -> {
                    Thread th = Thread.currentThread();
                    if (th instanceof ThreadForRanges) {
                        th.setName("thread #" + (ti + 1) + "/" + this.numberOfTasks + " (" + String.valueOf(this.src) + ")");
                    }
                    for (long rangeIndex = (long)ti; rangeIndex < this.numberOfRanges && !this.interruptionRequested; rangeIndex += (long)this.numberOfTasks) {
                        Object object;
                        if (PROCESS_SYNCHRONIZATION_ALGORITHM == ProcessSynchronizationAlgorithm.BEGINS) {
                            object = synchronizer;
                            synchronized (object) {
                                long startIndexInThisSeries = rangeIndex - (long)ti;
                                while (readyRanges.get() < startIndexInThisSeries) {
                                    try {
                                        synchronizer.wait();
                                    }
                                    catch (InterruptedException ex) {
                                        this.interruptionRequested = true;
                                        throw new IOError(ex);
                                    }
                                }
                            }
                        }
                        try {
                            long rFrom = this.rangeFrom(rangeIndex);
                            long rTo = this.rangeTo(rangeIndex);
                            this.src.subArray(rFrom, rTo).loadResources(null);
                            this.processRange(rFrom, rTo, ti, rangeIndex);
                        }
                        catch (Throwable ex) {
                            this.interruptionRequested = true;
                            Arrays.throwUncheckedException(ex);
                        }
                        object = synchronizer;
                        synchronized (object) {
                            if (PROCESS_SYNCHRONIZATION_ALGORITHM == ProcessSynchronizationAlgorithm.BEGINS) {
                                readyRanges.incrementAndGet();
                            } else {
                                while (readyRanges.get() < rangeIndex) {
                                    try {
                                        synchronizer.wait();
                                    }
                                    catch (InterruptedException ex) {
                                        this.interruptionRequested = true;
                                        throw new IOError(ex);
                                    }
                                }
                                long ready = readyRanges.incrementAndGet();
                                if (ready != rangeIndex + 1L) {
                                    throw new AssertionError((Object)("Invalid synchronization (" + ready + " instead of " + (rangeIndex + 1L) + " in " + String.valueOf(this.getClass())));
                                }
                            }
                            synchronizer.notifyAll();
                            continue;
                        }
                    }
                };
                long summaryLen = 0L;
                if (this.numberOfRanges > 10000L) {
                    summaryLen = this.length / (long)this.numberOfTasks;
                } else {
                    for (long rangeIndex = (long)ti; rangeIndex < this.numberOfRanges; rangeIndex += (long)this.numberOfTasks) {
                        summaryLen += this.rangeLength(rangeIndex);
                    }
                }
                this.readyCountPerTask[ti] = 0L;
                this.lengthPerTask[ti] = summaryLen;
            }
            boolean noExceptions = false;
            try {
                if (this.numberOfTasks == 1) {
                    tasks[0].run();
                } else {
                    ExecutorService pool = this.threadPoolFactory.getThreadPool(this.src, ThreadForRanges::new);
                    try {
                        int k;
                        Future[] results = new Future[this.numberOfTasks];
                        for (k = 0; k < this.numberOfTasks; ++k) {
                            results[k] = pool.submit(tasks[k]);
                        }
                        try {
                            for (k = 0; k < this.numberOfTasks; ++k) {
                                results[k].get();
                            }
                        }
                        catch (ExecutionException ex) {
                            Arrays.throwUncheckedException(ex);
                        }
                        catch (InterruptedException ex) {
                            this.interruptionRequested = true;
                            throw new IOError(ex);
                        }
                    }
                    finally {
                        this.threadPoolFactory.releaseThreadPool(pool);
                    }
                }
                if (this.interruptionReason != null) {
                    throw this.interruptionReason;
                }
                noExceptions = true;
            }
            finally {
                block45: {
                    try {
                        this.finish();
                    }
                    catch (RuntimeException ex) {
                        if (!noExceptions) break block45;
                        throw ex;
                    }
                }
            }
        }

        public int numberOfTasks() {
            return this.numberOfTasks;
        }

        public long numberOfRanges() {
            return this.numberOfRanges;
        }

        public final long rangeLength(long rangeIndex) {
            return this.rangeTo(rangeIndex) - this.rangeFrom(rangeIndex);
        }

        public final long rangeFrom(long rangeIndex) {
            if (rangeIndex < 0L || rangeIndex >= this.numberOfRanges) {
                throw new IndexOutOfBoundsException("rangeIndex (" + rangeIndex + (String)(rangeIndex < 0L ? ") < 0" : ") >= numberOfRanges (" + this.numberOfRanges + ")"));
            }
            if (rangeIndex == 0L) {
                return 0L;
            }
            long gr = this.granularity();
            if (gr <= 0L) {
                throw new AssertionError((Object)("Negative or zero granularity() = " + gr));
            }
            long p = (long)((double)rangeIndex * this.approximateRangeLength);
            assert (p <= this.length);
            return gr == 1L ? p : p / gr * gr;
        }

        public final long rangeTo(long rangeIndex) {
            if (rangeIndex < 0L || rangeIndex >= this.numberOfRanges) {
                throw new IndexOutOfBoundsException("rangeIndex (" + rangeIndex + (String)(rangeIndex < 0L ? ") < 0" : ") >= numberOfRanges (" + this.numberOfRanges + ")"));
            }
            if (rangeIndex == this.numberOfRanges - 1L) {
                return this.length;
            }
            long gr = this.granularity();
            if (gr <= 0L) {
                throw new AssertionError((Object)("Negative or zero granularity() = " + gr));
            }
            long p = (long)((double)(rangeIndex + 1L) * this.approximateRangeLength);
            assert (p <= this.length);
            return gr == 1L ? p : p / gr * gr;
        }

        protected void finish() {
        }

        protected void processRange(long fromIndex, long toIndex, int threadIndex, long rangeIndex) {
            long len;
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex > toIndex");
            }
            long startGap = this.startGap(rangeIndex);
            long endGap = this.endGap(rangeIndex);
            if (startGap < 0L) {
                throw new AssertionError((Object)("Negative startGap() = " + startGap));
            }
            if (endGap < 0L) {
                throw new AssertionError((Object)("Negative endGap() = " + endGap));
            }
            startGap = Math.min(startGap, toIndex - fromIndex);
            endGap = Math.min(endGap, toIndex - fromIndex - startGap);
            if (startGap > 0L) {
                this.increaseReadyCount(threadIndex, startGap);
            }
            toIndex -= endGap;
            for (long p = fromIndex += startGap; p < toIndex; p += len) {
                len = Math.min(toIndex - p, (long)this.blockSize);
                assert (len == (long)((int)len));
                this.processSubArr(p, (int)len, threadIndex);
                this.increaseReadyCount(threadIndex, len);
                boolean interrupted = this.checkInterruption();
                this.updateProgress();
                if (!interrupted) continue;
                break;
            }
            if (endGap > 0L) {
                this.increaseReadyCount(threadIndex, endGap);
            }
        }

        public long startGap(long rangeIndex) {
            return 0L;
        }

        public long endGap(long rangeIndex) {
            return 0L;
        }

        public long granularity() {
            return this.src instanceof BitArray ? 64L : 1L;
        }

        protected abstract void processSubArr(long var1, int var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final long readyCount() {
            this.lock.lock();
            try {
                long sum = 0L;
                for (long count : this.readyCountPerTask) {
                    sum += count;
                }
                long l = sum;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void increaseReadyCount(int threadIndex, long increment) {
            this.lock.lock();
            try {
                int n = threadIndex;
                this.readyCountPerTask[n] = this.readyCountPerTask[n] + increment;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected final boolean checkInterruption() {
            if (this.interruptionRequested) {
                return true;
            }
            if (this.context == null) {
                return false;
            }
            if (!this.updateTime(false)) {
                return false;
            }
            RuntimeException re = null;
            try {
                this.context.checkInterruption();
            }
            catch (RuntimeException ex) {
                re = ex;
            }
            this.lock.lock();
            try {
                if (re != null) {
                    if (this.interruptionReason == null) {
                        this.interruptionReason = re;
                    }
                    this.interruptionRequested = true;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected final void updateProgress() {
            if (this.context == null) {
                return;
            }
            if (this.updateTime(true)) {
                long[] readyCountPerTask;
                long[] lengthPerTask;
                this.lock.lock();
                try {
                    lengthPerTask = (long[])this.lengthPerTask.clone();
                    readyCountPerTask = (long[])this.readyCountPerTask.clone();
                }
                finally {
                    this.lock.unlock();
                }
                for (int k = 0; k < readyCountPerTask.length; ++k) {
                    readyCountPerTask[k] = Math.min(readyCountPerTask[k], lengthPerTask[k]);
                }
                this.context.updateProgress(new ArrayContext.Event(this.src.elementType(), readyCountPerTask, lengthPerTask));
            }
        }

        public String toString() {
            return "Parallel executor for " + this.numberOfTasks + " tasks and " + this.numberOfRanges + " ranges per ~" + this.approximateRangeLength + " elements, block size " + this.blockSize + ", source array " + String.valueOf(this.src);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateTime(boolean progressTime) {
            this.lock.lock();
            try {
                long t1 = progressTime ? this.lastProgressTime : this.lastInterruptionTime;
                long t2 = System.currentTimeMillis();
                if (t1 == Long.MIN_VALUE || t2 - t1 > 250L) {
                    if (progressTime) {
                        this.lastProgressTime = t2;
                    } else {
                        this.lastInterruptionTime = t2;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private static enum ProcessSynchronizationAlgorithm {
            NO_SYNCHRONIZATION,
            TILING,
            BEGINS;

        }

        private static class ThreadForRanges
        extends Thread {
            public ThreadForRanges(Runnable r) {
                super(r);
            }
        }
    }

    public static enum CopyAlgorithm {
        SIMPLE,
        BUFFERING_WHOLE_ARRAY,
        BUFFERING_LAYERS,
        REGULAR_BUFFERING_TILES,
        RECURSIVE_BUFFERING_TILES,
        TILING,
        UNTILING;

    }
}

