/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableArray;

public interface Array {
    public Class<?> elementType();

    public Class<? extends Array> type();

    public Class<? extends UpdatableArray> updatableType();

    public Class<? extends MutableArray> mutableType();

    public long length();

    default public int length32() throws TooLargeArrayException {
        long result = this.length();
        if (result < 0L) {
            throw new AssertionError((Object)("Negative result " + result + " of length() method"));
        }
        if (result > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large array (>= 2^31 elements): " + String.valueOf(this));
        }
        return (int)result;
    }

    default public boolean isEmpty() {
        return this.length() == 0L;
    }

    public long capacity();

    public Object getElement(long var1);

    public void getData(long var1, Object var3, int var4, int var5);

    public void getData(long var1, Object var3);

    default public Object newJavaArray(int length) {
        return java.lang.reflect.Array.newInstance(this.elementType(), length);
    }

    public Array subArray(long var1, long var3);

    public Array subArr(long var1, long var3);

    public DataBuffer buffer(DataBuffer.AccessMode var1, long var2);

    public DataBuffer buffer(DataBuffer.AccessMode var1);

    public DataBuffer buffer(long var1);

    public DataBuffer buffer();

    public Array asImmutable();

    public boolean isImmutable();

    public Array asTrustedImmutable();

    public void checkUnallowedMutation() throws UnallowedMutationError;

    public Array asCopyOnNextWrite();

    public boolean isCopyOnNextWrite();

    public boolean isUnresizable();

    public boolean isNew();

    public boolean isNewReadOnlyView();

    public boolean isLazy();

    public ByteOrder byteOrder();

    public Array shallowClone();

    public MutableArray mutableClone(MemoryModel var1);

    public UpdatableArray updatableClone(MemoryModel var1);

    default public Object toJavaArray() {
        long len = this.length();
        if (len != (long)((int)len)) {
            throw new TooLargeArrayException("Cannot convert AlgART array to Java array, because it is too large: " + String.valueOf(this));
        }
        Object result = this.newJavaArray((int)len);
        this.getData(0L, result);
        return result;
    }

    public Object ja();

    default public boolean isJavaArrayWrapper() {
        DirectAccessible da;
        Array array = this;
        return array instanceof DirectAccessible && (da = (DirectAccessible)((Object)array)).hasJavaArray() && da.javaArrayOffset() == 0 && (long)java.lang.reflect.Array.getLength(da.javaArray()) == this.length();
    }

    default public Matrix<? extends Array> matrix(long ... dim) {
        return Matrices.matrix(this, dim);
    }

    default public void loadResources() {
        this.loadResources(null);
    }

    public void loadResources(ArrayContext var1);

    default public void flushResources() {
        this.flushResources(null, false);
    }

    default public void flushResources(ArrayContext context) {
        this.flushResources(context, false);
    }

    public void flushResources(ArrayContext var1, boolean var2);

    default public void freeResources() {
        this.freeResources(null, false);
    }

    default public void freeResources(ArrayContext context) {
        this.freeResources(context, false);
    }

    public void freeResources(ArrayContext var1, boolean var2);

    public String toString();

    public int hashCode();

    public boolean equals(Object var1);

    public static UpdatableArray newArray(MemoryModel memoryModel, Class<?> elementType, long length) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableArray(elementType, length);
    }

    public static UpdatableArray newArray(Class<?> elementType, long length) {
        return Array.newArray(Arrays.SMM, elementType, length);
    }
}

