/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableObjectArray;

public abstract class AbstractObjectArray<E>
extends AbstractArray
implements ObjectArray<E> {
    final boolean underlyingArraysAreParallel;
    final Class<E> elementType;

    protected AbstractObjectArray(Class<E> elementType, long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArrays);
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initialLength argument");
        }
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initialCapacity argument");
        }
        if (initialLength > initialCapacity) {
            throw new IllegalArgumentException("initialCapacity argument must not be less than initialLength");
        }
        Objects.requireNonNull(underlyingArrays, "Null underlyingArrays argument");
        this.underlyingArraysAreParallel = underlyingArraysAreParallel;
        long len = -1L;
        for (int k = 0; k < underlyingArrays.length; ++k) {
            Objects.requireNonNull(underlyingArrays[k], "Null underlyingArrays[" + k + "] argument");
            if (!underlyingArraysAreParallel) continue;
            if (k == 0) {
                len = underlyingArrays[k].length();
                continue;
            }
            if (underlyingArrays[k].length() == len) continue;
            throw new SizeMismatchException("underlyingArrays[" + k + "].length() and underlyingArrays[0].length() mismatch");
        }
        this.elementType = elementType;
    }

    protected AbstractObjectArray(Class<E> elementType, long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(elementType, initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public Class<E> elementType() {
        return this.elementType;
    }

    @Override
    public Class<? extends ObjectArray<E>> type() {
        return (Class)InternalUtils.cast(ObjectArray.class);
    }

    @Override
    public Class<? extends UpdatableObjectArray<E>> updatableType() {
        return (Class)InternalUtils.cast(UpdatableObjectArray.class);
    }

    @Override
    public Class<? extends MutableObjectArray<E>> mutableType() {
        return (Class)InternalUtils.cast(MutableObjectArray.class);
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        Object[] a = (Object[])destArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            a[destArrayOffset] = this.get(arrayPos);
            ++arrayPos;
            ++destArrayOffset;
        }
    }

    @Override
    public void getData(long arrayPos, Object destArray) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((Object[])destArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.getData(arrayPos, destArray, 0, count);
    }

    @Override
    public Object getElement(long index) {
        return this.get(index);
    }

    @Override
    public <D> ObjectArray<D> cast(Class<D> elementType) {
        Class desiredType = (Class)InternalUtils.cast(elementType);
        if (!desiredType.isAssignableFrom(this.elementType)) {
            throw new ClassCastException("Illegal desired element type " + String.valueOf(elementType) + " for " + String.valueOf(this));
        }
        return (ObjectArray)InternalUtils.cast(this);
    }

    @Override
    public Array subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractObjectArray parent = this;
        final long offset = fromIndex;
        return new AbstractObjectArray<E>(this, this.elementType, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public E get(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.get(offset + index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, E value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, E value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode, long capacity) {
        return (DataObjectBuffer)InternalUtils.cast(super.buffer(mode, capacity));
    }

    @Override
    public DataObjectBuffer<E> buffer(DataBuffer.AccessMode mode) {
        return (DataObjectBuffer)InternalUtils.cast(super.buffer(mode));
    }

    @Override
    public DataObjectBuffer<E> buffer(long capacity) {
        return (DataObjectBuffer)InternalUtils.cast(super.buffer(capacity));
    }

    @Override
    public DataObjectBuffer<E> buffer() {
        return (DataObjectBuffer)InternalUtils.cast(super.buffer());
    }

    @Override
    public abstract E get(long var1);

    @Override
    public long indexOf(long lowIndex, long highIndex, E value) {
        long n = Math.min(this.length(), highIndex);
        if (value == null) {
            for (k = Math.max(lowIndex, 0L); k < n; ++k) {
                if (this.get(k) != null) continue;
                return k;
            }
        } else {
            while (k < n) {
                if (value.equals(this.get(k))) {
                    return k;
                }
                ++k;
            }
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, E value) {
        long k = Math.min(this.length(), highIndex);
        long low = Math.max(lowIndex, 0L);
        if (value == null) {
            while (k > low) {
                if (this.get(--k) != null) continue;
                return k;
            }
        } else {
            while (k > low) {
                if (!value.equals(this.get(--k))) continue;
                return k;
            }
        }
        return -1L;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isUnresizable() {
        return true;
    }

    @Override
    public void checkUnallowedMutation() throws UnallowedMutationError {
    }

    @Override
    public ObjectArray<E> asTrustedImmutable() {
        return this.asImmutable();
    }

    @Override
    public Array asCopyOnNextWrite() {
        return this;
    }

    @Override
    public boolean isCopyOnNextWrite() {
        return false;
    }

    @Override
    public ObjectArray<E> asImmutable() {
        return this;
    }

    @Override
    public MutableObjectArray<E> mutableClone(MemoryModel memoryModel) {
        return (MutableObjectArray)InternalUtils.cast(super.mutableClone(memoryModel));
    }

    @Override
    public UpdatableObjectArray<E> updatableClone(MemoryModel memoryModel) {
        return (UpdatableObjectArray)InternalUtils.cast(super.updatableClone(memoryModel));
    }

    @Override
    public E[] ja() {
        return (Object[])super.ja();
    }

    @Override
    public void loadResources(ArrayContext context) {
        this.loadResources(context, 0L, this.length());
    }

    @Override
    public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.flushResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    @Override
    public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.freeResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).loadResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length));
            }
        }
    }

    protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).flushResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.flushResources(context, forcePhysicalWriting);
        }
    }

    protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).freeResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.freeResources(context, forcePhysicalWriting);
        }
    }

    @Override
    public String toString() {
        return "immutable AlgART array " + this.elementType.getName() + "[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }

    @Override
    Object javaArrayInternal() {
        return null;
    }

    @Override
    int javaArrayOffsetInternal() {
        return 0;
    }
}

