/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractMatrix;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.Matrix;
import net.algart.arrays.MatrixImpl;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.MutableObjectArray;
import net.algart.arrays.MutableShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

public abstract class AbstractMemoryModel
implements MemoryModel {
    @Override
    public abstract MutableArray newEmptyArray(Class<?> var1);

    @Override
    public abstract MutableArray newEmptyArray(Class<?> var1, long var2);

    @Override
    public abstract MutableArray newArray(Class<?> var1, long var2);

    @Override
    public abstract UpdatableArray newUnresizableArray(Class<?> var1, long var2);

    @Override
    public MutableArray newArray(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        return this.newArray(array.elementType(), array.length());
    }

    @Override
    public UpdatableArray newUnresizableArray(Array array) {
        Objects.requireNonNull(array, "Null array argument");
        return this.newUnresizableArray(array.elementType(), array.length());
    }

    @Override
    public MutableBitArray newEmptyBitArray() {
        return (MutableBitArray)this.newEmptyArray(Boolean.TYPE);
    }

    @Override
    public MutableBitArray newEmptyBitArray(long initialCapacity) {
        return (MutableBitArray)this.newEmptyArray(Boolean.TYPE, initialCapacity);
    }

    @Override
    public MutableBitArray newBitArray(long initialLength) {
        return (MutableBitArray)this.newArray(Boolean.TYPE, initialLength);
    }

    @Override
    public UpdatableBitArray newUnresizableBitArray(long initialLength) {
        return (UpdatableBitArray)this.newUnresizableArray(Boolean.TYPE, initialLength);
    }

    @Override
    public MutableCharArray newEmptyCharArray() {
        return (MutableCharArray)this.newEmptyArray(Character.TYPE);
    }

    @Override
    public MutableCharArray newEmptyCharArray(long initialCapacity) {
        return (MutableCharArray)this.newEmptyArray(Character.TYPE, initialCapacity);
    }

    @Override
    public MutableCharArray newCharArray(long initialLength) {
        return (MutableCharArray)this.newArray(Character.TYPE, initialLength);
    }

    @Override
    public UpdatableCharArray newUnresizableCharArray(long initialLength) {
        return (UpdatableCharArray)this.newUnresizableArray(Character.TYPE, initialLength);
    }

    @Override
    public MutableByteArray newEmptyByteArray() {
        return (MutableByteArray)this.newEmptyArray(Byte.TYPE);
    }

    @Override
    public MutableByteArray newEmptyByteArray(long initialCapacity) {
        return (MutableByteArray)this.newEmptyArray(Byte.TYPE, initialCapacity);
    }

    @Override
    public MutableByteArray newByteArray(long initialLength) {
        return (MutableByteArray)this.newArray(Byte.TYPE, initialLength);
    }

    @Override
    public UpdatableByteArray newUnresizableByteArray(long initialLength) {
        return (UpdatableByteArray)this.newUnresizableArray(Byte.TYPE, initialLength);
    }

    @Override
    public MutableShortArray newEmptyShortArray() {
        return (MutableShortArray)this.newEmptyArray(Short.TYPE);
    }

    @Override
    public MutableShortArray newEmptyShortArray(long initialCapacity) {
        return (MutableShortArray)this.newEmptyArray(Short.TYPE, initialCapacity);
    }

    @Override
    public MutableShortArray newShortArray(long initialLength) {
        return (MutableShortArray)this.newArray(Short.TYPE, initialLength);
    }

    @Override
    public UpdatableShortArray newUnresizableShortArray(long initialLength) {
        return (UpdatableShortArray)this.newUnresizableArray(Short.TYPE, initialLength);
    }

    @Override
    public MutableIntArray newEmptyIntArray() {
        return (MutableIntArray)this.newEmptyArray(Integer.TYPE);
    }

    @Override
    public MutableIntArray newEmptyIntArray(long initialCapacity) {
        return (MutableIntArray)this.newEmptyArray(Integer.TYPE, initialCapacity);
    }

    @Override
    public MutableIntArray newIntArray(long initialLength) {
        return (MutableIntArray)this.newArray(Integer.TYPE, initialLength);
    }

    @Override
    public UpdatableIntArray newUnresizableIntArray(long initialLength) {
        return (UpdatableIntArray)this.newUnresizableArray(Integer.TYPE, initialLength);
    }

    @Override
    public MutableLongArray newEmptyLongArray() {
        return (MutableLongArray)this.newEmptyArray(Long.TYPE);
    }

    @Override
    public MutableLongArray newEmptyLongArray(long initialCapacity) {
        return (MutableLongArray)this.newEmptyArray(Long.TYPE, initialCapacity);
    }

    @Override
    public MutableLongArray newLongArray(long initialLength) {
        return (MutableLongArray)this.newArray(Long.TYPE, initialLength);
    }

    @Override
    public UpdatableLongArray newUnresizableLongArray(long initialLength) {
        return (UpdatableLongArray)this.newUnresizableArray(Long.TYPE, initialLength);
    }

    @Override
    public MutableFloatArray newEmptyFloatArray() {
        return (MutableFloatArray)this.newEmptyArray(Float.TYPE);
    }

    @Override
    public MutableFloatArray newEmptyFloatArray(long initialCapacity) {
        return (MutableFloatArray)this.newEmptyArray(Float.TYPE, initialCapacity);
    }

    @Override
    public MutableFloatArray newFloatArray(long initialLength) {
        return (MutableFloatArray)this.newArray(Float.TYPE, initialLength);
    }

    @Override
    public UpdatableFloatArray newUnresizableFloatArray(long initialLength) {
        return (UpdatableFloatArray)this.newUnresizableArray(Float.TYPE, initialLength);
    }

    @Override
    public MutableDoubleArray newEmptyDoubleArray() {
        return (MutableDoubleArray)this.newEmptyArray(Double.TYPE);
    }

    @Override
    public MutableDoubleArray newEmptyDoubleArray(long initialCapacity) {
        return (MutableDoubleArray)this.newEmptyArray(Double.TYPE, initialCapacity);
    }

    @Override
    public MutableDoubleArray newDoubleArray(long initialLength) {
        return (MutableDoubleArray)this.newArray(Double.TYPE, initialLength);
    }

    @Override
    public UpdatableDoubleArray newUnresizableDoubleArray(long initialLength) {
        return (UpdatableDoubleArray)this.newUnresizableArray(Double.TYPE, initialLength);
    }

    @Override
    public <E> MutableObjectArray<E> newEmptyObjectArray(Class<E> elementType) {
        return (MutableObjectArray)InternalUtils.cast(this.newEmptyArray(elementType));
    }

    @Override
    public <E> MutableObjectArray<E> newEmptyObjectArray(Class<E> elementType, long initialCapacity) {
        return (MutableObjectArray)InternalUtils.cast(this.newEmptyArray(elementType, initialCapacity));
    }

    @Override
    public <E> MutableObjectArray<E> newObjectArray(Class<E> elementType, long initialLength) {
        return (MutableObjectArray)InternalUtils.cast(this.newArray(elementType, initialLength));
    }

    @Override
    public <E> UpdatableObjectArray<E> newUnresizableObjectArray(Class<E> elementType, long initialLength) {
        return (UpdatableObjectArray)InternalUtils.cast(this.newUnresizableArray(elementType, initialLength));
    }

    @Override
    public MutableArray newLazyCopy(Array array) {
        return this.newArray(array.elementType(), array.length()).copy(array);
    }

    @Override
    public UpdatableArray newUnresizableLazyCopy(Array array) {
        return this.newUnresizableArray(array.elementType(), array.length()).copy(array);
    }

    @Override
    public <T extends UpdatableArray> Matrix<T> newMatrix(Class<T> arraySupertype, Class<?> elementType, long ... dim) {
        Objects.requireNonNull(arraySupertype, "Null arraySupertype argument");
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (MutableArray.class.isAssignableFrom(arraySupertype)) {
            throw new IllegalArgumentException("Illegal arraySupertype = " + String.valueOf(arraySupertype) + ": it is MutableArray or its subtype, but a matrix cannot be based on a resizable array");
        }
        Class<UpdatableArray> type = Arrays.type(UpdatableArray.class, elementType);
        if (!arraySupertype.isAssignableFrom(type)) {
            throw new ClassCastException("The passed array supertype " + arraySupertype.getName() + " is not a supertype for " + type.getName() + " and, so, cannot contain required " + elementType.getCanonicalName() + " elements");
        }
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableArray array = (UpdatableArray)arraySupertype.cast(this.newUnresizableArray(elementType, len));
        return new MatrixImpl<UpdatableArray>(array, dim);
    }

    @Override
    public <T extends UpdatableArray> Matrix<T> newMatrix(long maxSizeAllocatedInJavaMemory, Class<T> arraySupertype, Class<?> elementType, long ... dim) {
        long arrayLength = Arrays.longMul(dim);
        return (arrayLength != Long.MIN_VALUE && Arrays.sizeOf(elementType, arrayLength) <= maxSizeAllocatedInJavaMemory ? Arrays.SMM : this).newMatrix(arraySupertype, elementType, dim);
    }

    @Override
    public <T extends UpdatableArray> Matrix<T> newMatrix(Class<T> arraySupertype, Matrix<?> matrix) {
        Objects.requireNonNull(matrix, "Null matrix argument");
        return this.newMatrix(arraySupertype, matrix.elementType(), matrix.dimensions());
    }

    @Override
    public <T extends UpdatableArray> Matrix<T> newStructuredMatrix(Class<T> arraySupertype, Matrix<?> matrix) {
        return this.newMatrix(arraySupertype, matrix).structureLike(matrix);
    }

    @Override
    public Matrix<UpdatableBitArray> newBitMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableBitArray array = this.newUnresizableBitArray(len);
        return new MatrixImpl<UpdatableBitArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableCharArray> newCharMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableCharArray array = this.newUnresizableCharArray(len);
        return new MatrixImpl<UpdatableCharArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableByteArray> newByteMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableByteArray array = this.newUnresizableByteArray(len);
        return new MatrixImpl<UpdatableByteArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableShortArray> newShortMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableShortArray array = this.newUnresizableShortArray(len);
        return new MatrixImpl<UpdatableShortArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableIntArray> newIntMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableIntArray array = this.newUnresizableIntArray(len);
        return new MatrixImpl<UpdatableIntArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableLongArray> newLongMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableLongArray array = this.newUnresizableLongArray(len);
        return new MatrixImpl<UpdatableLongArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableFloatArray> newFloatMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableFloatArray array = this.newUnresizableFloatArray(len);
        return new MatrixImpl<UpdatableFloatArray>(array, dim);
    }

    @Override
    public Matrix<UpdatableDoubleArray> newDoubleMatrix(long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableDoubleArray array = this.newUnresizableDoubleArray(len);
        return new MatrixImpl<UpdatableDoubleArray>(array, dim);
    }

    @Override
    public <E> Matrix<UpdatableObjectArray<E>> newObjectMatrix(Class<E> elementType, long ... dim) {
        long len = AbstractMatrix.checkDimensions(dim);
        UpdatableObjectArray<E> array = this.newUnresizableObjectArray(elementType, len);
        return new MatrixImpl<UpdatableObjectArray<E>>(array, dim);
    }

    @Override
    public <T extends UpdatableArray> Matrix<T> newLazyCopy(Class<T> arraySupertype, Matrix<?> matrix) {
        return matrix.matrix(this.newUnresizableLazyCopy((Array)matrix.array())).cast(arraySupertype);
    }

    @Override
    public UpdatableArray of(Object array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType == null) {
            throw new IllegalArgumentException("The argument is not a Java array: " + String.valueOf(array.getClass()));
        }
        return this.newUnresizableArray(elementType, count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableArray of(Object array) {
        Objects.requireNonNull(array, "Null array argument");
        Class<?> elementType = array.getClass().getComponentType();
        if (elementType == null) {
            throw new IllegalArgumentException("The argument is not a Java array: " + String.valueOf(array.getClass()));
        }
        return this.newUnresizableArray(elementType, java.lang.reflect.Array.getLength(array)).setData(0L, array);
    }

    @Override
    public UpdatableBitArray of(boolean[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableBitArray)this.newUnresizableBitArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableBitArray of(boolean[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableBitArray)this.newUnresizableBitArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableCharArray of(char[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableCharArray)this.newUnresizableCharArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableCharArray of(char[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableCharArray)this.newUnresizableCharArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableByteArray of(byte[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableByteArray)this.newUnresizableByteArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableByteArray of(byte[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableByteArray)this.newUnresizableByteArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableShortArray of(short[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableShortArray)this.newUnresizableShortArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableShortArray of(short[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableShortArray)this.newUnresizableShortArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableIntArray of(int[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableIntArray)this.newUnresizableIntArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableIntArray of(int[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableIntArray)this.newUnresizableIntArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableLongArray of(long[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableLongArray)this.newUnresizableLongArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableLongArray of(long[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableLongArray)this.newUnresizableLongArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableFloatArray of(float[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableFloatArray)this.newUnresizableFloatArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableFloatArray of(float[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableFloatArray)this.newUnresizableFloatArray(array.length).setData(0L, array);
    }

    @Override
    public UpdatableDoubleArray of(double[] array, int offset, int count) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableDoubleArray)this.newUnresizableDoubleArray(count).setData(0L, array, offset, count);
    }

    @Override
    public UpdatableDoubleArray of(double[] array) {
        Objects.requireNonNull(array, "Null array argument");
        return (UpdatableDoubleArray)this.newUnresizableDoubleArray(array.length).setData(0L, array);
    }

    @Override
    public <E> UpdatableObjectArray<E> of(E[] array, int offset, int count) {
        return (UpdatableObjectArray)InternalUtils.cast(this.of((Object)array, offset, count));
    }

    @Override
    public <E> UpdatableObjectArray<E> of(E[] array) {
        return (UpdatableObjectArray)InternalUtils.cast(this.of((Object)array));
    }

    @Override
    public abstract boolean isElementTypeSupported(Class<?> var1);

    @Override
    public abstract boolean areAllPrimitiveElementTypesSupported();

    @Override
    public abstract boolean areAllElementTypesSupported();

    @Override
    public abstract long maxSupportedLength(Class<?> var1);

    @Override
    public abstract boolean isCreatedBy(Array var1);
}

