/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteOrder;
import java.util.Objects;
import java.util.zip.CRC32;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixCopier;
import net.algart.arrays.BitArray;
import net.algart.arrays.CopiesArraysImpl;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableObjectArray;

public abstract class AbstractArray
implements Array,
Cloneable {
    static final boolean DETAILED_PROFILING_COPY = false;
    private static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 65536);
    protected long capacity;
    protected long length;
    protected final Array[] underlyingArrays;
    private volatile byte newAndNewReadOnlyViewStatus = 0;

    protected AbstractArray(long initialCapacity, long initialLength, Array ... underlyingArrays) {
        Objects.requireNonNull(underlyingArrays, "Null underlyingArrays argument");
        this.capacity = initialCapacity;
        this.length = initialLength;
        this.underlyingArrays = underlyingArrays;
    }

    protected AbstractArray(long initialCapacity, long initialLength) {
        this.capacity = initialCapacity;
        this.length = initialLength;
        this.underlyingArrays = new Array[0];
    }

    protected AbstractArray(long initialCapacityAndLength) {
        this.capacity = this.length = initialCapacityAndLength;
        this.underlyingArrays = new Array[0];
    }

    @Override
    public abstract Class<?> elementType();

    @Override
    public abstract Class<? extends Array> type();

    @Override
    public abstract Class<? extends UpdatableArray> updatableType();

    @Override
    public abstract Class<? extends MutableArray> mutableType();

    @Override
    public long length() {
        return this.length & Long.MAX_VALUE;
    }

    @Override
    public long capacity() {
        return this.capacity & Long.MAX_VALUE;
    }

    @Override
    public abstract Object getElement(long var1);

    @Override
    public abstract void getData(long var1, Object var3, int var4, int var5);

    @Override
    public abstract void getData(long var1, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZeroFilled() {
        if (!(this instanceof PArray)) {
            throw new UnsupportedOperationException("isZeroFilled() must not be called for non-primitive arrays)");
        }
        long n = this.length();
        if (n == 0L) {
            return true;
        }
        Object ja = Arrays.javaArrayInternal(this);
        if (ja != null) {
            int offset = Arrays.javaArrayOffsetInternal(this);
            return JArrays.areElementsZero(ja, offset, (int)n);
        }
        if (this instanceof BitArray) {
            DataBitBuffer buf = (DataBitBuffer)Arrays.bufferInternal(this, DataBuffer.AccessMode.READ);
            try {
                Arrays.enableCaching(buf);
                buf.map(0L);
                while (buf.hasData()) {
                    if (!PackedBitArrays.areBitsZero(buf.data(), buf.fromIndex(), buf.count())) {
                        boolean bl = false;
                        return bl;
                    }
                    buf.mapNext();
                }
            }
            finally {
                Arrays.dispose(buf);
            }
            return true;
        }
        DataBuffer buf = Arrays.bufferInternal(this, DataBuffer.AccessMode.READ);
        try {
            Arrays.enableCaching(buf);
            buf.map(0L);
            while (buf.hasData()) {
                if (!JArrays.areElementsZero(buf.data(), buf.from(), buf.cnt())) {
                    boolean bl = false;
                    return bl;
                }
                buf.mapNext();
            }
        }
        finally {
            Arrays.dispose(buf);
        }
        return true;
    }

    @Override
    public abstract Array subArray(long var1, long var3);

    @Override
    public Array subArr(long position, long count) {
        return this.subArray(position, position + count);
    }

    @Override
    public DataBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
        return AbstractArray.defaultBuffer(this, mode, capacity);
    }

    @Override
    public DataBuffer buffer(DataBuffer.AccessMode mode) {
        return this.buffer(mode, AbstractArray.defaultBufferCapacity(this));
    }

    @Override
    public DataBuffer buffer(long capacity) {
        return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ, capacity);
    }

    @Override
    public DataBuffer buffer() {
        return this.buffer(this instanceof UpdatableArray ? DataBuffer.AccessMode.READ_WRITE : DataBuffer.AccessMode.READ);
    }

    @Override
    public abstract Array asImmutable();

    @Override
    public abstract boolean isImmutable();

    @Override
    public abstract Array asTrustedImmutable();

    @Override
    public abstract void checkUnallowedMutation() throws UnallowedMutationError;

    @Override
    public abstract Array asCopyOnNextWrite();

    @Override
    public abstract boolean isCopyOnNextWrite();

    @Override
    public abstract boolean isUnresizable();

    @Override
    public boolean isNew() {
        return (this.newAndNewReadOnlyViewStatus & 1) != 0;
    }

    @Override
    public boolean isNewReadOnlyView() {
        return (this.newAndNewReadOnlyViewStatus & 2) != 0;
    }

    @Override
    public boolean isLazy() {
        return this.underlyingArrays.length > 0;
    }

    @Override
    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public Array shallowClone() {
        return this.standardObjectClone();
    }

    @Override
    public MutableArray mutableClone(MemoryModel memoryModel) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newArray(this).copy(this);
    }

    @Override
    public UpdatableArray updatableClone(MemoryModel memoryModel) {
        Objects.requireNonNull(memoryModel, "Null memory model");
        return memoryModel.newUnresizableArray(this).copy(this);
    }

    @Override
    public Object ja() {
        Object a;
        DirectAccessible da;
        AbstractArray abstractArray = this;
        return abstractArray instanceof DirectAccessible && (da = (DirectAccessible)((Object)abstractArray)).hasJavaArray() && da.javaArrayOffset() == 0 && (long)java.lang.reflect.Array.getLength(a = da.javaArray()) == this.length() ? a : this.toJavaArray();
    }

    @Override
    public void loadResources(ArrayContext context) {
    }

    @Override
    public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        for (int k = 0; k < this.underlyingArrays.length; ++k) {
            this.underlyingArrays[k].flushResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
        }
    }

    @Override
    public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        for (int k = 0; k < this.underlyingArrays.length; ++k) {
            this.underlyingArrays[k].freeResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
        }
    }

    @Override
    public abstract String toString();

    @Override
    public final int hashCode() {
        return AbstractArray.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Array && AbstractArray.equals(this, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hashCode(Array array) {
        long n = array.length();
        if (n == 0L) {
            return 0;
        }
        Object ja = Arrays.javaArrayInternal(array);
        if (ja != null) {
            int offset = Arrays.javaArrayOffsetInternal(array);
            return JArrays.arrayHashCode(ja, offset, offset + (int)n);
        }
        if (array instanceof BitArray) {
            CRC32 hash = new CRC32();
            DataBitBuffer buf = (DataBitBuffer)Arrays.bufferInternal(array, DataBuffer.AccessMode.READ);
            try {
                Arrays.enableCaching(buf);
                buf.map(0L);
                while (buf.hasData()) {
                    PackedBitArrays.updateBitHashCode(buf.data(), buf.fromIndex(), buf.toIndex(), hash);
                    buf.mapNext();
                }
            }
            finally {
                Arrays.dispose(buf);
            }
            return (int)hash.getValue() * 37 + 28;
        }
        CRC32 hash = new CRC32();
        DataBuffer buf = Arrays.bufferInternal(array, DataBuffer.AccessMode.READ);
        try {
            Arrays.enableCaching(buf);
            buf.map(0L);
            while (buf.hasData()) {
                JArrays.updateArrayHashCode(buf.data(), buf.from(), buf.to(), hash);
                buf.mapNext();
            }
        }
        finally {
            Arrays.dispose(buf);
        }
        return (int)hash.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean equals(Array obj1, Object obj2) {
        Object ja2;
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || !(obj2 instanceof Array)) {
            return false;
        }
        Array a = (Array)obj2;
        long n = obj1.length();
        if (a.length() != n) {
            return false;
        }
        if (obj1 instanceof PArray != a instanceof PArray) {
            return false;
        }
        if (obj1 instanceof PArray && a.elementType() != obj1.elementType()) {
            return false;
        }
        Object ja1 = obj1 instanceof AbstractArray ? ((AbstractArray)obj1).javaArrayInternal() : null;
        Object object = ja2 = a instanceof AbstractArray ? ((AbstractArray)a).javaArrayInternal() : null;
        if (ja1 != null && ja2 != null) {
            return JArrays.arrayEquals(ja1, ((AbstractArray)obj1).javaArrayOffsetInternal(), ja2, ((AbstractArray)a).javaArrayOffsetInternal(), (int)n);
        }
        if (n == 0L) {
            return true;
        }
        if (obj1 instanceof BitArray) {
            DataBitBuffer buf1 = (DataBitBuffer)Arrays.bufferInternal(obj1, DataBuffer.AccessMode.READ, AbstractArray.largeBufferCapacity(obj1), true);
            DataBitBuffer buf2 = (DataBitBuffer)Arrays.bufferInternal(a, DataBuffer.AccessMode.READ, buf1.capacity(), true);
            try {
                Arrays.enableCaching(buf1);
                Arrays.enableCaching(buf2);
                buf1.map(0L);
                buf2.map(0L);
                while (buf1.hasData()) {
                    assert (buf1.count() == buf2.count());
                    if (!PackedBitArrays.bitEquals(buf1.data(), buf1.fromIndex(), buf2.data(), buf2.fromIndex(), buf1.count())) {
                        boolean bl = false;
                        return bl;
                    }
                    buf1.mapNext();
                    buf2.mapNext();
                }
            }
            finally {
                Arrays.dispose(buf1);
                Arrays.dispose(buf2);
            }
        }
        DataBuffer buf1 = Arrays.bufferInternal(obj1, DataBuffer.AccessMode.READ, AbstractArray.largeBufferCapacity(obj1), true);
        DataBuffer buf2 = Arrays.bufferInternal(a, DataBuffer.AccessMode.READ, buf1.capacity(), true);
        try {
            Arrays.enableCaching(buf1);
            Arrays.enableCaching(buf2);
            buf1.map(0L);
            buf2.map(0L);
            while (buf1.hasData()) {
                assert (buf1.count() == buf2.count());
                if (!JArrays.arrayEquals(buf1.data(), buf1.from(), buf2.data(), buf2.from(), buf1.cnt())) {
                    boolean bl = false;
                    return bl;
                }
                buf1.mapNext();
                buf2.mapNext();
            }
        }
        finally {
            Arrays.dispose(buf1);
            Arrays.dispose(buf2);
        }
        return true;
    }

    public static int defaultBufferCapacity(Array thisArray) {
        int result;
        if (thisArray instanceof BitArray) {
            result = 262144;
        } else {
            int bitsPerElement;
            int n = bitsPerElement = thisArray instanceof PArray ? (int)Math.min(1024L, ((PArray)thisArray).bitsPerElement()) : 32;
            if (bitsPerElement == -1) {
                bitsPerElement = 32;
            }
            result = Math.max(131072 / bitsPerElement, 1024);
        }
        assert (result <= AbstractArray.largeBufferCapacity(thisArray)) : "defaultBufferCapacity / largeBufferCapacity mismatch";
        return result;
    }

    public static void checkCopyArguments(UpdatableArray thisArray, Array src) {
        Objects.requireNonNull(thisArray, "Null thisArray argument");
        Objects.requireNonNull(src, "Null src argument");
        if (!thisArray.elementType().isAssignableFrom(src.elementType())) {
            throw new IllegalArgumentException("Element types mismatch (" + String.valueOf(thisArray.elementType()) + " cannot be assigned from " + String.valueOf(src.elementType()) + ")");
        }
    }

    public static void checkSwapArguments(UpdatableArray thisArray, UpdatableArray another) {
        Objects.requireNonNull(thisArray, "Null thisArray argument");
        Objects.requireNonNull(another, "Null another argument");
        if (thisArray.elementType() != another.elementType()) {
            throw new IllegalArgumentException("Element types mismatch (" + String.valueOf(thisArray.elementType()) + " and " + String.valueOf(another.elementType()) + ")");
        }
    }

    protected final AbstractArray standardObjectClone() {
        try {
            AbstractArray result = (AbstractArray)super.clone();
            result.newAndNewReadOnlyViewStatus = 0;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    protected final void checkSubArrayArguments(long fromIndex, long toIndex) {
        if (fromIndex < 0L) {
            throw AbstractArray.rangeException(fromIndex, this.length(), this.getClass());
        }
        if (toIndex > this.length()) {
            throw AbstractArray.rangeException(toIndex - 1L, this.length(), this.getClass());
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Negative number of elements (fromIndex = " + fromIndex + " > toIndex = " + toIndex + ") in " + String.valueOf(this.getClass()));
        }
    }

    protected final void checkSubArrArguments(long position, long count) {
        if (position < 0L) {
            throw AbstractArray.rangeException(position, this.length(), this.getClass());
        }
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        if (position > this.length() - count) {
            throw AbstractArray.rangeException(position + count - 1L, this.length(), this.getClass());
        }
    }

    protected final void setNewStatus(boolean value) {
        if (!(this instanceof UpdatableArray)) {
            throw new UnsupportedOperationException("setNewStatus(boolean) can be called for updatable arrays only");
        }
        assert (this.newAndNewReadOnlyViewStatus < 2) : "new read-only view is impossible for UpdatableArray";
        this.newAndNewReadOnlyViewStatus = value ? (byte)1 : 0;
    }

    protected final void setNewReadOnlyViewStatus() {
        if (this instanceof UpdatableArray) {
            throw new UnsupportedOperationException("setNewReadOnlyViewStatus() must not be called for updatable arrays");
        }
        assert ((this.newAndNewReadOnlyViewStatus & 1) == 0) : "new status is possible only in UpdatableArray";
        this.newAndNewReadOnlyViewStatus = (byte)2;
    }

    protected static DataBuffer defaultBuffer(Array thisArray, DataBuffer.AccessMode mode, long capacity) {
        return Arrays.bufferInternal(thisArray, mode, capacity, false);
    }

    protected static void defaultCopy(UpdatableArray thisArray, Array src) {
        AbstractArray.defaultCopy(thisArray, src, false);
    }

    protected static void defaultCopy(UpdatableArray thisArray, Array src, boolean allowNulls) {
        boolean nullFilled;
        boolean bl = nullFilled = thisArray instanceof UpdatableObjectArray && src instanceof CopiesArraysImpl.CopiesObjectArray && ((CopiesArraysImpl.CopiesObjectArray)src).element == null;
        if (!allowNulls || !nullFilled) {
            AbstractArray.checkCopyArguments(thisArray, src);
        }
        if (ArraysSubMatrixCopier.copySubMatrixArray(null, thisArray, src)) {
            return;
        }
        AbstractArray.defaultCopyWithoutOptimizations(thisArray, src);
    }

    protected static void defaultSwap(UpdatableArray thisArray, UpdatableArray another) {
        AbstractArray.checkSwapArguments(thisArray, another);
        long len = Math.min(thisArray.length(), another.length());
        if (len > 0L) {
            int buffLen = (int)Math.min(len, 32768L);
            Object buff1 = java.lang.reflect.Array.newInstance(thisArray.elementType(), buffLen);
            Object buff2 = java.lang.reflect.Array.newInstance(thisArray.elementType(), buffLen);
            for (long disp = 0L; disp < len; disp += (long)buffLen) {
                if ((long)buffLen > len - disp) {
                    buffLen = (int)(len - disp);
                }
                thisArray.getData(disp, buff1, 0, buffLen);
                another.getData(disp, buff2, 0, buffLen);
                thisArray.setData(disp, buff2, 0, buffLen);
                another.setData(disp, buff1, 0, buffLen);
            }
        }
    }

    protected static MutableArray defaultAppend(MutableArray thisArray, Array appendedArray) {
        long currentLength = thisArray.length();
        long appendedLength = appendedArray.length();
        if (appendedLength > 0L) {
            Array appended = appendedArray.shallowClone();
            Arrays.lengthUnsigned(thisArray, currentLength + appendedLength);
            thisArray.subArr(currentLength, appendedLength).copy(appended);
        }
        return thisArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void defaultCopyWithoutOptimizations(UpdatableArray thisArray, Array src) {
        long t0 = AbstractArray.nanoTime();
        long t1 = -1L;
        long t2 = -1L;
        long t3 = -1L;
        long copyCount = 0L;
        long tRead = 0L;
        long tWrite = 0L;
        if (thisArray.length() < src.length()) {
            src = src.subArr(0L, thisArray.length());
        }
        if (thisArray instanceof BitArray) {
            if (((BitArray)src).nextQuickPosition(0L) == -1L || thisArray.isLazy()) {
                boolean[] buf = (boolean[])BOOLEAN_BUFFERS.requestArray();
                t1 = AbstractArray.nanoTime();
                try {
                    int len;
                    long n = src.length();
                    for (long p = 0L; p < n; p += (long)len) {
                        long tt1 = AbstractArray.nanoTime();
                        len = (int)Math.min(n - p, (long)buf.length);
                        src.getData(p, buf, 0, len);
                        long tt2 = AbstractArray.nanoTime();
                        tRead += tt2 - tt1;
                        thisArray.setData(p, buf, 0, len);
                        tWrite += AbstractArray.nanoTime() - tt2;
                    }
                    t2 = AbstractArray.nanoTime();
                }
                finally {
                    BOOLEAN_BUFFERS.releaseArray(buf);
                }
            } else {
                long[] jaDest = Arrays.longJavaArrayInternal((BitArray)((Object)thisArray));
                if (jaDest != null) {
                    long jaOffset = Arrays.longJavaArrayOffsetInternal((BitArray)((Object)thisArray));
                    t1 = AbstractArray.nanoTime();
                    ((BitArray)src).getBits(0L, jaDest, jaOffset, src.length());
                    t2 = AbstractArray.nanoTime();
                    tRead += t2 - t1;
                } else {
                    UpdatableBitArray dest = (UpdatableBitArray)thisArray;
                    DataBitBuffer srcBuf = (DataBitBuffer)Arrays.bufferInternal(src, DataBuffer.AccessMode.READ, AbstractArray.largeBufferCapacity(src), true);
                    Arrays.enableCaching(srcBuf);
                    t1 = AbstractArray.nanoTime();
                    try {
                        srcBuf.map(0L);
                        tRead = AbstractArray.nanoTime() - t1;
                        while (srcBuf.hasData()) {
                            long tt1 = AbstractArray.nanoTime();
                            dest.setBits(srcBuf.position(), srcBuf.data(), srcBuf.fromIndex(), srcBuf.count());
                            long tt2 = AbstractArray.nanoTime();
                            tWrite += tt2 - tt1;
                            srcBuf.mapNext();
                            tRead += AbstractArray.nanoTime() - tt2;
                            ++copyCount;
                        }
                        t2 = AbstractArray.nanoTime();
                    }
                    finally {
                        Arrays.dispose(srcBuf);
                    }
                }
            }
        } else {
            Object jaDest = Arrays.javaArrayInternal(thisArray);
            if (jaDest != null) {
                int jaOffset = Arrays.javaArrayOffsetInternal(thisArray);
                t1 = AbstractArray.nanoTime();
                src.getData(0L, jaDest, jaOffset, (int)src.length());
                t2 = AbstractArray.nanoTime();
                tRead += t2 - t1;
            } else {
                DataBuffer srcBuf = Arrays.bufferInternal(src, DataBuffer.AccessMode.READ, AbstractArray.largeBufferCapacity(thisArray), true);
                Arrays.enableCaching(srcBuf);
                t1 = AbstractArray.nanoTime();
                try {
                    srcBuf.map(0L);
                    tRead = AbstractArray.nanoTime() - t1;
                    while (srcBuf.hasData()) {
                        long tt1 = AbstractArray.nanoTime();
                        thisArray.setData(srcBuf.position(), srcBuf.data(), srcBuf.from(), srcBuf.cnt());
                        long tt2 = AbstractArray.nanoTime();
                        tWrite += tt2 - tt1;
                        srcBuf.mapNext();
                        tRead += AbstractArray.nanoTime() - tt2;
                        ++copyCount;
                    }
                    t2 = AbstractArray.nanoTime();
                }
                finally {
                    Arrays.dispose(srcBuf);
                }
            }
        }
        t3 = AbstractArray.nanoTime();
    }

    static int largeBufferCapacity(Array thisArray) {
        int bitsPerElement;
        if (thisArray instanceof BitArray) {
            return 524288;
        }
        int n = bitsPerElement = thisArray instanceof PArray ? (int)Math.min(1024L, ((PArray)thisArray).bitsPerElement()) : 32;
        if (bitsPerElement == -1) {
            bitsPerElement = 32;
        }
        int maxBufferSizeInBits = bitsPerElement == 64 ? 0x100000 : 524288;
        return maxBufferSizeInBits / bitsPerElement;
    }

    Object javaArrayInternal() {
        return null;
    }

    int javaArrayOffsetInternal() {
        return 0;
    }

    final <T extends Array> T setNewStatus() {
        this.newAndNewReadOnlyViewStatus = 1;
        return (T)((Array)InternalUtils.cast(this));
    }

    IndexOutOfBoundsException rangeException(long index) {
        return AbstractArray.rangeException(index, this.length, this.getClass());
    }

    static IndexOutOfBoundsException rangeException(long index, long length, Class<?> clazz) {
        return new IndexOutOfBoundsException("Index (" + index + (String)(index < 0L ? ") < 0" : ") >= length (" + length + ")") + " in " + clazz.getName() + " class");
    }

    private static long nanoTime() {
        return -1L;
    }
}

