/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.menu;

import com.siams.preferences.UIPreference;
import java.io.File;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;

public class ExamplesDialog
extends Dialog<File>
implements UIPreference {
    public ExamplesDialog(List<File> examples) {
        DialogPane dialogPane = new DialogPane();
        TableView table = new TableView();
        ObservableList observableExamples = FXCollections.observableArrayList(examples);
        table.setItems(observableExamples);
        table.setEditable(false);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(param -> {
            SimpleStringProperty prop = new SimpleStringProperty(((File)param.getValue()).getName());
            return prop;
        });
        TableColumn locationColumn = new TableColumn("Location");
        locationColumn.setCellValueFactory(param -> {
            SimpleStringProperty prop = new SimpleStringProperty(((File)param.getValue()).toPath().toString());
            return prop;
        });
        table.getColumns().add((Object)nameColumn);
        table.getColumns().add((Object)locationColumn);
        table.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.setResult((File)table.getSelectionModel().getSelectedItem());
            }
        });
        dialogPane.setContent((Node)table);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setTitle("Choose example");
        this.setDialogPane(dialogPane);
        this.setResizable(true);
        this.setResultConverter(pressed -> {
            this.savePreference();
            ButtonBar.ButtonData data = pressed == null ? null : pressed.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? (File)table.getSelectionModel().getSelectedItem() : null;
        });
        this.restorePreference();
    }

    public void restorePreference() {
        this.getDialogPane().setPrefWidth(this.getPreferredDouble("width", 500.0));
        this.getDialogPane().setPrefHeight(this.getPreferredDouble("height", 400.0));
    }

    public void savePreference() {
        this.putPreferredDouble("width", this.getDialogPane().getWidth());
        this.putPreferredDouble("height", this.getDialogPane().getHeight());
    }
}

