/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.transport.grpc.observer.stream.SImage;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.javafx.utils.FxPlatform;
import java.awt.image.BufferedImage;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;

public class UIVisibleResult {
    private final ImageView imageView;
    private final TextArea textArea;
    private VisibleResultState state;

    UIVisibleResult(ImageView imageView, TextArea textArea) {
        this.imageView = imageView;
        this.textArea = textArea;
        this.state = new StateImage(Desktop.getDefaultEmptyImage());
    }

    VisibleResultState getState() {
        return this.state;
    }

    public WritableImage getWritableImage() {
        if (this.state instanceof StateImage) {
            return ((StateImage)this.state).image;
        }
        return null;
    }

    public String getScalar() {
        if (this.state instanceof StateText) {
            return ((StateText)this.state).text;
        }
        return null;
    }

    void show() {
        this.changeState(this.state);
    }

    void showImage(WritableImage image) {
        this.changeState(new StateImage(image));
    }

    void showImage(SImage sImage) {
        this.changeState(new StateImage(sImage.getImage()));
    }

    void showImage(BufferedImage image) {
        WritableImage writableImage = new WritableImage(image.getWidth(), image.getHeight());
        SwingFXUtils.toFXImage((BufferedImage)image, (WritableImage)writableImage);
        this.changeState(new StateImage(writableImage));
    }

    void showDefaultEmptyImage() {
        this.changeState(new StateImage(Desktop.getDefaultEmptyImage()));
    }

    void showDefaultMultiMatrixImage() {
        this.changeState(new StateImage(Desktop.getDefaultMultichannelImage()));
    }

    void showText(String text) {
        this.changeState(new StateText(text, false));
    }

    void showError(String error) {
        this.changeState(new StateError(this, error, true));
    }

    void updateState() {
        this.getState().update();
    }

    void setTooltip(Tooltip tooltip) {
        this.state.setTooltip(tooltip);
    }

    private void changeState(VisibleResultState state) {
        FxPlatform.RunFxThread(() -> {
            this.state.hide();
            this.state = state;
            this.state.show();
        });
    }

    public boolean isError() {
        return this.state instanceof StateError;
    }

    public ViewerKind getViewerKind() {
        if (this.state instanceof StateImage) {
            return ViewerKind.IMAGE;
        }
        if (this.state instanceof StateText) {
            return ViewerKind.PLAIN_TEXT;
        }
        return ViewerKind.UNKNOWN;
    }

    class StateImage
    extends VisibleResultState {
        WritableImage image;

        StateImage(WritableImage image) {
            this.image = image;
        }

        @Override
        public void show() {
            UIVisibleResult.this.imageView.setImage((Image)this.image);
        }

        @Override
        void hide() {
            UIVisibleResult.this.imageView.setImage(null);
        }

        @Override
        public void showHideNode(boolean show) {
        }

        @Override
        public void update() {
            this.checkMinVisibleSize();
        }

        private void checkMinVisibleSize() {
        }

        @Override
        public boolean isImage() {
            return true;
        }
    }

    public abstract class VisibleResultState {
        abstract void hide();

        public abstract boolean isImage();

        abstract void show();

        public abstract void showHideNode(boolean var1);

        void setTooltip(Tooltip tooltip) {
            Tooltip.install((Node)UIVisibleResult.this.imageView, (Tooltip)tooltip);
        }

        public abstract void update();
    }

    class StateText
    extends VisibleResultState {
        protected final String text;
        private final boolean wrapText;
        private static final int MaxTextSize = 1000;

        StateText(String text, boolean wrapText) {
            this.text = text.length() > 1000 ? text.substring(0, 1000) + "..." : text;
            this.wrapText = wrapText;
        }

        @Override
        void show() {
            UIVisibleResult.this.textArea.setWrapText(this.wrapText);
            UIVisibleResult.this.textArea.setText(this.text);
            UIVisibleResult.this.textArea.setMinWidth(0.0);
            UIVisibleResult.this.textArea.setMinHeight(0.0);
        }

        @Override
        public void showHideNode(boolean show) {
            UIVisibleResult.this.textArea.setText(null);
        }

        @Override
        void hide() {
            UIVisibleResult.this.textArea.setText(null);
        }

        @Override
        public void update() {
        }

        @Override
        public boolean isImage() {
            return false;
        }
    }

    private class StateError
    extends StateText {
        private StateError(UIVisibleResult uIVisibleResult, String text, boolean wrapText) {
            super(text, wrapText);
        }
    }
}

