/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.message.StareDragDetected;
import com.siams.cv.monitor.message.StareDragDone;
import com.siams.cv.monitor.message.StareDragDropped;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.AnchorType;
import com.siams.cv.monitor.model.node.ConnectionModel;
import com.siams.cv.monitor.model.node.PortDataType;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.ui.content.container.Desktop;
import com.siams.cv.monitor.ui.factory.Connection;
import com.siams.cv.monitor.ui.factory.DataTooltip;
import com.siams.cv.monitor.ui.factory.LinkingMode;
import com.siams.cv.monitor.ui.factory.NodeChangePositionListener;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UILinkAnchor;
import com.siams.cv.monitor.ui.factory.UIPortInput;
import com.siams.dialogs.DialogManager;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurve;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.Text;
import org.greenrobot.eventbus.EventBus;

public abstract class UIPort
extends AnchorPane
implements StareNode {
    protected static final Logger logger = Logger.getLogger(UIPort.class.getCanonicalName());
    protected static final App app = App.getInstance();
    protected UIPortModel model;
    protected UIBlock uiBlock;
    @FXML
    protected Label portCaption;
    @FXML
    Node anchor;
    private Node alternativeAnchor;
    private String portDataTooltip = "";
    protected static final DataFormat dragDataUuid = new DataFormat(new String[]{"java.util.UUID"});
    protected static final DataFormat dragDataLinkingMode = new DataFormat(new String[]{"com.siams.cv.monitor.ui.factory.LinkingMode"});
    private final Map<Runnable, NodeChangePositionListener> listeners = new HashMap<Runnable, NodeChangePositionListener>();

    public UIPort(UIPortModel model) {
        Objects.requireNonNull(model, "Valid model required");
        this.model = model;
    }

    void initialize() {
        this.initializeFxml();
        this.portCaption.setFocusTraversable(false);
        this.initializePortName();
        this.initializeAnchor();
        this.initializeMouseEvents();
    }

    public UUID getUuid() {
        return this.model.getUuid();
    }

    @Override
    public Node getNode() {
        return this;
    }

    public UIPortModel getNodeModel() {
        return this.model;
    }

    public UIBlock getUIBlock() {
        return this.uiBlock;
    }

    public void setUIBlock(UIBlock uiBlock) {
        this.uiBlock = uiBlock;
    }

    public Node getConnectionAnchor() {
        if (this.isVisible()) {
            return this.anchor;
        }
        return this.alternativeAnchor;
    }

    public void updatePortDataTooltip(Statistic statistic) {
        this.portDataTooltip = DataTooltip.createTooltip(statistic, this.getUuid().toString());
    }

    protected abstract void initializeFxml();

    protected void initializeMouseEvents() {
        this.setOnMouseClicked(event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            event.consume();
            if (event.getClickCount() == 2) {
                App.getInstance().unplugLinksFromPort(this.model).thenAccept(unpluggedLinks -> {
                    Point2D portPosition;
                    AnchorType anchorType;
                    PortType portType = this.model.getPortType();
                    if (portType.isInput()) {
                        anchorType = AnchorType.DEST;
                        portPosition = this.figureStartPoint().subtract(30.0, 0.0);
                    } else if (portType.isOutput()) {
                        anchorType = AnchorType.SRC;
                        portPosition = this.figureStartPoint().add(30.0, 0.0);
                    } else {
                        throw new RuntimeException("Unsupported port type");
                    }
                    UILinkAnchor uiLinkAnchor = App.getInstance().addUiLinkAnchor(anchorType);
                    uiLinkAnchor.setDataType(this.model.getDataType());
                    uiLinkAnchor.setLayoutX(portPosition.getX());
                    uiLinkAnchor.setLayoutY(portPosition.getY());
                    unpluggedLinks.forEach(uiLink -> {
                        uiLinkAnchor.addLink((UILink)uiLink);
                        uiLink.setDetached(true);
                        uiLink.render();
                    });
                });
            }
        });
        this.setOnMouseEntered(event -> this.portCaption.setTooltip(this.createPortTooltip()));
        this.setOnMouseDragged(event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                event.consume();
            }
        });
        this.setOnDragDetected(event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            EventBus.getDefault().post((Object)new StareDragDetected());
            event.consume();
            this.startFullDrag();
            if (this.model.getPortType().isInput() && !App.hasConnection(this)) {
                return;
            }
            Point2D start = this.figureStartPoint();
            CubicCurve link = Desktop.getInstance().getDragLink();
            UILink.setUpLink(link, start, start);
            link.toFront();
            link.setVisible(true);
            Dragboard db = this.startDragAndDrop(TransferMode.ANY);
            ClipboardContent content = new ClipboardContent();
            content.put((Object)dragDataUuid, (Object)this.getUuid());
            if (UIPortInput.class.isAssignableFrom(this.getClass())) {
                content.put((Object)dragDataLinkingMode, (Object)LinkingMode.RE_PLUG);
            } else {
                content.put((Object)dragDataLinkingMode, (Object)LinkingMode.SINGLE);
            }
            db.setContent((Map)content);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("drag detected: " + this.getUuid().toString());
            }
        });
        this.setOnDragOver(event -> {
            UUID destDataType;
            event.consume();
            if (event.getGestureSource() == this) {
                return;
            }
            Dragboard dragboard = event.getDragboard();
            UUID uuid = (UUID)dragboard.getContent(dragDataUuid);
            LinkingMode linkingMode = (LinkingMode)((Object)((Object)event.getDragboard().getContent(dragDataLinkingMode)));
            if (linkingMode == LinkingMode.ATTACH) {
                UILinkAnchor uiLinkAnchor = (UILinkAnchor)NodeStorage.getInstance().findFirst(uuid).orElseThrow(() -> {
                    String msg = String.format("Can't find UILinkAnchor %s", uuid.toString());
                    logger.warning(msg);
                    return new NoSuchElementException(msg);
                });
                if (uiLinkAnchor.getAnchorType() == AnchorType.SRC && this.model.getPortType().isInput()) {
                    return;
                }
                if (uiLinkAnchor.getAnchorType() == AnchorType.DEST && this.model.getPortType().isOutput()) {
                    return;
                }
                if (!this.model.getDataType().equals((Object)uiLinkAnchor.getDataType())) {
                    return;
                }
                event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
                return;
            }
            Optional<UIPort> optSrcPort = NodeStorage.getInstance().findFirst(uuid, UIPort.class);
            if (optSrcPort.isEmpty()) {
                return;
            }
            UIPort destPort = this;
            UIPort srcPort = optSrcPort.get();
            if (destPort.getUIBlock().getUuid().equals(srcPort.getUIBlock().getUuid())) {
                return;
            }
            UUID srcDataType = srcPort.getNodeModel().getDataType().getUuid();
            if (!srcDataType.equals(destDataType = destPort.getNodeModel().getDataType().getUuid())) {
                return;
            }
            if (srcPort.getNodeModel().getPortType().isInput() && destPort.getNodeModel().getPortType().isOutput()) {
                return;
            }
            if (linkingMode == LinkingMode.BUNDLE && destPort.getNodeModel().getPortType().isInput()) {
                return;
            }
            if (linkingMode == LinkingMode.SINGLE && destPort.getNodeModel().getPortType().isOutput()) {
                return;
            }
            event.acceptTransferModes(new TransferMode[]{TransferMode.LINK});
        });
        this.setOnDragDropped(event -> {
            event.consume();
            event.setDropCompleted(true);
            EventBus.getDefault().post((Object)new StareDragDropped());
            LinkingMode linkingMode = (LinkingMode)((Object)((Object)event.getDragboard().getContent(dragDataLinkingMode)));
            UUID uuid = (UUID)event.getDragboard().getContent(dragDataUuid);
            StareNode srcPort = NodeStorage.getInstance().findFirst(uuid).orElseGet(() -> {
                String error = String.format("Source port not found: %s", uuid.toString());
                logger.severe(error);
                StareNotification.showWarn((String)error);
                return null;
            });
            UIPort destPort = this;
            if (srcPort == null) {
                return;
            }
            switch (linkingMode) {
                case SINGLE: {
                    if (!this.checkPortConnections(destPort)) {
                        return;
                    }
                    ((CompletableFuture)app.rqCreateNewLink(srcPort.getUuid(), destPort.getUuid()).exceptionally(throwable -> {
                        StareNotification.showWarn((String)"Failed create link");
                        return null;
                    })).thenAccept(v -> UserAction.executeWorkerIfInstanceMode(destPort.uiBlock.getUuid()));
                    break;
                }
                case RE_PLUG: {
                    if (!this.checkPortConnections(destPort)) {
                        return;
                    }
                    App.findConnectedLinks(srcPort.getUuid()).forEach(connection -> {
                        UILink uiLink = (UILink)connection;
                        app.rqCreateNewLink(uiLink.getNodeModel().getSrcPortUuid(), destPort.getUuid()).exceptionally(throwable -> {
                            StareNotification.showWarn((String)"Failed create link");
                            return null;
                        });
                        UserAction.deleteObject(uiLink, false);
                    });
                    break;
                }
                case BUNDLE: {
                    for (Connection connection2 : App.findConnectedLinks(srcPort.getUuid())) {
                        UILink uiLink = (UILink)connection2;
                        app.rqCreateNewLink(destPort.getUuid(), uiLink.getNodeModel().getDestPortUuid()).exceptionally(throwable -> {
                            StareNotification.showWarn((String)"Failed create link");
                            return null;
                        });
                        UserAction.deleteObject(uiLink, false);
                    }
                    break;
                }
                case ATTACH: {
                    if (destPort.getNodeModel().getPortType().isInput() && !this.checkPortConnections(destPort)) {
                        return;
                    }
                    ((CompletableFuture)((CompletableFuture)app.plugLinksToPort(((UILinkAnchor)srcPort).getConnectedLinks(), destPort.getNodeModel()).thenAccept(uiLinks -> FxPlatform.RunFxThread(() -> {
                        PortType portType = destPort.getNodeModel().getPortType();
                        uiLinks.forEach(uiLink -> {
                            UILinkModel uiLinkModel = uiLink.getNodeModel();
                            if (portType.isOutput()) {
                                uiLink.setSrcAnchor(destPort);
                            } else if (portType.isInput()) {
                                uiLink.setDestAnchor(destPort);
                            } else {
                                throw new RuntimeException(String.format("Unsupported port type: %s", portType.toString()));
                            }
                            if (uiLinkModel.getSrcPortUuid() != null && uiLinkModel.getDestPortUuid() != null) {
                                uiLink.setDetached(false);
                            }
                            ((UILinkAnchor)srcPort).removeLink((UILink)uiLink);
                        });
                    }))).exceptionally(t -> {
                        StareNotification.showWarn((String)String.format("Failed attach two objects: %s", t.getMessage()));
                        return null;
                    })).thenAccept(v -> UserAction.executeWorkerIfInstanceMode(destPort.uiBlock.getUuid()));
                    break;
                }
                default: {
                    String error = "Unknown linking type";
                    logger.severe("Unknown linking type");
                    StareNotification.showWarn((String)"Unknown linking type");
                }
            }
        });
        this.setOnDragDone(event -> {
            Desktop.getInstance().getDragLink().setVisible(false);
            EventBus.getDefault().post((Object)new StareDragDone());
        });
    }

    Map<String, String> standardCaptions(PortDataType portDataType) {
        return Collections.emptyMap();
    }

    static Map<String, String> makeDictionary(String ... pairs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int k = 0; k < pairs.length; k += 2) {
            result.put(pairs[k], pairs[k + 1]);
        }
        return Collections.unmodifiableMap(result);
    }

    void setAlternativeAnchor(Node alternativeAnchor) {
        this.alternativeAnchor = alternativeAnchor;
    }

    private boolean checkPortConnections(UIPort destPort) {
        if (App.hasConnection(destPort)) {
            if (DialogManager.showQuery((String)"Delete existing links?", (String)"Multiply input detected").isPresent()) {
                for (UILink link : App.findConnectedLinks(destPort)) {
                    UserAction.deleteObject(link, false);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void initializePortName() {
        String portCaption = this.model.getCaption().isEmpty() ? this.model.getName() : this.model.getCaption();
        portCaption = this.standardCaptions(this.model.getDataType()).getOrDefault(portCaption, portCaption);
        if (portCaption.startsWith("img:")) {
            Image image = new Image(this.getClass().getResourceAsStream(portCaption.substring("img:".length())), 0.0, 0.0, true, false);
            this.portCaption.setGraphic((Node)new ImageView(image));
            this.portCaption.setMinWidth(image.getWidth());
            this.portCaption.setMinHeight(image.getHeight());
            this.portCaption.setText("");
        } else {
            this.portCaption.setWrapText(true);
            String type = this.model.getDataType().getName();
            if (type != null) {
                switch (type) {
                    case "mat": {
                        this.portCaption.setTextFill((Paint)Color.web((String)"#0000E0"));
                        break;
                    }
                    case "numbers": {
                        break;
                    }
                    case "scalar": {
                        Font font = this.portCaption.getFont();
                        this.portCaption.setFont(Font.font((String)font.getFamily(), (FontPosture)FontPosture.ITALIC, (double)font.getSize()));
                    }
                }
                this.portCaption.setPrefWidth(UIPort.findWidthForWrapping(this.portCaption, portCaption));
                this.portCaption.setText(portCaption);
            }
        }
    }

    private void initializeAnchor() {
        this.alternativeAnchor = this.anchor;
    }

    private Tooltip createPortTooltip() {
        String caption;
        List<Connection> connected = App.findConnections(this);
        StringBuilder uiPortHint = new StringBuilder();
        String hint = this.model.getHint();
        if (!hint.isEmpty()) {
            uiPortHint.append(hint).append("\n");
        }
        if (!(caption = this.model.getCaption()).isEmpty()) {
            uiPortHint.append(String.format("Caption: %s\n", caption));
        }
        uiPortHint.append(String.format("Name: %s\n", this.model.getName()));
        uiPortHint.append(String.format("Data type: %s\n", this.model.getDataType().getName()));
        List connectedModels = connected.stream().map(connection -> {
            ConnectionModel model = (ConnectionModel)connection.getNodeModel();
            Optional optStareNode = switch (this.model.getPortType()) {
                default -> throw new MatchException(null, null);
                case PortType.INPUT, PortType.INPUT_CONTROL -> {
                    if (model.getSrcPortUuid() != null) {
                        yield NodeStorage.getInstance().findFirst(model.getSrcPortUuid());
                    }
                    yield Optional.empty();
                }
                case PortType.OUTPUT, PortType.OUTPUT_CONTROL -> model.getDestPortUuid() != null ? NodeStorage.getInstance().findFirst(model.getDestPortUuid()) : Optional.empty();
            };
            return optStareNode;
        }).filter(Optional::isPresent).flatMap(optStareNode -> optStareNode.map(StareNode::getNodeModel).stream()).collect(Collectors.toList());
        for (Model model : connectedModels) {
            if (UIPortModel.class.isAssignableFrom(model.getClass())) {
                UIPortModel portModel = (UIPortModel)model;
                String portCaption = portModel.getCaption().isEmpty() ? portModel.getName() : portModel.getCaption();
                Optional<Model> optParent = app.getProject().findModelByPredicate(nodeModel -> {
                    if (UIBlockModel.class.isAssignableFrom(nodeModel.getClass())) {
                        return ((UIBlockModel)nodeModel).hasPort(portModel.getUuid());
                    }
                    return false;
                });
                String parentCaption = optParent.isPresent() ? ((UIBlockModel)optParent.get()).getCaption() : "unknown block";
                uiPortHint.append(String.format("Connected with %s.%s\n", parentCaption, portCaption));
                continue;
            }
            uiPortHint.append("Detached");
        }
        try {
            IIDStorage.getInstance().findFirst(this.uiBlock.getNodeModel().getWorkerType(), WorkerType.class).ifPresent(workerType -> {
                List ports = Collections.emptyList();
                if (this.model.getPortType() == PortType.INPUT) {
                    ports = workerType.getStructure().getInPorts();
                } else if (this.model.getPortType() == PortType.OUTPUT) {
                    ports = workerType.getStructure().getOutPorts();
                }
                ports.stream().filter(sPort -> sPort.getName().equals(this.model.getName())).findFirst().ifPresent(sPort -> {
                    if (!sPort.getHint().isEmpty()) {
                        uiPortHint.append(sPort.getHint());
                    }
                });
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.portDataTooltip.isEmpty()) {
            uiPortHint.append("\n").append(this.portDataTooltip);
        }
        StareTooltip tooltip = new StareTooltip();
        tooltip.setText(uiPortHint.toString());
        return tooltip;
    }

    private Point2D figureStartPoint() {
        return Desktop.getInstance().nodeToGroup(this.getConnectionAnchor(), Desktop.ConvertStrategy.CENTER);
    }

    private static double findWidthForWrapping(Label label, String s) {
        Text text = new Text();
        text.setFont(label.getFont());
        double maxWidth = 0.0;
        for (String word : s.split("[\\s+]")) {
            text.setText("___" + word);
            maxWidth = Math.max(maxWidth, text.getBoundsInLocal().getWidth());
        }
        text.setText(s);
        return Math.min(maxWidth, text.getBoundsInLocal().getWidth());
    }

    @Override
    public void addChangePositionListener(Runnable listener) {
        UIPortChangePositionListener portPositionListener = new UIPortChangePositionListener(this.uiBlock, listener);
        this.listeners.put(listener, portPositionListener);
    }

    @Override
    public void removeChangePositionListener(Runnable listener) {
        NodeChangePositionListener portPositionListener = this.listeners.get(listener);
        if (portPositionListener != null) {
            portPositionListener.release();
            this.listeners.remove(listener);
        }
    }

    class UIPortChangePositionListener
    extends NodeChangePositionListener {
        private final ChangeListener<Boolean> needsLayoutListener;

        UIPortChangePositionListener(UIBlock uiBlock, Runnable callback) {
            super(uiBlock.getNode(), callback);
            this.needsLayoutListener = (ob, o, n) -> this.listenerSubject.onNext(Void.class);
            UIPort.this.needsLayoutProperty().addListener(this.needsLayoutListener);
        }

        @Override
        public void release() {
            super.release();
            UIPort.this.needsLayoutProperty().removeListener(this.needsLayoutListener);
        }
    }
}

