/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.node.SmartLinkModel;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UICommentModel;
import com.siams.cv.monitor.model.node.UILinkAnchorModel;
import com.siams.cv.monitor.model.node.UILinkModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.storage.NodeStorage;
import com.siams.cv.monitor.ui.factory.SmartLink;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.ui.factory.UIComment;
import com.siams.cv.monitor.ui.factory.UILink;
import com.siams.cv.monitor.ui.factory.UILinkAnchor;
import com.siams.cv.monitor.ui.factory.UIPort;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NodeFactory {
    private static final Logger logger = Logger.getLogger(NodeFactory.class);
    private static final NodeStorage nodeStorage = NodeStorage.getInstance();
    private static final Map<Class<? extends NodeModel>, Class<? extends StareNode>> registeredNodes = new HashMap<Class<? extends NodeModel>, Class<? extends StareNode>>();

    public static <T extends StareNode> T createNode(NodeModel model) {
        StareNode node;
        Class<? extends StareNode> clazz = registeredNodes.get(model.getClass());
        try {
            Constructor<? extends StareNode> uiNodeConstructor = clazz.getConstructor(model.getClass());
            node = uiNodeConstructor.newInstance(model);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Unknown model: %s, class: %s", model, clazz));
            throw new IllegalArgumentException(t);
        }
        node.getNode().setId(model.getUuid().toString());
        nodeStorage.addObject(node);
        return (T)node;
    }

    public static <T extends StareNode> T createNode(NodeModel model, Class<T> clazz) {
        StareNode node = null;
        if (UIPort.class.isAssignableFrom(clazz)) {
            UIPortModel portModel = (UIPortModel)model;
            try {
                Constructor<T> ctor = clazz.getConstructor(portModel.getClass());
                node = (StareNode)ctor.newInstance(portModel);
                node.getNode().setId(model.getUuid().toString());
                nodeStorage.addObject(node);
            }
            catch (Throwable t) {
                logger.error((Object)String.format("Failed create node: %s", t.getMessage()), t);
            }
        } else {
            node = (StareNode)NodeFactory.createNode(model);
        }
        return (T)node;
    }

    static {
        registeredNodes.put(UIBlockModel.class, UIBlock.class);
        registeredNodes.put(UICommentModel.class, UIComment.class);
        registeredNodes.put(UILinkModel.class, UILink.class);
        registeredNodes.put(SmartLinkModel.class, SmartLink.class);
        registeredNodes.put(UIPortModel.class, UIPort.class);
        registeredNodes.put(UILinkAnchorModel.class, UILinkAnchor.class);
    }
}

