/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.model.statistic.MatStatisticDetail;
import com.siams.cv.monitor.model.statistic.NumbersStatisticDetail;
import com.siams.cv.monitor.model.statistic.ScalarStatisticDetail;
import com.siams.cv.monitor.model.statistic.Statistic;
import com.siams.cv.monitor.model.statistic.StatisticDetail;
import java.util.Locale;
import net.algart.executors.api.data.SMat;
import org.apache.log4j.Logger;

public class DataTooltip {
    private static final Logger logger = Logger.getLogger(DataTooltip.class);
    private static final String[] RGBA_CHANNEL_COMMENTS = new String[]{"(R) ", "(G) ", "(B) ", "(A) "};

    public static String createTooltip(Statistic statistic, String statId) {
        return statistic.findFirstDetail(StatisticDetail.class, detail -> detail.getId().equals(statId)).map(DataTooltip::buildTooltip).orElse("");
    }

    private static String buildTooltip(StatisticDetail detail) {
        if (detail instanceof MatStatisticDetail) {
            return DataTooltip.buildTooltip((MatStatisticDetail)detail);
        }
        if (detail instanceof NumbersStatisticDetail) {
            return DataTooltip.buildTooltip((NumbersStatisticDetail)detail);
        }
        if (detail instanceof ScalarStatisticDetail) {
            return DataTooltip.buildTooltip((ScalarStatisticDetail)detail);
        }
        throw new RuntimeException("Unknown StatisticDetail class: " + detail.getClass().toString());
    }

    private static String buildTooltip(MatStatisticDetail matStatistic) {
        String bits;
        if (!matStatistic.isInitialized()) {
            return "SMat [NOT INITIALIZED]";
        }
        SMat.Depth depth = SMat.Depth.of((int)matStatistic.getDepth());
        String elementType = switch (depth) {
            case SMat.Depth.S8 -> {
                bits = "8-bit, signed";
                yield "byte";
            }
            case SMat.Depth.U8 -> {
                bits = "8-bit";
                yield "byte";
            }
            case SMat.Depth.S16 -> {
                bits = "16-bit, signed";
                yield "short";
            }
            case SMat.Depth.U16 -> {
                bits = "16-bit";
                yield "short";
            }
            case SMat.Depth.S32 -> {
                bits = "32-bit, signed";
                yield "int";
            }
            case SMat.Depth.F32 -> {
                bits = "32-bit";
                yield "float";
            }
            case SMat.Depth.F64 -> {
                bits = "64-bit";
                yield "double";
            }
            case SMat.Depth.BIT -> {
                bits = "1-bit";
                yield "bit";
            }
            default -> {
                bits = "unrecognized";
                yield "unrecognized";
            }
        };
        StringBuilder sb = new StringBuilder(String.format("%s[%dx%dx%d] (%s)\n", elementType, matStatistic.getChannels().size(), matStatistic.getWidth(), matStatistic.getHeight(), bits));
        int channelsCount = matStatistic.getChannels().size();
        boolean probablyRGBA = channelsCount == 3 || channelsCount == 4;
        for (int i = 0; i < channelsCount; ++i) {
            int rgbaIndex = probablyRGBA ? (i == 0 ? 2 : (i == 2 ? 0 : i)) : i;
            double min = matStatistic.getChannels().get(rgbaIndex).getMin();
            double max = matStatistic.getChannels().get(rgbaIndex).getMax();
            String channelName = "[Channel #" + i + "] ";
            String channelPostfix = probablyRGBA && i < RGBA_CHANNEL_COMMENTS.length ? RGBA_CHANNEL_COMMENTS[i] : "";
            sb.append(DataTooltip.createMinMaxTooltipSubstring(min, max, elementType, channelName, channelPostfix));
        }
        return sb.toString();
    }

    private static String buildTooltip(NumbersStatisticDetail numbersStatistic) {
        String dataType;
        if (!numbersStatistic.isInitialized()) {
            return "SNumbers [NOT INITIALIZED]";
        }
        long blockLength = numbersStatistic.getBlockLength();
        long numberOfBlocks = numbersStatistic.getNumberOfBlocks();
        long count = blockLength * numberOfBlocks;
        long sizeInBytes = switch (dataType) {
            case "double", "long" -> 8L * count;
            case "float", "int" -> 4L * count;
            case "short" -> 2L * count;
            case "byte" -> count;
            default -> {
                logger.error((Object)String.format("Unsupported data type: %s", dataType));
                yield 0L;
            }
        };
        String tooltipHeader = String.format("numbers %d x %d (%s) [%d bytes]", blockLength, numberOfBlocks, dataType, sizeInBytes);
        return String.format("%s\n%s", tooltipHeader, tooltipPreview);
    }

    private static String buildTooltip(ScalarStatisticDetail scalarStatistic) {
        return scalarStatistic.isInitialized() ? scalarStatistic.getScalar() : "SScalar [NOT INITIALIZED]";
    }

    private static String formatData(NumbersStatisticDetail details, double[] values) {
        StringBuilder sb = new StringBuilder();
        int blockLimit = (int)Math.min(5L, details.getNumberOfBlocks());
        int lengthLimit = (int)Math.min(5L, details.getBlockLength());
        for (int i = 0; i < blockLimit; ++i) {
            for (int j = 0; j < lengthLimit; ++j) {
                sb.append(String.format("%.1f ", values[i * lengthLimit + j]));
            }
            if (details.getBlockLength() > 5L) {
                sb.append("...");
            }
            sb.append("\n");
        }
        if (details.getNumberOfBlocks() > 5L) {
            sb.append("...");
        }
        return sb.toString();
    }

    private static String formatData(NumbersStatisticDetail details, long[] values) {
        StringBuilder sb = new StringBuilder();
        int blockLimit = (int)Math.min(5L, details.getNumberOfBlocks());
        int lengthLimit = (int)Math.min(5L, details.getBlockLength());
        for (int i = 0; i < blockLimit; ++i) {
            for (int j = 0; j < lengthLimit; ++j) {
                sb.append(String.format("%d ", values[i * lengthLimit + j]));
            }
            if (details.getBlockLength() > 5L) {
                sb.append("...");
            }
            sb.append("\n");
        }
        if (details.getNumberOfBlocks() > 5L) {
            sb.append("...");
        }
        return sb.toString();
    }

    private static String createMinMaxTooltipSubstring(double min, double max, String elementType, String channelName, String channelComment) {
        double scale = "byte".equals(elementType) ? 0.00392156862745098 : ("short".equals(elementType) ? 1.5259021896696422E-5 : ("int".equals(elementType) ? 4.656612875245797E-10 : 1.0));
        StringBuilder result = new StringBuilder(channelName).append(channelComment);
        result.append("range: ").append(DataTooltip.rangeToString(min * scale, max * scale, false));
        if (scale != 1.0) {
            result.append("  (non-normalized: ").append(DataTooltip.rangeToString(min, max, true)).append(")");
        }
        return result.append("\n").toString();
    }

    private static String rangeToString(double min, double max, boolean simpleIntegers) {
        if (simpleIntegers) {
            return String.format("%s..%s", DataTooltip.doubleOrIntegerToString(min), DataTooltip.doubleOrIntegerToString(max));
        }
        return String.format(Locale.US, "%.5f..%.5f", min, max);
    }

    private static String doubleOrIntegerToString(double v) {
        return v == (double)((long)v) ? String.valueOf((long)v) : String.format(Locale.US, "%f", v);
    }

    private static /* synthetic */ long lambda$buildTooltip$1(double d) {
        return (long)d;
    }
}

