/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.factory;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import java.util.concurrent.CompletableFuture;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public abstract class Block<T extends AnchorPane>
implements StareNode {
    protected Point2D initialSize = Point2D.ZERO;
    protected Point2D initialResizePoint = Point2D.ZERO;
    CompletableFuture<Void> fxmlInitialized = new CompletableFuture();
    protected T root;

    Block() {
    }

    protected void initialize() {
        this.initializeFxml();
        this.initializeStyle();
        this.initializeEvents();
    }

    protected abstract void initializeFxml();

    protected void initializeStyle() {
        this.root.getStyleClass().add((Object)"ui-block");
    }

    protected void initializeEvents() {
        this.root.setOnKeyReleased(this::onKeyReleasedHandler);
    }

    private void onKeyReleasedHandler(KeyEvent event) {
        if (event.getCode() == KeyCode.DELETE) {
            UserAction.deleteSelectedObjects(true);
            event.consume();
        }
    }

    public CompletableFuture<Void> fxmlInitialized() {
        return this.fxmlInitialized;
    }

    void onResizeMousePressed(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        event.consume();
        this.initialSize = new Point2D(this.root.getWidth(), this.root.getHeight());
        this.initialResizePoint = new Point2D(event.getScreenX(), event.getScreenY());
    }

    void onResizeMouseDragged(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        event.consume();
        double width = this.initialSize.getX() + (event.getScreenX() - this.initialResizePoint.getX());
        double height = this.initialSize.getY() + (event.getScreenY() - this.initialResizePoint.getY());
        this.root.setPrefWidth(width);
        this.root.setPrefHeight(height);
    }

    void onResizeMouseReleased(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (App.getInstance().getProject().getRoot().getGridAdjust()) {
            int gridSize = App.getInstance().getProject().getRoot().getGridSize();
            double width = Math.floor(this.root.getPrefWidth() / (double)gridSize + 0.5) * (double)gridSize;
            double height = Math.floor(this.root.getPrefHeight() / (double)gridSize + 0.5) * (double)gridSize;
            this.root.setPrefWidth(width);
            this.root.setPrefHeight(height);
        }
        event.consume();
    }

    protected void initializeResizeTriangle(Node resizeAnchor) {
        resizeAnchor.setOnMouseDragged(this::onResizeMouseDragged);
        resizeAnchor.setOnMousePressed(this::onResizeMousePressed);
        resizeAnchor.setOnMouseReleased(this::onResizeMouseReleased);
    }
}

