/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.windows;

import com.siams.cv.monitor.ui.content.windows.OnlineHelp;
import com.siams.javafx.PaneHelper;
import java.util.prefs.Preferences;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public class WebViewWindow
extends Stage {
    private WebViewContent webViewContent;
    private double prefWidth;
    private double prefHeight;

    public WebViewWindow(String title) {
        this.setTitle(title);
        this.initModality(Modality.APPLICATION_MODAL);
        this.setResizable(true);
        this.restorePreference();
        this.webViewContent = new WebViewContent();
        Scene scene = new Scene((Parent)this.webViewContent, this.prefWidth, this.prefHeight);
        this.setScene(scene);
        this.webViewContent.webView.getEngine().getLoadWorker().stateProperty().addListener((ob, o, n) -> {
            if (n == Worker.State.SUCCEEDED) {
                JSObject window = (JSObject)this.webViewContent.webView.getEngine().executeScript("window");
                window.setMember("app", new JavaApp());
            }
        });
        this.setOnCloseRequest(e -> this.savePreference());
        this.initGlobalHotKeys(scene);
    }

    private void initGlobalHotKeys(Scene scene) {
        scene.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            boolean isConsumed = true;
            switch (e.getCode()) {
                case ESCAPE: {
                    this.savePreference();
                    this.close();
                    break;
                }
                default: {
                    isConsumed = false;
                }
            }
            if (isConsumed) {
                e.consume();
            }
        });
    }

    public void setHtml(String html) {
        this.webViewContent.webView.getEngine().loadContent(html);
    }

    public void setUrl(String url) {
        this.webViewContent.webView.getEngine().load(url);
    }

    private void savePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(OnlineHelp.class);
            preferences.putBoolean("isMaximized", this.isMaximized());
            preferences.putDouble("width", this.getWidth());
            preferences.putDouble("height", this.getHeight());
            preferences.putDouble("x", this.getX());
            preferences.putDouble("y", this.getY());
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void restorePreference() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(OnlineHelp.class);
            boolean isMaximazed = preferences.getBoolean("isMaximized", true);
            if (isMaximazed) {
                this.setMaximized(true);
            } else {
                this.prefWidth = preferences.getDouble("width", 600.0);
                this.prefHeight = preferences.getDouble("height", 800.0);
                this.setX(preferences.getDouble("x", 0.0));
                this.setY(preferences.getDouble("y", 0.0));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private static class WebViewContent
    extends AnchorPane {
        private WebView webView = new WebView();

        private WebViewContent() {
            this.webView.setMinSize(-1.0, -1.0);
            this.webView.setPrefSize(-1.0, -1.0);
            this.webView.setMaxSize(-1.0, -1.0);
            this.getChildren().add((Object)this.webView);
            this.setPrefSize(800.0, 600.0);
            PaneHelper.setAnchorZero((Node)this.webView);
        }
    }

    public static class JavaApp {
        public void onClick() {
            System.out.println("Clicked");
        }
    }
}

