/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.windows;

import com.siams.cv.monitor.entity.jvm.JvmProperties;
import com.siams.cv.monitor.message.JvmPropertiesLoaded;
import com.siams.cv.monitor.ui.factory.Deletable;
import com.siams.fxml.loader.CustomFXMLLoader;
import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class JvmPropertyWindow
extends Stage
implements Deletable {
    private static JvmPropertyWindow instance;
    private JvmPropertyContent content;

    public static JvmPropertyWindow getInstance() {
        if (instance == null) {
            instance = new JvmPropertyWindow();
        }
        return instance;
    }

    private JvmPropertyWindow() {
        this.setTitle("Jvm properties");
        this.initModality(Modality.APPLICATION_MODAL);
        this.setResizable(true);
        this.setScene(new Scene((Parent)new JvmPropertyContent(this)));
    }

    public void close() {
        super.close();
        this.release();
    }

    @Override
    public void release() {
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    public class JvmPropertyContent
    extends AnchorPane {
        @FXML
        private TextField path;
        @FXML
        private TextArea properties;

        JvmPropertyContent(JvmPropertyWindow this$0) {
            try {
                URL url = ((Object)((Object)this)).getClass().getResource("/com/siams/cv/monitor/ui/content/windows/JvmPropertyContent.fxml");
                CustomFXMLLoader.loadElement((Object)((Object)this), (URL)url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.subscribe();
        }

        @Subscribe
        public void onJvmPropertiesLoaded(JvmPropertiesLoaded event) {
            Platform.runLater(() -> {
                JvmProperties jvmProperties = event.getJvmProperties();
                this.path.setText(jvmProperties.getJvmPath());
                StringBuilder sb = new StringBuilder();
                for (String property : jvmProperties.getProperties()) {
                    sb.append(property).append("\n");
                }
                sb.deleteCharAt(sb.length() - 1);
                this.properties.setText(sb.toString());
            });
        }

        private void subscribe() {
            EventBus.getDefault().register((Object)this);
        }
    }
}

