/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.property.BoolPropertyModel;
import com.siams.cv.monitor.model.property.DoublePropertyModel;
import com.siams.cv.monitor.model.property.PropertyModel;
import com.siams.cv.monitor.model.storage.ViewerModelStorage;
import com.siams.cv.monitor.model.viewer.CropViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.worker.control.SCRange;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.cv.monitor.transport.BlockBasedDataSource;
import com.siams.cv.monitor.ui.content.container.ViewerContainer;
import com.siams.cv.monitor.ui.factory.UIBlock;
import com.siams.cv.monitor.viewers.ui.content.CropViewer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlBuilder;
import com.siams.fx.control.UIControlContainer;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControlContainer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import net.algart.executors.api.data.SNumbers;

class UIObjectProperties
extends AnchorPane {
    private static final Logger logger = Logger.getLogger(UIObjectProperties.class.getCanonicalName());
    private IIdentifiable iid;
    private final List<UIControlContainer> controlContainers = new LinkedList<UIControlContainer>();
    @FXML
    private VBox vBoxProperties;
    private ToggleButton tbDisplayAdvanced;

    UIObjectProperties(IIdentifiable iid) {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/com/siams/cv/monitor/ui/content/container/UIObjectProperties.fxml");
            CustomFXMLLoader.loadElement((Object)((Object)this), (URL)url);
            this.iid = iid;
            this.initializeMenu();
            App.getInstance().getProject().findModel(iid, UIBlockModel.class).ifPresent(this::specCaseForCropWorker);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeMenu() {
        this.tbDisplayAdvanced = new ToggleButton();
        this.tbDisplayAdvanced.getStyleClass().add((Object)"introspection-menu");
        Tooltip.install((Node)this.tbDisplayAdvanced, (Tooltip)new StareTooltip("Display advanced parameters"));
        App.getInstance().getProject().findModel(this.iid, UIBlockModel.class).ifPresent(model -> this.tbDisplayAdvanced.setSelected(model.getDisplayAdvanced().booleanValue()));
        this.tbDisplayAdvanced.selectedProperty().addListener((ob, o, selected) -> {
            this.updateControlsVisibility((boolean)selected);
            App.getInstance().getProject().findModel(this.iid, UIBlockModel.class).ifPresent(model -> model.setDisplayAdvanced(selected));
        });
    }

    public List<UIControlContainer> setControls(List<SControl> controls) {
        boolean hasAdvanced = controls.stream().anyMatch(SControl::getAdvanced);
        this.tbDisplayAdvanced.setVisible(hasAdvanced);
        this.tbDisplayAdvanced.setManaged(hasAdvanced);
        ArrayList<UIControlContainer> createdContainers = new ArrayList<UIControlContainer>();
        controls.forEach(structureControl -> {
            try {
                UIValueControlContainer controlContainer = UIControlBuilder.createUIControl((SControl)structureControl);
                createdContainers.add((UIControlContainer)controlContainer);
                controlContainer.setObject(this.iid);
                File projectFile = App.getInstance().getProject().getProjectFile();
                controlContainer.setWorkingDir(projectFile != null ? projectFile.getParentFile() : null);
                if (structureControl instanceof SCRange) {
                    this.handleRangeControl((UIControlContainer)controlContainer);
                }
                this.controlContainers.add((UIControlContainer)controlContainer);
                Node node = controlContainer.getNode();
                this.vBoxProperties.getChildren().add((Object)node);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, t, t::getMessage);
            }
        });
        boolean displayAdvanced = App.getInstance().getProject().findModel(this.iid, UIBlockModel.class).map(UIBlockModel::getDisplayAdvanced).orElse(false);
        this.updateControlsVisibility(displayAdvanced);
        return createdContainers;
    }

    void setControls(List<SControl> controls, UIControlEventHandler valueChangedHandler) {
        boolean hasAdvanced = controls.stream().anyMatch(SControl::getAdvanced);
        this.tbDisplayAdvanced.setVisible(hasAdvanced);
        this.tbDisplayAdvanced.setManaged(hasAdvanced);
        controls.forEach(structureControl -> {
            try {
                UIValueControlContainer controlContainer = UIControlBuilder.createUIControl((SControl)structureControl);
                controlContainer.setObject(this.iid);
                controlContainer.setUIControlEventHandler(valueChangedHandler);
                File projectFile = App.getInstance().getProject().getProjectFile();
                controlContainer.setWorkingDir(projectFile != null ? projectFile.getParentFile() : null);
                if (structureControl instanceof SCRange) {
                    this.handleRangeControl((UIControlContainer)controlContainer);
                }
                this.controlContainers.add((UIControlContainer)controlContainer);
                Node node = controlContainer.getNode();
                this.vBoxProperties.getChildren().add((Object)node);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, t, t::getMessage);
            }
        });
        boolean displayAdvanced = App.getInstance().getProject().findModel(this.iid, UIBlockModel.class).map(UIBlockModel::getDisplayAdvanced).orElse(false);
        this.updateControlsVisibility(displayAdvanced);
    }

    public void setEventHandler(UIControlEventHandler handler) {
        FxPlatform.RunFxThread(() -> this.controlContainers.forEach(container -> container.setUIControlEventHandler(handler)));
    }

    ButtonBase getToggleAdvanced() {
        return this.tbDisplayAdvanced;
    }

    private void updateControlsVisibility(boolean displayAdvanced) {
        this.controlContainers.forEach(uiControlContainer -> {
            SControl structureControl = uiControlContainer.getStructureControl();
            boolean isAdvancedControl = structureControl.getAdvanced();
            Node node = uiControlContainer.getNode();
            if (isAdvancedControl) {
                node.setManaged(displayAdvanced);
                node.setVisible(displayAdvanced);
            }
        });
    }

    void setProperties(List<SimplePrimitive> properties) {
        properties.forEach(property -> this.findControlByName(property.getName()).ifPresent(uiControlContainer -> uiControlContainer.setProperty(property)));
    }

    public Optional<UIControlContainer> findControlByName(String name) {
        return this.controlContainers.stream().filter(uiControlContainer -> uiControlContainer.getStructureControl().getName().equals(name)).findFirst();
    }

    private void specCaseForCropWorker(UIBlockModel blockModel) {
        UUID cropBlockUuid = UUID.fromString("9bdbc1e8-0789-46ab-a4e6-be30b497a863");
        if (!blockModel.getWorkerType().equals(cropBlockUuid)) {
            return;
        }
        Button openCropViewerButton = new Button("Edit Crop");
        openCropViewerButton.setOnAction(event -> this.callCropViewer(blockModel));
        this.vBoxProperties.getChildren().add((Object)openCropViewerButton);
    }

    private void callCropViewer(UIBlockModel cropUIBlockModel) {
        App app = App.getInstance();
        Consumer<Map> saveCallback = cropParams -> ((CompletableFuture)app.rqGetObjectProperties((IIdentifiable)cropUIBlockModel).thenAccept(dRs -> dRs.getProperties().stream().filter(propertyModel -> cropParams.containsKey(propertyModel.getName())).forEach(property -> {
            DoublePropertyModel propertyModel;
            String name = property.getName();
            Object value = cropParams.get(name);
            if (value instanceof Double) {
                propertyModel = new DoublePropertyModel(name, (Double)value);
            } else if (value instanceof Boolean) {
                propertyModel = new BoolPropertyModel(name, (Boolean)value);
            } else {
                propertyModel = new PropertyModel();
                logger.fine("Some special case should be implemented?");
            }
            SimplePrimitive primitiveProperty = SimplePrimitive.valueOf((PropertyModel)propertyModel);
            App.getInstance().rqSetWorkerProperty(cropUIBlockModel.getUuid(), name, value);
            this.findControlByName(name).ifPresent(uiControlContainer -> uiControlContainer.setProperty(primitiveProperty));
        }))).exceptionally(t -> {
            StareNotification.showWarn((String)"Failed save crop property");
            return null;
        });
        cropUIBlockModel.findPort(PortType.INPUT, "input").flatMap(uiInputPort -> app.findConnectedBlocks((UIPortModel)uiInputPort).stream().findFirst()).ifPresentOrElse(imageSourceBlock -> ((CompletableFuture)app.rqViewerData((UIBlock)imageSourceBlock).thenAccept(viewerData -> {
            CropViewerModel cropViewerModel = (CropViewerModel)ViewerModelStorage.findByBlockId(cropUIBlockModel.getUuid()).flatMap(existingModel -> {
                if (CropViewerModel.class.isAssignableFrom(existingModel.getClass())) {
                    return Optional.of(existingModel);
                }
                return Optional.empty();
            }).orElseGet(() -> {
                CropViewerModel model = new CropViewerModel(cropUIBlockModel.getUuid());
                model.setTitle(cropUIBlockModel.getCaption());
                ViewerModelStorage.getInstance().addObject(model);
                return model;
            });
            if (cropViewerModel.isShowing()) {
                cropViewerModel.toFront();
                return;
            }
            CropViewer cropViewer = (CropViewer)ViewerFactory.create((ViewerKind)ViewerKind.CROP, (ViewerModel)cropViewerModel);
            BlockBasedDataSource dataSource = new BlockBasedDataSource(imageSourceBlock.getUuid());
            dataSource.setData((ViewerData)viewerData);
            cropViewer.setViewerDataSource((ViewerDataSource)dataSource);
            cropViewer.setSaveCallback(saveCallback);
            FxPlatform.RunFxThread(() -> ViewerContainer.createAndShow((Viewer)cropViewer));
        })).exceptionally(t -> {
            logger.log(Level.SEVERE, (Throwable)t, () -> String.format("Can't load all viewer required data: %s", t.getMessage()));
            return null;
        }), () -> StareNotification.showWarn((String)"Can't find source image to crop"));
    }

    private void handleRangeControl(UIControlContainer controlContainer) {
        Consumer<ViewerData> viewerDataConsumer = viewerData -> viewerData.getData().values().stream().filter(data -> SNumbers.class.isAssignableFrom(data.getClass())).findFirst().map(data -> (SNumbers)data).ifPresent(sNumbers -> FxPlatform.RunFxThread(() -> controlContainer.setNumbersData(sNumbers)));
        if (this.iid instanceof UIBlock) {
            App.getInstance().rqViewerData((UIBlock)this.iid).thenAccept((Consumer)viewerDataConsumer);
        } else if (this.iid instanceof UIBlockModel) {
            App.getInstance().rqViewerData((UIBlockModel)this.iid).thenAccept((Consumer)viewerDataConsumer);
        }
    }
}

