/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.PortImageViewerModel;
import com.siams.cv.monitor.transport.BlockBasedDataSource;
import com.siams.cv.monitor.transport.PortBasedDataSource;
import com.siams.cv.monitor.viewers.ui.content.CompareViewer;
import com.siams.cv.monitor.viewers.ui.content.IBaseImageViewerContent;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTool;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class TunerCompareViewer
extends CompareViewer {
    private final List<SelectionTool> selectionTools = new LinkedList<SelectionTool>();
    private VBox vBoxToolsPanel;
    private final ToggleGroup selectionToolsToggleGroup = new ToggleGroup();

    protected TunerCompareViewer(CompareViewerModel viewerModel) {
        super(viewerModel);
    }

    protected ViewerDataSource createDataSource(BlockViewerModel blockModel) {
        if (blockModel instanceof PortImageViewerModel) {
            return new PortBasedDataSource(blockModel.getBlockUuid(), ((PortImageViewerModel)blockModel).getPortUuid());
        }
        return new BlockBasedDataSource(blockModel.getBlockUuid());
    }

    protected IBaseImageViewerContent getBaseContent() {
        return super.getBaseContent();
    }

    public void initialize() {
        super.initialize();
        this.initializeToolPanel();
    }

    protected void drawImage(Image image) {
        super.drawImage(image);
        this.moveSelectionTools();
    }

    protected void onRasterContainerClicked(MouseEvent event) {
        super.onRasterContainerClicked(event);
        this.selectionTools.forEach(tool -> tool.onHandlePaneClicked(event));
    }

    public void addSelectionTool(SelectionTool tool, ToggleButton activationControl) {
        this.selectionTools.add(tool);
        this.vBoxToolsPanel.getChildren().add((Object)activationControl);
        activationControl.setToggleGroup(this.selectionToolsToggleGroup);
    }

    public void release() {
        super.release();
        this.selectionTools.forEach(SelectionTool::release);
        this.selectionTools.clear();
        this.selectionToolsToggleGroup.getToggles().clear();
        this.vBoxToolsPanel.getChildren().clear();
    }

    private void initializeToolPanel() {
        this.vBoxToolsPanel = new VBox(5.0);
        Pane container = this.root.getRasterContainer();
        container.getChildren().add((Object)this.vBoxToolsPanel);
        AnchorPane.setLeftAnchor((Node)this.vBoxToolsPanel, (Double)5.0);
        AnchorPane.setTopAnchor((Node)this.vBoxToolsPanel, (Double)100.0);
    }

    private void moveSelectionTools() {
        double shiftX = this.imageViewRect.getX() + this.imageViewRect.getTranslateX();
        double shiftY = this.imageViewRect.getY() + this.imageViewRect.getTranslateY();
        double scale = this.imageViewRect.getScale();
        for (SelectionTool tool : this.selectionTools) {
            Point2D point = tool.getModelPosition();
            Point2D newPosition = new Point2D(Math.floor(point.getX()) * scale + shiftX, Math.floor(point.getY()) * scale + shiftY);
            tool.setScale(scale);
            tool.setViewPosition(newPosition);
        }
    }
}

