/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.ChartViewerModel;
import com.siams.cv.monitor.model.viewer.TableViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.transport.PortBasedDataSource;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import java.util.Collection;
import java.util.UUID;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class NonRasterViewerTab
extends Tab {
    private Viewer<? extends BlockViewerModel> tabViewer = null;

    NonRasterViewerTab(String text) {
        super(text);
    }

    public void setViewer(Viewer<? extends BlockViewerModel> viewer) {
        this.tabViewer = viewer;
        this.setTabContent(viewer);
        this.initializeContextMenu();
    }

    public Viewer<?> getViewer() {
        return this.tabViewer;
    }

    public void close() {
        if (this.getContextMenu() != null) {
            this.getContextMenu().getItems().clear();
            this.setContextMenu(null);
        }
        this.setContent(null);
        this.tabViewer.release();
    }

    private void initializeContextMenu() {
        ViewerKind kind = ViewerKind.from((String)((BlockViewerModel)this.tabViewer.getViewerModel()).getKind());
        switch (kind) {
            case TABLE: 
            case CHART: {
                String title = this.menuItemTextForKind(kind == ViewerKind.CHART ? ViewerKind.TABLE : ViewerKind.CHART);
                MenuItem miConvert = new MenuItem(title);
                miConvert.setOnAction(this::convert);
                this.setContextMenu(new ContextMenu(new MenuItem[]{miConvert}));
                break;
            }
        }
    }

    private void setTabContent(Viewer<?> viewer) {
        ToolBar toolbar = new ToolBar();
        toolbar.setOrientation(Orientation.HORIZONTAL);
        toolbar.getItems().addAll((Collection)viewer.provideTools());
        Node view = viewer.provideView();
        VBox wrapper = new VBox(new Node[]{toolbar, view});
        VBox.setVgrow((Node)view, (Priority)Priority.ALWAYS);
        this.setContent((Node)wrapper);
    }

    private void convert(ActionEvent event) {
        Viewer newViewer;
        UUID blockUuid = ((BlockViewerModel)this.tabViewer.getViewerModel()).getBlockUuid();
        ViewerKind kind = ViewerKind.from((String)((BlockViewerModel)this.tabViewer.getViewerModel()).getKind());
        ((MenuItem)this.getContextMenu().getItems().get(0)).setText(this.menuItemTextForKind(kind));
        if (kind == ViewerKind.CHART) {
            TableViewerModel tableViewerModel = new TableViewerModel(blockUuid);
            newViewer = ViewerFactory.create((ViewerKind)ViewerKind.TABLE, (ViewerModel)tableViewerModel);
        } else {
            ChartViewerModel chartViewerModel = new ChartViewerModel(blockUuid);
            newViewer = ViewerFactory.create((ViewerKind)ViewerKind.CHART, (ViewerModel)chartViewerModel);
        }
        PortBasedDataSource dataSource = new PortBasedDataSource(blockUuid, ((PortBasedDataSource)this.tabViewer.getViewerDataSource()).getPortId());
        this.tabViewer.getViewerDataSource().getData().ifPresent(dataSource::setData);
        dataSource.rqViewerData();
        newViewer.setViewerDataSource((ViewerDataSource)dataSource);
        this.setContent(null);
        this.tabViewer.release();
        this.tabViewer = newViewer;
        this.setTabContent(newViewer);
    }

    private String menuItemTextForKind(ViewerKind kind) {
        return String.format("Convert to %s", kind.toString());
    }
}

