/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.storage.NodeStorage;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;

public class MouseSelection {
    private NodeStorage nodeStorage = NodeStorage.getInstance();
    private Rectangle selectionArea = new Rectangle();
    private Point2D selectionSource;
    private boolean isSelection = false;

    public MouseSelection() {
        this.selectionArea.getStyleClass().add((Object)"selection-rectangle");
    }

    public Rectangle getSelectionRectangle() {
        return this.selectionArea;
    }

    public void setEventHandlingNode(Node target) {
        target.addEventHandler(MouseEvent.MOUSE_PRESSED, this::handleMousePressed);
        target.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        target.addEventHandler(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
    }

    private void handleMousePressed(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                if (!event.isControlDown()) break;
                event.consume();
                this.isSelection = true;
                this.selectionArea.getParent().setCursor(Cursor.CLOSED_HAND);
                this.selectionArea.setWidth(0.0);
                this.selectionArea.setHeight(0.0);
                this.selectionArea.setVisible(true);
                this.selectionArea.setX(event.getX());
                this.selectionArea.setY(event.getY());
                this.selectionArea.toFront();
                this.selectionSource = new Point2D(event.getX(), event.getY());
                break;
            }
            case SECONDARY: {
                break;
            }
        }
    }

    private void handleMouseDragged(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                if (!this.isSelection) break;
                event.consume();
                this.redrawSelectionArea(new Point2D(event.getX(), event.getY()));
                break;
            }
            case SECONDARY: {
                break;
            }
        }
    }

    private void handleMouseReleased(MouseEvent event) {
        switch (event.getButton()) {
            case PRIMARY: {
                if (!this.isSelection) break;
                event.consume();
                this.selectionArea.getParent().setCursor(Cursor.DEFAULT);
                Point2D upperLeft = new Point2D(this.selectionArea.getX(), this.selectionArea.getY());
                Point2D bottomRight = new Point2D(this.selectionArea.getX() + this.selectionArea.getWidth(), this.selectionArea.getY() + this.selectionArea.getHeight());
                this.selectionArea.setVisible(false);
                this.applySelection(upperLeft, bottomRight);
                this.isSelection = false;
                break;
            }
            case SECONDARY: {
                break;
            }
        }
    }

    private void redrawSelectionArea(Point2D cursor) {
        Point2D upperleft = new Point2D(Math.min(this.selectionSource.getX(), cursor.getX()), Math.min(this.selectionSource.getY(), cursor.getY()));
        Point2D bottomRight = new Point2D(Math.max(this.selectionSource.getX(), cursor.getX()), Math.max(this.selectionSource.getY(), cursor.getY()));
        this.selectionArea.setX(upperleft.getX());
        this.selectionArea.setY(upperleft.getY());
        this.selectionArea.setWidth(bottomRight.getX() - upperleft.getX());
        this.selectionArea.setHeight(bottomRight.getY() - upperleft.getY());
    }

    private void applySelection(Point2D upperLeft, Point2D bottomRight) {
        BoundingBox selectionBounds = new BoundingBox(upperLeft.getX(), upperLeft.getY(), bottomRight.getX() - upperLeft.getX(), bottomRight.getY() - upperLeft.getY());
        ArrayList<StareNode> selectedNodes = new ArrayList<StareNode>();
        this.nodeStorage.getAll().forEach(arg_0 -> MouseSelection.lambda$applySelection$0((Bounds)selectionBounds, selectedNodes, arg_0));
        UserAction.selectNodes(selectedNodes);
    }

    private static /* synthetic */ void lambda$applySelection$0(Bounds selectionBounds, List selectedNodes, StareNode stareNode) {
        Node node = stareNode.getNode();
        BoundingBox nodeBounds = new BoundingBox(node.getBoundsInParent().getMinX(), node.getBoundsInParent().getMinY(), node.getBoundsInLocal().getWidth(), node.getBoundsInLocal().getHeight());
        if (selectionBounds.contains((Bounds)nodeBounds)) {
            selectedNodes.add(stareNode);
        }
    }
}

