/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui.content.container;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.application.GlobalHotKeys;
import com.siams.cv.monitor.application.UserAction;
import com.siams.cv.monitor.message.StareMonitorClosing;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.node.PortDataType;
import com.siams.cv.monitor.model.node.UIBlockModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.storage.IIDStorage;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.PortImageViewerModel;
import com.siams.cv.monitor.model.viewer.TableViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.model.viewer.VoxelViewerModel;
import com.siams.cv.monitor.model.worker.WorkerStructure;
import com.siams.cv.monitor.model.worker.WorkerType;
import com.siams.cv.monitor.transport.PortBasedDataSource;
import com.siams.cv.monitor.ui.content.container.NonRasterViewerTab;
import com.siams.cv.monitor.ui.content.container.TunerCompareViewer;
import com.siams.cv.monitor.ui.content.container.UIObjectProperties;
import com.siams.cv.monitor.viewers.ui.content.CompareViewerContent;
import com.siams.cv.monitor.viewers.ui.content.IViewerContainer;
import com.siams.cv.monitor.viewers.ui.content.Viewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTool;
import com.siams.cv.monitor.viewers.ui.content.tools.SelectionTools;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlContainer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import com.siams.preferences.UIPreference;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import net.algart.executors.api.data.Data;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class BlockTuner
implements IViewerContainer,
UIPreference {
    private final Logger logger = Logger.getLogger(BlockTuner.class.getCanonicalName());
    private Stage window;
    private BlockTunerContent root;
    private UIObjectProperties uiObjectProperties;
    private TunerCompareViewer compareViewer;
    private static final Map<String, List<String>> nameAliases = new LinkedHashMap<String, List<String>>();
    private final EventHandler<WindowEvent> editorCloseHandler;

    public BlockTuner(UIBlockModel model) {
        nameAliases.put("x", List.of("left", "startX"));
        nameAliases.put("y", List.of("top", "startY"));
        nameAliases.put("width", List.of("sizeX"));
        nameAliases.put("height", List.of("sizeY"));
        nameAliases.put("size", List.of("radius"));
        this.editorCloseHandler = event -> {
            this.savePreference();
            this.release();
        };
        this.initializeRoot();
        this.initializePinUnpinButton();
        this.initializeScene();
        this.window.setTitle(model.getCaption());
        this.initializeSettings(model);
        this.initializeCompareViewer();
        this.initializeCompareViewerTools();
        this.initializeCompareViewerLayers(model);
        this.subscribe();
    }

    private void initializeRoot() {
        this.root = new BlockTunerContent();
    }

    private void initializePinUnpinButton() {
        this.root.tbPinUnpin.getStyleClass().add((Object)"unpinned");
        this.root.tbPinUnpin.selectedProperty().addListener((ob, o, pinned) -> {
            if (pinned.booleanValue()) {
                this.root.tbPinUnpin.getStyleClass().remove((Object)"unpinned");
                this.root.tbPinUnpin.getStyleClass().add((Object)"pinned");
            } else {
                this.root.tbPinUnpin.getStyleClass().add((Object)"unpinned");
                this.root.tbPinUnpin.getStyleClass().remove((Object)"pinned");
            }
            Stage currentWindow = this.window;
            Scene permanentScene = currentWindow.getScene();
            double x = currentWindow.getX();
            double y = currentWindow.getY();
            double width = currentWindow.getWidth();
            double height = currentWindow.getHeight();
            Stage newWindow = this.createWindow();
            if (pinned.booleanValue()) {
                newWindow.initOwner((Window)App.getInstance().getMainStage());
            }
            newWindow.setX(x);
            newWindow.setY(y);
            newWindow.setWidth(width);
            newWindow.setHeight(height);
            newWindow.setTitle(currentWindow.getTitle());
            newWindow.setScene(permanentScene);
            newWindow.show();
            currentWindow.setOnCloseRequest(null);
            currentWindow.close();
            this.window = newWindow;
        });
    }

    private void initializeScene() {
        double width = this.getPreferredDouble("scene_width", 1280.0);
        double height = this.getPreferredDouble("scene_height", 720.0);
        double panelDivPos = this.getPreferredDouble("params_panel_divider_position", 0.3);
        double tableDivPos = this.getPreferredDouble("viewers_table_divider_position", 0.8);
        boolean instanceMode = this.getPreferredBoolean("instance_mode", true);
        Scene scene = new Scene((Parent)this.root, width, height);
        this.root.splitPane.setDividerPosition(0, panelDivPos);
        this.root.tableSplitter.setDividerPosition(0, tableDivPos);
        this.root.cbInstanceMode.setSelected(instanceMode);
        GlobalHotKeys.initializeGlobalHotKeys(scene);
        scene.getStylesheets().add((Object)"viewer-container.css");
        scene.getStylesheets().add((Object)"tooltip.css");
        scene.getStylesheets().add((Object)"tools.css");
        this.window = this.createWindow();
        this.window.setScene(scene);
    }

    private void initializeSettings(UIBlockModel model) {
        ((CompletableFuture)App.getInstance().rqGetObjectProperties((IIdentifiable)model).thenAccept(dRsObjectProperties -> FxPlatform.RunFxThread(() -> this.setUpBlockSettings(model, dRsObjectProperties.getProperties())))).exceptionally(t -> {
            this.logger.log(Level.SEVERE, (Throwable)t, () -> String.format("Fail getting properties for %s: %s", model.toString(), t.getMessage()));
            return null;
        });
    }

    private void initializeCompareViewer() {
        CompareViewerModel compareViewerModel = new CompareViewerModel(10);
        this.compareViewer = new TunerCompareViewer(compareViewerModel);
        this.compareViewer.initialize();
        this.compareViewer.embed((Pane)this.root.apViewerContainer);
    }

    private void initializeCompareViewerTools() {
        MenuItem miHidePanels = new MenuItem("Hide panels");
        miHidePanels.setOnAction(action -> {
            this.root.splitPane.setDividerPosition(0, 0.0);
            this.root.tableSplitter.setDividerPosition(0, 1.0);
            try {
                ((CompareViewerContent)this.compareViewer.getBaseContent()).getSpWorkspace().setDividerPosition(0, 1.0);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        });
        List viewerTools = this.compareViewer.provideTools();
        viewerTools.stream().filter(node -> node instanceof MenuButton).findFirst().ifPresent(mbView -> ((MenuButton)mbView).getItems().add(0, (Object)miHidePanels));
        this.root.tunerToolbar.getItems().addAll(1, (Collection)viewerTools);
    }

    private void initializeCompareViewerLayers(UIBlockModel model) {
        String firstOutputNonRasterTabName = null;
        LinkedList<CompletionStage> awaitableRequests = new LinkedList<CompletionStage>();
        LinkedList<NonRasterViewerTab> nonRasterTabs = new LinkedList<NonRasterViewerTab>();
        block3: for (UIPortModel portModel : model.getPorts()) {
            if (portModel.getPortType().isControl()) continue;
            switch (portModel.getDataType()) {
                case SCALAR: 
                case NUMBERS: {
                    if (firstOutputNonRasterTabName == null && portModel.getPortType().isOutput()) {
                        firstOutputNonRasterTabName = this.createTitleFromModel(portModel);
                    }
                    nonRasterTabs.add(this.createViewerTab(portModel, model.getUuid()));
                    continue block3;
                }
            }
            CompletionStage modelRequest = this.createViewerLayerAsync(portModel, model.getUuid()).thenApply(viewerModel -> new AbstractMap.SimpleImmutableEntry<UIPortModel, ViewerModel>(portModel, (ViewerModel)viewerModel));
            awaitableRequests.add(modelRequest);
        }
        if (awaitableRequests.isEmpty()) {
            this.hideRasterPanel();
        } else {
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])awaitableRequests.toArray(CompletableFuture[]::new)).thenApply(v -> awaitableRequests.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenAccept(pairs -> {
                boolean firstInputPort = true;
                boolean firstOutputPort = true;
                for (Map.Entry pair : pairs) {
                    UIPortModel portModel = (UIPortModel)pair.getKey();
                    ViewerModel viewerModel = (ViewerModel)pair.getValue();
                    if (portModel.getPortType().isInput()) {
                        viewerModel.setEnabled(Boolean.valueOf(firstInputPort));
                        firstInputPort = false;
                    }
                    if (!portModel.getPortType().isOutput()) continue;
                    viewerModel.setEnabled(Boolean.valueOf(firstOutputPort));
                    firstOutputPort = false;
                }
                List rasterLayers = pairs.stream().map(Map.Entry::getValue).collect(Collectors.toList());
                ((CompareViewerModel)this.compareViewer.getViewerModel()).setViewerModels(rasterLayers);
            });
        }
        if (nonRasterTabs.isEmpty()) {
            this.hideScalarPanel();
        } else {
            this.root.tabPanel.getTabs().addAll(nonRasterTabs);
            String nameFinal = firstOutputNonRasterTabName;
            this.root.tabPanel.getTabs().stream().filter(tab -> tab.getText().equals(nameFinal)).findFirst().ifPresent(outputTab -> this.root.tabPanel.getSelectionModel().select(outputTab));
        }
    }

    private void subscribe() {
        EventBus.getDefault().register((Object)this);
    }

    public void setViewer(Viewer<? extends ViewerModel> viewer) {
    }

    public void show() {
        this.window.show();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.window.showingProperty();
    }

    public void setOwnerWindow(Stage ownerWindow) {
        this.window.initOwner((Window)ownerWindow);
    }

    public void addSelectionTool(SelectionTools tool) {
        this.setSelectionTools(List.of(tool));
    }

    public void setSelectionTools(List<SelectionTools> selectionTools) {
        for (SelectionTools eTool : selectionTools) {
            Pane handlePane = this.compareViewer.getBaseContent().getRasterContainer();
            SelectionTool tool = eTool.instance(handlePane);
            tool.setModelChangeListener(this::onSelectionToolModelChanged);
            tool.getView().getStyleClass().add((Object)"selection-tool");
            ToggleButton tbActiveTool = new ToggleButton();
            tbActiveTool.setMinSize(25.0, 25.0);
            this.applyStyle(tbActiveTool, eTool);
            tool.activeProperty().bindBidirectional((Property)tbActiveTool.selectedProperty());
            tbActiveTool.selectedProperty().addListener((ob, o, selected) -> {
                if (selected.booleanValue() && !this.matchToolParameters(tool)) {
                    String message = String.format("%s's parameters aren't match with this block", tool.getName());
                    StareNotification.showWarn((String)message);
                    this.logger.warning(String.format("Can't match parameters for %s", tool.getClass().getCanonicalName()));
                    tbActiveTool.setSelected(false);
                }
            });
            this.compareViewer.addSelectionTool(tool, tbActiveTool);
        }
    }

    @Subscribe
    public void onStareMonitorClosing(StareMonitorClosing event) {
        this.release();
    }

    public void savePreference() {
        this.putPreferredDouble("scene_width", this.window.getScene().getWidth());
        this.putPreferredDouble("scene_height", this.window.getScene().getHeight());
        this.putPreferredDouble("params_panel_divider_position", this.root.splitPane.getDividerPositions()[0]);
        this.putPreferredDouble("viewers_table_divider_position", this.root.tableSplitter.getDividerPositions()[0]);
        this.putPreferredBoolean("instance_mode", this.root.cbInstanceMode.isSelected());
    }

    public void restorePreference() {
    }

    public void release() {
        this.compareViewer.release();
        this.root.apPropertiesContainer.getChildren().clear();
        this.root.apViewerContainer.getChildren().clear();
        this.root.tunerToolbar.getItems().retainAll((Object[])new Node[]{this.root.tbPinUnpin});
        this.compareViewer = null;
        this.root.tabPanel.getTabs().forEach(tab -> {
            if (tab instanceof NonRasterViewerTab) {
                ((NonRasterViewerTab)((Object)tab)).close();
            } else {
                tab.setContent(null);
            }
        });
        this.root.tabPanel.getTabs().clear();
        this.window.setOnCloseRequest(null);
        this.window.close();
        if (EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().unregister((Object)this);
        }
    }

    private void setUpBlockSettings(UIBlockModel model, List<SimplePrimitive> properties) {
        UUID modelUuid = model.getUuid();
        IIDStorage.getInstance().findFirst(model.getWorkerType(), WorkerType.class).ifPresent(workerType -> {
            WorkerStructure workerStructure = workerType.getStructure();
            List structureControls = workerStructure.getControls();
            this.uiObjectProperties = new UIObjectProperties((IIdentifiable)model);
            this.uiObjectProperties.setControls(structureControls);
            this.root.spScroller.setContent((Node)this.uiObjectProperties);
            PaneHelper.setAnchorZero((Node)this.uiObjectProperties);
            this.uiObjectProperties.setProperties(properties);
            this.uiObjectProperties.setEventHandler((control, value) -> {
                if (control != null) {
                    App.getInstance().rqSetWorkerProperty(modelUuid, control.getName(), value).thenAccept(v -> {
                        if (this.root.cbInstanceMode.isSelected()) {
                            UserAction.executeWorker(modelUuid);
                        }
                    });
                }
            });
        });
    }

    private Stage createWindow() {
        Stage window = new Stage();
        window.setTitle("Block tuner");
        window.setOnCloseRequest(this.editorCloseHandler);
        return window;
    }

    private CompletableFuture<ViewerModel> createViewerLayerAsync(UIPortModel portModel, UUID blockId) {
        String portDataUrl = String.format("P/cache:%s", portModel.getUuid().toString());
        return ((CompletableFuture)App.getInstance().rqExist(portDataUrl).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                throw new CompletionException(new Throwable("Data no exist"));
            }
            return App.getInstance().rqGetData(portDataUrl);
        })).thenApply(any -> (ViewerModel)any.getData(Data.class).map(data -> {
            ViewerKind kind = ViewerKind.from((Data)data);
            if (kind == ViewerKind.UNKNOWN) {
                String error = "No data to display";
                StareNotification.showWarn((String)"No data to display");
                throw new CompletionException(new Throwable("No data to display"));
            }
            Object blockPortModel = kind == ViewerKind.VOXEL ? new VoxelViewerModel(blockId) : new PortImageViewerModel(blockId, portModel.getUuid());
            String layerTitle = this.createTitleFromModel(portModel);
            blockPortModel.setTitle(layerTitle);
            return blockPortModel;
        }).orElseGet(() -> {
            PortImageViewerModel model = new PortImageViewerModel(blockId, portModel.getUuid());
            model.setTitle(this.createTitleFromModel(portModel));
            return model;
        }));
    }

    private NonRasterViewerTab createViewerTab(UIPortModel portModel, UUID blockId) {
        TableViewerModel model;
        ViewerKind kind;
        if (portModel.getDataType() == PortDataType.NUMBERS) {
            kind = ViewerKind.TABLE;
            model = new TableViewerModel(blockId);
        } else {
            kind = ViewerKind.PLAIN_TEXT;
            model = new PlainTextViewerModel(blockId);
        }
        Viewer viewer = ViewerFactory.create((ViewerKind)kind, (ViewerModel)model);
        PortBasedDataSource dataSource = new PortBasedDataSource(blockId, portModel.getUuid());
        viewer.setViewerDataSource((ViewerDataSource)dataSource);
        dataSource.rqViewerData();
        String tabTitle = this.createTitleFromModel(portModel);
        NonRasterViewerTab tab = new NonRasterViewerTab(tabTitle);
        tab.setViewer((Viewer<? extends BlockViewerModel>)viewer);
        return tab;
    }

    private boolean matchToolParameters(SelectionTool tool) {
        Optional<Optional> optMismatchedContainer = tool.getModel().stream().map(primitive -> this.findControlByName(primitive.getName())).filter(Optional::isEmpty).findAny();
        return optMismatchedContainer.isEmpty();
    }

    private void onSelectionToolModelChanged(List<SimplePrimitive> toolParams) {
        for (SimplePrimitive primitive : toolParams) {
            Optional<UIControlContainer> optContainer = this.findControlByName(primitive.getName());
            optContainer.ifPresent(uiControlContainer -> uiControlContainer.setProperty(primitive));
        }
    }

    private Optional<UIControlContainer> findControlByName(String primitiveName) {
        return this.uiObjectProperties.findControlByName(primitiveName).or(() -> nameAliases.get(primitiveName).stream().map(alias -> this.uiObjectProperties.findControlByName((String)alias)).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    private void applyStyle(ToggleButton toggle, SelectionTools eTool) {
        switch (eTool) {
            case RECTANGLE: {
                toggle.getStyleClass().add((Object)"activate-rectangle-tool");
                break;
            }
            case POINT: {
                toggle.getStyleClass().add((Object)"activate-point-tool");
                break;
            }
            default: {
                toggle.setText(eTool.name().toLowerCase());
            }
        }
    }

    private String createTitleFromModel(UIPortModel portModel) {
        return String.format("%s/%s", portModel.getPortType().name().toLowerCase(), portModel.getName());
    }

    private void hideRasterPanel() {
        this.root.apViewerContainer.setVisible(false);
        this.root.apViewerContainer.setManaged(false);
        this.root.tableSplitter.setDividerPosition(0, 0.0);
    }

    private void hideScalarPanel() {
        this.root.tabPanel.setVisible(false);
        this.root.tabPanel.setManaged(false);
        this.root.tableSplitter.setDividerPosition(0, 1.0);
    }

    private static class BlockTunerContent
    extends AnchorPane {
        @FXML
        private ToolBar tunerToolbar;
        @FXML
        private ToggleButton tbPinUnpin;
        @FXML
        private CheckBox cbInstanceMode;
        @FXML
        SplitPane splitPane;
        @FXML
        AnchorPane apPropertiesContainer;
        @FXML
        ScrollPane spScroller;
        @FXML
        SplitPane tableSplitter;
        @FXML
        AnchorPane apViewerContainer;
        @FXML
        TabPane tabPanel;

        private BlockTunerContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
                Tooltip.install((Node)this.cbInstanceMode, (Tooltip)new StareTooltip("Execute the tuning block when some parameters have changed"));
            }
            catch (IOException e) {
                e.printStackTrace();
                StareNotification.showWarn((String)"Fail to initialize ToolViewerContent");
            }
        }
    }
}

