/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.ui;

import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.ui.NodeActionHandler;
import com.siams.cv.monitor.ui.event.DragInfo;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class NodeDragHandler
extends NodeActionHandler {
    protected Point2D eventStart;
    protected MouseButton dragMouseButton = MouseButton.PRIMARY;
    protected DragInfo dragInfoScreen = new DragInfo();
    protected DragInfo dragInfoLocal = new DragInfo();
    DragMode dragMode = DragMode.LAYOUT;

    public NodeDragHandler(Node eventConsumer, StareNode eventTarget) {
        super(eventConsumer, eventTarget);
        this.initialize();
    }

    public NodeDragHandler(Node eventConsumer, StareNode eventTarget, NodeActionHandler.EventConsumptionMode consumptionMode) {
        super(eventConsumer, eventTarget, consumptionMode);
        this.initialize();
    }

    protected void onPress(MouseEvent event) {
    }

    protected void onDrag(MouseEvent event) {
    }

    protected void onRelease(MouseEvent event) {
    }

    private void initialize() {
        this.initializePressHandler();
        this.initializeDragHandler();
        this.initializeReleaseHandler();
    }

    private void onMousePressedHandle(MouseEvent event) {
        if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
            this.eventStart = new Point2D(event.getX(), event.getY());
            this.dragInfoScreen.startDrag(event.getScreenX(), event.getScreenY());
            this.dragInfoLocal.startDrag(event.getX(), event.getY());
            this.onPress(event);
        }
    }

    private void initializePressHandler() {
        switch (this.eventConsumptionMode) {
            case DEFAULT: {
                this.eventConsumer.setOnMousePressed(this::onMousePressedHandle);
                break;
            }
            case CAPTURING: {
                this.eventConsumer.addEventFilter(MouseEvent.MOUSE_PRESSED, this::onMousePressedHandle);
                break;
            }
            case BUBBLING: {
                this.eventConsumer.addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressedHandle);
            }
        }
    }

    private void onMouseDraggedHandle(MouseEvent event) {
        if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
            this.dragInfoScreen.dragTo(event.getScreenX(), event.getScreenY());
            this.dragInfoLocal.dragTo(this.dragInfoLocal.distanceX + event.getX(), this.dragInfoLocal.distanceY + event.getY());
            this.onDrag(event);
        }
    }

    private void initializeDragHandler() {
        switch (this.eventConsumptionMode) {
            case DEFAULT: {
                this.eventConsumer.setOnMouseDragged(this::onMouseDraggedHandle);
                break;
            }
            case CAPTURING: {
                this.eventConsumer.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::onMouseDraggedHandle);
                break;
            }
            case BUBBLING: {
                this.eventConsumer.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::onMouseDraggedHandle);
            }
        }
    }

    private void onMouseReleasedHandle(MouseEvent event) {
        if (this.dragMouseButton == MouseButton.NONE || event.getButton() == this.dragMouseButton) {
            this.onRelease(event);
        }
    }

    private void initializeReleaseHandler() {
        switch (this.eventConsumptionMode) {
            case DEFAULT: {
                this.eventConsumer.setOnMouseReleased(this::onMouseReleasedHandle);
                break;
            }
            case CAPTURING: {
                this.eventConsumer.addEventFilter(MouseEvent.MOUSE_RELEASED, this::onMouseReleasedHandle);
                break;
            }
            case BUBBLING: {
                this.eventConsumer.addEventHandler(MouseEvent.MOUSE_RELEASED, this::onMouseReleasedHandle);
            }
        }
    }

    @Override
    public void release() {
    }

    public void setDragMode(DragMode dragMode) {
        this.dragMode = dragMode;
    }

    public DragInfo getDragInfoScreen() {
        return this.dragInfoScreen;
    }

    public DragInfo getDragInfoLocal() {
        return this.dragInfoLocal;
    }

    public static enum DragMode {
        LAYOUT,
        TRANSLATE,
        NONE;

    }
}

