/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport.grpc;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.transport.StareTransport;
import com.siams.cv.monitor.transport.grpc.GrpcV1;
import com.siams.cv.monitor.ui.content.windows.ConnectionWindow;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.prefs.Preferences;
import net.algart.arrays.Arrays;
import org.apache.log4j.Logger;

public class GrpcTransport
implements StareTransport {
    public static final String DEFAULT_CONNECTION_HOST = Arrays.SystemSettings.getStringProperty((String)"com.scichains.ide.connection.host", (String)"127.0.0.1");
    public static final int DEFAULT_CONNECTION_PORT = Arrays.SystemSettings.getIntProperty((String)"com.scichains.ide.connection.port", (int)50051);
    private Logger logger = Logger.getLogger(GrpcTransport.class);
    private ManagedChannel channel = null;

    @Override
    public void connect() {
        Preferences preferences = Preferences.userNodeForPackage(ConnectionWindow.class);
        String host = preferences.get("host", DEFAULT_CONNECTION_HOST);
        int port = preferences.getInt("port", DEFAULT_CONNECTION_PORT);
        if (port <= 0) {
            throw new IllegalArgumentException("port: " + port + " <= 0");
        }
        if (port > 65535) {
            throw new IllegalArgumentException("port: " + port + " >= 65535");
        }
        this.logger.debug((Object)String.format("Connect to grpc server: %s:%d", host, port));
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)host, (int)port);
        builder.usePlaintext();
        this.channel = builder.build();
        GrpcV1.getInstance().setChannel(this.channel);
        this.channel.getState(true);
        this.subscribeWhenStateChanged();
    }

    private void subscribeWhenStateChanged() {
        if (this.channel != null) {
            this.channel.notifyWhenStateChanged(this.channel.getState(false), () -> {
                ConnectivityState state = this.channel.getState(false);
                this.logger.debug((Object)String.format("channel state changed: %s", state.toString()));
                App.getInstance().setStareServerConnectedStatus(state == ConnectivityState.READY);
                this.subscribeWhenStateChanged();
            });
        }
    }

    @Override
    public void disconnect() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    @Override
    public void release() {
        this.disconnect();
    }
}

