/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.transport;

import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.transport.BlockBasedDataSource;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultMetaData;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultPort;
import com.siams.cv.monitor.viewers.ui.content.VisibleResultPortType;
import com.siams.stare.api.Any;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SScalar;

public class PortBasedDataSource
extends BlockBasedDataSource {
    private final UUID portId;

    public PortBasedDataSource(UUID blockId, UUID portId) {
        super(blockId);
        this.portId = portId;
    }

    public UUID getPortId() {
        return this.portId;
    }

    @Override
    public CompletableFuture<Void> rqViewerData() {
        String portDataUrl = String.format("P/cache:%s", this.portId.toString());
        return ((CompletableFuture)((CompletableFuture)App.getInstance().rqExist(portDataUrl).thenCompose(exists -> exists != false ? App.getInstance().rqGetData(portDataUrl) : CompletableFuture.completedFuture(new Any(portDataUrl, (Object)new SScalar("Empty port"))))).thenAccept(any -> any.getData(Data.class).map(this::asViewerData).ifPresent(this::notifyListenersViewerDataReceived))).exceptionally(t -> {
            this.notifyListenersErrorReceived((Throwable)t);
            throw new CompletionException(new Throwable(t.getMessage()));
        });
    }

    private ViewerData asViewerData(Data data) {
        VisibleResultPort metaPort = App.getInstance().getProject().findModel(this.portId, UIPortModel.class).map(this::uiToVisibleResultPort).orElseGet(this::defaultVisibleResultPort);
        TreeMap<String, Data> dataMap = new TreeMap<String, Data>();
        dataMap.put(metaPort.getName(), data);
        VisibleResultMetaData meta = new VisibleResultMetaData();
        meta.getPorts().add(metaPort);
        return new ViewerData(dataMap, meta);
    }

    private VisibleResultPort uiToVisibleResultPort(UIPortModel uiPortModel) {
        return this.buildVisibleResultPort(this.portId, uiPortModel.getName(), uiPortModel.getPortType().name());
    }

    private VisibleResultPort defaultVisibleResultPort() {
        return this.buildVisibleResultPort(this.portId, "Name", VisibleResultPortType.OUTPUT.name());
    }

    private VisibleResultPort buildVisibleResultPort(UUID id, String name, String type) {
        VisibleResultPort port = new VisibleResultPort();
        port.setId(id.toString());
        port.setName(name);
        port.setType(type);
        return port;
    }
}

