/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.plugin.poke.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.plugin.PluginModel;
import com.siams.cv.monitor.plugin.poke.model.FileUserMarkers;
import com.siams.cv.monitor.plugin.poke.model.LabelFeature;
import com.siams.cv.monitor.plugin.poke.model.LabelFeatureComparator;
import com.siams.cv.monitor.plugin.poke.model.PokeClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PokePluginModel
extends PluginModel {
    public static final String id = "PokePluginModel";
    @JsonProperty(value="current_base_file")
    private String currentBaseFileName = null;
    @JsonProperty(value="base_folder")
    private String baseFolder = null;
    @JsonProperty(value="labels_folder")
    private String labelsFolder = null;
    @JsonProperty(value="draw_folder")
    private String drawFolder = null;
    @JsonProperty(value="classification_folder")
    private String classificationFolder = null;
    @JsonProperty(value="classes")
    private Set<PokeClass> pokeClasses = new TreeSet<PokeClass>();
    @JsonProperty(value="user_markers")
    private Set<FileUserMarkers> baseFileUserMakers = new TreeSet<FileUserMarkers>();
    @JsonProperty(value="label_features")
    private List<LabelFeature> labelFeatures = new ArrayList<LabelFeature>();
    @JsonProperty(value="export_label_feature_idx")
    private List<Integer> exportLabelFeatureIdx = new ArrayList<Integer>();

    @JsonCreator
    public PokePluginModel() {
    }

    @JsonGetter(value="base_folder")
    public String getBaseFolder() {
        return this.baseFolder;
    }

    @JsonSetter(value="base_folder")
    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    @JsonGetter(value="labels_folder")
    public String getLabelsFolder() {
        return this.labelsFolder;
    }

    @JsonSetter(value="labels_folder")
    public void setLabelsFolder(String labelsFolder) {
        this.labelsFolder = labelsFolder;
    }

    @JsonGetter(value="classes")
    public Set<PokeClass> getPokeClasses() {
        return this.pokeClasses;
    }

    @JsonSetter(value="classes")
    public void setPokeClasses(Set<PokeClass> pokeClasses) {
        this.pokeClasses = pokeClasses;
    }

    @JsonGetter(value="draw_folder")
    public String getDrawFolder() {
        return this.drawFolder;
    }

    @JsonSetter(value="draw_folder")
    public void setDrawFolder(String drawFolder) {
        this.drawFolder = drawFolder;
    }

    @JsonGetter(value="classification_folder")
    public String getClassificationFolder() {
        return this.classificationFolder;
    }

    @JsonSetter(value="classification_folder")
    public void setClassificationFolder(String classificationFolder) {
        this.classificationFolder = classificationFolder;
    }

    @JsonGetter(value="user_markers")
    public Set<FileUserMarkers> getBaseFileUserMakers() {
        return this.baseFileUserMakers;
    }

    @JsonSetter(value="user_markers")
    public void setBaseFileUserMakers(Set<FileUserMarkers> baseFileUserMakers) {
        this.baseFileUserMakers = baseFileUserMakers;
    }

    @JsonGetter(value="current_base_file")
    public String getCurrentBaseFileName() {
        if (this.currentBaseFileName != null && !this.currentBaseFileName.isEmpty()) {
            try {
                File file = new File(this.currentBaseFileName);
                this.currentBaseFileName = file.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.currentBaseFileName;
    }

    @JsonSetter(value="current_base_file")
    public void setCurrentBaseFileName(String currentBaseFileName) {
        this.currentBaseFileName = currentBaseFileName;
    }

    @JsonGetter(value="label_features")
    public List<LabelFeature> getLabelFeatures() {
        return this.labelFeatures;
    }

    @JsonSetter(value="label_features")
    public void setLabelFeatures(List<LabelFeature> labelFeatures) {
        this.labelFeatures = labelFeatures;
        this.labelFeatures.sort(new LabelFeatureComparator());
    }

    @JsonGetter(value="export_label_feature_idx")
    public List<Integer> getExportLabelFeatureIdx() {
        return this.exportLabelFeatureIdx;
    }

    @JsonSetter(value="export_label_feature_idx")
    public void setExportLabelFeatureIdx(List<Integer> exportLabelFeatureIdx) {
        this.exportLabelFeatureIdx = exportLabelFeatureIdx;
    }

    @JsonIgnore
    public List<String> getLabelFeatureNames() {
        return this.labelFeatures.stream().map(LabelFeature::getName).collect(Collectors.toList());
    }

    public Optional<PokeClass> findPokeClassById(int id) {
        return this.pokeClasses.stream().filter(pokeClass -> pokeClass.getId() == id).findFirst();
    }

    public Optional<PokeClass> findPokeClassByName(String name) {
        Objects.requireNonNull(name, "Name required");
        return this.pokeClasses.stream().filter(pokeClass -> pokeClass.getName().equals(name)).findFirst();
    }

    public boolean addPokeClass(PokeClass pokeClass) {
        return this.pokeClasses.add(pokeClass);
    }

    public int nextPokeId() {
        int id = 0;
        for (PokeClass pokeClass : this.pokeClasses) {
            id = Math.max(id, pokeClass.getId());
        }
        return ++id;
    }

    public PokeClass removePokeClass(int id) {
        PokeClass removed = null;
        Iterator<PokeClass> iterator = this.pokeClasses.iterator();
        while (iterator.hasNext()) {
            PokeClass pokeClass = iterator.next();
            if (pokeClass.getId() != id) continue;
            removed = pokeClass;
            iterator.remove();
            break;
        }
        return removed;
    }

    public Optional<FileUserMarkers> findUserMarkers(File baseFile) {
        String baseFileName = baseFile.getName();
        return this.baseFileUserMakers.stream().filter(fileUserMarkers -> fileUserMarkers.getBaseFileName().equals(baseFileName)).findFirst();
    }

    public void replaceUserMarkers(FileUserMarkers fileUserMarkers) {
        this.baseFileUserMakers.remove(fileUserMarkers);
        this.baseFileUserMakers.add(fileUserMarkers);
    }

    public static <T> T findAndRemove(Collection<T> collection, Predicate<T> predicate) {
        T removed = null;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T obj = iterator.next();
            if (!predicate.test(obj)) continue;
            iterator.remove();
            removed = obj;
            break;
        }
        return removed;
    }

    public static <T> List<T> findAndRemoveAll(Collection<T> collection, Predicate<T> predicate) {
        LinkedList<T> removed = new LinkedList<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T obj = iterator.next();
            if (!predicate.test(obj)) continue;
            iterator.remove();
            removed.add(obj);
        }
        return removed;
    }

    public void addLabelFeature(LabelFeature labelFeature) {
        labelFeature.setIndex(this.labelFeatures.size());
        this.labelFeatures.add(labelFeature);
    }

    private void reindexLabelFeatures() {
        int size = this.labelFeatures.size();
        for (int i = 0; i < size; ++i) {
            LabelFeature labelFeature = this.labelFeatures.get(i);
            labelFeature.setIndex(i);
        }
    }

    public LabelFeature removeLabelFeature(int index) {
        LabelFeature removed = PokePluginModel.findAndRemove(this.labelFeatures, labelFeature -> labelFeature.getIndex() == index);
        if (removed != null) {
            this.reindexLabelFeatures();
        }
        return removed;
    }

    public boolean swapLabelFeatures(int index1, int index2) {
        int size = this.labelFeatures.size();
        if (index1 < 0 || index1 >= size) {
            return false;
        }
        if (index2 < 0 || index2 >= size) {
            return false;
        }
        if (index1 == index2) {
            return false;
        }
        Collections.swap(this.labelFeatures, index1, index2);
        this.reindexLabelFeatures();
        return true;
    }

    @JsonIgnore
    public List<LabelFeature> getExportLabelFeatures() {
        ArrayList<LabelFeature> exportFeatures = new ArrayList<LabelFeature>();
        for (Integer idx : this.exportLabelFeatureIdx) {
            exportFeatures.add(this.labelFeatures.get(idx));
        }
        return exportFeatures;
    }

    public void clearFileUserMarkers() {
        this.baseFileUserMakers.clear();
    }

    public FileUserMarkers clearFileUserMarkers(File baseFile) {
        String baseFileName = baseFile.getName();
        return PokePluginModel.findAndRemove(this.baseFileUserMakers, fileUserMarkers -> fileUserMarkers.getBaseFileName().equals(baseFileName));
    }
}

