/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.storage;

import com.siams.cv.monitor.entity.StareNode;
import com.siams.cv.monitor.model.storage.BaseStorage;
import com.siams.cv.monitor.ui.factory.Deletable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NodeStorage
extends BaseStorage<StareNode> {
    private static NodeStorage instance;

    public static NodeStorage getInstance() {
        if (instance == null) {
            instance = new NodeStorage();
        }
        return instance;
    }

    public List<StareNode> remove(UUID uuid) {
        return this.remove((StareNode node) -> node.getUuid().equals(uuid));
    }

    @Override
    public List<StareNode> remove(Predicate<StareNode> predicate) {
        return super.remove(predicate).stream().peek(this::finalizeNode).collect(Collectors.toList());
    }

    @Override
    public <T extends StareNode> Optional<T> findFirst(Class<T> clazz, Predicate<T> predicate) {
        return ((BaseStorage)this).findFirst(predicate, clazz);
    }

    public <T extends StareNode> Optional<T> findFirst(Class<T> clazz, UUID uid) {
        return ((BaseStorage)this).findFirst((V stareNode) -> stareNode.getUuid().equals(uid), clazz);
    }

    public <T extends StareNode> Optional<T> findFirst(UUID uuid) {
        return this.findFirst((T node) -> node.getUuid().equals(uuid));
    }

    public <T extends StareNode> Optional<T> findFirst(UUID uuid, Class<T> clazz) {
        return ((BaseStorage)this).findFirst((V node) -> node.getUuid().equals(uuid), clazz);
    }

    @Override
    public <T extends StareNode> List<T> find(Class<T> clazz, Predicate<T> predicate) {
        return ((BaseStorage)this).find(predicate, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Collection collection = this.storage;
        synchronized (collection) {
            ArrayList copy = new ArrayList(this.storage);
            for (StareNode node : copy) {
                this.finalizeNode(node);
            }
        }
        this.storage.clear();
    }

    private void finalizeNode(StareNode node) {
        if (Deletable.class.isAssignableFrom(node.getClass())) {
            ((Deletable)((Object)node)).release();
        }
    }
}

