/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.storage;

import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.storage.BaseStorage;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public class IIDStorage
extends BaseStorage<IIdentifiable> {
    private static IIDStorage instance;

    public static IIDStorage getInstance() {
        if (instance == null) {
            instance = new IIDStorage();
        }
        return instance;
    }

    public boolean has(UUID uuid) {
        return this.has((T iid) -> iid.getUuid().equals(uuid));
    }

    public boolean has(IIdentifiable iid) {
        return this.has(iid.getUuid());
    }

    public Optional<IIdentifiable> findFirst(IIdentifiable iid) {
        return this.findFirst(iid.getUuid());
    }

    public Optional<IIdentifiable> findFirst(UUID uuid) {
        return this.findFirst((T iid) -> iid.getUuid().equals(uuid));
    }

    public <T extends IIdentifiable> Optional<T> findFirst(IIdentifiable iid, Class<T> clazz) {
        return this.findFirst((V item) -> item.getUuid().equals(iid.getUuid()), clazz);
    }

    public <T extends IIdentifiable> Optional<T> findFirst(UUID uuid, Class<T> clazz) {
        return this.findFirst((V item) -> item.getUuid().equals(uuid), clazz);
    }

    @Override
    public void addObject(IIdentifiable object) {
        assert (object.getUuid() != null);
        super.addObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IIdentifiable> void removeByClass(Class<T> clazz) {
        Collection collection = this.storage;
        synchronized (collection) {
            this.storage.removeIf(iid -> clazz.isAssignableFrom(iid.getClass()));
        }
    }
}

