/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.statistic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.siams.collection.CollectionsUtils;
import com.siams.cv.monitor.model.statistic.Duration;
import com.siams.cv.monitor.model.statistic.StatisticDetail;
import com.siams.stare.api.Any;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Statistic {
    private String id = "";
    @JsonProperty(value="object_id")
    private String objectId = "";
    private int order = 0;
    private Duration duration = new Duration();
    private String name = "";
    private String error = "";
    @JsonProperty(value="error_message")
    private String errorMessage = "";
    @JsonProperty(value="error_class_name")
    private String errorClassName = "";
    @JsonProperty(value="stack_trace")
    private String stackTrace = "";
    private String category = "";
    private String type = "";
    private String stage = "";
    private long modified = 0L;
    private List<StatisticDetail> details = Collections.EMPTY_LIST;
    @JsonProperty(value="system_name")
    private String systemName = "";

    public static Statistic valueOf(Any any) {
        Statistic statistic = any.getData(String.class).map(json -> {
            try {
                Statistic stat = Statistic.valueOf(json);
                stat.setModified(any.getModified());
                return stat;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed parse statistic json: %s", json));
            }
        }).orElseThrow(() -> new RuntimeException("Unexpected statistic format (String.class required)"));
        Objects.requireNonNull(statistic);
        return statistic;
    }

    public String getId() {
        return this.id;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasError() {
        return !this.error.isEmpty() || !this.errorMessage.isEmpty() || !this.stackTrace.isEmpty();
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorClassName() {
        return this.errorClassName;
    }

    public Statistic setErrorClassName(String errorClassName) {
        this.errorClassName = errorClassName;
        return this;
    }

    public String getStackTrace() {
        return this.stackTrace.isEmpty() ? this.errorMessage : this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getCategory() {
        return this.category == null || this.category.isEmpty() ? this.errorClassName : this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public static Statistic valueOf(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Statistic)objectMapper.readValue(json, Statistic.class);
    }

    public static Statistic valueOf(InputStream in) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Statistic)objectMapper.readValue(in, Statistic.class);
    }

    @JsonIgnore
    public UUID getUuid() {
        try {
            return UUID.fromString(this.id);
        }
        catch (Throwable throwable) {
            return new UUID(0L, 0L);
        }
    }

    @JsonIgnore
    public UUID getObjectUuid() {
        try {
            return UUID.fromString(this.objectId);
        }
        catch (Throwable throwable) {
            return new UUID(0L, 0L);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public long getModified() {
        return this.modified;
    }

    public void setModified(long modified) {
        this.modified = modified;
    }

    public String toString() {
        return "Statistic{id='" + this.id + "', name='" + this.name + "', error='" + this.error + "', modified=" + this.modified + "}";
    }

    public List<StatisticDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<StatisticDetail> details) {
        this.details = details;
    }

    public <T extends StatisticDetail> Optional<T> findFirstDetail(Class<T> clazz, Predicate<T> predicate) {
        return CollectionsUtils.findFirst(this.details, predicate, clazz);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }
}

