/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.application.App;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.Model;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.legacy.ProjectNode;
import com.siams.cv.monitor.model.legacy.ProjectPort;
import com.siams.cv.monitor.model.node.UIBlockModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.scene.Node;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectUIBlock
extends ProjectNode {
    public static String id = "ProjectUIBlock";
    @JsonProperty(value="layout_x")
    private double layoutX;
    @JsonProperty(value="layout_y")
    private double layoutY;
    @JsonProperty(value="layout_width")
    private double layoutWidth;
    @JsonProperty(value="layout_height")
    private double layoutHeight;
    @JsonProperty(value="custom_caption")
    private String customCaption = "";
    @JsonProperty(value="custom_comment")
    private String customComment = "";
    @JsonProperty(value="customCaptionOrName")
    private String customCaptionOrName = "";
    @JsonProperty(value="ports")
    private List<ProjectPort> projectPorts = new ArrayList<ProjectPort>();
    @JsonProperty(value="display_advanced")
    private Boolean displayAdvanced = false;

    @JsonCreator
    ProjectUIBlock() {
    }

    private ProjectUIBlock(UUID uuid, double layoutX, double layoutY) {
        this.uuid = uuid;
        this.layoutX = layoutX;
        this.layoutY = layoutY;
    }

    public void setLayoutWidth(double layoutWidth) {
        this.layoutWidth = layoutWidth;
    }

    public void setLayoutHeight(double layoutHeight) {
        this.layoutHeight = layoutHeight;
    }

    public double getLayoutX() {
        return this.layoutX;
    }

    public void setLayoutX(double layoutX) {
        this.layoutX = layoutX;
    }

    public double getLayoutY() {
        return this.layoutY;
    }

    public void setLayoutY(double layoutY) {
        this.layoutY = layoutY;
    }

    public String getCustomCaption() {
        return this.customCaption;
    }

    public String getCustomCaptionOrName() {
        return this.customCaptionOrName;
    }

    public void setCustomCaptionOrName(String customCaptionOrName) {
        this.customCaptionOrName = customCaptionOrName;
    }

    @JsonIgnore
    public String customCaptionOrName(String systemName) {
        Object caption = !this.customCaption.isEmpty() ? this.customCaption : (systemName != null ? "[" + systemName + "]" : "");
        return caption;
    }

    public void setCustomCaption(String customCaption) {
        this.customCaption = customCaption;
    }

    public String getCustomComment() {
        return this.customComment;
    }

    public void setCustomComment(String customComment) {
        this.customComment = customComment;
    }

    public void addPort(ProjectPort projectPort) {
        this.projectPorts.add(projectPort);
    }

    public Optional<ProjectPort> findPort(IIdentifiable port) {
        return this.findPort(port.getUuid());
    }

    public Optional<ProjectPort> findPort(UUID uuid) {
        return this.projectPorts.stream().filter(projectPort -> projectPort.getUuid().equals(uuid)).findFirst();
    }

    public Optional<ProjectPort> findPort(PortType portType, String name) {
        return this.projectPorts.stream().filter(projectPort -> projectPort.getUuid().equals(this.uuid)).findFirst();
    }

    public double getLayoutWidth() {
        return this.layoutWidth;
    }

    public double getLayoutHeight() {
        return this.layoutHeight;
    }

    public boolean hasProjectPort(IIdentifiable iid) {
        return this.hasProjectPort(iid.getUuid());
    }

    public boolean hasProjectPort(UUID uuid) {
        return this.projectPorts.stream().anyMatch(projectPort -> projectPort.getUuid().equals(uuid));
    }

    @Override
    public void release() {
        this.projectPorts.forEach(ProjectPort::release);
    }

    private void setProjectPorts(List<ProjectPort> projectPorts) {
        this.projectPorts = projectPorts;
    }

    @JsonSetter(value="input_ports")
    private void setInputProjectPorts(List<ProjectPort> projectPorts) {
        this.projectPorts.addAll(projectPorts);
    }

    @JsonSetter(value="output_ports")
    private void setOutputProjectPorts(List<ProjectPort> projectPorts) {
        this.projectPorts.addAll(projectPorts);
    }

    @JsonSetter(value="input_control_ports")
    private void setInputControlProjectPorts(List<ProjectPort> projectPorts) {
        this.projectPorts.addAll(projectPorts);
    }

    @JsonSetter(value="output_control_ports")
    private void setOutputControlProjectPorts(List<ProjectPort> projectPorts) {
        this.projectPorts.addAll(projectPorts);
    }

    @JsonGetter(value="display_advanced")
    public Boolean getDisplayAdvanced() {
        return this.displayAdvanced;
    }

    @JsonSetter(value="display_advanced")
    public void setDisplayAdvanced(Boolean displayAdvanced) {
        this.displayAdvanced = displayAdvanced;
    }

    @JsonGetter(value="ports")
    public List<ProjectPort> getProjectPorts() {
        return this.projectPorts;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public Model convertToModel() {
        UIBlockModel model = new UIBlockModel.Builder().setUuid(this.uuid).build();
        int gridSize = App.getInstance().getProject().getRoot().getGridSize();
        model.setLayoutX(this.layoutX);
        model.setLayoutY(this.layoutY);
        model.setLayoutWidth(this.layoutWidth == 0.0 ? (double)UIBlockModel.getPreferredWidth((int)gridSize) : this.layoutWidth);
        model.setLayoutHeight(this.layoutHeight == 0.0 ? (double)UIBlockModel.getPreferredHeight((int)gridSize) : this.layoutHeight);
        model.setCaption(this.customCaption);
        model.setComment(this.customComment);
        model.setDisplayAdvanced(this.displayAdvanced);
        List uiPortModels = this.projectPorts.stream().map(ProjectPort::convertToNodeModel).collect(Collectors.toList());
        model.setPorts(uiPortModels);
        return model;
    }

    public static class Builder {
        private UUID id;
        private double layoutX = 0.0;
        private double layoutY = 0.0;
        private double layoutWidth = 0.0;
        private double layoutHeight = 0.0;
        private String customCaption = "";
        private String customComment = "";
        private List<ProjectPort> projectPorts = new ArrayList<ProjectPort>();

        public Builder setId(UUID id) {
            this.id = id;
            return this;
        }

        public Builder setNode(Node node) {
            this.layoutX = node.getLayoutX();
            this.layoutY = node.getLayoutY();
            this.layoutWidth = node.getLayoutBounds().getWidth();
            this.layoutHeight = node.getLayoutBounds().getHeight();
            return this;
        }

        public Builder setCustomCaption(String customCaption) {
            this.customCaption = customCaption;
            return this;
        }

        public Builder setCustomComment(String customComment) {
            this.customComment = customComment;
            return this;
        }

        public ProjectUIBlock build() {
            if (this.id == null) {
                throw new NullPointerException("Expected project node id");
            }
            ProjectUIBlock projectNode = new ProjectUIBlock(this.id, this.layoutX, this.layoutY);
            projectNode.setLayoutWidth(this.layoutWidth);
            projectNode.setLayoutHeight(this.layoutHeight);
            projectNode.setCustomCaption(this.customCaption);
            projectNode.setCustomComment(this.customComment);
            projectNode.setProjectPorts(this.projectPorts);
            return projectNode;
        }
    }
}

